/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.pathname;

import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Pathname"})
public class RubyPathname
extends RubyObject {
    private RubyString path = null;
    private static final ReturnValueMapper IDENTITY_MAPPER = new ReturnValueMapper(){

        @Override
        public IRubyObject map(ThreadContext context, IRubyObject value2) {
            return value2;
        }
    };
    private static final ReturnValueMapper SINGLE_PATH_MAPPER = new ReturnValueMapper(){

        @Override
        public IRubyObject map(ThreadContext context, IRubyObject value2) {
            return RubyPathname.newInstance(context, value2);
        }
    };
    private static final ReturnValueMapper ARRAY_OF_PATHS_MAPPER = new ReturnValueMapper(){

        @Override
        public IRubyObject map(ThreadContext context, IRubyObject value2) {
            return RubyPathname.mapToPathnames(context, value2);
        }
    };
    private static final AddArg UNSHIFT_PATH = new AddArg(){

        @Override
        public IRubyObject[] addArg(IRubyObject[] args2, RubyString path2) {
            return RubyPathname.insert(args2, 0, path2);
        }
    };
    private static final AddArg APPEND_PATH = new AddArg(){

        @Override
        public IRubyObject[] addArg(IRubyObject[] args2, RubyString path2) {
            return RubyPathname.insert(args2, args2.length, path2);
        }
    };
    private static ObjectAllocator PATHNAME_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyPathname(runtime, klass);
        }
    };

    static void createPathnameClass(Ruby runtime) {
        RubyClass cPathname = runtime.defineClass("Pathname", runtime.getObject(), PATHNAME_ALLOCATOR);
        cPathname.defineAnnotatedMethods(RubyPathname.class);
        runtime.getKernel().defineAnnotatedMethods(PathnameKernelMethods.class);
        RubyPathname.defineDelegateMethods(cPathname, runtime.getFile(), "atime", "ctime", "mtime", "ftype", "rename", "stat", "lstat", "truncate", "extname", "open");
        RubyPathname.defineDelegateMethodsAppendPath(cPathname, runtime.getFile(), "chmod", "lchmod", "chown", "lchown", "utime");
        RubyPathname.defineDelegateMethodsSinglePath(cPathname, runtime.getFile(), "realpath", "realdirpath", "basename", "dirname", "expand_path", "readlink");
        RubyPathname.defineDelegateMethodsArrayOfPaths(cPathname, runtime.getFile(), "split");
        RubyPathname.defineDelegateMethods(cPathname, runtime.getIO(), "read", "binread", "write", "binwrite", "readlines", "sysopen");
        RubyPathname.defineDelegateMethods(cPathname, runtime.getFileTest(), "blockdev?", "chardev?", "executable?", "executable_real?", "exist?", "grpowned?", "directory?", "file?", "pipe?", "socket?", "owned?", "readable?", "world_readable?", "readable_real?", "setuid?", "setgid?", "size", "size?", "sticky?", "symlink?", "writable?", "world_writable?", "writable_real?", "zero?");
        RubyPathname.defineDelegateMethods(cPathname, runtime.getDir(), "mkdir", "rmdir");
        RubyPathname.defineDelegateMethodsArrayOfPaths(cPathname, runtime.getDir(), "entries");
        cPathname.undefineMethod("=~");
    }

    private static void defineDelegateMethodsGeneric(RubyClass cPathname, final RubyModule klass, final ReturnValueMapper mapper, final AddArg addArg, String ... methods2) {
        for (String method2 : methods2) {
            cPathname.addMethod(method2, new JavaMethod.JavaMethodNBlock(cPathname, Visibility.PUBLIC){

                @Override
                public IRubyObject call(ThreadContext context, IRubyObject _self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                    RubyPathname self2 = (RubyPathname)_self;
                    args2 = addArg.addArg(args2, self2.path);
                    return mapper.map(context, klass.callMethod(context, name2, args2, block));
                }
            });
        }
    }

    private static void defineDelegateMethods(RubyClass cPathname, RubyModule klass, String ... methods2) {
        RubyPathname.defineDelegateMethodsGeneric(cPathname, klass, IDENTITY_MAPPER, UNSHIFT_PATH, methods2);
    }

    private static void defineDelegateMethodsAppendPath(RubyClass cPathname, RubyModule klass, String ... methods2) {
        RubyPathname.defineDelegateMethodsGeneric(cPathname, klass, IDENTITY_MAPPER, APPEND_PATH, methods2);
    }

    private static void defineDelegateMethodsSinglePath(RubyClass cPathname, RubyModule klass, String ... methods2) {
        RubyPathname.defineDelegateMethodsGeneric(cPathname, klass, SINGLE_PATH_MAPPER, UNSHIFT_PATH, methods2);
    }

    private static void defineDelegateMethodsArrayOfPaths(RubyClass cPathname, RubyModule klass, String ... methods2) {
        RubyPathname.defineDelegateMethodsGeneric(cPathname, klass, ARRAY_OF_PATHS_MAPPER, UNSHIFT_PATH, methods2);
    }

    public RubyPathname(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    public static RubyPathname newInstance(ThreadContext context, RubyClass klass, IRubyObject path2) {
        RubyPathname pathname2 = new RubyPathname(context.runtime, klass);
        return (RubyPathname)pathname2.initialize(context, path2);
    }

    public static RubyPathname newInstance(ThreadContext context, IRubyObject path2) {
        return RubyPathname.newInstance(context, context.runtime.getClass("Pathname"), path2);
    }

    @JRubyMethod
    public IRubyObject initialize(ThreadContext context, IRubyObject path2) {
        RubyString str;
        String toPath = RubyPathname.toPathMethod(context.runtime);
        if (path2.respondsTo(toPath)) {
            path2 = path2.callMethod(context, toPath);
        }
        if ((str = path2.convertToString()).getByteList().indexOf(0) != -1) {
            throw context.runtime.newArgumentError("pathname contains null byte");
        }
        this.infectBy(str);
        this.path = (RubyString)str.dup();
        this.setInstanceVariable("@path", path2);
        return this;
    }

    private static String toPathMethod(Ruby runtime) {
        return runtime.is1_8() ? "to_str" : "to_path";
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_8)
    public IRubyObject to_str(ThreadContext context) {
        return this.path;
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject to_path(ThreadContext context) {
        return this.path;
    }

    @Override
    @JRubyMethod
    public IRubyObject freeze(ThreadContext context) {
        this.path.freeze(context);
        return super.freeze(context);
    }

    @Override
    @JRubyMethod
    public IRubyObject taint(ThreadContext context) {
        this.path.taint(context);
        return super.taint(context);
    }

    @Override
    @JRubyMethod
    public IRubyObject untaint(ThreadContext context) {
        this.path.untaint(context);
        return super.untaint(context);
    }

    @Override
    @JRubyMethod(name={"==", "eql?"})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyPathname) {
            return Helpers.rbEqual(context, this.path, ((RubyPathname)other).path);
        }
        return context.runtime.getFalse();
    }

    private int cmp(RubyPathname other) {
        int i2;
        byte[] a = this.path.getByteList().bytes();
        byte[] b = other.path.getByteList().bytes();
        for (i2 = 0; i2 < a.length && i2 < b.length; ++i2) {
            byte ca = a[i2];
            byte cb = b[i2];
            if (ca == 47) {
                ca = 0;
            }
            if (cb == 47) {
                cb = 0;
            }
            if (ca == cb) continue;
            return ca < cb ? -1 : 1;
        }
        if (i2 < a.length) {
            return 1;
        }
        if (i2 < b.length) {
            return -1;
        }
        return 0;
    }

    @Override
    @JRubyMethod(name={"<=>"})
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyPathname) {
            return context.runtime.newFixnum(this.cmp((RubyPathname)other));
        }
        return context.nil;
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash(ThreadContext context) {
        return this.path.hash();
    }

    @Override
    public int hashCode() {
        return this.path.hashCode();
    }

    @JRubyMethod
    public IRubyObject to_s(ThreadContext context) {
        return this.path.dup();
    }

    @JRubyMethod
    public IRubyObject inspect(ThreadContext context) {
        return context.runtime.newString("<Pathname:" + this.path + ">");
    }

    @JRubyMethod(required=1, optional=1, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject sub(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject result2 = this.path.callMethod(context, "sub", args2, block);
        return RubyPathname.newInstance(context, result2);
    }

    @JRubyMethod
    public IRubyObject sub_ext(ThreadContext context, IRubyObject newExt) {
        IRubyObject ext2 = context.runtime.getFile().callMethod(context, "extname", (IRubyObject)this.path);
        IRubyObject newPath = this.path.chomp(context, ext2).callMethod(context, "+", newExt);
        return RubyPathname.newInstance(context, newPath);
    }

    @JRubyMethod(alias={"fnmatch?"}, required=1, optional=1)
    public IRubyObject fnmatch(ThreadContext context, IRubyObject[] args2) {
        args2 = this.insertPath(args2, 1);
        return context.runtime.getFile().callMethod(context, "fnmatch?", args2);
    }

    @JRubyMethod
    public IRubyObject make_link(ThreadContext context, IRubyObject old) {
        IRubyObject[] args2 = new IRubyObject[]{old, this.path};
        return context.runtime.getFile().callMethod(context, "link", args2);
    }

    @JRubyMethod
    public IRubyObject make_symlink(ThreadContext context, IRubyObject old) {
        IRubyObject[] args2 = new IRubyObject[]{old, this.path};
        return context.runtime.getFile().callMethod(context, "symlink", args2);
    }

    @JRubyMethod(optional=3)
    public IRubyObject each_line(ThreadContext context, IRubyObject[] args2, Block block) {
        return context.runtime.getIO().callMethod(context, "foreach", this.unshiftPath(args2), block);
    }

    @JRubyMethod(alias={"pwd"}, meta=true)
    public static IRubyObject getwd(ThreadContext context, IRubyObject recv2) {
        return RubyPathname.newInstance(context, context.runtime.getDir().callMethod("getwd"));
    }

    @JRubyMethod(required=1, optional=1, meta=true)
    public static IRubyObject glob(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyArray files = RubyPathname.mapToPathnames(context, context.runtime.getDir().callMethod(context, "glob", args2));
        if (block.isGiven()) {
            files.each(context, block);
            return context.nil;
        }
        return files;
    }

    @JRubyMethod
    public IRubyObject opendir(ThreadContext context, Block block) {
        return context.runtime.getDir().callMethod(context, "open", new IRubyObject[]{this.path}, block);
    }

    @JRubyMethod
    public IRubyObject each_entry(ThreadContext context, Block block) {
        if (block.isGiven()) {
            RubyArray entries2 = this.callMethod(context, "entries").convertToArray();
            entries2.each(context, block);
            return context.nil;
        }
        return context.runtime.getDir().callMethod(context, "foreach");
    }

    @JRubyMethod
    public IRubyObject unlink(ThreadContext context) {
        try {
            return context.runtime.getDir().callMethod(context, "unlink", (IRubyObject)this.path);
        }
        catch (RaiseException ex) {
            if (!context.runtime.getErrno().getClass("ENOTDIR").isInstance(ex.getException())) {
                throw ex;
            }
            return context.runtime.getFile().callMethod(context, "unlink", (IRubyObject)this.path);
        }
    }

    private IRubyObject[] insertPath(IRubyObject[] args2, int i2) {
        return RubyPathname.insert(args2, i2, this.path);
    }

    private IRubyObject[] unshiftPath(IRubyObject[] args2) {
        return RubyPathname.insert(args2, 0, this.path);
    }

    private static IRubyObject[] insert(IRubyObject[] old, int i2, IRubyObject obj) {
        IRubyObject[] ary = new IRubyObject[old.length + 1];
        if (i2 > 0) {
            System.arraycopy(old, 0, ary, 0, i2);
        }
        ary[i2] = obj;
        if (old.length > i2) {
            System.arraycopy(old, i2, ary, i2 + 1, old.length - i2);
        }
        return ary;
    }

    private static RubyArray mapToPathnames(ThreadContext context, IRubyObject ary) {
        RubyArray paths = ary.convertToArray();
        for (int i2 = 0; i2 < paths.size(); ++i2) {
            RubyString path2 = paths.eltOk(i2).convertToString();
            paths.store(i2, RubyPathname.newInstance(context, path2));
        }
        return paths;
    }

    public static class PathnameKernelMethods {
        @JRubyMethod(name={"Pathname"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject newPathname(IRubyObject recv2, IRubyObject path2) {
            return RubyPathname.newInstance(recv2.getRuntime().getCurrentContext(), path2);
        }
    }

    static interface AddArg {
        public IRubyObject[] addArg(IRubyObject[] var1, RubyString var2);
    }

    static interface ReturnValueMapper {
        public IRubyObject map(ThreadContext var1, IRubyObject var2);
    }
}

