/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.operands.Stringable;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.util.ByteList;

public class FrozenString
extends ImmutableLiteral
implements Stringable {
    public final ByteList bytelist;
    public final String string;
    public final int coderange;
    public final String file;
    public final int line;

    public FrozenString(ByteList byteList, int cr, String file2, int line) {
        this(FrozenString.internedStringFromByteList(byteList), byteList, cr, file2, line);
    }

    protected FrozenString(String string2, ByteList bytelist, int coderange, String file2, int line) {
        this.bytelist = bytelist;
        this.coderange = coderange;
        this.string = string2;
        this.file = file2;
        this.line = line;
    }

    public FrozenString(String s2) {
        this(s2, ByteList.create(s2));
    }

    private FrozenString(String string2, ByteList byteList) {
        this.bytelist = byteList;
        this.string = string2;
        this.coderange = 16;
        this.file = "<dummy>";
        this.line = -1;
    }

    private static String internedStringFromByteList(ByteList val) {
        try {
            return Helpers.byteListToString(val).intern();
        }
        catch (UnsupportedCharsetException e) {
            return val.toString().intern();
        }
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.FROZEN_STRING;
    }

    @Override
    public boolean hasKnownValue() {
        return true;
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
    }

    public int hashCode() {
        return this.bytelist.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof FrozenString && this.bytelist.equals(((FrozenString)other).bytelist) && this.coderange == ((FrozenString)other).coderange;
    }

    public String toString() {
        return "frozen:\"" + this.string + "\"";
    }

    @Override
    public Operand cloneForInlining(CloneInfo ii) {
        return this;
    }

    @Override
    public Object createCacheObject(ThreadContext context) {
        return IRRuntimeHelpers.newFrozenString(context, this.bytelist, this.coderange, this.file, this.line);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.FrozenString(this);
    }

    public ByteList getByteList() {
        return this.bytelist;
    }

    @Override
    public String getString() {
        return this.string;
    }

    public String getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.bytelist);
        e.encode(this.coderange);
        e.encode(this.file);
        e.encode(this.line);
    }

    public static FrozenString decode(IRReaderDecoder d) {
        return new FrozenString(d.decodeByteList(), d.decodeInt(), d.decodeString(), d.decodeInt());
    }

    public int getCodeRange() {
        return this.coderange;
    }
}

