/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jruby.Ruby;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public abstract class SecurityHelper {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityHelper.class);
    private static boolean attempted = false;

    public static void checkCryptoRestrictions(Ruby runtime) {
        if (!attempted) {
            attempted = true;
            SecurityHelper.setNonRestricted();
        }
    }

    private static boolean setNonRestricted() {
        block5: {
            try {
                Class<?> jceSecurity = Class.forName("javax.crypto.JceSecurity");
                Field isRestricted = jceSecurity.getDeclaredField("isRestricted");
                if (Modifier.isFinal(isRestricted.getModifiers())) {
                    Field modifiers2 = Field.class.getDeclaredField("modifiers");
                    modifiers2.setAccessible(true);
                    modifiers2.setInt(isRestricted, isRestricted.getModifiers() & 0xFFFFFFEF);
                }
                isRestricted.setAccessible(true);
                isRestricted.setBoolean(null, false);
                isRestricted.setAccessible(false);
                return true;
            }
            catch (ClassNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("unable un-restrict jce security: " + e, new Object[0]);
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block5;
                LOG.debug("unable un-restrict jce security: ", e);
            }
        }
        return false;
    }
}

