/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.annotate;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.model.CEnumLeafInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.ElementOutline;
import com.sun.tools.xjc.outline.EnumConstantOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.text.MessageFormat;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.Validate;
import org.jvnet.jaxb2_commons.plugin.annotate.AnnotatePlugin;
import org.jvnet.jaxb2_commons.util.FieldAccessorUtils;
import org.jvnet.jaxb2_commons.util.OutlineUtils;
import org.w3c.dom.Element;

public enum AnnotationTarget {
    PACKAGE("package", AnnotatePlugin.ANNOTATE_PACKAGE_QNAME){

        @Override
        public JAnnotatable getAnnotatable(Outline outline, FieldOutline fieldOutline) {
            return fieldOutline.parent().ref._package();
        }

        @Override
        public JAnnotatable getAnnotatable(Outline outline, ClassOutline classOutline) throws IllegalArgumentException, UnsupportedOperationException {
            return classOutline.ref._package();
        }

        @Override
        public JAnnotatable getAnnotatable(Outline outline, ElementOutline elementOutline) throws IllegalArgumentException, UnsupportedOperationException {
            return elementOutline.implClass._package();
        }

        @Override
        public JAnnotatable getAnnotatable(Outline outline, EnumConstantOutline enumConstantOutline) throws IllegalArgumentException, UnsupportedOperationException {
            CEnumLeafInfo enclosingClass = enumConstantOutline.target.getEnclosingClass();
            return this.getAnnotatable(outline, outline.getEnum(enclosingClass));
        }

        @Override
        public JAnnotatable getAnnotatable(Outline outline, EnumOutline enumOutline) throws IllegalArgumentException, UnsupportedOperationException {
            return enumOutline.clazz._package();
        }
    }
    ,
    CLASS("class", AnnotatePlugin.ANNOTATE_CLASS_QNAME){

        @Override
        public JAnnotatable getAnnotatable(Outline outline, FieldOutline fieldOutline) {
            return fieldOutline.parent().ref;
        }

        @Override
        public JAnnotatable getAnnotatable(Outline outline, ClassOutline classOutline) throws IllegalArgumentException, UnsupportedOperationException {
            return classOutline.ref;
        }
    }
    ,
    PROPERTY_GETTER("getter", AnnotatePlugin.ANNOTATE_PROPERTY_GETTER_QNAME){

        @Override
        public JAnnotatable getAnnotatable(Outline outline, FieldOutline fieldOutline) {
            JMethod _getter = FieldAccessorUtils.getter((FieldOutline)fieldOutline);
            if (_getter == null) {
                throw new IllegalArgumentException(MessageFormat.format("Could not annotate the getter of the field outline [{0}], getter method could not be found.", OutlineUtils.getFieldName((FieldOutline)fieldOutline)));
            }
            return _getter;
        }
    }
    ,
    PROPERTY_SETTER("setter", AnnotatePlugin.ANNOTATE_PROPERTY_SETTER_QNAME){

        @Override
        public JAnnotatable getAnnotatable(Outline outline, FieldOutline fieldOutline) {
            JMethod _setter = FieldAccessorUtils.setter((FieldOutline)fieldOutline);
            if (_setter == null) {
                throw new IllegalArgumentException(MessageFormat.format("Could not annotate the setter of the field outline [{0}], setter method could not be found.", OutlineUtils.getFieldName((FieldOutline)fieldOutline)));
            }
            return _setter;
        }
    }
    ,
    PROPERTY_FIELD("field", AnnotatePlugin.ANNOTATE_PROPERTY_FIELD_QNAME){

        @Override
        public JAnnotatable getAnnotatable(Outline outline, FieldOutline fieldOutline) {
            JFieldVar _field = FieldAccessorUtils.field((FieldOutline)fieldOutline);
            if (_field == null) {
                throw new IllegalArgumentException(MessageFormat.format("Could not annotate the field of the field outline [{0}] since it could not be found.", OutlineUtils.getFieldName((FieldOutline)fieldOutline)));
            }
            return _field;
        }
    }
    ,
    PROPERTY_SETTER_PARAMETER("setter-parameter", AnnotatePlugin.ANNOTATE_PROPERTY_SETTER_PARAMETER_QNAME){

        @Override
        public JAnnotatable getAnnotatable(Outline outline, FieldOutline fieldOutline) {
            JMethod _setter = FieldAccessorUtils.setter((FieldOutline)fieldOutline);
            if (_setter == null) {
                throw new IllegalArgumentException(MessageFormat.format("Could not annotate the setter parameter of the field outline [{0}], setter method could not be found.", OutlineUtils.getFieldName((FieldOutline)fieldOutline)));
            }
            JVar[] params = _setter.listParams();
            if (params.length != 1) {
                throw new IllegalArgumentException(MessageFormat.format("Could not annotate the setter parameter of the field outline [{0}], setter method must have a single parameter(this setter has {1}).", OutlineUtils.getFieldName((FieldOutline)fieldOutline), params.length));
            }
            return params[0];
        }
    }
    ,
    ENUM("enum", AnnotatePlugin.ANNOTATE_ENUM_QNAME){

        @Override
        public JAnnotatable getAnnotatable(Outline outline, EnumConstantOutline enumConstantOutline) throws IllegalArgumentException, UnsupportedOperationException {
            CEnumLeafInfo enclosingClass = enumConstantOutline.target.getEnclosingClass();
            return this.getAnnotatable(outline, outline.getEnum(enclosingClass));
        }

        @Override
        public JAnnotatable getAnnotatable(Outline outline, EnumOutline enumOutline) throws IllegalArgumentException, UnsupportedOperationException {
            return enumOutline.clazz;
        }
    }
    ,
    ENUM_CONSTANT("enum-constant", AnnotatePlugin.ANNOTATE_ENUM_CONSTANT_QNAME){

        @Override
        public JAnnotatable getAnnotatable(Outline outline, EnumConstantOutline enumConstantOutline) throws IllegalArgumentException, UnsupportedOperationException {
            return enumConstantOutline.constRef;
        }
    }
    ,
    ENUM_VALUE_METHOD("enum-value-method", AnnotatePlugin.ANNOTATE_ENUM_VALUE_METHOD_QNAME){

        @Override
        public JAnnotatable getAnnotatable(Outline outline, EnumOutline enumOutline) throws IllegalArgumentException, UnsupportedOperationException {
            JMethod valueMethod = enumOutline.clazz.getMethod("value", new JType[0]);
            if (null == valueMethod) {
                throw new IllegalArgumentException(MessageFormat.format("Could not annotate the value() method of the enum [{0}] since it could not be found.", enumOutline.clazz.name()));
            }
            return valueMethod;
        }
    }
    ,
    ENUM_FROM_VALUE_METHOD("enum-fromValue-method", AnnotatePlugin.ANNOTATE_ENUM_FROM_VALUE_METHOD_QNAME){

        @Override
        public JAnnotatable getAnnotatable(Outline outline, EnumOutline enumOutline) throws IllegalArgumentException, UnsupportedOperationException {
            JCodeModel codeModel = enumOutline.clazz.owner();
            JType jTypeString = codeModel._ref(String.class);
            JMethod fromValueMethod = enumOutline.clazz.getMethod("fromValue", new JType[]{jTypeString});
            if (null == fromValueMethod) {
                throw new IllegalArgumentException(MessageFormat.format("Could not annotate the fromValue(String) method of the enum [{0}] since it could not be found.", enumOutline.clazz.name()));
            }
            return fromValueMethod;
        }
    }
    ,
    ELEMENT("element", AnnotatePlugin.ANNOTATE_ELEMENT_QNAME){

        @Override
        public JAnnotatable getAnnotatable(Outline outline, ElementOutline elementOutline) throws IllegalArgumentException, UnsupportedOperationException {
            return elementOutline.implClass;
        }
    };

    private final String target;
    private final QName name;

    private AnnotationTarget(String target, QName name) {
        this.target = target;
        this.name = name;
    }

    public QName getName() {
        return this.name;
    }

    public String getTarget() {
        return this.target;
    }

    public JAnnotatable getAnnotatable(Outline outline, EnumOutline enumOutline) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException(MessageFormat.format("Annotation target [{0}] cannot be applied to an enum.", this.getTarget()));
    }

    public JAnnotatable getAnnotatable(Outline outline, EnumConstantOutline enumConstantOutline) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException(MessageFormat.format("Annotation target [{0}] cannot be applied to an enum constant.", this.getTarget()));
    }

    public JAnnotatable getAnnotatable(Outline outline, ClassOutline classOutline) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException(MessageFormat.format("Annotation target [{0}] cannot be applied to a class.", this.getTarget()));
    }

    public JAnnotatable getAnnotatable(Outline outline, FieldOutline fieldOutline) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException(MessageFormat.format("Annotation target [{0}] cannot be applied to a field.", this.getTarget()));
    }

    public JAnnotatable getAnnotatable(Outline outline, ElementOutline elementOutline) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException(MessageFormat.format("Annotation target [{0}] cannot be applied to an element.", this.getTarget()));
    }

    public static AnnotationTarget getAnnotationTarget(Element element, AnnotationTarget defaultAnnotationTarget) {
        Validate.notNull((Object)element);
        Validate.notNull((Object)((Object)defaultAnnotationTarget));
        QName name = new QName(element.getNamespaceURI(), element.getLocalName());
        if (AnnotatePlugin.ANNOTATE_QNAME.equals(name) || AnnotatePlugin.ANNOTATE_PROPERTY_QNAME.equals(name)) {
            String target = element.getAttribute("target");
            if (target == null || "".equals(target)) {
                return defaultAnnotationTarget;
            }
            return AnnotationTarget.getAnnotationTarget(target);
        }
        for (AnnotationTarget possibleAnnotationTarget : AnnotationTarget.values()) {
            if (!possibleAnnotationTarget.getName().equals(name)) continue;
            return possibleAnnotationTarget;
        }
        throw new IllegalArgumentException(MessageFormat.format("Unknown annotation element name [{0}].", name));
    }

    public static AnnotationTarget getAnnotationTarget(String target) {
        for (AnnotationTarget possibleAnnotationTarget : AnnotationTarget.values()) {
            if (!possibleAnnotationTarget.getTarget().equals(target)) continue;
            return possibleAnnotationTarget;
        }
        throw new IllegalArgumentException(MessageFormat.format("Unknown annotation target [{0}].", target));
    }
}

