/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.drools.base.rule.KieModuleMetaInfo;
import org.drools.base.rule.TypeMetaInfo;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.util.ClassUtils;
import org.drools.util.IoUtils;
import org.drools.wiring.api.classloader.ProjectClassLoader;
import org.kie.api.builder.ReleaseId;
import org.kie.maven.integration.ArtifactResolver;
import org.kie.scanner.KieModuleMetaData;
import org.kie.util.maven.support.DependencyFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieInJarModuleMetaDataImpl
implements KieModuleMetaData {
    private static final Logger log = LoggerFactory.getLogger(KieInJarModuleMetaDataImpl.class);
    private final Map<String, Collection<String>> classes = new HashMap<String, Collection<String>>();
    private final Map<String, String> processes = new HashMap<String, String>();
    private final Map<String, String> forms = new HashMap<String, String>();
    private final Set<URL> jars = new HashSet<URL>();
    private final Map<String, TypeMetaInfo> typeMetaInfos = new HashMap<String, TypeMetaInfo>();
    private final Map<String, Set<String>> rulesByPackage = new HashMap<String, Set<String>>();
    private final Set<String> packages = new HashSet<String>();
    private final DependencyFilter dependencyFilter;
    private ProjectClassLoader classLoader;
    private ReleaseId releaseId;
    private InternalKieModule kieModule;

    public KieInJarModuleMetaDataImpl(ReleaseId releaseId, DependencyFilter dependencyFilter) {
        this.releaseId = releaseId;
        this.dependencyFilter = dependencyFilter;
        this.init(ArtifactResolver.getResolverFor((ClassLoader)this.getClass().getClassLoader(), (ReleaseId)releaseId, (boolean)false));
    }

    @Override
    public Collection<String> getPackages() {
        return this.packages;
    }

    @Override
    public Collection<String> getClasses(String packageName) {
        Collection<String> classesInPkg = this.classes.get(packageName);
        return classesInPkg != null ? classesInPkg : Collections.emptyList();
    }

    @Override
    public Class<?> getClass(String pkgName, String className) {
        try {
            return Class.forName((String)(pkgName == null || pkgName.trim().length() == 0 ? className : pkgName + "." + className), false, this.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public TypeMetaInfo getTypeMetaInfo(Class<?> clazz) {
        TypeMetaInfo typeMetaInfo = this.typeMetaInfos.get(clazz.getName());
        return typeMetaInfo != null ? typeMetaInfo : new TypeMetaInfo(clazz);
    }

    @Override
    public Collection<String> getRuleNamesInPackage(String packageName) {
        Set<String> rulesPerPackage = this.rulesByPackage.get(packageName);
        return rulesPerPackage != null ? rulesPerPackage : Collections.emptyList();
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            URL[] urls = (URL[])this.jars.stream().toArray(URL[]::new);
            String msg = this.jars.stream().map(e -> e.getFile()).collect(Collectors.joining("\n"));
            log.debug("SpringBoot In Jar ClassLoader:\n{}", (Object)msg);
            this.classLoader = ProjectClassLoader.createProjectClassLoader((ClassLoader)new InJarClassLoader(urls, this.getClass().getClassLoader()));
            if (this.kieModule != null) {
                Map classes = this.kieModule.getClassesMap();
                for (Map.Entry entry : classes.entrySet()) {
                    this.classLoader.storeClass(ClassUtils.convertResourceToClassName((String)((String)entry.getKey())), (String)entry.getKey(), (byte[])entry.getValue());
                }
            }
        }
        return this.classLoader;
    }

    private void init(ArtifactResolver artifactResolver) {
        if (artifactResolver == null) {
            return;
        }
        ArrayList<Object> releasesId = new ArrayList<Object>();
        if (this.releaseId != null) {
            releasesId.add(this.releaseId);
        }
        if (this.kieModule != null && this.kieModule.getPomModel() != null) {
            releasesId.addAll(this.kieModule.getPomModel().getDependencies(this.dependencyFilter));
        } else {
            List dependencies = artifactResolver.getAllDependecies(this.dependencyFilter).stream().map(e -> e.getReleaseId()).collect(Collectors.toList());
            releasesId.addAll(dependencies);
        }
        for (ReleaseId releaseId : releasesId) {
            ArtifactResolver.ArtifactLocation artifactLocation = artifactResolver.resolveArtifactLocation(releaseId);
            this.addArtifact(artifactLocation);
        }
        this.packages.addAll(this.classes.keySet());
        this.packages.addAll(this.rulesByPackage.keySet());
    }

    private void addArtifact(ArtifactResolver.ArtifactLocation artifactLocation) {
        if (artifactLocation != null && artifactLocation.getArtifact().getExtension() != null && artifactLocation.getArtifact().getExtension().equals("jar")) {
            this.addJar(artifactLocation.toURL());
        }
    }

    private void addJar(URL url) {
        if (!this.jars.contains(url)) {
            this.jars.add(url);
            this.scanJar(url);
        }
    }

    private void scanJar(URL jarFile) {
        try (ZipInputStream zipFile = new ZipInputStream(jarFile.openStream());){
            ZipEntry entry;
            while ((entry = zipFile.getNextEntry()) != null) {
                int read;
                int available = zipFile.available();
                if (available <= 0) continue;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((read = zipFile.read(buffer)) > 0) {
                    out.write(buffer, 0, read);
                }
                byte[] blob = out.toByteArray();
                if (blob.length == 0) continue;
                String pathName = entry.getName();
                if (KieInJarModuleMetaDataImpl.isProcessFile(pathName)) {
                    this.processes.put(pathName, new String(blob, IoUtils.UTF8_CHARSET));
                } else if (KieInJarModuleMetaDataImpl.isFormFile(pathName)) {
                    this.forms.put(pathName, new String(blob, IoUtils.UTF8_CHARSET));
                }
                if (this.indexClass(pathName) || !pathName.endsWith(KieModuleModelImpl.KMODULE_INFO_JAR_PATH.asString())) continue;
                this.indexMetaInfo(blob);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean indexClass(String pathName) {
        if (!pathName.endsWith(".class")) {
            return false;
        }
        int separator = pathName.lastIndexOf(47);
        String packageName = separator > 0 ? pathName.substring(0, separator).replace('/', '.') : "";
        String className = pathName.substring(separator + 1, pathName.length() - ".class".length());
        Collection pkg = this.classes.computeIfAbsent(packageName, k -> new HashSet());
        pkg.add(className);
        return true;
    }

    private void indexMetaInfo(byte[] bytes) {
        KieModuleMetaInfo info = KieModuleMetaInfo.unmarshallMetaInfos((String)new String(bytes, IoUtils.UTF8_CHARSET));
        this.typeMetaInfos.putAll(info.getTypeMetaInfos());
        this.rulesByPackage.putAll(info.getRulesByPackage());
    }

    @Override
    public Map<String, String> getProcesses() {
        return this.processes;
    }

    @Override
    public Map<String, String> getForms() {
        return this.forms;
    }

    static boolean isFormFile(String pathName) {
        return pathName.endsWith("frm");
    }

    static boolean isProcessFile(String pathName) {
        return pathName.endsWith("bpmn") || pathName.endsWith("bpmn2") || pathName.endsWith("bpmn-cm");
    }

    private static class InJarClassLoader
    extends ClassLoader {
        private URL[] urls;

        public InJarClassLoader(URL[] urls, ClassLoader parent) {
            super(parent);
            this.urls = urls;
        }

        private Class<?> getClass(String name) throws ClassNotFoundException {
            try {
                String file = ClassUtils.convertClassToResourcePath((String)name);
                Class<?> clazz = null;
                byte[] binaryClassDefinition = this.loadClassData(file);
                if (binaryClassDefinition != null) {
                    clazz = this.defineClass(name, binaryClassDefinition, 0, binaryClassDefinition.length);
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            catch (IOException e) {
                return null;
            }
        }

        private byte[] loadClassData(String name) throws IOException {
            for (URL url : this.urls) {
                byte[] byArray;
                block11: {
                    InputStream stream;
                    block10: {
                        if (url == null) continue;
                        String prefix = "file".equals(url.getProtocol()) ? "jar:" : "";
                        URL tryUrl = new URL(prefix + url.toString() + "!/" + name);
                        stream = tryUrl.openStream();
                        if (stream != null) break block10;
                        if (stream == null) continue;
                        stream.close();
                        continue;
                    }
                    try {
                        byArray = IoUtils.readBytesFromInputStream((InputStream)stream, (boolean)false);
                        if (stream == null) break block11;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    stream.close();
                }
                return byArray;
            }
            return null;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            Class<?> clazz = this.getClass(name);
            return clazz != null ? clazz : super.loadClass(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return Collections.enumeration(this.getJarResources(name));
        }

        @Override
        public URL getResource(String name) {
            List<URL> resources = this.getJarResources(name);
            return !resources.isEmpty() ? resources.get(0) : super.getResource(name);
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            List<URL> resources = this.getJarResources(name);
            try {
                return !resources.isEmpty() ? resources.get(0).openStream() : super.getResourceAsStream(name);
            }
            catch (IOException e) {
                return super.getResourceAsStream(name);
            }
        }

        private List<URL> getJarResources(String name) {
            ArrayList<URL> result = new ArrayList<URL>();
            for (URL url : this.urls) {
                try {
                    String urlToString = url.toString();
                    if (!urlToString.endsWith(".jar")) continue;
                    URL tmp = !urlToString.startsWith("jar:") ? new URL("jar:" + urlToString + "!/" + name) : new URL(urlToString + "!/" + name);
                    tmp.getContent();
                    log.debug("found {} in {}", (Object)tmp, (Object)this.urls);
                    result.add(tmp);
                }
                catch (IOException e) {
                    log.trace("Failed to load resource {} in {}", (Object)name, (Object)url);
                }
            }
            return result;
        }
    }
}

