/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.ext.spring;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.ext.spring.ApplicationContextHolder;
import ch.qos.logback.ext.spring.EventCacheMode;
import ch.qos.logback.ext.spring.ILoggingEventCache;
import java.util.List;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

public class DelegatingLogbackAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private final Object lock;
    private String beanName;
    private ILoggingEventCache cache;
    private EventCacheMode cacheMode = EventCacheMode.ON;
    private volatile Appender<ILoggingEvent> delegate;

    public DelegatingLogbackAppender() {
        this.lock = new Object();
    }

    public void setCacheMode(String mode) {
        this.cacheMode = Enum.valueOf(EventCacheMode.class, mode.toUpperCase());
    }

    public void start() {
        if (this.isStarted()) {
            return;
        }
        if (this.beanName == null || this.beanName.trim().isEmpty()) {
            if (this.name == null || this.name.trim().isEmpty()) {
                throw new IllegalStateException("A 'name' or 'beanName' is required for DelegatingLogbackAppender");
            }
            this.beanName = this.name;
        }
        this.cache = this.cacheMode.createCache();
        super.start();
    }

    public void stop() {
        super.stop();
        if (this.cache != null) {
            this.cache = null;
        }
        if (this.delegate != null) {
            this.delegate.stop();
            this.delegate = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(ILoggingEvent event) {
        if (this.delegate == null) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.isStarted()) {
                    return;
                }
                if (this.delegate == null) {
                    if (ApplicationContextHolder.hasApplicationContext()) {
                        Appender<ILoggingEvent> appender = this.getDelegate();
                        if (appender == null) {
                            return;
                        }
                        List<ILoggingEvent> cachedEvents = this.cache.get();
                        for (ILoggingEvent cachedEvent : cachedEvents) {
                            appender.doAppend((Object)cachedEvent);
                        }
                        this.cache = null;
                        this.delegate = appender;
                    } else {
                        this.cache.put(event);
                        return;
                    }
                }
            }
        }
        this.delegate.doAppend((Object)event);
    }

    private Appender<ILoggingEvent> getDelegate() {
        ApplicationContext context = ApplicationContextHolder.getApplicationContext();
        try {
            Appender appender = (Appender)context.getBean(this.beanName, Appender.class);
            appender.setContext(this.getContext());
            if (!appender.isStarted()) {
                appender.start();
            }
            return appender;
        }
        catch (NoSuchBeanDefinitionException e) {
            this.stop();
            this.addError("The ApplicationContext does not contain an Appender named [" + this.beanName + "]. This delegating appender will now stop processing events.", e);
            return null;
        }
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }
}

