/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import org.luaj.vm2.Buffer;
import org.luaj.vm2.LuaClosure;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaThread;
import org.luaj.vm2.LuaValue;

public abstract class Varargs {
    public abstract LuaValue arg(int var1);

    public abstract int narg();

    public abstract LuaValue arg1();

    public Varargs eval() {
        return this;
    }

    public boolean isTailcall() {
        return false;
    }

    public int type(int n) {
        return this.arg(n).type();
    }

    public boolean isnil(int n) {
        return this.arg(n).isnil();
    }

    public boolean isfunction(int n) {
        return this.arg(n).isfunction();
    }

    public boolean isnumber(int n) {
        return this.arg(n).isnumber();
    }

    public boolean isstring(int n) {
        return this.arg(n).isstring();
    }

    public boolean istable(int n) {
        return this.arg(n).istable();
    }

    public boolean isthread(int n) {
        return this.arg(n).isthread();
    }

    public boolean isuserdata(int n) {
        return this.arg(n).isuserdata();
    }

    public boolean isvalue(int n) {
        return n > 0 && n <= this.narg();
    }

    public boolean optboolean(int n, boolean bl) {
        return this.arg(n).optboolean(bl);
    }

    public LuaClosure optclosure(int n, LuaClosure luaClosure) {
        return this.arg(n).optclosure(luaClosure);
    }

    public double optdouble(int n, double d) {
        return this.arg(n).optdouble(d);
    }

    public LuaFunction optfunction(int n, LuaFunction luaFunction) {
        return this.arg(n).optfunction(luaFunction);
    }

    public int optint(int n, int n2) {
        return this.arg(n).optint(n2);
    }

    public LuaInteger optinteger(int n, LuaInteger luaInteger) {
        return this.arg(n).optinteger(luaInteger);
    }

    public long optlong(int n, long l) {
        return this.arg(n).optlong(l);
    }

    public LuaNumber optnumber(int n, LuaNumber luaNumber) {
        return this.arg(n).optnumber(luaNumber);
    }

    public String optjstring(int n, String string) {
        return this.arg(n).optjstring(string);
    }

    public LuaString optstring(int n, LuaString luaString) {
        return this.arg(n).optstring(luaString);
    }

    public LuaTable opttable(int n, LuaTable luaTable) {
        return this.arg(n).opttable(luaTable);
    }

    public LuaThread optthread(int n, LuaThread luaThread) {
        return this.arg(n).optthread(luaThread);
    }

    public Object optuserdata(int n, Object object) {
        return this.arg(n).optuserdata(object);
    }

    public Object optuserdata(int n, Class clazz, Object object) {
        return this.arg(n).optuserdata(clazz, object);
    }

    public LuaValue optvalue(int n, LuaValue luaValue) {
        return n > 0 && n <= this.narg() ? this.arg(n) : luaValue;
    }

    public boolean checkboolean(int n) {
        return this.arg(n).checkboolean();
    }

    public LuaClosure checkclosure(int n) {
        return this.arg(n).checkclosure();
    }

    public double checkdouble(int n) {
        return this.arg(n).checknumber().todouble();
    }

    public LuaFunction checkfunction(int n) {
        return this.arg(n).checkfunction();
    }

    public int checkint(int n) {
        return this.arg(n).checknumber().toint();
    }

    public LuaInteger checkinteger(int n) {
        return this.arg(n).checkinteger();
    }

    public long checklong(int n) {
        return this.arg(n).checknumber().tolong();
    }

    public LuaNumber checknumber(int n) {
        return this.arg(n).checknumber();
    }

    public String checkjstring(int n) {
        return this.arg(n).checkjstring();
    }

    public LuaString checkstring(int n) {
        return this.arg(n).checkstring();
    }

    public LuaTable checktable(int n) {
        return this.arg(n).checktable();
    }

    public LuaThread checkthread(int n) {
        return this.arg(n).checkthread();
    }

    public Object checkuserdata(int n) {
        return this.arg(n).checkuserdata();
    }

    public Object checkuserdata(int n, Class clazz) {
        return this.arg(n).checkuserdata(clazz);
    }

    public LuaValue checkvalue(int n) {
        return n <= this.narg() ? this.arg(n) : LuaValue.argerror(n, "value expected");
    }

    public LuaValue checknotnil(int n) {
        return this.arg(n).checknotnil();
    }

    public void argcheck(boolean bl, int n, String string) {
        if (!bl) {
            LuaValue.argerror(n, string);
        }
    }

    public boolean isnoneornil(int n) {
        return n > this.narg() || this.arg(n).isnil();
    }

    public boolean toboolean(int n) {
        return this.arg(n).toboolean();
    }

    public byte tobyte(int n) {
        return this.arg(n).tobyte();
    }

    public char tochar(int n) {
        return this.arg(n).tochar();
    }

    public double todouble(int n) {
        return this.arg(n).todouble();
    }

    public float tofloat(int n) {
        return this.arg(n).tofloat();
    }

    public int toint(int n) {
        return this.arg(n).toint();
    }

    public long tolong(int n) {
        return this.arg(n).tolong();
    }

    public String tojstring(int n) {
        return this.arg(n).tojstring();
    }

    public short toshort(int n) {
        return this.arg(n).toshort();
    }

    public Object touserdata(int n) {
        return this.arg(n).touserdata();
    }

    public Object touserdata(int n, Class clazz) {
        return this.arg(n).touserdata(clazz);
    }

    public String tojstring() {
        Buffer buffer = new Buffer();
        buffer.append("(");
        int n = this.narg();
        for (int i = 1; i <= n; ++i) {
            if (i > 1) {
                buffer.append(",");
            }
            buffer.append(this.arg(i).tojstring());
        }
        buffer.append(")");
        return buffer.tojstring();
    }

    public String toString() {
        return this.tojstring();
    }

    public abstract Varargs subargs(int var1);

    static final class ArrayPartVarargs
    extends Varargs {
        private final int offset;
        private final LuaValue[] v;
        private final int length;
        private final Varargs more;

        ArrayPartVarargs(LuaValue[] luaValueArray, int n, int n2) {
            this.v = luaValueArray;
            this.offset = n;
            this.length = n2;
            this.more = LuaValue.NONE;
        }

        public ArrayPartVarargs(LuaValue[] luaValueArray, int n, int n2, Varargs varargs) {
            this.v = luaValueArray;
            this.offset = n;
            this.length = n2;
            this.more = varargs;
        }

        public LuaValue arg(int n) {
            return n < 1 ? LuaValue.NIL : (n <= this.length ? this.v[this.offset + n - 1] : this.more.arg(n - this.length));
        }

        public int narg() {
            return this.length + this.more.narg();
        }

        public LuaValue arg1() {
            return this.length > 0 ? this.v[this.offset] : this.more.arg1();
        }

        public Varargs subargs(int n) {
            if (n <= 0) {
                LuaValue.argerror(1, "start must be > 0");
            }
            if (n == 1) {
                return this;
            }
            if (n > this.length) {
                return this.more.subargs(n - this.length);
            }
            return LuaValue.varargsOf(this.v, this.offset + n - 1, this.length - (n - 1), this.more);
        }
    }

    static final class ArrayVarargs
    extends Varargs {
        private final LuaValue[] v;
        private final Varargs r;

        ArrayVarargs(LuaValue[] luaValueArray, Varargs varargs) {
            this.v = luaValueArray;
            this.r = varargs;
            for (int i = 0; i < luaValueArray.length; ++i) {
                if (luaValueArray[i] != null) continue;
                throw new IllegalArgumentException("nulls in array");
            }
        }

        public LuaValue arg(int n) {
            return n < 1 ? LuaValue.NIL : (n <= this.v.length ? this.v[n - 1] : this.r.arg(n - this.v.length));
        }

        public int narg() {
            return this.v.length + this.r.narg();
        }

        public LuaValue arg1() {
            return this.v.length > 0 ? this.v[0] : this.r.arg1();
        }

        public Varargs subargs(int n) {
            if (n <= 0) {
                LuaValue.argerror(1, "start must be > 0");
            }
            if (n == 1) {
                return this;
            }
            if (n > this.v.length) {
                return this.r.subargs(n - this.v.length);
            }
            return LuaValue.varargsOf(this.v, n - 1, this.v.length - (n - 1), this.r);
        }
    }

    static final class PairVarargs
    extends Varargs {
        private final LuaValue v1;
        private final Varargs v2;

        PairVarargs(LuaValue luaValue, Varargs varargs) {
            this.v1 = luaValue;
            this.v2 = varargs;
        }

        public LuaValue arg(int n) {
            return n == 1 ? this.v1 : this.v2.arg(n - 1);
        }

        public int narg() {
            return 1 + this.v2.narg();
        }

        public LuaValue arg1() {
            return this.v1;
        }

        public Varargs subargs(int n) {
            if (n == 1) {
                return this;
            }
            if (n == 2) {
                return this.v2;
            }
            if (n > 2) {
                return this.v2.subargs(n - 1);
            }
            return LuaValue.argerror(1, "start must be > 0");
        }
    }

    static class SubVarargs
    extends Varargs {
        private final Varargs v;
        private final int start;
        private final int end;

        public SubVarargs(Varargs varargs, int n, int n2) {
            this.v = varargs;
            this.start = n;
            this.end = n2;
        }

        public LuaValue arg(int n) {
            return (n += this.start - 1) >= this.start && n <= this.end ? this.v.arg(n) : LuaValue.NIL;
        }

        public LuaValue arg1() {
            return this.v.arg(this.start);
        }

        public int narg() {
            return this.end + 1 - this.start;
        }

        public Varargs subargs(int n) {
            if (n == 1) {
                return this;
            }
            int n2 = this.start + n - 1;
            if (n > 0) {
                if (n2 >= this.end) {
                    return LuaValue.NONE;
                }
                if (n2 == this.end) {
                    return this.v.arg(this.end);
                }
                if (n2 == this.end - 1) {
                    return new PairVarargs(this.v.arg(this.end - 1), this.v.arg(this.end));
                }
                return new SubVarargs(this.v, n2, this.end);
            }
            return new SubVarargs(this.v, n2, this.end);
        }
    }
}

