/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.ast;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import org.luaj.vm2.LuaString;

public class Str {
    private Str() {
    }

    public static LuaString quoteString(String string) {
        String string2 = string.substring(1, string.length() - 1);
        byte[] byArray = Str.unquote(string2);
        return LuaString.valueOf(byArray);
    }

    public static LuaString charString(String string) {
        String string2 = string.substring(1, string.length() - 1);
        byte[] byArray = Str.unquote(string2);
        return LuaString.valueOf(byArray);
    }

    public static LuaString longString(String string) {
        int n = string.indexOf(91, string.indexOf(91) + 1) + 1;
        String string2 = string.substring(n, string.length() - n);
        byte[] byArray = Str.iso88591bytes(string2);
        return LuaString.valueOf(byArray);
    }

    public static byte[] iso88591bytes(String string) {
        try {
            return string.getBytes("ISO8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("ISO8859-1 not supported");
        }
    }

    public static byte[] unquote(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            if (cArray[i] == '\\' && i < n) {
                switch (cArray[++i]) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        int n2 = cArray[i++] - 48;
                        for (int j = 0; i < n && j < 2 && cArray[i] >= '0' && cArray[i] <= '9'; ++i, ++j) {
                            n2 = n2 * 10 + (cArray[i] - 48);
                        }
                        byteArrayOutputStream.write((byte)n2);
                        --i;
                        break;
                    }
                    case 'a': {
                        byteArrayOutputStream.write(7);
                        break;
                    }
                    case 'b': {
                        byteArrayOutputStream.write(8);
                        break;
                    }
                    case 'f': {
                        byteArrayOutputStream.write(12);
                        break;
                    }
                    case 'n': {
                        byteArrayOutputStream.write(10);
                        break;
                    }
                    case 'r': {
                        byteArrayOutputStream.write(13);
                        break;
                    }
                    case 't': {
                        byteArrayOutputStream.write(9);
                        break;
                    }
                    case 'v': {
                        byteArrayOutputStream.write(11);
                        break;
                    }
                    case '\"': {
                        byteArrayOutputStream.write(34);
                        break;
                    }
                    case '\'': {
                        byteArrayOutputStream.write(39);
                        break;
                    }
                    case '\\': {
                        byteArrayOutputStream.write(92);
                        break;
                    }
                    default: {
                        byteArrayOutputStream.write((byte)cArray[i]);
                        break;
                    }
                }
                continue;
            }
            byteArrayOutputStream.write((byte)cArray[i]);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

