/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.text.XmlNameEncoder;
import org.modeshape.common.xml.StreamingContentHandler;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrSharedNode;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.value.Name;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

@NotThreadSafe
abstract class AbstractJcrExporter {
    private static final TextEncoder NAME_ENCODER = new XmlNameEncoder();
    private static final List<String> UNEXPORTABLE_NAMESPACES = Arrays.asList("", "xml", "xmlns");
    protected final JcrSession session;
    private final Collection<String> restrictedPrefixes;
    private final Map<Name, String> prefixedNames;
    private final Set<NodeKey> shareableNodes = new HashSet<NodeKey>();

    AbstractJcrExporter(JcrSession session, Collection<String> restrictedPrefixes) {
        this.session = session;
        this.restrictedPrefixes = restrictedPrefixes;
        this.prefixedNames = new HashMap<Name, String>();
    }

    protected String getPrefixedName(Name baseName) {
        String prefixedName = this.prefixedNames.get(baseName);
        if (prefixedName == null) {
            prefixedName = baseName.getString(this.session.namespaces());
            this.prefixedNames.put(baseName, prefixedName);
        }
        return prefixedName;
    }

    protected void startDocument(ContentHandler handler) throws SAXException {
        this.shareableNodes.clear();
        handler.startDocument();
    }

    protected void endDocument(ContentHandler handler) throws SAXException {
        handler.endDocument();
    }

    public void exportView(Node exportRootNode, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws RepositoryException, SAXException {
        int i;
        assert (exportRootNode != null);
        assert (contentHandler != null);
        this.session.checkLive();
        NamespaceRegistry registry = this.session.getWorkspace().getNamespaceRegistry();
        this.startDocument(contentHandler);
        String[] namespacePrefixes = registry.getPrefixes();
        for (i = 0; i < namespacePrefixes.length; ++i) {
            String prefix = namespacePrefixes[i];
            if (this.restrictedPrefixes.contains(prefix)) continue;
            contentHandler.startPrefixMapping(prefix, registry.getURI(prefix));
        }
        this.exportNode(exportRootNode, contentHandler, skipBinary, noRecurse);
        for (i = 0; i < namespacePrefixes.length; ++i) {
            if (this.restrictedPrefixes.contains(namespacePrefixes[i])) continue;
            contentHandler.endPrefixMapping(namespacePrefixes[i]);
        }
        this.endDocument(contentHandler);
    }

    public void exportView(Node node, OutputStream os, boolean skipBinary, boolean noRecurse) throws IOException, RepositoryException {
        try {
            this.exportView(node, (ContentHandler)new StreamingContentHandler(os, UNEXPORTABLE_NAMESPACES), skipBinary, noRecurse);
            os.flush();
        }
        catch (SAXException se) {
            throw new RepositoryException((Throwable)se);
        }
    }

    public abstract void exportNode(Node var1, ContentHandler var2, boolean var3, boolean var4) throws RepositoryException, SAXException;

    protected void startElement(ContentHandler contentHandler, Name name, Attributes atts) throws SAXException {
        contentHandler.startElement(name.getNamespaceUri(), NAME_ENCODER.encode(name.getLocalName()), NAME_ENCODER.encode(this.getPrefixedName(name)), atts);
    }

    protected void endElement(ContentHandler contentHandler, Name name) throws SAXException {
        contentHandler.endElement(name.getNamespaceUri(), NAME_ENCODER.encode(name.getLocalName()), NAME_ENCODER.encode(this.getPrefixedName(name)));
    }

    protected void exporting(Node node) throws RepositoryException {
        AbstractJcrNode jcrNode;
        if (node instanceof AbstractJcrNode && (jcrNode = (AbstractJcrNode)node).isShareable()) {
            this.shareableNodes.add(jcrNode.key());
        }
    }

    protected JcrSharedNode asSharedNode(Node node) {
        JcrSharedNode sharedNode;
        NodeKey shareableKey;
        if (node instanceof JcrSharedNode && !this.shareableNodes.add(shareableKey = (sharedNode = (JcrSharedNode)node).key())) {
            return sharedNode;
        }
        return null;
    }
}

