/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.schematic.document.Document;
import org.modeshape.schematic.document.Json;

@NotThreadSafe
public final class BackupDocumentWriter {
    public static final String GZIP_EXTENSION = ".gz";
    public static final String DOCUMENTS_EXTENSION = ".bin";
    private final File parentDirectory;
    private final String filenamePrefix;
    private final boolean compress;
    protected final long maxDocumentsPerFile;
    protected OutputStream stream;
    protected long count = 0L;
    protected long totalCount = 0L;
    protected long fileCount = 0L;
    private final Problems problems;
    private File currentFile;

    public BackupDocumentWriter(File parentDirectory, String filenamePrefix, long documentsPerFile, boolean compress, Problems problems) {
        CheckArg.isNotNull((Object)parentDirectory, (String)"parentDirectory");
        CheckArg.isNotEmpty((String)filenamePrefix, (String)"filenamePrefix");
        CheckArg.isPositive((long)documentsPerFile, (String)"documentsPerFile");
        this.parentDirectory = parentDirectory;
        this.filenamePrefix = filenamePrefix;
        this.maxDocumentsPerFile = documentsPerFile;
        this.problems = problems;
        this.compress = compress;
    }

    public void write(Document document) {
        assert (document != null);
        ++this.count;
        ++this.totalCount;
        if (this.count > this.maxDocumentsPerFile) {
            this.close();
            this.count = 1L;
        }
        try {
            if (this.stream == null) {
                ++this.fileCount;
                String suffix = StringUtil.justifyRight((String)Long.toString(this.fileCount), (int)6, (char)'0');
                String filename = this.filenamePrefix + "_" + suffix + DOCUMENTS_EXTENSION;
                if (this.compress) {
                    filename = filename + GZIP_EXTENSION;
                }
                this.currentFile = new File(this.parentDirectory, filename);
                OutputStream fileStream = new FileOutputStream(this.currentFile);
                if (this.compress) {
                    fileStream = new GZIPOutputStream(fileStream);
                }
                this.stream = new BufferedOutputStream(fileStream);
            }
            Json.write((Document)document, (OutputStream)this.stream);
            this.stream.write(10);
        }
        catch (IOException e) {
            this.problems.addError(JcrI18n.problemsWritingDocumentToBackup, new Object[]{this.currentFile.getAbsolutePath(), e.getMessage()});
        }
    }

    public void close() {
        if (this.stream != null) {
            try {
                this.stream.flush();
                this.stream.close();
            }
            catch (IOException e) {
                this.problems.addError(JcrI18n.problemsClosingBackupFiles, new Object[]{this.parentDirectory.getAbsolutePath(), e.getMessage()});
            }
            finally {
                this.stream = null;
            }
        }
    }

    public long getDocumentCount() {
        return this.totalCount;
    }

    public long getFileCount() {
        return this.fileCount;
    }
}

