/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.change;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.change.AbstractNodeChange;
import org.modeshape.jcr.cache.change.AbstractPropertyChange;
import org.modeshape.jcr.cache.change.BinaryValueUnused;
import org.modeshape.jcr.cache.change.Change;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetListener;
import org.modeshape.jcr.cache.change.NodeAdded;
import org.modeshape.jcr.cache.change.NodeChanged;
import org.modeshape.jcr.cache.change.NodeMoved;
import org.modeshape.jcr.cache.change.NodeRemoved;
import org.modeshape.jcr.cache.change.NodeRenamed;
import org.modeshape.jcr.cache.change.NodeReordered;
import org.modeshape.jcr.cache.change.NodeSequenced;
import org.modeshape.jcr.cache.change.NodeSequencingFailure;
import org.modeshape.jcr.cache.change.RepositoryMetadataChanged;
import org.modeshape.jcr.cache.change.WorkspaceAdded;
import org.modeshape.jcr.cache.change.WorkspaceRemoved;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.Property;

public abstract class ChangeSetAdapter
implements ChangeSetListener {
    protected final ExecutionContext context;
    protected final NodeTypePredicate predicate;

    public ChangeSetAdapter(ExecutionContext context) {
        this(context, null);
    }

    public ChangeSetAdapter(ExecutionContext context, NodeTypePredicate predicate) {
        assert (context != null);
        this.context = context;
        this.predicate = predicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void notify(ChangeSet changeSet) {
        String workspaceName = changeSet.getWorkspaceName();
        if (workspaceName != null) {
            if (!this.includesWorkspace(workspaceName)) return;
            try {
                this.beginWorkspaceChanges();
                HashMap<Name, AbstractPropertyChange> propChanges = new HashMap<Name, AbstractPropertyChange>();
                NodeKey lastKey = null;
                Name lastPrimaryType = null;
                Set<Name> lastMixinTypes = null;
                for (Change change : changeSet) {
                    Set<Name> mixinTypes;
                    AbstractNodeChange anc;
                    Name primaryType;
                    if (!(change instanceof AbstractNodeChange) || !this.matchesType(primaryType = (anc = (AbstractNodeChange)change).getPrimaryType(), mixinTypes = anc.getMixinTypes()) || !this.isQueryable(primaryType, mixinTypes)) continue;
                    if (change instanceof NodeAdded) {
                        this.firePropertyChanges(lastKey, lastPrimaryType, lastMixinTypes, propChanges);
                        NodeAdded added = (NodeAdded)change;
                        this.addNode(workspaceName, added.getKey(), added.getPath(), added.getPrimaryType(), added.getMixinTypes(), this.props(added.getProperties()));
                    } else if (change instanceof NodeRemoved) {
                        this.firePropertyChanges(lastKey, lastPrimaryType, lastMixinTypes, propChanges);
                        NodeRemoved removed = (NodeRemoved)change;
                        this.removeNode(workspaceName, removed.getKey(), removed.getParentKey(), removed.getPath(), removed.getPrimaryType(), removed.getMixinTypes());
                    } else if (change instanceof AbstractPropertyChange) {
                        AbstractPropertyChange propChange = (AbstractPropertyChange)change;
                        if (!propChange.getKey().equals(lastKey)) {
                            this.firePropertyChanges(lastKey, lastPrimaryType, lastMixinTypes, propChanges);
                        }
                        propChanges.put(propChange.getProperty().getName(), propChange);
                    } else if (change instanceof NodeChanged) {
                        this.firePropertyChanges(lastKey, lastPrimaryType, lastMixinTypes, propChanges);
                        NodeChanged nodeChanged = (NodeChanged)change;
                        this.changeNode(workspaceName, nodeChanged.getKey(), nodeChanged.getPath(), nodeChanged.getPrimaryType(), nodeChanged.getMixinTypes());
                    } else if (change instanceof NodeMoved) {
                        this.firePropertyChanges(lastKey, lastPrimaryType, lastMixinTypes, propChanges);
                        NodeMoved moved = (NodeMoved)change;
                        this.moveNode(workspaceName, moved.getKey(), moved.getPrimaryType(), moved.getMixinTypes(), moved.getNewParent(), moved.getOldParent(), moved.getNewPath(), moved.getOldPath());
                    } else if (change instanceof NodeRenamed) {
                        this.firePropertyChanges(lastKey, lastPrimaryType, lastMixinTypes, propChanges);
                        NodeRenamed renamed = (NodeRenamed)change;
                        this.renameNode(workspaceName, renamed.getKey(), renamed.getPath(), renamed.getOldSegment(), renamed.getPrimaryType(), renamed.getMixinTypes());
                    } else if (change instanceof NodeReordered) {
                        this.firePropertyChanges(lastKey, lastPrimaryType, lastMixinTypes, propChanges);
                        NodeReordered reordered = (NodeReordered)change;
                        this.reorderNode(workspaceName, reordered.getKey(), reordered.getPrimaryType(), reordered.getMixinTypes(), reordered.getParent(), reordered.getPath(), reordered.getOldPath(), reordered.getReorderedBeforePath());
                    } else if (change instanceof NodeSequenced) {
                        this.firePropertyChanges(lastKey, lastPrimaryType, lastMixinTypes, propChanges);
                        NodeSequenced s = (NodeSequenced)change;
                        this.sequenced(workspaceName, s.getKey(), s.getPath(), s.getPrimaryType(), s.getMixinTypes(), s.getOutputNodeKey(), s.getOutputNodePath(), s.getOutputPath(), s.getUserId(), s.getSelectedPath(), s.getSequencerName());
                    } else if (change instanceof NodeSequencingFailure) {
                        this.firePropertyChanges(lastKey, lastPrimaryType, lastMixinTypes, propChanges);
                        NodeSequencingFailure f = (NodeSequencingFailure)change;
                        this.sequenceFailure(workspaceName, f.getKey(), f.getPath(), f.getPrimaryType(), f.getMixinTypes(), f.getOutputPath(), f.getUserId(), f.getSelectedPath(), f.getSequencerName(), f.getCause());
                    }
                    lastKey = anc.getKey();
                    lastPrimaryType = anc.getPrimaryType();
                    lastMixinTypes = anc.getMixinTypes();
                }
                if (lastKey == null) return;
                this.firePropertyChanges(lastKey, lastPrimaryType, lastMixinTypes, propChanges);
                return;
            }
            finally {
                this.completeWorkspaceChanges();
            }
        } else {
            this.beginChanges();
            for (Change change : changeSet) {
                if (change instanceof WorkspaceAdded) {
                    WorkspaceAdded added = (WorkspaceAdded)change;
                    this.addWorkspace(added.getWorkspaceName());
                    continue;
                }
                if (change instanceof WorkspaceRemoved) {
                    WorkspaceRemoved removed = (WorkspaceRemoved)change;
                    this.removeWorkspace(removed.getWorkspaceName());
                    continue;
                }
                if (change instanceof RepositoryMetadataChanged) {
                    this.repositoryMetadataChanged();
                    continue;
                }
                if (!(change instanceof BinaryValueUnused)) continue;
                BinaryValueUnused bvu = (BinaryValueUnused)change;
                this.binaryValueUnused(bvu.getKey());
            }
            this.completeChanges();
        }
    }

    private boolean matchesType(Name primaryType, Set<Name> mixinTypes) {
        return this.predicate == null || this.predicate.matchesType(primaryType, mixinTypes);
    }

    private boolean isQueryable(Name primaryType, Set<Name> mixinTypes) {
        return this.predicate == null || this.predicate.isQueryable(primaryType, mixinTypes);
    }

    protected void beginWorkspaceChanges() {
    }

    protected void completeWorkspaceChanges() {
    }

    protected void beginChanges() {
    }

    protected void completeChanges() {
    }

    private void firePropertyChanges(NodeKey key, Name primaryType, Set<Name> mixinTypes, Map<Name, AbstractPropertyChange> propChanges) {
        if (!propChanges.isEmpty()) {
            this.modifyProperties(key, primaryType, mixinTypes, propChanges);
            propChanges.clear();
        }
    }

    protected void modifyProperties(NodeKey key, Name primaryType, Set<Name> mixinTypes, Map<Name, AbstractPropertyChange> propChanges) {
    }

    private final CachedNode.Properties props(final Map<Name, Property> properties) {
        return new CachedNode.Properties(){

            @Override
            public Property getProperty(Name name) {
                return (Property)properties.get(name);
            }

            @Override
            public Iterator<Property> iterator() {
                return properties.values().iterator();
            }
        };
    }

    protected boolean includesWorkspace(String workspaceName) {
        return true;
    }

    protected void addNode(String workspaceName, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, CachedNode.Properties properties) {
    }

    protected void reindexNode(String workspaceName, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, CachedNode.Properties properties, boolean queryable) {
    }

    protected void removeNode(String workspaceName, NodeKey key, NodeKey parentKey, Path path, Name primaryType, Set<Name> mixinTypes) {
    }

    protected void changeNode(String workspaceName, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes) {
    }

    protected void moveNode(String workspaceName, NodeKey key, Name primaryType, Set<Name> mixinTypes, NodeKey oldParent, NodeKey newParent, Path newPath, Path oldPath) {
    }

    protected void renameNode(String workspaceName, NodeKey key, Path newPath, Path.Segment oldSegment, Name primaryType, Set<Name> mixinTypes) {
    }

    protected void reorderNode(String workspaceName, NodeKey key, Name primaryType, Set<Name> mixinTypes, NodeKey parent, Path newPath, Path oldPath, Path reorderedBeforePath) {
    }

    protected void sequenced(String workspaceName, NodeKey sequencedNodeKey, Path sequencedNodePath, Name sequencedNodePrimaryType, Set<Name> sequencedNodeMixinTypes, NodeKey outputNodeKey, Path outputNodePath, String outputPath, String userId, String selectedPath, String sequencerName) {
    }

    protected void sequenceFailure(String workspaceName, NodeKey sequencedNodeKey, Path sequencedNodePath, Name sequencedNodePrimaryType, Set<Name> sequencedNodeMixinTypes, String outputPath, String userId, String selectedPath, String sequencerName, Throwable cause) {
    }

    protected void repositoryMetadataChanged() {
    }

    protected void binaryValueUnused(BinaryKey key) {
    }

    protected void addWorkspace(String workspaceName) {
    }

    protected void removeWorkspace(String workspaceName) {
    }

    public static interface NodeTypePredicate {
        public boolean matchesType(Name var1, Set<Name> var2);

        public boolean isQueryable(Name var1, Set<Name> var2);
    }
}

