/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.local;

import java.util.Comparator;
import java.util.NavigableSet;
import java.util.concurrent.atomic.AtomicLong;
import org.mapdb.DB;
import org.mapdb.Fun;
import org.mapdb.Serializer;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.index.local.IndexValues;
import org.modeshape.jcr.index.local.LocalMapIndex;
import org.modeshape.jcr.index.local.MapDB;

final class LocalDuplicateIndex<T>
extends LocalMapIndex<MapDB.UniqueKey<T>, T> {
    private static final String NEXT_COUNTER = "next-counter";
    private final Logger logger = Logger.getLogger(this.getClass());
    private final AtomicLong counter;

    static <T> LocalDuplicateIndex<T> create(String name, String workspaceName, DB db, IndexValues.Converter<T> converter, Serializer<T> valueSerializer, Comparator<T> comparator) {
        return new LocalDuplicateIndex<T>(name, workspaceName, db, converter, valueSerializer, comparator);
    }

    protected LocalDuplicateIndex(String name, String workspaceName, DB db, IndexValues.Converter<T> converter, Serializer<T> valueSerializer, Comparator<T> comparator) {
        super(name, workspaceName, db, IndexValues.uniqueKeyConverter(converter), MapDB.uniqueKeyBTreeSerializer(valueSerializer, comparator), MapDB.uniqueKeySerializer(valueSerializer, comparator));
        Long nextCounter = (Long)this.options.get(NEXT_COUNTER);
        this.counter = new AtomicLong(nextCounter != null ? nextCounter : 0L);
    }

    @Override
    public void shutdown(boolean destroyed) {
        this.options.put(NEXT_COUNTER, this.counter.get());
        super.shutdown(destroyed);
    }

    @Override
    public void add(String nodeKey, String propertyName, T value) {
        this.logger.trace("Adding node '{0}' to '{1}' index with value '{2}'", new Object[]{nodeKey, this.name, value});
        this.keysByValue.put(new MapDB.UniqueKey<T>(value, this.counter.getAndIncrement()), (Object)nodeKey);
    }

    @Override
    public void remove(String nodeKey, String propertyName, T value) {
        for (MapDB.UniqueKey key : Fun.filter((NavigableSet)this.valuesByKey, (Object)nodeKey)) {
            if (!key.actualKey.equals(value)) continue;
            this.logger.trace("Removing node '{0}' from '{1}' index with value '{2}'", new Object[]{nodeKey, this.name, key.actualKey});
            this.keysByValue.remove((Object)key);
        }
    }

    @Override
    public void remove(String nodeKey) {
        for (MapDB.UniqueKey key : Fun.filter((NavigableSet)this.valuesByKey, (Object)nodeKey)) {
            this.logger.trace("Removing node '{0}' from '{1}' index with value '{2}'", new Object[]{nodeKey, this.name, key.actualKey});
            this.keysByValue.remove((Object)key);
        }
    }
}

