/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.mimetype;

import java.io.InputStream;
import org.apache.tika.detect.Detector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeTypes;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.jcr.Environment;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.mimetype.TikaMimeTypeDetector;

@Immutable
@ThreadSafe
public final class NameOnlyDetector
extends TikaMimeTypeDetector {
    private Detector detector;

    public NameOnlyDetector(Environment environment) {
        super(environment);
    }

    @Override
    protected void initDetector(ClassLoader loader) {
        try {
            this.detector = MimeTypes.getDefaultMimeTypes((ClassLoader)loader);
        }
        catch (Throwable t) {
            throw new SystemFailureException(JcrI18n.unableToInitializeMimeTypeDetector.text(new Object[]{t.getMessage()}), t);
        }
    }

    @Override
    protected String detect(InputStream inputStream, Metadata metadata) {
        try {
            MediaType detectedMimeType = this.detector.detect(null, metadata);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("MIME type for '" + metadata.get("resourceName") + "' ==> " + detectedMimeType, new Object[0]);
            }
            return detectedMimeType.toString();
        }
        catch (Exception e) {
            this.logger.debug((Throwable)e, "Unable to extract mime-type", new Object[0]);
            return null;
        }
    }
}

