/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.engine.process;

import org.mapdb.Serializer;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.query.BufferManager;
import org.modeshape.jcr.query.NodeSequence;
import org.modeshape.jcr.query.RowExtractors;
import org.modeshape.jcr.query.Tuples;
import org.modeshape.jcr.query.engine.process.DelegatingSequence;
import org.modeshape.jcr.query.model.TypeSystem;

public class DistinctSequence
extends DelegatingSequence {
    protected static final Logger LOGGER = Logger.getLogger(DistinctSequence.class);
    protected final RowExtractors.ExtractFromRow keyExtractor;
    private final NodeSequence.RowFilter filter;
    protected final boolean trace = LOGGER.isTraceEnabled();

    public DistinctSequence(NodeSequence delegate, TypeSystem types, BufferManager bufferMgr, boolean useHeap) {
        super(delegate);
        this.keyExtractor = RowExtractors.extractUniqueKey(delegate.width(), types);
        TypeSystem.TypeFactory<NodeKey> keyType = types.getNodeKeyFactory();
        Serializer<?> keySerializer = bufferMgr.serializerFor(keyType);
        Serializer<?> serializer = Tuples.serializer(keySerializer, delegate.width());
        final BufferManager.DistinctBuffer<?> rowsSeen = bufferMgr.createDistinctBuffer(serializer).keepSize(true).useHeap(useHeap).make();
        this.filter = new NodeSequence.RowFilter(){

            @Override
            public boolean isCurrentRowValid(NodeSequence.Batch batch) {
                Object key = DistinctSequence.this.keyExtractor.getValueInRow(batch);
                if (!rowsSeen.addIfAbsent(key)) {
                    if (DistinctSequence.this.trace) {
                        LOGGER.trace("Distinct found existing key: {0}", new Object[]{key});
                    }
                    return false;
                }
                if (DistinctSequence.this.trace) {
                    LOGGER.trace("Distinct found new key: {0}", new Object[]{key});
                }
                return true;
            }
        };
    }

    @Override
    public NodeSequence.Batch nextBatch() {
        NodeSequence.Batch batch = super.nextBatch();
        return NodeSequence.batchFilteredWith(batch, this.filter);
    }

    public String toString() {
        return "(distinct on " + this.filter + " " + this.delegate + ")";
    }
}

