/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.security.acl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.Privilege;
import org.modeshape.jcr.AccessControlManagerImpl;
import org.modeshape.jcr.security.SecurityContext;
import org.modeshape.jcr.security.SimplePrincipal;
import org.modeshape.jcr.security.acl.AccessControlEntryImpl;

public class JcrAccessControlList
implements AccessControlList {
    private HashMap<Principal, AccessControlEntryImpl> principals = new HashMap();
    private final String path;

    public static JcrAccessControlList defaultAcl(AccessControlManagerImpl acm) {
        JcrAccessControlList acl = new JcrAccessControlList("/");
        try {
            acl.principals.put(SimplePrincipal.EVERYONE, new AccessControlEntryImpl(SimplePrincipal.EVERYONE, acm.privileges()));
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        return acl;
    }

    public JcrAccessControlList(String path) {
        this.path = path;
    }

    public boolean isEmpty() {
        return this.principals.isEmpty();
    }

    public AccessControlEntry[] getAccessControlEntries() {
        AccessControlEntry[] list = new AccessControlEntry[this.principals.values().size()];
        this.principals.values().toArray(list);
        return list;
    }

    public boolean addAccessControlEntry(Principal principal, Privilege[] privileges) throws AccessControlException, RepositoryException {
        if (privileges == null || privileges.length == 0) {
            throw new AccessControlException("Invalid privilege array");
        }
        if (principal.getName().equals("unknown")) {
            throw new AccessControlException("Unknown principal");
        }
        if (!this.principals.containsKey(principal)) {
            this.principals.put(principal, new AccessControlEntryImpl(principal, privileges));
            return true;
        }
        AccessControlEntryImpl ace = this.principals.get(principal);
        return ace.addIfNotPresent(privileges);
    }

    public void removeAccessControlEntry(AccessControlEntry accessControlEntry) throws AccessControlException, RepositoryException {
        AccessControlEntry entry = this.principals.remove(accessControlEntry.getPrincipal());
        if (entry == null) {
            throw new AccessControlException("Invalid access control entry");
        }
    }

    public boolean hasPrivileges(SecurityContext sc, Privilege[] privileges) {
        for (AccessControlEntryImpl ace : this.principals.values()) {
            if (ace.getPrincipal().getName().equals(SimplePrincipal.EVERYONE.getName()) && ace.hasPrivileges(privileges)) {
                return true;
            }
            if (ace.getPrincipal().getName().equals(this.username(sc.getUserName())) && ace.hasPrivileges(privileges)) {
                return true;
            }
            if (!sc.hasRole(ace.getPrincipal().getName()) || !ace.hasPrivileges(privileges)) continue;
            return true;
        }
        return false;
    }

    public Privilege[] getPrivileges(SecurityContext context) {
        ArrayList<Privilege> privs = new ArrayList<Privilege>();
        for (AccessControlEntryImpl ace : this.principals.values()) {
            if (ace.getPrincipal().equals(SimplePrincipal.EVERYONE)) {
                privs.addAll(Arrays.asList(ace.getPrivileges()));
            }
            if (ace.getPrincipal().getName().equals(this.username(context.getUserName()))) {
                privs.addAll(Arrays.asList(ace.getPrivileges()));
            }
            if (!context.hasRole(ace.getPrincipal().getName())) continue;
            privs.addAll(Arrays.asList(ace.getPrivileges()));
        }
        Privilege[] res = new Privilege[privs.size()];
        privs.toArray(res);
        return res;
    }

    public boolean hasEntry(String name) {
        AccessControlEntry[] entries = this.getAccessControlEntries();
        for (int i = 0; i < entries.length; ++i) {
            if (!entries[i].getPrincipal().getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof JcrAccessControlList)) {
            return false;
        }
        return ((JcrAccessControlList)other).path.equals(this.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ACL[");
        sb.append(this.path).append(", ");
        if (this.principals.isEmpty()) {
            sb.append(" <is empty>");
        } else {
            Iterator<AccessControlEntryImpl> entryIterator = this.principals.values().iterator();
            while (entryIterator.hasNext()) {
                sb.append(entryIterator.next());
                if (!entryIterator.hasNext()) continue;
                sb.append(",");
            }
        }
        sb.append(']');
        return sb.toString();
    }

    private String username(String username) {
        return username.startsWith("<") && username.endsWith(">") ? username.substring(1, username.length() - 1) : username;
    }
}

