/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jmx;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.jcr.RepositoryException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.api.monitor.DurationActivity;
import org.modeshape.jcr.api.monitor.DurationMetric;
import org.modeshape.jcr.api.monitor.History;
import org.modeshape.jcr.api.monitor.RepositoryMonitor;
import org.modeshape.jcr.api.monitor.Statistics;
import org.modeshape.jcr.api.monitor.ValueMetric;
import org.modeshape.jcr.api.monitor.Window;
import org.modeshape.jmx.DurationData;
import org.modeshape.jmx.EnumDescription;
import org.modeshape.jmx.HistoricalData;
import org.modeshape.jmx.RepositoryStatisticsMXBean;
import org.modeshape.jmx.StatisticalData;

public class RepositoryStatisticsBean
implements RepositoryStatisticsMXBean {
    private static final Logger LOGGER = Logger.getLogger(RepositoryStatisticsBean.class);
    private final RepositoryMonitor monitor;
    private final String repositoryName;

    public RepositoryStatisticsBean(RepositoryMonitor monitor, String repositoryName) {
        this.monitor = monitor;
        this.repositoryName = repositoryName;
    }

    public void start() {
        ObjectName beanName = null;
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            beanName = this.getObjectName();
            server.registerMBean(this, beanName);
        }
        catch (InstanceAlreadyExistsException e) {
            LOGGER.warn((I18nResource)JcrI18n.mBeanAlreadyRegistered, new Object[]{beanName});
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e, (I18nResource)JcrI18n.cannotRegisterMBean, new Object[]{beanName});
        }
    }

    public void stop() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        ObjectName beanName = null;
        try {
            beanName = this.getObjectName();
            server.unregisterMBean(beanName);
        }
        catch (InstanceNotFoundException e) {
            LOGGER.debug("JMX bean {0} not found", new Object[]{beanName});
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e, (I18nResource)JcrI18n.cannotUnRegisterMBean, new Object[]{beanName});
        }
    }

    private ObjectName getObjectName() throws MalformedObjectNameException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("name", this.repositoryName);
        props.put("type", "RepositoryStatistics");
        return new ObjectName("org.modeshape", props);
    }

    @Override
    public List<EnumDescription> getValueMetrics() {
        ArrayList<EnumDescription> result = new ArrayList<EnumDescription>();
        for (ValueMetric metric : RepositoryMonitor.ALL_VALUE_METRICS) {
            result.add(new EnumDescription(metric.name(), metric.getDescription()));
        }
        return result;
    }

    @Override
    public List<EnumDescription> getDurationMetrics() {
        ArrayList<EnumDescription> result = new ArrayList<EnumDescription>();
        for (DurationMetric metric : RepositoryMonitor.ALL_DURATION_METRICS) {
            result.add(new EnumDescription(metric.name(), metric.getDescription()));
        }
        return result;
    }

    @Override
    public List<EnumDescription> getTimeWindows() {
        ArrayList<EnumDescription> result = new ArrayList<EnumDescription>();
        for (Window window : RepositoryMonitor.ALL_WINDOWS) {
            result.add(new EnumDescription(window.name(), window.getLiteral()));
        }
        return result;
    }

    @Override
    public HistoricalData getValues(ValueMetric metric, Window windowInTime) throws MBeanException {
        try {
            History history = this.monitor.getHistory(metric, windowInTime);
            return this.historyToHistoricalData(history);
        }
        catch (RepositoryException e) {
            throw new MBeanException((Exception)((Object)e));
        }
    }

    @Override
    public HistoricalData getDurations(DurationMetric metric, Window windowInTime) throws MBeanException {
        try {
            History history = this.monitor.getHistory(metric, windowInTime);
            return this.historyToHistoricalData(history);
        }
        catch (RepositoryException e) {
            throw new MBeanException((Exception)((Object)e));
        }
    }

    private HistoricalData historyToHistoricalData(History history) {
        ArrayList<StatisticalData> statisticalData = new ArrayList<StatisticalData>();
        for (Statistics statistics : history.getStats()) {
            if (statistics == null) continue;
            statisticalData.add(new StatisticalData(statistics.getCount(), statistics.getMaximum(), statistics.getMinimum(), statistics.getMean(), statistics.getVariance()));
        }
        return new HistoricalData(history.getWindow().getLiteral(), history.getStartTime().getString(), history.getEndTime().getString(), statisticalData);
    }

    @Override
    public List<DurationData> getLongestRunning(DurationMetric metric) throws MBeanException {
        ArrayList<DurationData> longestRunning = new ArrayList<DurationData>();
        try {
            for (DurationActivity durationActivity : this.monitor.getLongestRunning(metric)) {
                longestRunning.add(new DurationData(durationActivity.getDuration(TimeUnit.SECONDS), durationActivity.getPayload()));
            }
            return longestRunning;
        }
        catch (RepositoryException e) {
            throw new MBeanException((Exception)((Object)e));
        }
    }
}

