/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal.crypt;

import com.mongodb.MongoClientException;
import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.vault.DataKeyOptions;
import com.mongodb.client.model.vault.EncryptOptions;
import com.mongodb.crypt.capi.MongoCrypt;
import com.mongodb.crypt.capi.MongoCryptContext;
import com.mongodb.crypt.capi.MongoCryptException;
import com.mongodb.crypt.capi.MongoDataKeyOptions;
import com.mongodb.crypt.capi.MongoExplicitEncryptOptions;
import com.mongodb.crypt.capi.MongoKeyDecryptor;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.internal.capi.MongoCryptHelper;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.internal.crypt.CollectionInfoRetriever;
import com.mongodb.reactivestreams.client.internal.crypt.CommandMarker;
import com.mongodb.reactivestreams.client.internal.crypt.KeyManagementService;
import com.mongodb.reactivestreams.client.internal.crypt.KeyRetriever;
import java.io.Closeable;
import java.util.Map;
import java.util.function.Supplier;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public class Crypt
implements Closeable {
    private static final Logger LOGGER = Loggers.getLogger((String)"client");
    private final MongoCrypt mongoCrypt;
    private final Map<String, Map<String, Object>> kmsProviders;
    private final Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers;
    private final CollectionInfoRetriever collectionInfoRetriever;
    private final CommandMarker commandMarker;
    private final KeyRetriever keyRetriever;
    private final KeyManagementService keyManagementService;
    private final boolean bypassAutoEncryption;
    @Nullable
    private final MongoClient internalClient;

    Crypt(MongoCrypt mongoCrypt, Map<String, Map<String, Object>> kmsProviders, Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers, KeyRetriever keyRetriever, KeyManagementService keyManagementService) {
        this(mongoCrypt, kmsProviders, kmsProviderPropertySuppliers, null, null, keyRetriever, keyManagementService, false, null);
    }

    Crypt(MongoCrypt mongoCrypt, Map<String, Map<String, Object>> kmsProviders, Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers, @Nullable CollectionInfoRetriever collectionInfoRetriever, @Nullable CommandMarker commandMarker, KeyRetriever keyRetriever, KeyManagementService keyManagementService, boolean bypassAutoEncryption, @Nullable MongoClient internalClient) {
        this.mongoCrypt = mongoCrypt;
        this.kmsProviders = kmsProviders;
        this.kmsProviderPropertySuppliers = kmsProviderPropertySuppliers;
        this.collectionInfoRetriever = collectionInfoRetriever;
        this.commandMarker = commandMarker;
        this.keyRetriever = keyRetriever;
        this.keyManagementService = keyManagementService;
        this.bypassAutoEncryption = bypassAutoEncryption;
        this.internalClient = internalClient;
    }

    public Mono<RawBsonDocument> encrypt(String databaseName, RawBsonDocument command) {
        Assertions.notNull((String)"databaseName", (Object)databaseName);
        Assertions.notNull((String)"command", (Object)command);
        if (this.bypassAutoEncryption) {
            return Mono.fromCallable(() -> command);
        }
        return this.executeStateMachine(() -> this.mongoCrypt.createEncryptionContext(databaseName, (BsonDocument)command), databaseName);
    }

    public Mono<RawBsonDocument> decrypt(RawBsonDocument commandResponse) {
        Assertions.notNull((String)"commandResponse", (Object)commandResponse);
        return this.executeStateMachine(() -> this.mongoCrypt.createDecryptionContext((BsonDocument)commandResponse));
    }

    public Mono<RawBsonDocument> createDataKey(String kmsProvider, DataKeyOptions options) {
        Assertions.notNull((String)"kmsProvider", (Object)kmsProvider);
        Assertions.notNull((String)"options", (Object)options);
        return this.executeStateMachine(() -> this.mongoCrypt.createDataKeyContext(kmsProvider, MongoDataKeyOptions.builder().keyAltNames(options.getKeyAltNames()).masterKey(options.getMasterKey()).build()));
    }

    public Mono<BsonBinary> encryptExplicitly(BsonValue value, EncryptOptions options) {
        Assertions.notNull((String)"value", (Object)value);
        Assertions.notNull((String)"options", (Object)options);
        return this.executeStateMachine(() -> {
            MongoExplicitEncryptOptions.Builder encryptOptionsBuilder = MongoExplicitEncryptOptions.builder().algorithm(options.getAlgorithm());
            if (options.getKeyId() != null) {
                encryptOptionsBuilder.keyId(options.getKeyId());
            }
            if (options.getKeyAltName() != null) {
                encryptOptionsBuilder.keyAltName(options.getKeyAltName());
            }
            return this.mongoCrypt.createExplicitEncryptionContext(new BsonDocument("v", value), encryptOptionsBuilder.build());
        }).map(result -> result.getBinary((Object)"v"));
    }

    public Mono<BsonValue> decryptExplicitly(BsonBinary value) {
        Assertions.notNull((String)"value", (Object)value);
        return this.executeStateMachine(() -> this.mongoCrypt.createExplicitDecryptionContext(new BsonDocument("v", (BsonValue)value))).map(result -> result.get((Object)"v"));
    }

    @Override
    public void close() {
        try (MongoCrypt mongoCrypt = this.mongoCrypt;
             CommandMarker commandMarker = this.commandMarker;
             MongoClient internalClient = this.internalClient;){
            KeyManagementService keyManagementService = this.keyManagementService;
            if (keyManagementService != null) {
                keyManagementService.close();
            }
        }
    }

    private Mono<RawBsonDocument> executeStateMachine(Supplier<MongoCryptContext> cryptContextSupplier) {
        return this.executeStateMachine(cryptContextSupplier, null);
    }

    private Mono<RawBsonDocument> executeStateMachine(Supplier<MongoCryptContext> cryptContextSupplier, @Nullable String databaseName) {
        try {
            MongoCryptContext cryptContext = cryptContextSupplier.get();
            return Mono.create(sink -> this.executeStateMachineWithSink(cryptContext, databaseName, (MonoSink<RawBsonDocument>)sink)).doFinally(s -> cryptContext.close()).doOnError(t -> LOGGER.error(String.format("Crypt error: %s", t.getMessage()))).doOnError(MongoCryptException.class, this::wrapInClientException);
        }
        catch (MongoCryptException e) {
            return Mono.error((Throwable)this.wrapInClientException(e));
        }
    }

    private void executeStateMachineWithSink(MongoCryptContext cryptContext, @Nullable String databaseName, MonoSink<RawBsonDocument> sink) {
        MongoCryptContext.State state = cryptContext.getState();
        LOGGER.info("executeStateMachine: " + state);
        switch (state) {
            case NEED_MONGO_COLLINFO: {
                this.collInfo(cryptContext, databaseName, sink);
                break;
            }
            case NEED_MONGO_MARKINGS: {
                this.mark(cryptContext, databaseName, sink);
                break;
            }
            case NEED_KMS_CREDENTIALS: {
                this.fetchCredentials(cryptContext, databaseName, sink);
                break;
            }
            case NEED_MONGO_KEYS: {
                this.fetchKeys(cryptContext, databaseName, sink);
                break;
            }
            case NEED_KMS: {
                this.decryptKeys(cryptContext, databaseName, sink);
                break;
            }
            case READY: {
                sink.success((Object)cryptContext.finish());
                break;
            }
            default: {
                sink.error((Throwable)new MongoInternalException("Unsupported encryptor state + " + state));
            }
        }
    }

    private void fetchCredentials(MongoCryptContext cryptContext, @Nullable String databaseName, MonoSink<RawBsonDocument> sink) {
        try {
            cryptContext.provideKmsProviderCredentials(MongoCryptHelper.fetchCredentials(this.kmsProviders, this.kmsProviderPropertySuppliers));
            this.executeStateMachineWithSink(cryptContext, databaseName, sink);
        }
        catch (Exception e) {
            sink.error((Throwable)e);
        }
    }

    private void collInfo(MongoCryptContext cryptContext, @Nullable String databaseName, MonoSink<RawBsonDocument> sink) {
        if (this.collectionInfoRetriever == null) {
            sink.error((Throwable)new IllegalStateException("Missing collection Info retriever"));
        } else if (databaseName == null) {
            sink.error((Throwable)new IllegalStateException("Missing database name"));
        } else {
            this.collectionInfoRetriever.filter(databaseName, (BsonDocument)cryptContext.getMongoOperation()).doOnSuccess(result -> {
                if (result != null) {
                    cryptContext.addMongoOperationResult(result);
                }
                cryptContext.completeMongoOperation();
                this.executeStateMachineWithSink(cryptContext, databaseName, sink);
            }).doOnError(t -> sink.error((Throwable)MongoException.fromThrowableNonNull((Throwable)t))).subscribe();
        }
    }

    private void mark(MongoCryptContext cryptContext, @Nullable String databaseName, MonoSink<RawBsonDocument> sink) {
        if (this.commandMarker == null) {
            sink.error(this.wrapInClientException((Throwable)new MongoInternalException("Missing command marker")));
        } else if (databaseName == null) {
            sink.error(this.wrapInClientException(new IllegalStateException("Missing database name")));
        } else {
            this.commandMarker.mark(databaseName, cryptContext.getMongoOperation()).doOnSuccess(result -> {
                cryptContext.addMongoOperationResult((BsonDocument)result);
                cryptContext.completeMongoOperation();
                this.executeStateMachineWithSink(cryptContext, databaseName, sink);
            }).doOnError(e -> sink.error(this.wrapInClientException((Throwable)e))).subscribe();
        }
    }

    private void fetchKeys(MongoCryptContext cryptContext, @Nullable String databaseName, MonoSink<RawBsonDocument> sink) {
        this.keyRetriever.find((BsonDocument)cryptContext.getMongoOperation()).doOnSuccess(results -> {
            for (BsonDocument result : results) {
                cryptContext.addMongoOperationResult(result);
            }
            cryptContext.completeMongoOperation();
            this.executeStateMachineWithSink(cryptContext, databaseName, sink);
        }).doOnError(t -> sink.error((Throwable)MongoException.fromThrowableNonNull((Throwable)t))).subscribe();
    }

    private void decryptKeys(MongoCryptContext cryptContext, @Nullable String databaseName, MonoSink<RawBsonDocument> sink) {
        MongoKeyDecryptor keyDecryptor = cryptContext.nextKeyDecryptor();
        if (keyDecryptor != null) {
            this.keyManagementService.decryptKey(keyDecryptor).doOnSuccess(r -> this.decryptKeys(cryptContext, databaseName, sink)).doOnError(e -> sink.error(this.wrapInClientException((Throwable)e))).subscribe();
        } else {
            Mono.fromRunnable(() -> ((MongoCryptContext)cryptContext).completeKeyDecryptors()).doOnSuccess(r -> this.executeStateMachineWithSink(cryptContext, databaseName, sink)).doOnError(e -> sink.error(this.wrapInClientException((Throwable)e))).subscribe();
        }
    }

    private Throwable wrapInClientException(Throwable t) {
        return new MongoClientException("Exception in encryption library: " + t.getMessage(), t);
    }
}

