/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.api;

import java.util.List;

/**
 * The result of a bundle descriptor version range resolution request.
 *
 * @since 1.1
 */
public interface VersionRangeResult {

  /**
   * Gets the versions (in ascending order) that matched the requested range.
   *
   * @return The matching versions (if any), never {@code null}.
   */
  List<String> getVersions();

  /**
   * Gets the lowest version matching the requested range.
   *
   * @return The lowest matching version or {@code null} if no versions matched the requested range.
   */
  String getLowestVersion();

  /**
   * Gets the highest version matching the requested range.
   *
   * @return The highest matching version or {@code null} if no versions matched the requested range.
   */
  String getHighestVersion();

}
