/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.internal.app.declaration.serialization;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import org.mule.runtime.api.app.declaration.serialization.ArtifactDeclarationJsonSerializer;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ParameterGroupElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.internal.app.declaration.serialization.adapter.ElementDeclarationTypeAdapterFactory;
import org.mule.runtime.internal.app.declaration.serialization.adapter.ParameterGroupElementDeclarationTypeAdapter;
import org.mule.runtime.internal.app.declaration.serialization.adapter.ParameterValueTypeAdapter;

public class DefaultArtifactDeclarationJsonSerializer
implements ArtifactDeclarationJsonSerializer {
    private boolean prettyPrint;

    public DefaultArtifactDeclarationJsonSerializer(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    @Override
    public String serialize(ArtifactDeclaration declaration) {
        return this.createGson().toJson((Object)declaration);
    }

    @Override
    public ArtifactDeclaration deserialize(String declaration) {
        return (ArtifactDeclaration)this.createGson().fromJson(declaration, ArtifactDeclaration.class);
    }

    private Gson createGson() {
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new ElementDeclarationTypeAdapterFactory()).registerTypeAdapter(ParameterValue.class, (Object)new ParameterValueTypeAdapter()).registerTypeAdapter(ParameterGroupElementDeclaration.class, (Object)new ParameterGroupElementDeclarationTypeAdapter());
        if (this.prettyPrint) {
            gsonBuilder.setPrettyPrinting();
        }
        return gsonBuilder.create();
    }
}

