/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;

public class SourceConnectionManager {
    private final ConnectionManager connectionManager;
    private final Map<Reference<Object>, ConnectionHandler<Object>> connections = new ConcurrentHashMap<Reference<Object>, ConnectionHandler<Object>>();

    SourceConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    <T> T getConnection(ConfigurationInstance config) throws ConnectionException {
        ConnectionHandler connectionHandler = this.connectionManager.getConnection(config.getValue());
        Object connection = connectionHandler.getConnection();
        this.connections.put((Reference<Object>)new Reference(connection), (ConnectionHandler<Object>)connectionHandler);
        return (T)connection;
    }

    void release(Object connection) {
        ConnectionHandler<Object> connectionHandler = this.connections.remove(new Reference(connection));
        if (connectionHandler != null) {
            connectionHandler.release();
        }
    }

    void invalidate(Object connection) {
        ConnectionHandler<Object> connectionHandler = this.connections.remove(new Reference(connection));
        if (connectionHandler != null) {
            connectionHandler.invalidate();
        }
    }

    ConnectionValidationResult testConnectivity(Object connection) {
        ConnectionHandler<Object> connectionHandler = this.connections.get(new Reference(connection));
        if (connectionHandler == null) {
            throw new IllegalArgumentException("Cannot validate a connection which was not generated through this " + ConnectionProvider.class.getSimpleName());
        }
        return this.connectionManager.testConnectivity(connection, connectionHandler);
    }

    <T> Optional<ConnectionHandler<T>> getConnectionHandler(T connection) {
        return Optional.ofNullable(this.connections.get(new Reference(connection)));
    }
}

