/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice;

import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.type.TypeHandler;
import org.mybatis.guice.AbstractMyBatisModule;
import org.mybatis.guice.Preconditions;

public abstract class XMLMyBatisModule
extends AbstractMyBatisModule {
    private static final String DEFAULT_CONFIG_RESOURCE = "mybatis-config.xml";
    private static final String DEFAULT_ENVIRONMENT_ID = "development";
    private String classPathResource = "mybatis-config.xml";
    private String environmentId = "development";
    private Properties properties = new Properties();

    protected final void setClassPathResource(String classPathResource) {
        Preconditions.checkArgument(classPathResource != null, "Parameter 'classPathResource' must be not null");
        this.classPathResource = classPathResource;
    }

    protected final void setEnvironmentId(String environmentId) {
        Preconditions.checkArgument(environmentId != null, "Parameter 'environmentId' must be not null");
        this.environmentId = environmentId;
    }

    protected final void addProperties(Properties properties) {
        if (properties != null) {
            this.properties.putAll((Map<?, ?>)properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void internalConfigure() {
        this.initialize();
        Reader reader = null;
        reader = Resources.getResourceAsReader((ClassLoader)this.getResourceClassLoader(), (String)this.classPathResource);
        SqlSessionFactory sessionFactory = new SqlSessionFactoryBuilder().build(reader, this.environmentId, this.properties);
        this.bind(SqlSessionFactory.class).toInstance((Object)sessionFactory);
        Configuration configuration = sessionFactory.getConfiguration();
        Collection mapperClasses = configuration.getMapperRegistry().getMappers();
        for (Class mapperType : mapperClasses) {
            this.bindMapper(mapperType);
        }
        Collection allTypeHandlers = configuration.getTypeHandlerRegistry().getTypeHandlers();
        for (TypeHandler handler : allTypeHandlers) {
            this.requestInjection(handler);
        }
        List interceptors = configuration.getInterceptors();
        for (Interceptor interceptor : interceptors) {
            this.requestInjection(interceptor);
        }
        Object var10_10 = null;
        if (reader == null) return;
        try {
            reader.close();
            return;
        }
        catch (IOException e2) {}
        return;
        {
            catch (Exception e) {
                this.addError("Impossible to read classpath resource '%s', see nested exceptions: %s", new Object[]{this.classPathResource, e.getMessage()});
                Object var10_11 = null;
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

