/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.clirr;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.clirr.core.Checker;
import net.sf.clirr.core.CheckerException;
import net.sf.clirr.core.ClassFilter;
import net.sf.clirr.core.DiffListener;
import net.sf.clirr.core.PlainDiffListener;
import net.sf.clirr.core.Severity;
import net.sf.clirr.core.XmlDiffListener;
import net.sf.clirr.core.internal.bcel.BcelJavaType;
import net.sf.clirr.core.internal.bcel.BcelTypeArrayBuilder;
import net.sf.clirr.core.spi.JavaType;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.ClassLoaderRepository;
import org.apache.bcel.util.Repository;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.codehaus.mojo.clirr.AdaptedInterfacesFilter;
import org.codehaus.mojo.clirr.ApiDifferenceFilter;
import org.codehaus.mojo.clirr.ArtifactSpecification;
import org.codehaus.mojo.clirr.ClirrClassFilter;
import org.codehaus.mojo.clirr.ClirrDiffListener;
import org.codehaus.mojo.clirr.DelegatingListener;
import org.codehaus.mojo.clirr.ExternallyInvokedFilter;
import org.codehaus.mojo.clirr.JavaTypeRepository;
import org.codehaus.mojo.clirr.MessageCodeFilter;
import org.codehaus.mojo.clirr.MissingPreviousException;
import org.codehaus.mojo.clirr.SkipDeprecatedFilter;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.IOUtil;

public abstract class AbstractClirrMojo
extends AbstractMojo {
    protected boolean skip;
    protected MavenProject project;
    protected ArtifactResolver resolver;
    protected ArtifactFactory factory;
    protected ArtifactRepository localRepository;
    private ArtifactMetadataSource metadataSource;
    private MavenProjectBuilder mavenProjectBuilder;
    protected File classesDirectory;
    protected String comparisonVersion;
    protected Integer versionsBack;
    protected boolean ignoreMaintenenceVersions;
    protected ArtifactSpecification[] comparisonArtifacts;
    protected String minSeverity;
    protected File textOutputFile;
    protected File xmlOutputFile;
    protected String[] includes;
    protected String[] excludes;
    protected boolean logResults;
    protected Set<String> excludeMessageCodes = new HashSet<String>();
    protected Set<String> includeMessageCodes = new HashSet<String>();
    protected boolean ignoreDeprecatedMethods;
    protected Set<String> adapterAnnotations = new HashSet<String>();
    protected Set<String> externallyInvokedAnnotations;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution");
        } else {
            this.doExecute();
        }
    }

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    public ClirrDiffListener executeClirr() throws MojoExecutionException, MojoFailureException {
        return this.executeClirr(null);
    }

    protected ClirrDiffListener executeClirr(Severity minSeverity) throws MojoExecutionException, MojoFailureException {
        ClirrClassFilter classFilter = new ClirrClassFilter(this.includes, this.excludes);
        JavaTypeRepository origClasses = this.resolvePreviousReleaseClasses(classFilter);
        JavaTypeRepository currentClasses = this.resolveCurrentClasses(classFilter);
        ClirrDiffListener listener = this.createDiffListener(origClasses, currentClasses);
        Checker checker = new Checker();
        ArrayList<ClirrDiffListener> listeners = new ArrayList<ClirrDiffListener>();
        listeners.add(listener);
        if (this.xmlOutputFile != null) {
            try {
                listeners.add((ClirrDiffListener)new XmlDiffListener(this.xmlOutputFile.getAbsolutePath()));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error adding '" + this.xmlOutputFile + "' for output: " + e.getMessage(), (Exception)e);
            }
        }
        if (this.textOutputFile != null) {
            try {
                listeners.add((ClirrDiffListener)new PlainDiffListener(this.textOutputFile.getAbsolutePath()));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error adding '" + this.textOutputFile + "' for output: " + e.getMessage(), (Exception)e);
            }
        }
        checker.addDiffListener((DiffListener)new DelegatingListener(listeners, minSeverity));
        this.reportDiffs(checker, origClasses.getRawJavaTypes(), currentClasses.getRawJavaTypes());
        return listener;
    }

    protected ClirrDiffListener createDiffListener(JavaTypeRepository origClasses, JavaTypeRepository currentClasses) {
        ArrayList<ApiDifferenceFilter> filters = new ArrayList<ApiDifferenceFilter>();
        filters.add(new MessageCodeFilter(this.toIntegerSet(this.includeMessageCodes), this.toIntegerSet(this.excludeMessageCodes)));
        if (this.ignoreDeprecatedMethods) {
            filters.add(new SkipDeprecatedFilter(origClasses));
        }
        if (this.adapterAnnotations != null && this.adapterAnnotations.size() > 0) {
            filters.add(new AdaptedInterfacesFilter(this.adapterAnnotations, origClasses));
        }
        if (this.externallyInvokedAnnotations != null && this.externallyInvokedAnnotations.size() > 0) {
            filters.add(new ExternallyInvokedFilter(this.externallyInvokedAnnotations, origClasses));
        }
        ClirrDiffListener listener = new ClirrDiffListener(filters.toArray(new ApiDifferenceFilter[filters.size()]));
        return listener;
    }

    protected Set<Integer> toIntegerSet(Set<String> set) {
        HashSet<Integer> ints = new HashSet<Integer>();
        for (String str : set) {
            ints.add(Integer.valueOf(str));
        }
        return ints;
    }

    private JavaTypeRepository resolveCurrentClasses(ClassFilter classFilter) throws MojoExecutionException {
        try {
            ClassLoader currentDepCL = AbstractClirrMojo.createClassLoader(this.project.getArtifacts(), null);
            return new JavaTypeRepository(AbstractClirrMojo.createClassSet(this.classesDirectory, currentDepCL, classFilter), currentDepCL);
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error creating classloader for current classes", (Exception)e);
        }
    }

    private JavaTypeRepository resolvePreviousReleaseClasses(ClassFilter classFilter) throws MojoFailureException, MojoExecutionException {
        Set<Artifact> previousArtifacts;
        Artifact firstPreviousArtifact;
        if (this.comparisonArtifacts == null) {
            firstPreviousArtifact = this.getComparisonArtifact();
            this.comparisonVersion = firstPreviousArtifact.getVersion();
            this.getLog().info((CharSequence)("Comparing to version: " + this.comparisonVersion));
            previousArtifacts = Collections.singleton(firstPreviousArtifact);
        } else {
            previousArtifacts = this.resolveArtifacts(this.comparisonArtifacts);
            Artifact a = null;
            for (Artifact artifact : previousArtifacts) {
                if (a == null) {
                    a = artifact;
                }
                this.getLog().debug((CharSequence)("Comparing to " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + ":" + artifact.getClassifier() + ":" + artifact.getType()));
            }
            firstPreviousArtifact = a;
        }
        try {
            for (Artifact artifact : previousArtifacts) {
                this.resolver.resolve(artifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
            }
            List dependencies = this.getTransitiveDependencies(previousArtifacts);
            ClassLoader origDepCL = AbstractClirrMojo.createClassLoader(dependencies, previousArtifacts);
            HashSet<File> files = new HashSet<File>();
            for (Artifact artifact : previousArtifacts) {
                if (!"jar".equals(artifact.getType()) && !"maven-plugin".equals(artifact.getType())) continue;
                files.add(new File(this.localRepository.getBasedir(), this.localRepository.pathOf(artifact)));
            }
            ClassLoader prevArtifactClassLoader = AbstractClirrMojo.createClassLoader(dependencies, null);
            return new JavaTypeRepository(BcelTypeArrayBuilder.createClassSet((File[])files.toArray(new File[files.size()]), (ClassLoader)origDepCL, (ClassFilter)classFilter), prevArtifactClassLoader);
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException("Failed to build project for previous artifact: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (InvalidDependencyVersionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactResolutionException e) {
            throw new MissingPreviousException("Error resolving previous version: " + e.getMessage(), e);
        }
        catch (ArtifactNotFoundException e) {
            this.getLog().warn((CharSequence)"Impossible to find previous version");
            return new JavaTypeRepository(new JavaType[0], ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error creating classloader for previous version's classes", (Exception)e);
        }
    }

    protected List getTransitiveDependencies(Set previousArtifacts) throws ProjectBuildingException, InvalidDependencyVersionException, ArtifactResolutionException, ArtifactNotFoundException {
        ArrayList dependencies = new ArrayList();
        for (Artifact a : previousArtifacts) {
            Artifact pomArtifact = this.factory.createArtifact(a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getScope(), "pom");
            MavenProject pomProject = this.mavenProjectBuilder.buildFromRepository(pomArtifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
            Set pomProjectArtifacts = pomProject.createArtifacts(this.factory, null, null);
            ArtifactResolutionResult result = this.resolver.resolveTransitively(pomProjectArtifacts, pomArtifact, this.localRepository, this.project.getRemoteArtifactRepositories(), this.metadataSource, null);
            dependencies.addAll(result.getArtifacts());
        }
        return dependencies;
    }

    private Artifact resolveArtifact(ArtifactSpecification artifactSpec) throws MojoFailureException, MojoExecutionException {
        String groupId = artifactSpec.getGroupId();
        if (groupId == null) {
            throw new MojoFailureException("An artifacts groupId is required.");
        }
        String artifactId = artifactSpec.getArtifactId();
        if (artifactId == null) {
            throw new MojoFailureException("An artifacts artifactId is required.");
        }
        String version = artifactSpec.getVersion();
        if (version == null) {
            throw new MojoFailureException("An artifacts version number is required.");
        }
        VersionRange versionRange = VersionRange.createFromVersion((String)version);
        String type = artifactSpec.getType();
        if (type == null) {
            type = "jar";
        }
        Artifact artifact = this.factory.createDependencyArtifact(groupId, artifactId, versionRange, type, artifactSpec.getClassifier(), "compile");
        return artifact;
    }

    protected Set resolveArtifacts(ArtifactSpecification[] artifacts) throws MojoFailureException, MojoExecutionException {
        HashSet<Artifact> artifactSet = new HashSet<Artifact>();
        Artifact[] result = new Artifact[artifacts.length];
        for (int i = 0; i < result.length; ++i) {
            artifactSet.add(this.resolveArtifact(artifacts[i]));
        }
        return artifactSet;
    }

    private Artifact getComparisonArtifact() throws MojoFailureException, MojoExecutionException {
        try {
            if (this.versionsBack != null && this.versionsBack > 0) {
                while ((this.versionsBack = Integer.valueOf(this.versionsBack - 1)) >= 0) {
                    this.comparisonVersion = "(," + this.getComparisonArtifact(VersionRange.createFromVersionSpec((String)this.comparisonVersion), this.ignoreMaintenenceVersions).getVersion() + ")";
                }
            }
            return this.getComparisonArtifact(VersionRange.createFromVersionSpec((String)this.comparisonVersion), this.ignoreMaintenenceVersions);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoFailureException("Invalid comparison version: " + e.getMessage());
        }
    }

    private Artifact getComparisonArtifact(VersionRange range, boolean ignoreMaintenenceVersions) throws MojoFailureException, MojoExecutionException {
        Artifact previousArtifact = this.getArtifact(range);
        if (ignoreMaintenenceVersions && this.isMaintenenceVersion(previousArtifact.getVersion())) {
            return this.getArtifact(VersionRange.createFromVersion((String)this.getMinorVersionFromMaintenenceVersion(previousArtifact.getVersion())));
        }
        return previousArtifact;
    }

    private String getMinorVersionFromMaintenenceVersion(String version) {
        String[] parts;
        if (version != null && (parts = version.split("\\.")).length >= 2) {
            return parts[0] + "." + parts[1];
        }
        return version;
    }

    private boolean isMaintenenceVersion(String version) {
        return version != null && version.split("\\.").length > 2;
    }

    private Artifact getArtifact(VersionRange range) throws MojoFailureException, MojoExecutionException {
        Artifact previousArtifact;
        try {
            previousArtifact = this.factory.createDependencyArtifact(this.project.getGroupId(), this.project.getArtifactId(), range, this.project.getPackaging(), null, "compile");
            if (!previousArtifact.getVersionRange().isSelectedVersionKnown(previousArtifact)) {
                this.getLog().debug((CharSequence)("Searching for versions in range: " + previousArtifact.getVersionRange()));
                List availableVersions = this.metadataSource.retrieveAvailableVersions(previousArtifact, this.localRepository, this.project.getRemoteArtifactRepositories());
                this.filterSnapshots(availableVersions);
                ArtifactVersion version = range.matchVersion(availableVersions);
                if (version != null) {
                    previousArtifact.selectVersion(version.toString());
                }
            }
        }
        catch (OverConstrainedVersionException e1) {
            throw new MojoFailureException("Invalid comparison version: " + e1.getMessage());
        }
        catch (ArtifactMetadataRetrievalException e11) {
            throw new MojoExecutionException("Error determining previous version: " + e11.getMessage(), (Exception)((Object)e11));
        }
        if (previousArtifact.getVersion() == null) {
            this.getLog().info((CharSequence)"Unable to find a previous version of the project in the repository");
        }
        return previousArtifact;
    }

    private void filterSnapshots(List versions) {
        Iterator versionIterator = versions.iterator();
        while (versionIterator.hasNext()) {
            ArtifactVersion version = (ArtifactVersion)versionIterator.next();
            if (!"SNAPSHOT".equals(version.getQualifier())) continue;
            versionIterator.remove();
        }
    }

    public static JavaType[] createClassSet(File classes, ClassLoader thirdPartyClasses, ClassFilter classFilter) throws MalformedURLException {
        URLClassLoader classLoader = new URLClassLoader(new URL[]{classes.toURI().toURL()}, thirdPartyClasses);
        ClassLoaderRepository repository = new ClassLoaderRepository((ClassLoader)classLoader);
        ArrayList<BcelJavaType> selected = new ArrayList<BcelJavaType>();
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(classes);
        scanner.setIncludes(new String[]{"**/*.class"});
        scanner.scan();
        String[] files = scanner.getIncludedFiles();
        for (int i = 0; i < files.length; ++i) {
            File f = new File(classes, files[i]);
            JavaClass clazz = AbstractClirrMojo.extractClass(f, (Repository)repository);
            if (!classFilter.isSelected(clazz)) continue;
            selected.add(new BcelJavaType(clazz));
            repository.storeClass(clazz);
        }
        JavaType[] ret = new JavaType[selected.size()];
        selected.toArray(ret);
        return ret;
    }

    private static JavaClass extractClass(File f, Repository repository) throws CheckerException {
        JavaClass javaClass;
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            ClassParser parser = new ClassParser((InputStream)is, f.getName());
            JavaClass clazz = parser.parse();
            clazz.setRepository(repository);
            javaClass = clazz;
        }
        catch (IOException ex) {
            try {
                throw new CheckerException("Cannot read " + f, (Throwable)ex);
            }
            catch (Throwable throwable) {
                IOUtil.close(is);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)is);
        return javaClass;
    }

    protected static ClassLoader createClassLoader(Collection<Artifact> artifacts, Set<Artifact> previousArtifacts) throws MalformedURLException {
        URLClassLoader cl = null;
        if (!artifacts.isEmpty()) {
            ArrayList<URL> urls = new ArrayList<URL>(artifacts.size());
            for (Artifact artifact : artifacts) {
                if (previousArtifacts != null && previousArtifacts.contains(artifact)) continue;
                urls.add(artifact.getFile().toURI().toURL());
            }
            if (!urls.isEmpty()) {
                cl = new URLClassLoader(urls.toArray(new URL[urls.size()]));
            }
        }
        return cl;
    }

    protected static Severity convertSeverity(String minSeverity) {
        Object s = "info".equals(minSeverity) ? Severity.INFO : ("warning".equals(minSeverity) ? Severity.WARNING : ("error".equals(minSeverity) ? Severity.ERROR : null));
        return s;
    }

    protected boolean canGenerate() throws MojoFailureException, MojoExecutionException {
        Artifact previousArtifact;
        boolean classes = false;
        if (this.classesDirectory.exists()) {
            classes = true;
        } else {
            this.getLog().debug((CharSequence)("Classes directory not found: " + this.classesDirectory));
        }
        if (!classes) {
            this.getLog().info((CharSequence)"Not generating Clirr report as there are no classes generated by the project");
            return false;
        }
        if ((this.comparisonArtifacts == null || this.comparisonArtifacts.length == 0) && (previousArtifact = this.getComparisonArtifact()).getVersion() == null) {
            this.getLog().info((CharSequence)"Not generating Clirr report as there is no previous version of the library to compare against");
            return false;
        }
        return true;
    }

    private void reportDiffs(Checker checker, JavaType[] origClasses, JavaType[] currentClasses) {
        try {
            checker.reportDiffs(origClasses, currentClasses);
        }
        catch (CheckerException e) {
            int i;
            e.printStackTrace();
            this.getLog().error((CharSequence)e.getMessage());
            int matchingClasses = 0;
            int j = 0;
            for (int i2 = 0; i2 < origClasses.length; ++i2) {
                if (e.getMessage().endsWith(origClasses[i2].getName())) continue;
                ++matchingClasses;
            }
            JavaType[] origClasses2 = new JavaType[matchingClasses];
            for (i = 0; i < origClasses.length; ++i) {
                if (e.getMessage().endsWith(origClasses[i].getName())) continue;
                origClasses2[j++] = origClasses[i];
            }
            matchingClasses = 0;
            j = 0;
            for (i = 0; i < currentClasses.length; ++i) {
                if (e.getMessage().endsWith(currentClasses[i].getName())) continue;
                ++matchingClasses;
            }
            JavaType[] currentClasses2 = new JavaType[matchingClasses];
            for (int i3 = 0; i3 < currentClasses.length; ++i3) {
                if (e.getMessage().endsWith(currentClasses[i3].getName())) continue;
                currentClasses2[j++] = currentClasses[i3];
            }
            this.reportDiffs(checker, origClasses2, currentClasses2);
        }
    }
}

