/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import org.neo4j.helpers.Numbers;

public final class Preconditions {
    private Preconditions() {
        throw new AssertionError((Object)"no instances");
    }

    public static long requirePositive(long value) {
        if (value < 1L) {
            throw new IllegalArgumentException("Expected positive long value, got " + value);
        }
        return value;
    }

    public static long requirePowerOfTwo(long value) {
        if (!Numbers.isPowerOfTwo(value)) {
            throw new IllegalArgumentException("Expected long value to be a non zero power of 2, got " + value);
        }
        return value;
    }

    public static int requirePositive(int value) {
        if (value < 1) {
            throw new IllegalArgumentException("Expected positive int value, got " + value);
        }
        return value;
    }

    public static long requireNonNegative(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("Expected non-negative long value, got " + value);
        }
        return value;
    }

    public static int requireNonNegative(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Expected non-negative int value, got " + value);
        }
        return value;
    }

    public static int requireExactlyZero(int value) {
        if (value != 0) {
            throw new IllegalArgumentException("Expected int value equal to 0, got " + value);
        }
        return value;
    }

    public static void checkState(boolean expression, String message) {
        if (!expression) {
            throw new IllegalStateException(message);
        }
    }

    public static void checkArgument(boolean expression, String message, Object ... args) {
        if (!expression) {
            throw new IllegalArgumentException(args.length > 0 ? String.format(message, args) : message);
        }
    }

    public static void requireBetween(int value, int lowInclusive, int highExclusive) {
        if (value < lowInclusive || value >= highExclusive) {
            throw new IllegalArgumentException(String.format("Expected int value between %d (inclusive) and %d (exclusive), got %d.", lowInclusive, highExclusive, value));
        }
    }
}

