/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.function.Function;
import org.neo4j.consistency.checking.ChainCheck;
import org.neo4j.consistency.checking.PropertyRecordCheck;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.full.MandatoryProperties;
import org.neo4j.consistency.checking.full.PropertyAndNodeIndexedCheck;
import org.neo4j.consistency.checking.full.PropertyReader;
import org.neo4j.consistency.checking.full.RecordProcessor;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;

public class PropertyAndNode2LabelIndexProcessor
extends RecordProcessor.Adapter<NodeRecord> {
    private final ConsistencyReporter reporter;
    private final RecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> nodeIndexCheck;
    private final RecordCheck<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> propertyCheck;
    private final CacheAccess cacheAccess;
    private final Function<NodeRecord, MandatoryProperties.Check<NodeRecord, ConsistencyReport.NodeConsistencyReport>> mandatoryProperties;

    public PropertyAndNode2LabelIndexProcessor(ConsistencyReporter reporter, IndexAccessors indexes, PropertyReader propertyReader, CacheAccess cacheAccess, Function<NodeRecord, MandatoryProperties.Check<NodeRecord, ConsistencyReport.NodeConsistencyReport>> mandatoryProperties) {
        this.reporter = reporter;
        this.cacheAccess = cacheAccess;
        this.mandatoryProperties = mandatoryProperties;
        this.nodeIndexCheck = new PropertyAndNodeIndexedCheck(indexes, propertyReader, cacheAccess);
        this.propertyCheck = new PropertyRecordCheck();
    }

    @Override
    public void process(NodeRecord nodeRecord) {
        this.reporter.forNode(nodeRecord, this.nodeIndexCheck);
        CacheAccess.Client client = this.cacheAccess.client();
        try (MandatoryProperties.Check<NodeRecord, ConsistencyReport.NodeConsistencyReport> mandatoryCheck = this.mandatoryProperties.apply(nodeRecord);){
            for (PropertyRecord property : client.getPropertiesFromCache()) {
                this.reporter.forProperty(property, this.propertyCheck);
                mandatoryCheck.receive(ChainCheck.keys(property));
            }
        }
    }
}

