/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.executionplan.builders;

import org.neo4j.cypher.MissingIndexException;
import org.neo4j.cypher.internal.commands.NodeById;
import org.neo4j.cypher.internal.commands.NodeByIndex;
import org.neo4j.cypher.internal.commands.NodeByIndexQuery;
import org.neo4j.cypher.internal.commands.RelationshipByIndex;
import org.neo4j.cypher.internal.commands.RelationshipByIndexQuery;
import org.neo4j.cypher.internal.commands.StartItem;
import org.neo4j.cypher.internal.commands.expressions.Expression;
import org.neo4j.cypher.internal.executionplan.builders.GetGraphElements$;
import org.neo4j.cypher.internal.executionplan.builders.IndexQueryBuilder$;
import org.neo4j.cypher.internal.pipes.ExecutionContext;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.IndexHits;
import scala.Function1;
import scala.MatchError;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IndexQueryBuilder$
implements ScalaObject {
    public static final IndexQueryBuilder$ MODULE$;

    static {
        new IndexQueryBuilder$();
    }

    public Function1<ExecutionContext, Iterable<Node>> getNodeGetter(StartItem startItem, GraphDatabaseService graph$1) {
        StartItem startItem2;
        block5: {
            Object object;
            block3: {
                block4: {
                    block2: {
                        startItem2 = startItem;
                        if (!(startItem2 instanceof NodeByIndex)) break block2;
                        NodeByIndex nodeByIndex = (NodeByIndex)startItem2;
                        String string2 = nodeByIndex.idxName();
                        Expression expression2 = nodeByIndex.key();
                        Expression expression3 = nodeByIndex.expression();
                        String idxName$1 = string2;
                        Expression key$1 = expression2;
                        Expression value$1 = expression3;
                        this.checkNodeIndex(idxName$1, graph$1);
                        object = new Serializable(graph$1, idxName$1, key$1, value$1){
                            public static final long serialVersionUID;
                            private final GraphDatabaseService graph$1;
                            private final String idxName$1;
                            private final Expression key$1;
                            private final Expression value$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final List<Node> apply(ExecutionContext m) {
                                String keyVal = this.key$1.apply(m).toString();
                                Object valueVal = this.value$1.apply(m);
                                IndexHits indexHits = this.graph$1.index().forNodes(this.idxName$1).get(keyVal, valueVal);
                                List r = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)indexHits).asScala()).toList();
                                return r;
                            }
                            {
                                this.graph$1 = graphDatabaseService;
                                this.idxName$1 = string2;
                                this.key$1 = expression2;
                                this.value$1 = expression3;
                            }
                        };
                        break block3;
                    }
                    if (!(startItem2 instanceof NodeByIndexQuery)) break block4;
                    NodeByIndexQuery nodeByIndexQuery = (NodeByIndexQuery)startItem2;
                    String string3 = nodeByIndexQuery.idxName();
                    Expression expression4 = nodeByIndexQuery.query();
                    String idxName$2 = string3;
                    Expression query$1 = expression4;
                    this.checkNodeIndex(idxName$2, graph$1);
                    object = new Serializable(graph$1, idxName$2, query$1){
                        public static final long serialVersionUID;
                        private final GraphDatabaseService graph$1;
                        private final String idxName$2;
                        private final Expression query$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final List<Node> apply(ExecutionContext m) {
                            Object queryText = this.query$1.apply(m);
                            IndexHits indexHits = this.graph$1.index().forNodes(this.idxName$2).query(queryText);
                            List r = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)indexHits).asScala()).toList();
                            return r;
                        }
                        {
                            this.graph$1 = graphDatabaseService;
                            this.idxName$2 = string2;
                            this.query$1 = expression2;
                        }
                    };
                    break block3;
                }
                if (!(startItem2 instanceof NodeById)) break block5;
                NodeById nodeById = (NodeById)startItem2;
                String string4 = nodeById.varName();
                Expression expression5 = nodeById.expression();
                String varName$1 = string4;
                Expression ids$1 = expression5;
                object = new Serializable(graph$1, varName$1, ids$1){
                    public static final long serialVersionUID;
                    public final GraphDatabaseService graph$1;
                    private final String varName$1;
                    private final Expression ids$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Seq<Node> apply(ExecutionContext m) {
                        return GetGraphElements$.MODULE$.getElements(this.ids$1.apply(m), this.varName$1, new Serializable(this){
                            public static final long serialVersionUID;
                            private final anonfun.getNodeGetter.3 $outer;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final Node apply(long l) {
                                return this.$outer.graph$1.getNodeById(l);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    {
                        this.graph$1 = graphDatabaseService;
                        this.varName$1 = string2;
                        this.ids$1 = expression2;
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)startItem2);
    }

    public Function1<ExecutionContext, Iterable<Relationship>> getRelationshipGetter(StartItem startItem, GraphDatabaseService graph$2) {
        StartItem startItem2;
        block4: {
            Object object;
            block3: {
                block2: {
                    startItem2 = startItem;
                    if (!(startItem2 instanceof RelationshipByIndex)) break block2;
                    RelationshipByIndex relationshipByIndex = (RelationshipByIndex)startItem2;
                    String string2 = relationshipByIndex.idxName();
                    Expression expression2 = relationshipByIndex.key();
                    Expression expression3 = relationshipByIndex.expression();
                    String idxName$3 = string2;
                    Expression key$2 = expression2;
                    Expression value$2 = expression3;
                    this.checkRelIndex(idxName$3, graph$2);
                    object = new Serializable(graph$2, idxName$3, key$2, value$2){
                        public static final long serialVersionUID;
                        private final GraphDatabaseService graph$2;
                        private final String idxName$3;
                        private final Expression key$2;
                        private final Expression value$2;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final Iterable<Relationship> apply(ExecutionContext m) {
                            String keyVal = this.key$2.apply(m).toString();
                            Object valueVal = this.value$2.apply(m);
                            IndexHits indexHits = this.graph$2.index().forRelationships(this.idxName$3).get(keyVal, valueVal);
                            return (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)indexHits).asScala();
                        }
                        {
                            this.graph$2 = graphDatabaseService;
                            this.idxName$3 = string2;
                            this.key$2 = expression2;
                            this.value$2 = expression3;
                        }
                    };
                    break block3;
                }
                if (!(startItem2 instanceof RelationshipByIndexQuery)) break block4;
                RelationshipByIndexQuery relationshipByIndexQuery = (RelationshipByIndexQuery)startItem2;
                String string3 = relationshipByIndexQuery.idxName();
                Expression expression4 = relationshipByIndexQuery.query();
                String idxName$4 = string3;
                Expression query$2 = expression4;
                this.checkRelIndex(idxName$4, graph$2);
                object = new Serializable(graph$2, idxName$4, query$2){
                    public static final long serialVersionUID;
                    private final GraphDatabaseService graph$2;
                    private final String idxName$4;
                    private final Expression query$2;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Iterable<Relationship> apply(ExecutionContext m) {
                        Object queryText = this.query$2.apply(m);
                        IndexHits indexHits = this.graph$2.index().forRelationships(this.idxName$4).query(queryText);
                        return (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)indexHits).asScala();
                    }
                    {
                        this.graph$2 = graphDatabaseService;
                        this.idxName$4 = string2;
                        this.query$2 = expression2;
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)startItem2);
    }

    private void checkNodeIndex(String idxName, GraphDatabaseService graph) {
        if (graph.index().existsForNodes(idxName)) {
            return;
        }
        throw new MissingIndexException(idxName);
    }

    private void checkRelIndex(String idxName, GraphDatabaseService graph) {
        if (graph.index().existsForRelationships(idxName)) {
            return;
        }
        throw new MissingIndexException(idxName);
    }

    private IndexQueryBuilder$() {
        MODULE$ = this;
    }
}

