/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.collector;

import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.internal.collector.ActionResult;
import org.neo4j.internal.collector.Anonymizer;
import org.neo4j.internal.collector.CollectorStateMachine;
import org.neo4j.internal.collector.DataCollector;
import org.neo4j.internal.collector.GraphCountsSection;
import org.neo4j.internal.collector.IdAnonymizer;
import org.neo4j.internal.collector.PlainText;
import org.neo4j.internal.collector.QueriesSection;
import org.neo4j.internal.collector.QueryCollector;
import org.neo4j.internal.collector.RetrieveConfig;
import org.neo4j.internal.collector.RetrieveResult;
import org.neo4j.internal.collector.Sections;
import org.neo4j.internal.collector.StatusResult;
import org.neo4j.internal.collector.TokensSection;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.query.QuerySnapshot;
import org.neo4j.procedure.Admin;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class DataCollectorProcedures {
    @Context
    public DataCollector dataCollector;
    @Context
    public KernelTransaction transaction;

    @Admin
    @Description(value="Retrieve statistical data about the current database. Valid sections are 'GRAPH COUNTS', 'TOKENS', 'QUERIES'")
    @Procedure(name="db.stats.retrieve", mode=Mode.READ)
    public Stream<RetrieveResult> retrieve(@Name(value="section") String section, @Name(value="config", defaultValue="") Map<String, Object> config) throws InvalidArgumentsException, IndexNotFoundKernelException, TransactionFailureException {
        String upperSection;
        switch (upperSection = section.toUpperCase()) {
            case "GRAPH COUNTS": {
                return GraphCountsSection.retrieve(this.dataCollector.kernel, Anonymizer.PLAIN_TEXT);
            }
            case "TOKENS": {
                return TokensSection.retrieve(this.dataCollector.kernel);
            }
            case "QUERIES": {
                return QueriesSection.retrieve((Iterator<QuerySnapshot>)this.dataCollector.queryCollector.doGetData(), new PlainText(this.dataCollector.valueMapper), RetrieveConfig.of(config).maxInvocations);
            }
        }
        throw Sections.unknownSectionException(section);
    }

    @Admin
    @Description(value="Retrieve all available statistical data about the current database, in an anonymized form.")
    @Procedure(name="db.stats.retrieveAllAnonymized", mode=Mode.READ)
    public Stream<RetrieveResult> retrieveAllAnonymized(@Name(value="graphToken") String graphToken, @Name(value="config", defaultValue="") Map<String, Object> config) throws IndexNotFoundKernelException, TransactionFailureException, InvalidArgumentsException {
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        metaData.put("graphToken", graphToken);
        metaData.put("retrieveTime", ZonedDateTime.now());
        TokensSection.putTokenCounts(metaData, this.dataCollector.kernel);
        Stream<RetrieveResult> meta = Stream.of(new RetrieveResult("META", metaData));
        return Stream.of(meta, GraphCountsSection.retrieve(this.dataCollector.kernel, Anonymizer.IDS), QueriesSection.retrieve((Iterator<QuerySnapshot>)this.dataCollector.queryCollector.doGetData(), new IdAnonymizer(this.transaction.tokenRead()), RetrieveConfig.of(config).maxInvocations)).flatMap(x -> x);
    }

    @Admin
    @Description(value="Retrieve the status of all available collector daemons, for this database.")
    @Procedure(name="db.stats.status", mode=Mode.READ)
    public Stream<StatusResult> status() {
        CollectorStateMachine.Status status = this.dataCollector.queryCollector.status();
        return Stream.of(new StatusResult("QUERIES", status.message, Collections.emptyMap()));
    }

    @Admin
    @Description(value="Start data collection of a given data section. Valid sections are 'QUERIES'")
    @Procedure(name="db.stats.collect", mode=Mode.READ)
    public Stream<ActionResult> collect(@Name(value="section") String section, @Name(value="config", defaultValue="") Map<String, Object> config) throws InvalidArgumentsException {
        CollectorStateMachine.Result result = this.collectorStateMachine(section).collect(config);
        return Stream.of(new ActionResult(section, result.success, result.message));
    }

    @Admin
    @Description(value="Stop data collection of a given data section. Valid sections are 'QUERIES'")
    @Procedure(name="db.stats.stop", mode=Mode.READ)
    public Stream<ActionResult> stop(@Name(value="section") String section) throws InvalidArgumentsException {
        CollectorStateMachine.Result result = this.collectorStateMachine(section).stop(Long.MAX_VALUE);
        return Stream.of(new ActionResult(section, result.success, result.message));
    }

    @Admin
    @Description(value="Clear collected data of a given data section. Valid sections are 'QUERIES'")
    @Procedure(name="db.stats.clear", mode=Mode.READ)
    public Stream<ActionResult> clear(@Name(value="section") String section) throws InvalidArgumentsException {
        CollectorStateMachine.Result result = this.collectorStateMachine(section).clear();
        return Stream.of(new ActionResult(section, result.success, result.message));
    }

    private QueryCollector collectorStateMachine(String section) throws InvalidArgumentsException {
        switch (section) {
            case "TOKENS": 
            case "GRAPH COUNTS": {
                throw new InvalidArgumentsException("Section '%s' does not have to be explicitly collected, it can always be directly retrieved.");
            }
            case "QUERIES": {
                return this.dataCollector.queryCollector;
            }
        }
        throw Sections.unknownSectionException(section);
    }
}

