/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.io.compress.ZipUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.impl.index.schema.NativeIndexHeaderReader;

public class NativeIndexes {
    private NativeIndexes() {
    }

    public static InternalIndexState readState(PageCache pageCache, File indexFile) throws IOException {
        NativeIndexHeaderReader headerReader = new NativeIndexHeaderReader(GBPTree.NO_HEADER_READER);
        GBPTree.readHeader((PageCache)pageCache, (File)indexFile, (Header.Reader)headerReader);
        switch (headerReader.state) {
            case 0: {
                return InternalIndexState.FAILED;
            }
            case 1: {
                return InternalIndexState.ONLINE;
            }
            case 2: {
                return InternalIndexState.POPULATING;
            }
        }
        throw new IllegalStateException("Unexpected initial state byte value " + headerReader.state);
    }

    static String readFailureMessage(PageCache pageCache, File indexFile) throws IOException {
        NativeIndexHeaderReader headerReader = new NativeIndexHeaderReader(GBPTree.NO_HEADER_READER);
        GBPTree.readHeader((PageCache)pageCache, (File)indexFile, (Header.Reader)headerReader);
        return headerReader.failureMessage;
    }

    public static boolean deleteIndex(FileSystemAbstraction fs, IndexDirectoryStructure directoryStructure, long indexId, boolean archiveIfExists) throws IOException {
        File rootIndexDirectory = directoryStructure.directoryForIndex(indexId);
        if (archiveIfExists && fs.isDirectory(rootIndexDirectory) && fs.fileExists(rootIndexDirectory) && fs.listFiles(rootIndexDirectory).length > 0) {
            ZipUtils.zip((FileSystemAbstraction)fs, (File)rootIndexDirectory, (File)new File(rootIndexDirectory.getParent(), "archive-" + rootIndexDirectory.getName() + "-" + System.currentTimeMillis() + ".zip"));
            return true;
        }
        fs.deleteRecursively(rootIndexDirectory);
        return false;
    }
}

