/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.store.MetaDataStore;

public class StoreVersionCheck {
    private final PageCache pageCache;

    public StoreVersionCheck(PageCache pageCache) {
        this.pageCache = pageCache;
    }

    public Optional<String> getVersion(File neostoreFile) throws IOException {
        long record = MetaDataStore.getRecord(this.pageCache, neostoreFile, MetaDataStore.Position.STORE_VERSION);
        if (record == -1L) {
            return Optional.empty();
        }
        return Optional.of(MetaDataStore.versionLongToString(record));
    }

    public Result hasVersion(File neostoreFile, String expectedVersion) {
        Optional<String> storeVersion;
        try {
            storeVersion = this.getVersion(neostoreFile);
        }
        catch (IOException e) {
            return new Result(Result.Outcome.missingStoreFile, null, neostoreFile.getName());
        }
        return storeVersion.map(v -> expectedVersion.equals(v) ? new Result(Result.Outcome.ok, null, neostoreFile.getName()) : new Result(Result.Outcome.unexpectedStoreVersion, (String)v, neostoreFile.getName())).orElseGet(() -> new Result(Result.Outcome.storeVersionNotFound, null, neostoreFile.getName()));
    }

    public static class Result {
        public final Outcome outcome;
        public final String actualVersion;
        public final String storeFilename;

        public Result(Outcome outcome, String actualVersion, String storeFilename) {
            this.outcome = outcome;
            this.actualVersion = actualVersion;
            this.storeFilename = storeFilename;
        }

        public static enum Outcome {
            ok(true),
            missingStoreFile(false),
            storeVersionNotFound(false),
            unexpectedStoreVersion(false),
            attemptedStoreDowngrade(false),
            storeNotCleanlyShutDown(false);

            private final boolean success;

            private Outcome(boolean success) {
                this.success = success;
            }

            public boolean isSuccessful() {
                return this.success;
            }
        }
    }
}

