/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.embedded.driver;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.neo4j.ogm.driver.AbstractConfigurableDriver;
import org.neo4j.ogm.driver.ParameterConversion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum EmbeddedBasedParameterConversion implements ParameterConversion
{
    INSTANCE;

    private final Logger logger = LoggerFactory.getLogger(EmbeddedBasedParameterConversion.class);
    private final ParameterConversion fallback = AbstractConfigurableDriver.CONVERT_ALL_PARAMETERS_CONVERSION;
    private Predicate<Map.Entry<String, Object>> canConvert;

    private EmbeddedBasedParameterConversion() {
        try {
            String fqnOfValues = "org.neo4j.values.storable.Values";
            Method unsafeOf = Class.forName(fqnOfValues).getDeclaredMethod("unsafeOf", Object.class, Boolean.TYPE);
            this.canConvert = new WrappedValuesUnsafeOf(unsafeOf);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            this.logger.warn("Cannot use native type conversion prior to Neo4j 3.3.x");
            this.canConvert = anyObject -> false;
        }
    }

    public Map<String, Object> convertParameters(Map<String, Object> originalParameter) {
        Map<Boolean, Map<String, Object>> allParameters = originalParameter.entrySet().stream().collect(Collectors.partitioningBy(this.canConvert, Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        HashMap<String, Object> convertedParameters = new HashMap<String, Object>(originalParameter.size());
        convertedParameters.putAll(allParameters.get(true));
        convertedParameters.putAll(this.fallback.convertParameters(allParameters.get(false)));
        return convertedParameters;
    }

    private static class WrappedValuesUnsafeOf
    implements Predicate<Map.Entry<String, Object>> {
        private final Method unsafeOf;

        WrappedValuesUnsafeOf(Method unsafeOf) {
            this.unsafeOf = unsafeOf;
        }

        @Override
        public boolean test(Map.Entry<String, Object> o) {
            try {
                return this.unsafeOf.invoke(null, o.getValue(), true) != null;
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                return false;
            }
        }
    }
}

