/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.model;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.openapi4j.operation.validator.model.impl.Body;

public interface Request {
    public String getPath();

    public Method getMethod();

    public Body getBody();

    public String getQuery();

    public Map<String, String> getCookies();

    public Map<String, Collection<String>> getHeaders();

    public Collection<String> getHeaderValues(String var1);

    default public String getHeaderValue(String name) {
        Collection<String> values = this.getHeaderValues(name);
        if (values != null) {
            return values.stream().findFirst().orElse(null);
        }
        return null;
    }

    default public String getContentType() {
        return this.getHeaderValue("Content-Type");
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        PATCH,
        DELETE,
        HEAD,
        OPTIONS,
        TRACE;

        private static final Map<String, Method> BY_LABEL;

        public static Method getMethod(String value) {
            return BY_LABEL.get(value);
        }

        static {
            BY_LABEL = new TreeMap<String, Method>(String.CASE_INSENSITIVE_ORDER);
            for (Method e : Method.values()) {
                BY_LABEL.put(e.name(), e);
            }
        }
    }
}

