/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.model.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import org.openapi4j.operation.validator.util.ContentConverter;
import org.openapi4j.parser.model.v3.Schema;

public class Body {
    private static final String BODY_REQUIRED_ERR_MSG = "Body content is required.";
    private final Map<String, Object> bodyMap;
    private final JsonNode bodyNode;
    private final String bodyStr;
    private final InputStream bodyIs;

    private Body(Map<String, Object> body) {
        this.bodyMap = body;
        this.bodyNode = null;
        this.bodyStr = null;
        this.bodyIs = null;
    }

    private Body(JsonNode bodyNode) {
        this.bodyMap = null;
        this.bodyNode = bodyNode;
        this.bodyStr = null;
        this.bodyIs = null;
    }

    private Body(String body) {
        this.bodyMap = null;
        this.bodyNode = null;
        this.bodyStr = body;
        this.bodyIs = null;
    }

    private Body(InputStream bodyIs) {
        this.bodyMap = null;
        this.bodyNode = null;
        this.bodyStr = null;
        this.bodyIs = bodyIs;
    }

    public static Body from(JsonNode body) {
        Objects.requireNonNull(body, BODY_REQUIRED_ERR_MSG);
        return new Body(body);
    }

    public static Body from(Map<String, Object> body) {
        Objects.requireNonNull(body, BODY_REQUIRED_ERR_MSG);
        return new Body(body);
    }

    public static Body from(String body) {
        Objects.requireNonNull(body, BODY_REQUIRED_ERR_MSG);
        return new Body(body);
    }

    public static Body from(InputStream body) {
        Objects.requireNonNull(body, BODY_REQUIRED_ERR_MSG);
        return new Body(body);
    }

    public JsonNode getContentAsNode(Schema schema, String rawContentType) throws IOException {
        if (this.bodyNode != null) {
            return this.bodyNode;
        }
        if (this.bodyMap != null) {
            return ContentConverter.mapToNode(schema, this.bodyMap);
        }
        return ContentConverter.convert(schema, rawContentType, this.bodyIs, this.bodyStr);
    }
}

