/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.openapi4j.core.util.IOUtil;
import org.openapi4j.core.util.TreeUtil;
import org.openapi4j.operation.validator.util.ContentType;
import org.openapi4j.operation.validator.util.FormUrlConverter;
import org.openapi4j.operation.validator.util.MultipartConverter;
import org.openapi4j.operation.validator.util.TypeConverter;
import org.openapi4j.operation.validator.util.XmlConverter;
import org.openapi4j.parser.model.v3.Schema;

public final class ContentConverter {
    private ContentConverter() {
    }

    public static JsonNode convert(Schema schema, String rawContentType, InputStream is, String str) throws IOException {
        String contentType = ContentType.getTypeOnly(rawContentType);
        if (ContentType.isJson(contentType)) {
            return is != null ? ContentConverter.jsonToNode(is) : ContentConverter.jsonToNode(str);
        }
        if (ContentType.isXml(contentType)) {
            return is != null ? ContentConverter.xmlToNode(schema, is) : ContentConverter.xmlToNode(schema, str);
        }
        if (ContentType.isFormUrlEncoded(contentType)) {
            return is != null ? ContentConverter.formUrlEncodedToNode(schema, rawContentType, is) : ContentConverter.formUrlEncodedToNode(schema, rawContentType, str);
        }
        if (ContentType.isMultipartFormData(contentType)) {
            return is != null ? ContentConverter.multipartToNode(schema, rawContentType, is) : ContentConverter.multipartToNode(schema, rawContentType, str);
        }
        return is != null ? ContentConverter.textToNode(is) : ContentConverter.textToNode(str);
    }

    private static JsonNode formUrlEncodedToNode(Schema schema, String rawContentType, InputStream content) throws IOException {
        String encoding = ContentType.getCharSet(rawContentType);
        return FormUrlConverter.instance().formUrlEncodedToNode(schema, content, encoding);
    }

    private static JsonNode formUrlEncodedToNode(Schema schema, String rawContentType, String content) {
        String encoding = ContentType.getCharSet(rawContentType);
        return FormUrlConverter.instance().formUrlEncodedToNode(schema, content, encoding);
    }

    private static JsonNode multipartToNode(Schema schema, String rawContentType, InputStream content) throws IOException {
        String encoding = ContentType.getCharSet(rawContentType);
        return MultipartConverter.instance().multipartToNode(schema, content, rawContentType, encoding);
    }

    private static JsonNode multipartToNode(Schema schema, String rawContentType, String content) throws IOException {
        String encoding = ContentType.getCharSet(rawContentType);
        return MultipartConverter.instance().multipartToNode(schema, content, rawContentType, encoding);
    }

    private static JsonNode jsonToNode(InputStream content) throws IOException {
        return TreeUtil.json.readTree(content);
    }

    private static JsonNode jsonToNode(String content) throws IOException {
        return TreeUtil.json.readTree(content);
    }

    private static JsonNode xmlToNode(Schema schema, InputStream content) throws IOException {
        return XmlConverter.instance().xmlToNode(schema, IOUtil.toString((InputStream)content, (String)StandardCharsets.UTF_8.name()));
    }

    private static JsonNode xmlToNode(Schema schema, String content) {
        return XmlConverter.instance().xmlToNode(schema, content);
    }

    private static JsonNode textToNode(InputStream content) throws IOException {
        return JsonNodeFactory.instance.textNode(IOUtil.toString((InputStream)content, (String)StandardCharsets.UTF_8.name()));
    }

    private static JsonNode textToNode(String content) {
        return JsonNodeFactory.instance.textNode(content);
    }

    public static JsonNode mapToNode(Schema schema, Map<String, Object> content) {
        return TypeConverter.instance().convertObject(schema, content);
    }
}

