/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.util;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapi4j.core.util.IOUtil;
import org.openapi4j.operation.validator.util.ContentConverter;
import org.openapi4j.parser.model.v3.Schema;

class FormUrlConverter {
    private static final Pattern QUERY_STRING_PATTERN = Pattern.compile("([^&=]+?)\\s*=([^&=]*)");
    private static final FormUrlConverter INSTANCE = new FormUrlConverter();

    private FormUrlConverter() {
    }

    public static FormUrlConverter instance() {
        return INSTANCE;
    }

    JsonNode formUrlEncodedToNode(Schema schema, InputStream body, String encoding) throws IOException {
        return this.formUrlEncodedToNode(schema, IOUtil.toString((InputStream)body, (String)encoding), encoding);
    }

    JsonNode formUrlEncodedToNode(Schema schema, String body, String encoding) {
        String decodedBody;
        try {
            decodedBody = URLDecoder.decode(body, encoding);
        }
        catch (UnsupportedEncodingException e) {
            try {
                decodedBody = URLDecoder.decode(body, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException ignored) {
                decodedBody = body;
            }
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        Matcher matcher = QUERY_STRING_PATTERN.matcher(decodedBody);
        while (matcher.find()) {
            Object value = params.get(matcher.group(1));
            if (value == null) {
                params.put(matcher.group(1), matcher.group(2));
                continue;
            }
            if (value instanceof List) {
                ((List)value).add(matcher.group(2));
                continue;
            }
            ArrayList<Object> values = new ArrayList<Object>();
            values.add(value);
            values.add(matcher.group(2));
            params.put(matcher.group(1), values);
        }
        return ContentConverter.mapToNode(schema, params);
    }
}

