/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.UploadContext;
import org.openapi4j.core.util.IOUtil;
import org.openapi4j.core.util.TreeUtil;
import org.openapi4j.operation.validator.model.impl.Body;
import org.openapi4j.operation.validator.util.TypeConverter;
import org.openapi4j.parser.model.v3.Schema;

class MultipartConverter {
    private static final MultipartConverter INSTANCE = new MultipartConverter();
    private static final UploadContextInstance UPLOAD_CONTEXT_INSTANCE = (body, contentType, encoding) -> new UploadContext(){

        public String getCharacterEncoding() {
            return encoding;
        }

        public String getContentType() {
            return contentType;
        }

        public int getContentLength() {
            return 0;
        }

        public long contentLength() {
            return 0L;
        }

        public InputStream getInputStream() {
            return body;
        }
    };

    private MultipartConverter() {
    }

    public static MultipartConverter instance() {
        return INSTANCE;
    }

    JsonNode multipartToNode(Schema schema, InputStream body, String rawContentType, String encoding) throws IOException {
        UploadContext requestContext = UPLOAD_CONTEXT_INSTANCE.create(body, rawContentType, encoding);
        ObjectNode mappedBody = JsonNodeFactory.instance.objectNode();
        try {
            FileItemIterator iterator = new FileUpload().getItemIterator((RequestContext)requestContext);
            while (iterator.hasNext()) {
                FileItemStream item = iterator.next();
                String name = item.getFieldName();
                if (item.isFormField()) {
                    JsonNode value = mappedBody.get(name);
                    this.setValue(schema, mappedBody, item, name, value, encoding);
                    continue;
                }
                mappedBody.put(name, item.getName());
            }
        }
        catch (FileUploadException ex) {
            throw new IOException(ex);
        }
        return mappedBody;
    }

    JsonNode multipartToNode(Schema schema, String body, String rawContentType, String encoding) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(body.getBytes(encoding));
        return this.multipartToNode(schema, is, rawContentType, encoding);
    }

    private void setValue(Schema schema, ObjectNode mappedBody, FileItemStream item, String name, JsonNode value, String encoding) throws IOException {
        if (value == null) {
            if (item.getContentType() != null) {
                mappedBody.set(name, Body.from(item.openStream()).getContentAsNode(schema.getProperty(name), item.getContentType()));
            } else {
                mappedBody.set(name, this.convertType(schema.getProperty(name), item, encoding));
            }
        } else if (value instanceof ArrayNode) {
            ((ArrayNode)value).add(this.convertType(schema.getProperty(name), item, encoding));
        } else {
            ArrayNode values = JsonNodeFactory.instance.arrayNode();
            values.add(value);
            values.add(this.convertType(schema.getProperty(name), item, encoding));
            mappedBody.set(name, (JsonNode)values);
        }
    }

    private JsonNode convertType(Schema schema, FileItemStream item, String encoding) throws IOException {
        switch (schema.getSupposedType()) {
            case "object": {
                String content = IOUtil.toString((InputStream)item.openStream(), (String)encoding);
                Map jsonContent = (Map)TreeUtil.json.readValue(content, (TypeReference)new TypeReference<Map<String, Object>>(){});
                return TypeConverter.instance().convertObject(schema, jsonContent);
            }
            case "array": {
                return this.convertType(schema.getItemsSchema(), item, encoding);
            }
        }
        return TypeConverter.instance().convertPrimitive(schema, IOUtil.toString((InputStream)item.openStream(), (String)encoding));
    }

    @FunctionalInterface
    private static interface UploadContextInstance {
        public UploadContext create(InputStream var1, String var2, String var3);
    }
}

