/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.util.parameter;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapi4j.operation.validator.util.parameter.FlatStyleConverter;
import org.openapi4j.parser.model.v3.AbsParameter;

class DelimitedStyleConverter
extends FlatStyleConverter {
    private static final Pattern REGEX = Pattern.compile("([^&]+)(?:=)([^&]*)");
    private final String delimRegex;

    DelimitedStyleConverter(String delimRegex) {
        this.delimRegex = delimRegex;
    }

    @Override
    public JsonNode convert(AbsParameter<?> param, String paramName, String rawValue) {
        if (rawValue == null) {
            return null;
        }
        if ("array".equals(param.getSchema().getSupposedType())) {
            HashMap<String, Object> paramValues = new HashMap<String, Object>();
            ArrayList<String> arrayValues = new ArrayList<String>();
            Matcher matcher = REGEX.matcher(rawValue);
            while (matcher.find()) {
                if (!matcher.group(1).equals(paramName)) continue;
                if (param.isExplode()) {
                    arrayValues.add(matcher.group(2));
                    continue;
                }
                arrayValues.addAll(Arrays.asList(matcher.group(2).split(this.delimRegex)));
            }
            if (!arrayValues.isEmpty()) {
                paramValues.put(paramName, arrayValues);
            }
            return this.convert(param, paramName, paramValues);
        }
        return null;
    }
}

