/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.util.parameter;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapi4j.operation.validator.util.parameter.FlatStyleConverter;
import org.openapi4j.parser.model.v3.AbsParameter;
import org.openapi4j.parser.model.v3.Schema;

class FormStyleConverter
extends FlatStyleConverter {
    private static final Pattern REGEX = Pattern.compile("([^&]+)(?:=)([^&]*)");
    private static final FormStyleConverter INSTANCE = new FormStyleConverter();

    private FormStyleConverter() {
    }

    public static FormStyleConverter instance() {
        return INSTANCE;
    }

    @Override
    public JsonNode convert(AbsParameter<?> param, String paramName, String rawValue) {
        if (rawValue == null) {
            return null;
        }
        String type = param.getSchema().getSupposedType();
        Map<String, Object> paramValues = "array".equals(type) ? this.getArrayValues(param, paramName, rawValue) : ("object".equals(type) ? this.getObjectValues(param, paramName, rawValue) : this.getPrimitiveValue(paramName, rawValue));
        return this.convert(param, paramName, paramValues);
    }

    private Map<String, Object> getArrayValues(AbsParameter<?> param, String paramName, String rawValue) {
        HashMap<String, Object> paramValues = new HashMap<String, Object>();
        Matcher matcher = REGEX.matcher(rawValue);
        ArrayList<String> arrayValues = new ArrayList<String>();
        if (matcher.find()) {
            do {
                if (!matcher.group(1).equals(paramName)) continue;
                if (param.isExplode()) {
                    arrayValues.add(matcher.group(2));
                    continue;
                }
                arrayValues.addAll(Arrays.asList(matcher.group(2).split(",")));
            } while (matcher.find());
        }
        if (!arrayValues.isEmpty()) {
            paramValues.put(paramName, arrayValues);
        }
        return paramValues;
    }

    private Map<String, Object> getObjectValues(AbsParameter<?> param, String paramName, String rawValue) {
        Schema paramSchema = param.getSchema();
        if (param.isExplode()) {
            HashMap<String, Object> paramValues = new HashMap<String, Object>();
            Scanner scanner = new Scanner(rawValue);
            scanner.useDelimiter("&");
            while (scanner.hasNext()) {
                String[] propEntry = scanner.next().split("=");
                if (!paramSchema.hasProperty(propEntry[0])) continue;
                paramValues.put(propEntry[0], propEntry[1]);
            }
            scanner.close();
            return paramValues;
        }
        Matcher matcher = REGEX.matcher(rawValue);
        return matcher.find() ? this.getParameterValues(param, paramName, matcher.group(2), ",") : null;
    }

    private Map<String, Object> getPrimitiveValue(String paramName, String rawValue) {
        HashMap<String, Object> paramValues = new HashMap<String, Object>();
        Matcher matcher = REGEX.matcher(rawValue);
        while (matcher.find()) {
            if (!matcher.group(1).equals(paramName)) continue;
            paramValues.put(paramName, matcher.group(2));
            break;
        }
        return paramValues;
    }
}

