/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.validation;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.openapi4j.core.exception.EncodeException;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.operation.validator.model.impl.Body;
import org.openapi4j.parser.model.v3.MediaType;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.schema.validator.JsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class BodyValidator {
    private static final String BODY_REQUIRED_ERR_MSG = "Body is required but none provided.";
    private static final String BODY_CONTENT_ERR_MSG = "An error occurred when getting the body content from type '%s'.%n%s";
    private static final String BODY = "body";
    private final ValidationContext<OAI3> context;
    private final OpenApi3 openApi;
    private final MediaType mediaType;
    private final JsonValidator validator;

    BodyValidator(ValidationContext<OAI3> context, OpenApi3 openApi, MediaType mediaType) {
        this.context = context;
        this.openApi = openApi;
        this.mediaType = mediaType;
        this.validator = this.initValidator();
    }

    void validate(Body body, String rawContentType, boolean isBodyRequired, ValidationResults results) {
        if (this.validator == null) {
            return;
        }
        if (body == null) {
            if (isBodyRequired) {
                results.addError(BODY_REQUIRED_ERR_MSG);
            }
            return;
        }
        try {
            JsonNode jsonBody = body.getContentAsNode(this.mediaType.getSchema(), rawContentType);
            this.validator.validate(jsonBody, results);
        }
        catch (IOException ex) {
            results.addError(String.format(BODY_CONTENT_ERR_MSG, rawContentType, ex));
        }
    }

    private JsonValidator initValidator() {
        if (this.mediaType == null || this.mediaType.getSchema() == null) {
            return null;
        }
        try {
            return new SchemaValidator(this.context, BODY, this.mediaType.getSchema().toNode(this.openApi.getContext(), true));
        }
        catch (EncodeException ex) {
            return null;
        }
    }
}

