/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.validation;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openapi4j.core.exception.ResolutionException;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.operation.validator.model.Request;
import org.openapi4j.operation.validator.model.impl.Body;
import org.openapi4j.operation.validator.util.ContentType;
import org.openapi4j.operation.validator.util.PathResolver;
import org.openapi4j.operation.validator.util.parameter.ParameterConverter;
import org.openapi4j.operation.validator.validation.BodyValidator;
import org.openapi4j.operation.validator.validation.ParameterValidator;
import org.openapi4j.parser.model.v3.Header;
import org.openapi4j.parser.model.v3.MediaType;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.model.v3.Operation;
import org.openapi4j.parser.model.v3.Parameter;
import org.openapi4j.parser.model.v3.Path;
import org.openapi4j.parser.model.v3.Response;
import org.openapi4j.schema.validator.ValidationContext;

public class OperationValidator {
    private static final String VALIDATION_CTX_REQUIRED_ERR_MSG = "Validation context is required.";
    private static final String OAI_REQUIRED_ERR_MSG = "OpenAPI is required.";
    private static final String PATH_REQUIRED_ERR_MSG = "Path is required.";
    private static final String OPERATION_REQUIRED_ERR_MSG = "Operation is required.";
    private static final String BODY_CONTENT_TYPE_ERR_MSG = "Body content type cannot be determined. No 'Content-Type' header available.";
    private static final String BODY_WRONG_CONTENT_TYPE_ERR_MSG = "Content type '%s' is not allowed in body.";
    private static final String RESPONSE_STATUS_NOT_FOUND_ERR_MSG = "Response status '%s' or default has not been found.";
    private static final String IN_PATH = "path";
    private static final String IN_QUERY = "query";
    private static final String IN_HEADER = "header";
    private static final String IN_COOKIE = "cookie";
    private static final String DEFAULT_RESPONSE_CODE = "default";
    private final ParameterValidator<Parameter> specRequestPathValidator;
    private final ParameterValidator<Parameter> specRequestQueryValidator;
    private final ParameterValidator<Parameter> specRequestHeaderValidator;
    private final ParameterValidator<Parameter> specRequestCookieValidator;
    private final Map<String, BodyValidator> specRequestBodyValidators;
    private final Map<String, Map<String, BodyValidator>> specResponseBodyValidators;
    private final Map<String, ParameterValidator<Header>> specResponseHeaderValidators;
    private final ValidationContext<OAI3> context;
    private final OpenApi3 openApi;
    private final Operation operation;
    private final Pattern pathPattern;

    public OperationValidator(OpenApi3 openApi, Path path, Operation operation) {
        this((ValidationContext<OAI3>)new ValidationContext(openApi.getContext()), openApi, path, operation);
    }

    public OperationValidator(ValidationContext<OAI3> context, OpenApi3 openApi, Path path, Operation operation) {
        this.context = Objects.requireNonNull(context, VALIDATION_CTX_REQUIRED_ERR_MSG);
        this.openApi = Objects.requireNonNull(openApi, OAI_REQUIRED_ERR_MSG);
        String specPath = openApi.getPathFrom(Objects.requireNonNull(path, PATH_REQUIRED_ERR_MSG));
        Objects.requireNonNull(operation, OPERATION_REQUIRED_ERR_MSG);
        this.operation = operation.copy(openApi.getContext(), true);
        this.mergePathToOperationParameters(path);
        this.specRequestPathValidator = this.createParameterValidator(IN_PATH);
        this.pathPattern = this.initPathPattern(specPath);
        this.specRequestQueryValidator = this.createParameterValidator(IN_QUERY);
        this.specRequestHeaderValidator = this.createParameterValidator(IN_HEADER);
        this.specRequestCookieValidator = this.createParameterValidator(IN_COOKIE);
        this.specRequestBodyValidators = this.createRequestBodyValidators();
        this.specResponseHeaderValidators = this.createResponseHeaderValidators();
        this.specResponseBodyValidators = this.createResponseBodyValidators();
    }

    public Operation getOperation() {
        return this.operation;
    }

    public Map<String, JsonNode> validatePath(Request request, ValidationResults results) {
        if (this.specRequestPathValidator == null) {
            return null;
        }
        Map<String, JsonNode> mappedValues = ParameterConverter.pathToNode(this.specRequestPathValidator.getParameters(), this.pathPattern, request.getPath());
        this.specRequestPathValidator.validate(mappedValues, results);
        return mappedValues;
    }

    public Map<String, JsonNode> validateQuery(Request request, ValidationResults results) {
        if (this.specRequestQueryValidator == null) {
            return null;
        }
        Map<String, JsonNode> mappedValues = ParameterConverter.queryToNode(this.specRequestQueryValidator.getParameters(), request.getQuery());
        this.specRequestQueryValidator.validate(mappedValues, results);
        return mappedValues;
    }

    public Map<String, JsonNode> validateHeaders(Request request, ValidationResults results) {
        if (this.specRequestHeaderValidator == null) {
            return null;
        }
        Map<String, JsonNode> mappedValues = ParameterConverter.headersToNode(this.specRequestHeaderValidator.getParameters(), request.getHeaders());
        this.specRequestHeaderValidator.validate(mappedValues, results);
        return mappedValues;
    }

    public Map<String, JsonNode> validateCookies(Request request, ValidationResults results) {
        if (this.specRequestCookieValidator == null) {
            return null;
        }
        Map<String, JsonNode> mappedValues = ParameterConverter.cookiesToNode(this.specRequestCookieValidator.getParameters(), request.getCookies());
        this.specRequestCookieValidator.validate(mappedValues, results);
        return mappedValues;
    }

    public void validateBody(Request request, ValidationResults results) {
        if (this.specRequestBodyValidators == null) {
            return;
        }
        this.validateBody(this.specRequestBodyValidators, request.getContentType(), request.getBody(), this.operation.getRequestBody().isRequired(), results);
    }

    public void validateBody(org.openapi4j.operation.validator.model.Response response, ValidationResults results) {
        if (this.specResponseBodyValidators == null) {
            return;
        }
        Map<String, BodyValidator> validators = this.specResponseBodyValidators.get(String.valueOf(response.getStatus()));
        if (validators == null) {
            validators = this.specResponseBodyValidators.get(DEFAULT_RESPONSE_CODE);
        }
        if (validators == null) {
            results.addError(String.format(RESPONSE_STATUS_NOT_FOUND_ERR_MSG, response.getStatus()));
            return;
        }
        this.validateBody(validators, response.getContentType(), response.getBody(), true, results);
    }

    private void validateBody(Map<String, BodyValidator> validators, String rawContentType, Body body, boolean isRequired, ValidationResults results) {
        String contentType = ContentType.getTypeOnly(rawContentType);
        if (contentType == null) {
            results.addError(BODY_CONTENT_TYPE_ERR_MSG);
            return;
        }
        BodyValidator validator = validators.get(contentType);
        if (validator == null) {
            results.addError(String.format(BODY_WRONG_CONTENT_TYPE_ERR_MSG, contentType));
            return;
        }
        validator.validate(body, rawContentType, isRequired, results);
    }

    public void validateHeaders(org.openapi4j.operation.validator.model.Response response, ValidationResults results) {
        if (this.specResponseHeaderValidators == null) {
            return;
        }
        ParameterValidator<Header> validator = this.specResponseHeaderValidators.get(String.valueOf(response.getStatus()));
        if (validator == null) {
            validator = this.specResponseHeaderValidators.get(DEFAULT_RESPONSE_CODE);
        }
        if (validator == null) {
            results.addError(String.format(RESPONSE_STATUS_NOT_FOUND_ERR_MSG, response.getStatus()));
            return;
        }
        Map<String, JsonNode> mappedValues = ParameterConverter.headersToNode(validator.getParameters(), response.getHeaders());
        validator.validate(mappedValues, results);
    }

    private ParameterValidator<Parameter> createParameterValidator(String in) {
        List specParameters = this.operation.getParametersIn(in);
        Map parameters = specParameters.stream().collect(Collectors.toMap(Parameter::getName, parameter -> parameter));
        return parameters.size() != 0 ? new ParameterValidator(this.context, this.openApi, parameters) : null;
    }

    private Map<String, BodyValidator> createRequestBodyValidators() {
        if (this.operation.getRequestBody() == null) {
            return null;
        }
        return this.createBodyValidators(this.operation.getRequestBody().getContentMediaTypes());
    }

    private Map<String, Map<String, BodyValidator>> createResponseBodyValidators() {
        if (this.operation.getResponses() == null) {
            return null;
        }
        TreeMap<String, Map<String, BodyValidator>> validators = new TreeMap<String, Map<String, BodyValidator>>(String.CASE_INSENSITIVE_ORDER);
        Map responses = this.operation.getResponses();
        for (Map.Entry entryStatusCode : responses.entrySet()) {
            String statusCode = (String)entryStatusCode.getKey();
            Response response = (Response)entryStatusCode.getValue();
            validators.put(statusCode, this.createBodyValidators(response.getContentMediaTypes()));
        }
        return validators;
    }

    private Map<String, BodyValidator> createBodyValidators(Map<String, MediaType> mediaTypes) {
        if (mediaTypes == null) {
            return null;
        }
        TreeMap<String, BodyValidator> validators = new TreeMap<String, BodyValidator>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, MediaType> entry : mediaTypes.entrySet()) {
            validators.put(entry.getKey(), new BodyValidator(this.context, this.openApi, entry.getValue()));
        }
        return validators;
    }

    private Map<String, ParameterValidator<Header>> createResponseHeaderValidators() {
        TreeMap<String, ParameterValidator<Header>> validators = new TreeMap<String, ParameterValidator<Header>>(String.CASE_INSENSITIVE_ORDER);
        Map responses = this.operation.getResponses();
        if (responses != null) {
            for (Map.Entry entryStatusCode : responses.entrySet()) {
                String statusCode = (String)entryStatusCode.getKey();
                Response response = (Response)entryStatusCode.getValue();
                if (response.getHeaders() == null) continue;
                TreeMap headers = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                headers.putAll(response.getHeaders());
                validators.put(statusCode, new ParameterValidator(this.context, this.openApi, headers));
            }
        }
        return validators.size() != 0 ? validators : null;
    }

    private Pattern initPathPattern(String specPath) {
        if (this.specRequestPathValidator == null) {
            return null;
        }
        try {
            Optional<String> optRegEx = PathResolver.instance().solve(specPath, this.operation.getParametersIn(IN_PATH));
            return optRegEx.map(Pattern::compile).orElse(null);
        }
        catch (ResolutionException e) {
            return null;
        }
    }

    private void mergePathToOperationParameters(Path path) {
        if (path.getParameters() == null) {
            return;
        }
        ArrayList<Object> parentParameters = new ArrayList<Object>(path.getParameters().size());
        for (Parameter parentParam : path.getParameters()) {
            if (parentParam.isRef()) {
                parentParameters.add(parentParam.copy(this.openApi.getContext(), true));
                continue;
            }
            parentParameters.add(parentParam);
        }
        if (this.operation.getParameters() == null) {
            this.operation.setParameters(parentParameters);
        } else {
            List result = Stream.concat(this.operation.getParameters().stream(), parentParameters.stream()).distinct().collect(Collectors.toList());
            this.operation.setParameters(result);
        }
    }
}

