/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openapi4j.core.exception.EncodeException;
import org.openapi4j.core.model.OAIContext;
import org.openapi4j.core.util.TreeUtil;
import org.openapi4j.parser.model.OpenApiSchema;
import org.openapi4j.parser.model.SerializationFlag;

public abstract class AbsOpenApiSchema<M extends OpenApiSchema<M>>
implements OpenApiSchema<M> {
    @Override
    public JsonNode toNode(OAIContext context, boolean followRefs) throws EncodeException {
        AbsOpenApiSchema model = followRefs ? this.copy(context, true) : this;
        try {
            byte[] content = TreeUtil.json.writerWithView(Views.Public.class).writeValueAsBytes((Object)model);
            return TreeUtil.json.readTree(content);
        }
        catch (Exception e) {
            throw new EncodeException(String.format("Failed to encode: %s", e.getMessage()));
        }
    }

    @Override
    public String toString(OAIContext context, EnumSet<SerializationFlag> flags) throws EncodeException {
        AbsOpenApiSchema model = flags.contains((Object)SerializationFlag.FOLLOW_REFS) ? this.copy(context, true) : this;
        ObjectMapper mapper = flags.contains((Object)SerializationFlag.OUT_AS_YAML) ? TreeUtil.yaml : TreeUtil.json;
        try {
            return mapper.writerWithView(Views.Public.class).writeValueAsString((Object)model);
        }
        catch (Exception e) {
            throw new EncodeException(String.format("Failed to encode: %s", e.getMessage()));
        }
    }

    protected <T> List<T> copyList(List<T> original) {
        if (original != null) {
            return new ArrayList<T>(original);
        }
        return null;
    }

    protected <K, T> Map<K, T> copyMap(Map<K, T> original) {
        if (original != null) {
            return new HashMap<K, T>(original);
        }
        return null;
    }

    protected <T extends OpenApiSchema<T>> T copyField(T original, OAIContext context, boolean followRefs) {
        if (original != null) {
            return original.copy(context, followRefs);
        }
        return null;
    }

    protected <T extends OpenApiSchema<T>> List<T> copyList(List<T> original, OAIContext context, boolean followRefs) {
        if (original != null) {
            ArrayList copy = new ArrayList(original.size());
            for (OpenApiSchema element : original) {
                copy.add(element.copy(context, followRefs));
            }
            return copy;
        }
        return null;
    }

    protected <K, T extends OpenApiSchema<T>> Map<K, T> copyMap(Map<K, T> original, OAIContext context, boolean followRefs) {
        if (original != null) {
            HashMap copy = new HashMap(original.size());
            for (Map.Entry<K, T> element : original.entrySet()) {
                OpenApiSchema schema = (OpenApiSchema)element.getValue();
                if (schema != null) {
                    copy.put(element.getKey(), schema.copy(context, followRefs));
                    continue;
                }
                copy.put(element.getKey(), null);
            }
            return copy;
        }
        return null;
    }

    protected <K, V> Map<K, V> mapPut(Map<K, V> map, K key, V value) {
        if (map == null) {
            map = new HashMap();
        }
        map.put(key, value);
        return map;
    }

    protected <K, V> boolean mapHas(Map<K, V> map, K key) {
        return map != null && map.containsKey(key);
    }

    protected <K, V> V mapGet(Map<K, V> map, K key) {
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    protected <K, V> void mapRemove(Map<K, V> map, K key) {
        if (map != null) {
            map.remove(key);
        }
    }

    protected <K> List<K> listAdd(List<K> list, K value) {
        if (list == null) {
            list = new ArrayList<K>();
        }
        list.add(value);
        return list;
    }

    protected <K> List<K> listAdd(List<K> list, int index, K value) {
        if (list == null) {
            list = new ArrayList<K>();
        }
        list.add(index, value);
        return list;
    }

    protected <K> boolean listRemove(List<K> list, K value) {
        if (list == null) {
            return false;
        }
        return list.remove(value);
    }

    protected static class Views {
        private Views() {
        }

        public static class Internal
        extends Public {
            private Internal() {
            }
        }

        public static class Public {
            private Public() {
            }
        }
    }
}

