/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.model.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import org.openapi4j.core.model.OAIContext;
import org.openapi4j.parser.model.v3.AbsExtendedOpenApiSchema;
import org.openapi4j.parser.model.v3.EncodingProperty;
import org.openapi4j.parser.model.v3.Example;
import org.openapi4j.parser.model.v3.Schema;

public class MediaType
extends AbsExtendedOpenApiSchema<MediaType> {
    @JsonProperty(value="encoding")
    private Map<String, EncodingProperty> encodings;
    private Object example;
    private Map<String, Example> examples;
    private Schema schema;

    public Schema getSchema() {
        return this.schema;
    }

    public MediaType setSchema(Schema schema) {
        this.schema = schema;
        return this;
    }

    public Map<String, Example> getExamples() {
        return this.examples;
    }

    public MediaType setExamples(Map<String, Example> examples) {
        this.examples = examples;
        return this;
    }

    public boolean hasExample(String name) {
        return this.mapHas(this.examples, name);
    }

    public Example getExample(String name) {
        return this.mapGet(this.examples, name);
    }

    public MediaType setExample(String name, Example example) {
        if (this.examples == null) {
            this.examples = new HashMap<String, Example>();
        }
        this.examples.put(name, example);
        return this;
    }

    public MediaType removeExample(String name) {
        this.mapRemove(this.examples, name);
        return this;
    }

    public Object getExample() {
        return this.example;
    }

    public MediaType setExample(Object example) {
        this.example = example;
        return this;
    }

    public Map<String, EncodingProperty> getEncodings() {
        return this.encodings;
    }

    public MediaType setEncodings(Map<String, EncodingProperty> encodings) {
        this.encodings = encodings;
        return this;
    }

    public boolean hasEncoding(String name) {
        return this.mapHas(this.encodings, name);
    }

    public EncodingProperty getEncoding(String name) {
        return this.mapGet(this.encodings, name);
    }

    public MediaType setEncoding(String name, EncodingProperty encodingProperty) {
        if (this.encodings == null) {
            this.encodings = new HashMap<String, EncodingProperty>();
        }
        this.encodings.put(name, encodingProperty);
        return this;
    }

    public MediaType removeEncoding(String name) {
        this.mapRemove(this.encodings, name);
        return this;
    }

    @Override
    public MediaType copy(OAIContext context, boolean followRefs) {
        MediaType copy = new MediaType();
        copy.setSchema(this.copyField(this.getSchema(), context, followRefs));
        copy.setExample(this.getExample());
        copy.setExamples(this.copyMap(this.getExamples(), context, followRefs));
        copy.setEncodings(this.copyMap(this.getEncodings(), context, followRefs));
        copy.setExtensions(this.copyMap(this.getExtensions()));
        return copy;
    }
}

