/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Ticker;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableMap;
import com.samskivert.mustache.Mustache;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.Discriminator;
import io.swagger.v3.oas.models.media.Encoding;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.media.XML;
import io.swagger.v3.oas.models.parameters.CookieParameter;
import io.swagger.v3.oas.models.parameters.HeaderParameter;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.PathParameter;
import io.swagger.v3.oas.models.parameters.QueryParameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.servers.ServerVariable;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.text.StringEscapeUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenCallback;
import org.openapitools.codegen.CodegenComposedSchemas;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenDiscriminator;
import org.openapitools.codegen.CodegenEncoding;
import org.openapitools.codegen.CodegenMediaType;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenModelFactory;
import org.openapitools.codegen.CodegenModelType;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenSecurity;
import org.openapitools.codegen.CodegenServer;
import org.openapitools.codegen.CodegenServerVariable;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.IJsonSchemaValidationProperties;
import org.openapitools.codegen.ObjectWithTypeBooleans;
import org.openapitools.codegen.SchemaTestCase;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.VendorExtension;
import org.openapitools.codegen.api.TemplatingEngineAdapter;
import org.openapitools.codegen.config.GlobalSettings;
import org.openapitools.codegen.examples.ExampleGenerator;
import org.openapitools.codegen.languages.PhpNextgenClientCodegen;
import org.openapitools.codegen.languages.RustAxumServerCodegen;
import org.openapitools.codegen.languages.RustServerCodegen;
import org.openapitools.codegen.meta.FeatureSet;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.DataTypeFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.model.WebhooksMap;
import org.openapitools.codegen.serializer.SerializerUtils;
import org.openapitools.codegen.templating.MustacheEngineAdapter;
import org.openapitools.codegen.templating.mustache.BackSlashLambda;
import org.openapitools.codegen.templating.mustache.CamelCaseAndSanitizeLambda;
import org.openapitools.codegen.templating.mustache.DoubleQuoteLambda;
import org.openapitools.codegen.templating.mustache.ForwardSlashLambda;
import org.openapitools.codegen.templating.mustache.IndentedLambda;
import org.openapitools.codegen.templating.mustache.KebabCaseLambda;
import org.openapitools.codegen.templating.mustache.LowercaseLambda;
import org.openapitools.codegen.templating.mustache.SnakecaseLambda;
import org.openapitools.codegen.templating.mustache.TitlecaseLambda;
import org.openapitools.codegen.templating.mustache.UncamelizeLambda;
import org.openapitools.codegen.templating.mustache.UppercaseLambda;
import org.openapitools.codegen.utils.CamelizeOption;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.OnceLogger;
import org.openapitools.codegen.utils.OneOfImplementorAdditionalData;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(DefaultCodegen.class);
    public static FeatureSet DefaultFeatureSet;
    private static final Cache<SanitizeNameOptions, String> sanitizedNameCache;
    private static final String xSchemaTestExamplesKey = "x-schema-test-examples";
    private static final String xSchemaTestExamplesRefPrefix = "#/components/x-schema-test-examples/";
    protected static Schema falseSchema;
    protected static Schema trueSchema;
    protected GeneratorMetadata generatorMetadata;
    protected String inputSpec;
    protected String outputFolder = "";
    protected Set<String> defaultIncludes;
    protected Map<String, String> typeMapping;
    protected Map<String, String> instantiationTypes;
    protected Set<String> reservedWords;
    protected Set<String> languageSpecificPrimitives = new HashSet<String>();
    protected Set<String> openapiGeneratorIgnoreList = new HashSet<String>();
    protected Map<String, String> importMapping = new HashMap<String, String>();
    protected Map<String, String> schemaMapping = new HashMap<String, String>();
    protected Map<String, String> inlineSchemaNameMapping = new HashMap<String, String>();
    protected Map<String, String> inlineSchemaOption = new HashMap<String, String>();
    protected Map<String, String> nameMapping = new HashMap<String, String>();
    protected Map<String, String> parameterNameMapping = new HashMap<String, String>();
    protected Map<String, String> modelNameMapping = new HashMap<String, String>();
    protected Map<String, String> enumNameMapping = new HashMap<String, String>();
    protected Map<String, String> operationIdNameMapping = new HashMap<String, String>();
    protected Map<String, String> openapiNormalizer = new HashMap<String, String>();
    protected String modelPackage = "";
    protected String apiPackage = "";
    protected String fileSuffix;
    protected String modelNamePrefix = "";
    protected String modelNameSuffix = "";
    protected String apiNamePrefix = "";
    protected String apiNameSuffix = "Api";
    protected String testPackage = "";
    protected String filesMetadataFilename = "FILES";
    protected String versionMetadataFilename = "VERSION";
    protected Map<String, String> apiTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> modelTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> apiTestTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> modelTestTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> apiDocTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> modelDocTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> reservedWordsMappings = new HashMap<String, String>();
    protected String templateDir;
    protected String embeddedTemplateDir;
    protected Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected Map<String, String> serverVariables = new HashMap<String, String>();
    protected Map<String, Object> vendorExtensions = new HashMap<String, Object>();
    protected Map<String, String> templateOutputDirs = new HashMap<String, String>();
    protected List<SupportingFile> supportingFiles = new ArrayList<SupportingFile>();
    protected List<CliOption> cliOptions = new ArrayList<CliOption>();
    protected boolean skipOverwrite;
    protected boolean removeOperationIdPrefix;
    protected String removeOperationIdPrefixDelimiter = "_";
    protected int removeOperationIdPrefixCount = 1;
    protected boolean skipOperationExample;
    protected static final Pattern XML_MIME_PATTERN;
    protected static final Pattern JSON_MIME_PATTERN;
    protected static final Pattern JSON_VENDOR_MIME_PATTERN;
    private static final Pattern COMMON_PREFIX_ENUM_NAME;
    protected boolean supportsMultipleInheritance;
    protected boolean supportsInheritance;
    protected boolean supportsAdditionalPropertiesWithComposedSchema;
    protected boolean supportsMixins;
    protected Map<String, String> supportedLibraries = new LinkedHashMap<String, String>();
    protected String library;
    protected Boolean sortParamsByRequiredFlag = true;
    protected Boolean sortModelPropertiesByRequiredFlag = false;
    protected Boolean ensureUniqueParams = true;
    protected Boolean allowUnicodeIdentifiers = false;
    protected String gitHost;
    protected String gitUserId;
    protected String gitRepoId;
    protected String releaseNote;
    protected String httpUserAgent;
    protected Boolean hideGenerationTimestamp = true;
    protected Map<String, String> specialCharReplacements = new LinkedHashMap<String, String>();
    protected Map<String, String> typeAliases = Collections.emptyMap();
    protected Boolean prependFormOrBodyParameters = false;
    protected String docExtension;
    protected String ignoreFilePathOverride;
    protected boolean enablePostProcessFile = false;
    private TemplatingEngineAdapter templatingEngine = new MustacheEngineAdapter();
    protected boolean useOneOfInterfaces = false;
    protected boolean addOneOfInterfaceImports = false;
    protected List<CodegenModel> addOneOfInterfaces = new ArrayList<CodegenModel>();
    protected boolean enableMinimalUpdate = false;
    protected boolean strictSpecBehavior = true;
    protected boolean removeEnumValuePrefix = true;
    protected boolean legacyDiscriminatorBehavior = true;
    protected boolean disallowAdditionalPropertiesIfNotPresent = true;
    protected boolean enumUnknownDefaultCase = false;
    protected String enumUnknownDefaultCaseName = "unknown_default_open_api";
    protected OpenAPI openAPI;
    private Map<String, Schema> modelNameToSchemaCache;
    private final Map<String, String> schemaKeyToModelNameCache = new HashMap<String, String>();
    protected boolean loadDeepObjectIntoItems = true;
    protected boolean importBaseType = true;
    protected boolean importContainerType = true;
    protected boolean addSuffixToDuplicateOperationNicknames = true;
    protected boolean autosetConstants = false;
    Map<NamedSchema, CodegenProperty> schemaCodegenPropertyCache = new HashMap<NamedSchema, CodegenProperty>();

    @Override
    public boolean getAddSuffixToDuplicateOperationNicknames() {
        return this.addSuffixToDuplicateOperationNicknames;
    }

    @Override
    public List<CliOption> cliOptions() {
        return this.cliOptions;
    }

    protected void useCodegenAsMustacheParentContext() {
        this.additionalProperties.put("MUSTACHE_PARENT_CONTEXT", this);
    }

    @Override
    public void processOpts() {
        if (!this.additionalProperties.containsKey("MUSTACHE_PARENT_CONTEXT")) {
            this.additionalProperties.put("MUSTACHE_PARENT_CONTEXT", new Object());
        }
        this.convertPropertyToStringAndWriteBack("templateDir", this::setTemplateDir);
        this.convertPropertyToStringAndWriteBack("modelPackage", this::setModelPackage);
        this.convertPropertyToStringAndWriteBack("apiPackage", this::setApiPackage);
        this.convertPropertyToBooleanAndWriteBack("hideGenerationTimestamp", this::setHideGenerationTimestamp);
        this.writePropertyBack("hideGenerationTimestamp", this.isHideGenerationTimestamp());
        this.convertPropertyToBooleanAndWriteBack("sortParamsByRequiredFlag", this::setSortParamsByRequiredFlag);
        this.convertPropertyToBooleanAndWriteBack("sortModelPropertiesByRequiredFlag", this::setSortModelPropertiesByRequiredFlag);
        this.convertPropertyToBooleanAndWriteBack("prependFormOrBodyParameters", this::setPrependFormOrBodyParameters);
        this.convertPropertyToBooleanAndWriteBack("ensureUniqueParams", this::setEnsureUniqueParams);
        this.convertPropertyToBooleanAndWriteBack("allowUnicodeIdentifiers", this::setAllowUnicodeIdentifiers);
        this.convertPropertyToStringAndWriteBack("apiNamePrefix", this::setApiNamePrefix);
        this.convertPropertyToStringAndWriteBack("apiNameSuffix", this::setApiNameSuffix);
        this.convertPropertyToStringAndWriteBack("modelNamePrefix", this::setModelNamePrefix);
        this.convertPropertyToStringAndWriteBack("modelNameSuffix", this::setModelNameSuffix);
        this.convertPropertyToBooleanAndWriteBack("removeOperationIdPrefix", this::setRemoveOperationIdPrefix);
        this.convertPropertyToStringAndWriteBack("removeOperationIdPrefixDelimiter", this::setRemoveOperationIdPrefixDelimiter);
        this.convertPropertyToTypeAndWriteBack("removeOperationIdPrefixCount", Integer::parseInt, this::setRemoveOperationIdPrefixCount);
        this.convertPropertyToBooleanAndWriteBack("skipOperationExample", this::setSkipOperationExample);
        this.convertPropertyToStringAndWriteBack("docExtension", this::setDocExtension);
        this.convertPropertyToBooleanAndWriteBack("enablePostProcessFile", this::setEnablePostProcessFile);
        this.convertPropertyToBooleanAndWriteBack("generateAliasAsModel", ModelUtils::setGenerateAliasAsModel);
        this.convertPropertyToBooleanAndWriteBack("removeEnumValuePrefix", this::setRemoveEnumValuePrefix);
        this.convertPropertyToBooleanAndWriteBack("legacyDiscriminatorBehavior", this::setLegacyDiscriminatorBehavior);
        this.convertPropertyToBooleanAndWriteBack("disallowAdditionalPropertiesIfNotPresent", this::setDisallowAdditionalPropertiesIfNotPresent);
        this.convertPropertyToBooleanAndWriteBack("enumUnknownDefaultCase", this::setEnumUnknownDefaultCase);
        this.convertPropertyToBooleanAndWriteBack("autosetConstants", this::setAutosetConstants);
    }

    protected ImmutableMap.Builder<String, Mustache.Lambda> addMustacheLambdas() {
        return new ImmutableMap.Builder().put((Object)"lowercase", (Object)new LowercaseLambda().generator(this)).put((Object)"uppercase", (Object)new UppercaseLambda()).put((Object)"snakecase", (Object)new SnakecaseLambda()).put((Object)"titlecase", (Object)new TitlecaseLambda()).put((Object)"kebabcase", (Object)new KebabCaseLambda()).put((Object)"camelcase", (Object)new CamelCaseAndSanitizeLambda(true).generator(this)).put((Object)"pascalcase", (Object)new CamelCaseAndSanitizeLambda(false).generator(this)).put((Object)"uncamelize", (Object)new UncamelizeLambda()).put((Object)"forwardslash", (Object)new ForwardSlashLambda()).put((Object)"backslash", (Object)new BackSlashLambda()).put((Object)"doublequote", (Object)new DoubleQuoteLambda()).put((Object)"indented", (Object)new IndentedLambda()).put((Object)"indented_8", (Object)new IndentedLambda(8, " ", false, false)).put((Object)"indented_12", (Object)new IndentedLambda(12, " ", false, false)).put((Object)"indented_16", (Object)new IndentedLambda(16, " ", false, false));
    }

    private void registerMustacheLambdas() {
        ImmutableMap lambdas = this.addMustacheLambdas().build();
        if (lambdas.size() == 0) {
            return;
        }
        if (this.additionalProperties.containsKey("lambda")) {
            this.LOGGER.error("A property called 'lambda' already exists in additionalProperties");
            throw new RuntimeException("A property called 'lambda' already exists in additionalProperties");
        }
        this.additionalProperties.put("lambda", lambdas);
    }

    @Override
    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> objs) {
        for (Map.Entry<String, ModelsMap> entry : objs.entrySet()) {
            CodegenModel codegenModel = ModelUtils.getModelByName(entry.getKey(), objs);
            if (codegenModel == null) {
                this.LOGGER.warn("Null model found in postProcessAllModels: {}", (Object)entry.getKey());
                continue;
            }
            if (codegenModel.discriminator != null && codegenModel.discriminator.getMappedModels() != null) {
                for (CodegenDiscriminator.MappedModel mappedModel : codegenModel.discriminator.getMappedModels()) {
                    CodegenModel mappedCodegenModel = ModelUtils.getModelByName(mappedModel.getModelName(), objs);
                    mappedModel.setModel(mappedCodegenModel);
                }
            }
            for (CodegenProperty property : codegenModel.allVars) {
                property.isNew = this.codegenPropertyIsNew(codegenModel, property);
            }
            for (CodegenProperty property : codegenModel.vars) {
                property.isNew = this.codegenPropertyIsNew(codegenModel, property);
            }
            for (CodegenProperty property : codegenModel.readWriteVars) {
                property.isNew = this.codegenPropertyIsNew(codegenModel, property);
            }
            for (CodegenProperty property : codegenModel.optionalVars) {
                property.isNew = this.codegenPropertyIsNew(codegenModel, property);
            }
            for (CodegenProperty property : codegenModel.parentVars) {
                property.isNew = this.codegenPropertyIsNew(codegenModel, property);
            }
            for (CodegenProperty property : codegenModel.requiredVars) {
                property.isNew = this.codegenPropertyIsNew(codegenModel, property);
            }
            for (CodegenProperty property : codegenModel.readOnlyVars) {
                property.isNew = this.codegenPropertyIsNew(codegenModel, property);
            }
            for (CodegenProperty property : codegenModel.nonNullableVars) {
                property.isNew = this.codegenPropertyIsNew(codegenModel, property);
            }
        }
        if (this.useOneOfInterfaces) {
            for (CodegenModel cm : this.addOneOfInterfaces) {
                ModelMap modelMap = new ModelMap(this.additionalProperties());
                modelMap.setModel(cm);
                ArrayList<Map<String, String>> importsValue = new ArrayList<Map<String, String>>();
                ModelsMap objsValue = new ModelsMap();
                objsValue.setModels(Collections.singletonList(modelMap));
                objsValue.put("package", this.modelPackage());
                objsValue.setImports(importsValue);
                objsValue.put("classname", cm.classname);
                objsValue.putAll(this.additionalProperties);
                objs.put(cm.name, objsValue);
            }
            HashMap<String, OneOfImplementorAdditionalData> additionalDataMap = new HashMap<String, OneOfImplementorAdditionalData>();
            for (ModelsMap modelsMap : objs.values()) {
                List<Map<String, String>> modelsImports = modelsMap.getImportsOrEmpty();
                for (ModelMap mo : modelsMap.getModels()) {
                    CodegenModel cm = mo.getModel();
                    if (cm.oneOf.size() <= 0) continue;
                    cm.vendorExtensions.put("x-is-one-of-interface", true);
                    for (String one : cm.oneOf) {
                        if (!additionalDataMap.containsKey(one)) {
                            additionalDataMap.put(one, new OneOfImplementorAdditionalData(one));
                        }
                        ((OneOfImplementorAdditionalData)additionalDataMap.get(one)).addFromInterfaceModel(cm, modelsImports);
                    }
                    this.addImportsToOneOfInterface(modelsImports);
                }
            }
            for (Map.Entry entry : objs.entrySet()) {
                ModelsMap modelsAttrs = (ModelsMap)entry.getValue();
                List<Map<String, String>> imports = modelsAttrs.getImports();
                for (ModelMap implmo : modelsAttrs.getModels()) {
                    CodegenModel implcm = implmo.getModel();
                    String modelName = this.toModelName(implcm.name);
                    if (!additionalDataMap.containsKey(modelName)) continue;
                    ((OneOfImplementorAdditionalData)additionalDataMap.get(modelName)).addToImplementor(this, implcm, imports, this.addOneOfInterfaceImports);
                }
            }
        }
        return objs;
    }

    private boolean codegenPropertyIsNew(CodegenModel model, CodegenProperty property) {
        return model.parentModel == null ? false : model.parentModel.allVars.stream().anyMatch(p -> p.name.equals(property.name) && (!p.dataType.equals(property.dataType) || !p.datatypeWithEnum.equals(property.datatypeWithEnum) || p.isDiscriminator));
    }

    protected Map<String, Schema> getModelNameToSchemaCache() {
        if (this.modelNameToSchemaCache == null) {
            HashMap m = new HashMap();
            ModelUtils.getSchemas(this.openAPI).forEach((key, schema) -> m.put(this.toModelName((String)key), schema));
            this.modelNameToSchemaCache = Collections.unmodifiableMap(m);
        }
        return this.modelNameToSchemaCache;
    }

    public Map<String, CodegenModel> getAllModels(Map<String, ModelsMap> objs) {
        LinkedHashMap<String, CodegenModel> allModels = new LinkedHashMap<String, CodegenModel>();
        for (Map.Entry<String, ModelsMap> entry : objs.entrySet()) {
            String modelName = this.toModelName(entry.getKey());
            List<ModelMap> models = entry.getValue().getModels();
            for (ModelMap mo : models) {
                CodegenModel cm = mo.getModel();
                allModels.put(modelName, cm);
            }
        }
        return allModels;
    }

    @Override
    public Map<String, ModelsMap> updateAllModels(Map<String, ModelsMap> objs) {
        Map<String, CodegenModel> allModels = this.getAllModels(objs);
        for (CodegenModel codegenModel : allModels.values()) {
            if (codegenModel.getParent() != null) {
                codegenModel.setParentModel(allModels.get(codegenModel.getParent()));
            }
            if (codegenModel.getInterfaces() == null || codegenModel.getInterfaces().isEmpty()) continue;
            codegenModel.setInterfaceModels(new ArrayList<CodegenModel>(codegenModel.getInterfaces().size()));
            for (String intf : codegenModel.getInterfaces()) {
                CodegenModel intfModel = allModels.get(intf);
                if (intfModel == null) continue;
                codegenModel.getInterfaceModels().add(intfModel);
            }
        }
        for (Map.Entry entry : allModels.entrySet()) {
            String name = (String)entry.getKey();
            CodegenModel cm = (CodegenModel)entry.getValue();
            CodegenModel parent = allModels.get(cm.getParent());
            while (parent != null) {
                if (parent.getChildren() == null) {
                    parent.setChildren(new ArrayList<CodegenModel>());
                }
                parent.getChildren().add(cm);
                parent.hasChildren = true;
                Schema parentSchema = (Schema)this.openAPI.getComponents().getSchemas().get(parent.schemaName);
                if (parentSchema == null) {
                    this.LOGGER.warn("Failed to look up parent schema: {}", (Object)parent.schemaName);
                    parent = null;
                    continue;
                }
                if (parentSchema.getDiscriminator() == null) {
                    parent = allModels.get(parent.getParent());
                    continue;
                }
                parent = null;
            }
        }
        for (ModelsMap modelsMap : objs.values()) {
            for (ModelMap mo : modelsMap.getModels()) {
                CodegenModel cm = mo.getModel();
                this.removeSelfReferenceImports(cm);
                if (this.getLegacyDiscriminatorBehavior().booleanValue()) continue;
                cm.addDiscriminatorMappedModelsImports(true);
            }
        }
        this.setCircularReferences(allModels);
        return objs;
    }

    protected void removeImport(OperationsMap objs, String importToRemove) {
        List<Map<String, String>> imports = objs.getImports();
        Iterator<Map<String, String>> itr = imports.iterator();
        while (itr.hasNext()) {
            String itrImport = itr.next().get("import");
            if (!itrImport.equals(importToRemove)) continue;
            itr.remove();
        }
    }

    protected void removeSelfReferenceImports(CodegenModel model) {
        for (CodegenProperty cp : model.allVars) {
            if (!cp.dataType.equalsIgnoreCase(model.classname) && (!cp.isContainer || cp.items == null || !cp.items.dataType.equalsIgnoreCase(model.classname))) continue;
            model.imports.remove(model.classname);
            cp.isSelfReference = true;
        }
    }

    public void setCircularReferences(Map<String, CodegenModel> models) {
        Map<String, List> allVarsDependencyMap = models.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.getModelDependencies(((CodegenModel)entry.getValue()).getAllVars())));
        models.keySet().forEach(name -> this.setCircularReferencesOnProperties((String)name, (Map<String, List<CodegenProperty>>)allVarsDependencyMap));
        Map<String, List> varsDependencyMap = models.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.getModelDependencies(((CodegenModel)entry.getValue()).getVars())));
        models.keySet().forEach(name -> this.setCircularReferencesOnProperties((String)name, (Map<String, List<CodegenProperty>>)varsDependencyMap));
        Map<String, List> oneOfDependencyMap = models.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.getModelDependencies(((CodegenModel)entry.getValue()).getComposedSchemas() != null && ((CodegenModel)entry.getValue()).getComposedSchemas().getOneOf() != null ? ((CodegenModel)entry.getValue()).getComposedSchemas().getOneOf() : new ArrayList<CodegenProperty>())));
        models.keySet().forEach(name -> this.setCircularReferencesOnProperties((String)name, (Map<String, List<CodegenProperty>>)oneOfDependencyMap));
    }

    private List<CodegenProperty> getModelDependencies(List<CodegenProperty> vars) {
        return vars.stream().map(prop -> {
            if (prop.isContainer) {
                return prop.items.dataType == null ? null : prop;
            }
            return prop.dataType == null ? null : prop;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private void setCircularReferencesOnProperties(String root, Map<String, List<CodegenProperty>> dependencyMap) {
        ((List)dependencyMap.getOrDefault(root, new ArrayList())).forEach(prop -> {
            List<String> unvisited = Collections.singletonList(prop.isContainer ? prop.items.dataType : prop.dataType);
            prop.isCircularReference = this.isCircularReference(root, new HashSet<String>(), new ArrayList<String>(unvisited), dependencyMap);
        });
    }

    private boolean isCircularReference(String root, Set<String> visited, List<String> unvisited, Map<String, List<CodegenProperty>> dependencyMap) {
        for (int i = 0; i < unvisited.size(); ++i) {
            String next = unvisited.get(i);
            if (visited.contains(next)) continue;
            if (next.equals(root)) {
                return true;
            }
            ((List)dependencyMap.getOrDefault(next, new ArrayList())).forEach(prop -> unvisited.add(prop.isContainer ? prop.items.dataType : prop.dataType));
            visited.add(next);
        }
        return false;
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        return objs;
    }

    public ModelsMap postProcessModelsEnum(ModelsMap objs) {
        for (ModelMap mo : objs.getModels()) {
            CodegenModel cm = mo.getModel();
            if (Boolean.TRUE.equals(cm.isEnum) && cm.allowableValues != null) {
                Map<String, Object> allowableValues = cm.allowableValues;
                List values = (List)allowableValues.get("values");
                List<Map<String, Object>> enumVars = this.buildEnumVars(values, cm.dataType);
                this.postProcessEnumVars(enumVars);
                this.updateEnumVarsWithExtensions(enumVars, cm.getVendorExtensions(), cm.dataType);
                cm.allowableValues.put("enumVars", enumVars);
            }
            for (CodegenProperty var : cm.vars) {
                this.updateCodegenPropertyEnum(var);
            }
            for (CodegenProperty var : cm.allVars) {
                this.updateCodegenPropertyEnum(var);
            }
            for (CodegenProperty var : cm.nonNullableVars) {
                this.updateCodegenPropertyEnum(var);
            }
            for (CodegenProperty var : cm.requiredVars) {
                this.updateCodegenPropertyEnum(var);
            }
            for (CodegenProperty var : cm.optionalVars) {
                this.updateCodegenPropertyEnum(var);
            }
            for (CodegenProperty var : cm.parentVars) {
                this.updateCodegenPropertyEnum(var);
            }
            for (CodegenProperty var : cm.readOnlyVars) {
                this.updateCodegenPropertyEnum(var);
            }
            for (CodegenProperty var : cm.readWriteVars) {
                this.updateCodegenPropertyEnum(var);
            }
        }
        return objs;
    }

    public String findCommonPrefixOfVars(List<Object> vars) {
        if (vars.size() > 1) {
            try {
                String[] listStr = vars.toArray(new String[vars.size()]);
                String prefix = org.apache.commons.lang3.StringUtils.getCommonPrefix((String[])listStr);
                Matcher matcher = COMMON_PREFIX_ENUM_NAME.matcher(prefix);
                return matcher.replaceAll("");
            }
            catch (ArrayStoreException arrayStoreException) {
                // empty catch block
            }
        }
        return "";
    }

    public String toEnumDefaultValue(String value, String datatype) {
        return datatype + "." + value;
    }

    public String toEnumDefaultValue(CodegenProperty property, String value) {
        return this.toEnumDefaultValue(value, property.datatypeWithEnum);
    }

    public String toEnumValue(String value, String datatype) {
        if ("number".equalsIgnoreCase(datatype) || "boolean".equalsIgnoreCase(datatype)) {
            return value;
        }
        return "\"" + this.escapeText(value) + "\"";
    }

    public String toEnumVarName(String value, String datatype) {
        if (value.length() == 0) {
            return "EMPTY";
        }
        Object var = value.replaceAll("\\W+", "_").toUpperCase(Locale.ROOT);
        if (((String)var).matches("\\d.*")) {
            var = "_" + (String)var;
        }
        if (this.reservedWords.contains(var)) {
            return this.escapeReservedWord((String)var);
        }
        return var;
    }

    public boolean specVersionGreaterThanOrEqualTo310(OpenAPI openAPI) {
        String xOriginalSwaggerVersion = "x-original-swagger-version";
        String originalSpecVersion = openAPI.getExtensions() != null && !openAPI.getExtensions().isEmpty() && openAPI.getExtensions().containsValue(xOriginalSwaggerVersion) ? (String)openAPI.getExtensions().get(xOriginalSwaggerVersion) : openAPI.getOpenapi();
        Integer specMajorVersion = Integer.parseInt(originalSpecVersion.substring(0, 1));
        Integer specMinorVersion = Integer.parseInt(originalSpecVersion.substring(2, 3));
        return specMajorVersion == 3 && specMinorVersion >= 1;
    }

    @Override
    public void setOpenAPI(OpenAPI openAPI) {
        if (this.specVersionGreaterThanOrEqualTo310(openAPI)) {
            this.LOGGER.warn("Generation using 3.1.0 specs is in development and is not officially supported yet. If you would like to expedite development, please consider woking on the open issues in the 3.1.0 project: https://github.com/orgs/OpenAPITools/projects/4/views/1 and reach out to our team on Slack at https://join.slack.com/t/openapi-generator/shared_invite/zt-12jxxd7p2-XUeQM~4pzsU9x~eGLQqX2g");
        }
        this.openAPI = openAPI;
        ModelUtils.setDisallowAdditionalPropertiesIfNotPresent(this.getDisallowAdditionalPropertiesIfNotPresent());
        this.typeAliases = this.getAllAliases(ModelUtils.getSchemas(openAPI));
    }

    @Override
    public void postProcess() {
        System.out.println("################################################################################");
        System.out.println("# Thanks for using OpenAPI Generator.                                          #");
        System.out.println("# Please consider donation to help us maintain this project \ud83d\ude4f                 #");
        System.out.println("# https://opencollective.com/openapi_generator/donate                          #");
        System.out.println("################################################################################");
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        return objs;
    }

    @Override
    public WebhooksMap postProcessWebhooksWithModels(WebhooksMap objs, List<ModelMap> allModels) {
        return objs;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        return objs;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
    }

    @Override
    public void postProcessResponseWithProperty(CodegenResponse response, CodegenProperty property) {
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        if (this.useOneOfInterfaces && openAPI.getComponents() != null) {
            Paths pathItems;
            HashMap<Object, Object> schemas = new HashMap<Object, Object>(openAPI.getComponents().getSchemas());
            if (schemas == null) {
                schemas = new HashMap();
            }
            if ((pathItems = openAPI.getPaths()) != null) {
                for (Map.Entry e : pathItems.entrySet()) {
                    for (Map.Entry op : ((PathItem)e.getValue()).readOperationsMap().entrySet()) {
                        String opId = this.getOrGenerateOperationId((Operation)op.getValue(), (String)e.getKey(), ((PathItem.HttpMethod)op.getKey()).toString());
                        RequestBody b = ModelUtils.getReferencedRequestBody(openAPI, ((Operation)op.getValue()).getRequestBody());
                        Schema requestSchema = null;
                        if (b != null) {
                            requestSchema = ModelUtils.getSchemaFromRequestBody(b);
                        }
                        if (requestSchema != null) {
                            schemas.put(opId, requestSchema);
                        }
                        if (((Operation)op.getValue()).getResponses() == null) continue;
                        for (Map.Entry ar : ((Operation)op.getValue()).getResponses().entrySet()) {
                            ApiResponse a = ModelUtils.getReferencedApiResponse(openAPI, (ApiResponse)ar.getValue());
                            Schema responseSchema = this.unaliasSchema(ModelUtils.getSchemaFromResponse(openAPI, a));
                            if (responseSchema == null) continue;
                            schemas.put(opId + (String)ar.getKey(), responseSchema);
                        }
                    }
                }
            }
            HashMap<CallSite, Schema> propertySchemas = new HashMap<CallSite, Schema>();
            for (Map.Entry e : schemas.entrySet()) {
                Schema s = (Schema)e.getValue();
                HashMap props = s.getProperties();
                if (props == null) {
                    props = new HashMap();
                }
                for (Map.Entry p : props.entrySet()) {
                    propertySchemas.put((CallSite)((Object)((String)e.getKey() + "/" + (String)p.getKey())), (Schema)p.getValue());
                }
            }
            schemas.putAll(propertySchemas);
            for (Map.Entry e : schemas.entrySet()) {
                Schema addProps;
                String n = this.toModelName((String)e.getKey());
                Schema s = (Schema)e.getValue();
                String nOneOf = this.toModelName(n + "OneOf");
                if (ModelUtils.isComposedSchema(s)) {
                    if (((String)e.getKey()).contains("/")) {
                        this.addOneOfNameExtension(s, nOneOf);
                        this.addOneOfInterfaceModel(s, nOneOf);
                        continue;
                    }
                    this.addOneOfNameExtension(s, n);
                    continue;
                }
                if (ModelUtils.isArraySchema(s)) {
                    Schema<?> items = ModelUtils.getSchemaItems(s);
                    if (!ModelUtils.isComposedSchema(items)) continue;
                    this.addOneOfNameExtension(items, nOneOf);
                    this.addOneOfInterfaceModel(items, nOneOf);
                    continue;
                }
                if (!ModelUtils.isMapSchema(s) || (addProps = ModelUtils.getAdditionalProperties(s)) == null || !ModelUtils.isComposedSchema(addProps)) continue;
                this.addOneOfNameExtension(addProps, nOneOf);
                this.addOneOfInterfaceModel(addProps, nOneOf);
            }
        }
    }

    @Override
    public void processOpenAPI(OpenAPI openAPI) {
    }

    @Override
    public Mustache.Compiler processCompiler(Mustache.Compiler compiler) {
        return compiler;
    }

    @Override
    public TemplatingEngineAdapter processTemplatingEngine(TemplatingEngineAdapter templatingEngine) {
        return templatingEngine;
    }

    @Override
    public String escapeText(String input) {
        if (input == null) {
            return input;
        }
        return this.escapeUnsafeCharacters(StringEscapeUtils.unescapeJava((String)StringEscapeUtils.escapeJava((String)input).replace("\\/", "/")).replaceAll("[\\t\\n\\r]", " ").replace("\\", "\\\\").replace("\"", "\\\""));
    }

    @Override
    public String escapeTextWhileAllowingNewLines(String input) {
        if (input == null) {
            return input;
        }
        return this.escapeUnsafeCharacters(StringEscapeUtils.unescapeJava((String)StringEscapeUtils.escapeJava((String)input).replace("\\/", "/")).replaceAll("[\\t]", " ").replace("\\", "\\\\").replace("\"", "\\\""));
    }

    @Override
    public String encodePath(String input) {
        return this.escapeText(input);
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        this.LOGGER.warn("escapeUnsafeCharacters should be overridden in the code generator with proper logic to escape unsafe characters");
        return input;
    }

    @Override
    public String escapeQuotationMark(String input) {
        this.LOGGER.warn("escapeQuotationMark should be overridden in the code generator with proper logic to escape single/double quote");
        return input.replace("\"", "\\\"");
    }

    @Override
    public Set<String> defaultIncludes() {
        return this.defaultIncludes;
    }

    @Override
    public Map<String, String> typeMapping() {
        return this.typeMapping;
    }

    @Override
    public Map<String, String> instantiationTypes() {
        return this.instantiationTypes;
    }

    @Override
    public Set<String> reservedWords() {
        return this.reservedWords;
    }

    @Override
    public Set<String> languageSpecificPrimitives() {
        return this.languageSpecificPrimitives;
    }

    @Override
    public Set<String> openapiGeneratorIgnoreList() {
        return this.openapiGeneratorIgnoreList;
    }

    @Override
    public Map<String, String> importMapping() {
        return this.importMapping;
    }

    @Override
    public Map<String, String> schemaMapping() {
        return this.schemaMapping;
    }

    @Override
    public Map<String, String> inlineSchemaNameMapping() {
        return this.inlineSchemaNameMapping;
    }

    @Override
    public Map<String, String> inlineSchemaOption() {
        return this.inlineSchemaOption;
    }

    @Override
    public Map<String, String> nameMapping() {
        return this.nameMapping;
    }

    @Override
    public Map<String, String> parameterNameMapping() {
        return this.parameterNameMapping;
    }

    @Override
    public Map<String, String> modelNameMapping() {
        return this.modelNameMapping;
    }

    @Override
    public Map<String, String> enumNameMapping() {
        return this.enumNameMapping;
    }

    @Override
    public Map<String, String> operationIdNameMapping() {
        return this.operationIdNameMapping;
    }

    @Override
    public Map<String, String> openapiNormalizer() {
        return this.openapiNormalizer;
    }

    @Override
    public String testPackage() {
        return this.testPackage;
    }

    @Override
    public String modelPackage() {
        return this.modelPackage;
    }

    @Override
    public String apiPackage() {
        return this.apiPackage;
    }

    @Override
    public String fileSuffix() {
        return this.fileSuffix;
    }

    @Override
    public String templateDir() {
        return this.templateDir;
    }

    @Override
    public String embeddedTemplateDir() {
        if (this.embeddedTemplateDir != null) {
            return this.embeddedTemplateDir;
        }
        return this.templateDir;
    }

    @Override
    public Map<String, String> apiDocTemplateFiles() {
        return this.apiDocTemplateFiles;
    }

    @Override
    public Map<String, String> modelDocTemplateFiles() {
        return this.modelDocTemplateFiles;
    }

    @Override
    public Map<String, String> reservedWordsMappings() {
        return this.reservedWordsMappings;
    }

    @Override
    public Map<String, String> apiTestTemplateFiles() {
        return this.apiTestTemplateFiles;
    }

    @Override
    public Map<String, String> modelTestTemplateFiles() {
        return this.modelTestTemplateFiles;
    }

    @Override
    public Map<String, String> apiTemplateFiles() {
        return this.apiTemplateFiles;
    }

    @Override
    public Map<String, String> modelTemplateFiles() {
        return this.modelTemplateFiles;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + File.separator + this.testPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + File.separator + this.testPackage().replace('.', File.separatorChar);
    }

    @Override
    public String apiDocFileFolder() {
        return this.outputFolder;
    }

    @Override
    public String modelDocFileFolder() {
        return this.outputFolder;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public Map<String, String> serverVariableOverrides() {
        return this.serverVariables;
    }

    @Override
    public Map<String, Object> vendorExtensions() {
        return this.vendorExtensions;
    }

    @Override
    public Map<String, String> templateOutputDirs() {
        return this.templateOutputDirs;
    }

    @Override
    public List<SupportingFile> supportingFiles() {
        return this.supportingFiles;
    }

    @Override
    public String outputFolder() {
        return this.outputFolder;
    }

    @Override
    public void setOutputDir(String dir) {
        this.outputFolder = dir;
    }

    @Override
    public String getOutputDir() {
        return this.outputFolder();
    }

    @Override
    public String getInputSpec() {
        return this.inputSpec;
    }

    @Override
    public void setInputSpec(String inputSpec) {
        this.inputSpec = inputSpec;
    }

    @Override
    public String getFilesMetadataFilename() {
        return this.filesMetadataFilename;
    }

    @Override
    public String getVersionMetadataFilename() {
        return this.versionMetadataFilename;
    }

    public Boolean getLegacyDiscriminatorBehavior() {
        return this.legacyDiscriminatorBehavior;
    }

    public Boolean getDisallowAdditionalPropertiesIfNotPresent() {
        return this.disallowAdditionalPropertiesIfNotPresent;
    }

    public Boolean getEnumUnknownDefaultCase() {
        return this.enumUnknownDefaultCase;
    }

    public Boolean getUseOneOfInterfaces() {
        return this.useOneOfInterfaces;
    }

    public void setUseOneOfInterfaces(Boolean useOneOfInterfaces) {
        this.useOneOfInterfaces = useOneOfInterfaces;
    }

    public String toRegularExpression(String pattern) {
        return this.addRegularExpressionDelimiter(this.escapeText(pattern));
    }

    @Override
    public String toApiFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiName(name) + "Test";
    }

    @Override
    public String toApiVarName(String name) {
        return this.lowerCamelCase(name);
    }

    @Override
    public String toModelFilename(String name) {
        return StringUtils.camelize(name);
    }

    @Override
    public String toModelTestFilename(String name) {
        return StringUtils.camelize(name) + "Test";
    }

    @Override
    public String toModelDocFilename(String name) {
        return StringUtils.camelize(name);
    }

    @Override
    public GeneratorMetadata getGeneratorMetadata() {
        return this.generatorMetadata;
    }

    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        return operationId;
    }

    public String toVarName(String name) {
        if (this.nameMapping.containsKey(name)) {
            return this.nameMapping.get(name);
        }
        if (this.reservedWords.contains(name)) {
            return this.escapeReservedWord(name);
        }
        if (name.chars().anyMatch(character -> this.specialCharReplacements.containsKey(String.valueOf((char)character)))) {
            return StringUtils.escape(name, this.specialCharReplacements, null, null);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        if (this.parameterNameMapping.containsKey(name)) {
            return this.parameterNameMapping.get(name);
        }
        if (this.reservedWords.contains(name = this.removeNonNameElementToCamelCase(name))) {
            return this.escapeReservedWord(name);
        }
        if (name.chars().anyMatch(character -> this.specialCharReplacements.containsKey(String.valueOf((char)character)))) {
            return StringUtils.escape(name, this.specialCharReplacements, null, null);
        }
        return name;
    }

    public String toArrayModelParamName(String name) {
        return this.toParamName(name);
    }

    public String toEnumName(CodegenProperty property) {
        return org.apache.commons.lang3.StringUtils.capitalize((String)property.name) + "Enum";
    }

    @Override
    public String escapeReservedWord(String name) {
        throw new RuntimeException("reserved word " + name + " not allowed");
    }

    @Override
    public String toModelImport(String name) {
        if ("".equals(this.modelPackage())) {
            return name;
        }
        return this.modelPackage() + "." + name;
    }

    @Override
    public Map<String, String> toModelImportMap(String name) {
        return Collections.singletonMap(this.toModelImport(name), name);
    }

    @Override
    public String toApiImport(String name) {
        return this.apiPackage() + "." + name;
    }

    public DefaultCodegen() {
        CodegenType codegenType = this.getTag();
        if (codegenType == null) {
            codegenType = CodegenType.OTHER;
        }
        this.generatorMetadata = GeneratorMetadata.newBuilder().stability(Stability.STABLE).featureSet(DefaultFeatureSet).generationMessage(String.format(Locale.ROOT, "OpenAPI Generator: %s (%s)", this.getName(), codegenType.toValue())).build();
        this.defaultIncludes = new HashSet<String>(Arrays.asList("double", "int", "long", "short", "char", "float", "String", "boolean", "Boolean", "Double", "Void", "Integer", "Long", "Float"));
        this.typeMapping = new HashMap<String, String>();
        this.typeMapping.put("array", "List");
        this.typeMapping.put("set", "Set");
        this.typeMapping.put("map", "Map");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("int", "Integer");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("number", "BigDecimal");
        this.typeMapping.put("decimal", "BigDecimal");
        this.typeMapping.put("DateTime", "Date");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("short", "Short");
        this.typeMapping.put("integer", "Integer");
        this.typeMapping.put("UnsignedInteger", "Integer");
        this.typeMapping.put("UnsignedLong", "Long");
        this.typeMapping.put("char", "String");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("ByteArray", "byte[]");
        this.typeMapping.put("binary", "File");
        this.typeMapping.put("file", "File");
        this.typeMapping.put("UUID", "UUID");
        this.typeMapping.put("URI", "URI");
        this.typeMapping.put("AnyType", "oas_any_type_not_mapped");
        this.instantiationTypes = new HashMap<String, String>();
        this.reservedWords = new HashSet<String>();
        this.cliOptions.add(CliOption.newBoolean("sortParamsByRequiredFlag", "Sort method arguments to place required parameters before optional parameters.").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(CliOption.newBoolean("sortModelPropertiesByRequiredFlag", "Sort model properties to place required parameters before optional parameters.").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(CliOption.newBoolean("ensureUniqueParams", "Whether to ensure parameter names are unique in an operation (rename parameters that are not).").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(CliOption.newBoolean("allowUnicodeIdentifiers", "boolean, toggles whether unicode identifiers are allowed in names or not, default is false").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(CliOption.newBoolean("prependFormOrBodyParameters", "Add form or body parameters to the beginning of the parameter list.").defaultValue(Boolean.FALSE.toString()));
        CliOption legacyDiscriminatorBehaviorOpt = CliOption.newBoolean("legacyDiscriminatorBehavior", "Set to false for generators with better support for discriminators. (Python, Java, Go, PowerShell, C# have this enabled by default).").defaultValue(Boolean.TRUE.toString());
        HashMap<String, String> legacyDiscriminatorBehaviorOpts = new HashMap<String, String>();
        legacyDiscriminatorBehaviorOpts.put("true", "The mapping in the discriminator includes descendent schemas that allOf inherit from self and the discriminator mapping schemas in the OAS document.");
        legacyDiscriminatorBehaviorOpts.put("false", "The mapping in the discriminator includes any descendent schemas that allOf inherit from self, any oneOf schemas, any anyOf schemas, any x-discriminator-values, and the discriminator mapping schemas in the OAS document AND Codegen validates that oneOf and anyOf schemas contain the required discriminator and throws an error if the discriminator is missing.");
        legacyDiscriminatorBehaviorOpt.setEnum(legacyDiscriminatorBehaviorOpts);
        this.cliOptions.add(legacyDiscriminatorBehaviorOpt);
        CliOption disallowAdditionalPropertiesIfNotPresentOpt = CliOption.newBoolean("disallowAdditionalPropertiesIfNotPresent", "If false, the 'additionalProperties' implementation (set to true by default) is compliant with the OAS and JSON schema specifications. If true (default), keep the old (incorrect) behaviour that 'additionalProperties' is set to false by default.").defaultValue(Boolean.TRUE.toString());
        HashMap<String, String> disallowAdditionalPropertiesIfNotPresentOpts = new HashMap<String, String>();
        disallowAdditionalPropertiesIfNotPresentOpts.put("false", "The 'additionalProperties' implementation is compliant with the OAS and JSON schema specifications.");
        disallowAdditionalPropertiesIfNotPresentOpts.put("true", "Keep the old (incorrect) behaviour that 'additionalProperties' is set to false by default.");
        disallowAdditionalPropertiesIfNotPresentOpt.setEnum(disallowAdditionalPropertiesIfNotPresentOpts);
        this.cliOptions.add(disallowAdditionalPropertiesIfNotPresentOpt);
        this.setDisallowAdditionalPropertiesIfNotPresent(true);
        CliOption enumUnknownDefaultCaseOpt = CliOption.newBoolean("enumUnknownDefaultCase", "If the server adds new enum cases, that are unknown by an old spec/client, the client will fail to parse the network response.With this option enabled, each enum will have a new case, 'unknown_default_open_api', so that when the server sends an enum case that is not known by the client/spec, they can safely fallback to this case.").defaultValue(Boolean.FALSE.toString());
        HashMap<String, String> enumUnknownDefaultCaseOpts = new HashMap<String, String>();
        enumUnknownDefaultCaseOpts.put("false", "No changes to the enum's are made, this is the default option.");
        enumUnknownDefaultCaseOpts.put("true", "With this option enabled, each enum will have a new case, 'unknown_default_open_api', so that when the enum case sent by the server is not known by the client/spec, can safely be decoded to this case.");
        enumUnknownDefaultCaseOpt.setEnum(enumUnknownDefaultCaseOpts);
        this.cliOptions.add(enumUnknownDefaultCaseOpt);
        this.setEnumUnknownDefaultCase(false);
        this.initializeSpecialCharacterMapping();
        this.registerMustacheLambdas();
    }

    protected void initializeSpecialCharacterMapping() {
        this.specialCharReplacements.put("$", "Dollar");
        this.specialCharReplacements.put("^", "Caret");
        this.specialCharReplacements.put("|", "Pipe");
        this.specialCharReplacements.put("=", "Equal");
        this.specialCharReplacements.put("*", "Star");
        this.specialCharReplacements.put("-", "Minus");
        this.specialCharReplacements.put("&", "Ampersand");
        this.specialCharReplacements.put("%", "Percent");
        this.specialCharReplacements.put("#", "Hash");
        this.specialCharReplacements.put("@", "At");
        this.specialCharReplacements.put("!", "Exclamation");
        this.specialCharReplacements.put("+", "Plus");
        this.specialCharReplacements.put(":", "Colon");
        this.specialCharReplacements.put(";", "Semicolon");
        this.specialCharReplacements.put(">", "Greater_Than");
        this.specialCharReplacements.put("<", "Less_Than");
        this.specialCharReplacements.put(".", "Period");
        this.specialCharReplacements.put("_", "Underscore");
        this.specialCharReplacements.put("?", "Question_Mark");
        this.specialCharReplacements.put(",", "Comma");
        this.specialCharReplacements.put("'", "Quote");
        this.specialCharReplacements.put("\"", "Double_Quote");
        this.specialCharReplacements.put("/", "Slash");
        this.specialCharReplacements.put("\\", "Back_Slash");
        this.specialCharReplacements.put("(", "Left_Parenthesis");
        this.specialCharReplacements.put(")", "Right_Parenthesis");
        this.specialCharReplacements.put("{", "Left_Curly_Bracket");
        this.specialCharReplacements.put("}", "Right_Curly_Bracket");
        this.specialCharReplacements.put("[", "Left_Square_Bracket");
        this.specialCharReplacements.put("]", "Right_Square_Bracket");
        this.specialCharReplacements.put("~", "Tilde");
        this.specialCharReplacements.put("`", "Backtick");
        this.specialCharReplacements.put("<=", "Less_Than_Or_Equal_To");
        this.specialCharReplacements.put(">=", "Greater_Than_Or_Equal_To");
        this.specialCharReplacements.put("!=", "Not_Equal");
        this.specialCharReplacements.put("<>", "Not_Equal");
        this.specialCharReplacements.put("~=", "Tilde_Equal");
    }

    protected String getSymbolName(String input) {
        return this.specialCharReplacements.get(input);
    }

    @Override
    public String generateExamplePath(String path, Operation operation) {
        StringBuilder sb = new StringBuilder();
        sb.append(path);
        if (operation.getParameters() != null) {
            int count = 0;
            for (Parameter param : operation.getParameters()) {
                if (!(param instanceof QueryParameter)) continue;
                StringBuilder paramPart = new StringBuilder();
                QueryParameter qp = (QueryParameter)param;
                if (count == 0) {
                    paramPart.append("?");
                } else {
                    paramPart.append(",");
                }
                ++count;
                if (!param.getRequired().booleanValue()) {
                    paramPart.append("[");
                }
                paramPart.append(param.getName()).append("=");
                paramPart.append("{");
                if (qp.getStyle() != null) {
                    paramPart.append(param.getName()).append("1");
                    if (Parameter.StyleEnum.FORM.equals((Object)qp.getStyle())) {
                        if (qp.getExplode() != null && qp.getExplode().booleanValue()) {
                            paramPart.append(",");
                        } else {
                            paramPart.append("&").append(param.getName()).append("=");
                            paramPart.append(param.getName()).append("2");
                        }
                    } else if (Parameter.StyleEnum.PIPEDELIMITED.equals((Object)qp.getStyle())) {
                        paramPart.append("|");
                    } else if (Parameter.StyleEnum.SPACEDELIMITED.equals((Object)qp.getStyle())) {
                        paramPart.append("%20");
                    } else {
                        this.LOGGER.warn("query parameter '{}' style not support: {}", (Object)param.getName(), (Object)qp.getStyle());
                    }
                } else {
                    paramPart.append(param.getName());
                }
                paramPart.append("}");
                if (!param.getRequired().booleanValue()) {
                    paramPart.append("]");
                }
                sb.append((CharSequence)paramPart);
            }
        }
        return sb.toString();
    }

    public String toInstantiationType(Schema schema) {
        if (ModelUtils.isMapSchema(schema)) {
            Schema additionalProperties = ModelUtils.getAdditionalProperties(schema);
            String inner = this.getSchemaType(additionalProperties);
            String mapInstantion = this.instantiationTypes.get("map");
            if (mapInstantion != null) {
                return mapInstantion + "<String, " + inner + ">";
            }
            return inner;
        }
        if (ModelUtils.isArraySchema(schema)) {
            String inner = this.getSchemaType(ModelUtils.getSchemaItems(schema));
            String parentType = ModelUtils.isSet(schema) ? "set" : "array";
            return this.instantiationTypes.get(parentType) + "<" + inner + ">";
        }
        return null;
    }

    public void setParameterExampleValue(CodegenParameter codegenParameter) {
        if (codegenParameter.vendorExtensions != null && codegenParameter.vendorExtensions.containsKey("x-example")) {
            codegenParameter.example = Json.pretty((Object)codegenParameter.vendorExtensions.get("x-example"));
        } else if (Boolean.TRUE.equals(codegenParameter.isBoolean)) {
            codegenParameter.example = "true";
        } else if (Boolean.TRUE.equals(codegenParameter.isLong)) {
            codegenParameter.example = "789";
        } else if (Boolean.TRUE.equals(codegenParameter.isInteger)) {
            codegenParameter.example = "56";
        } else if (Boolean.TRUE.equals(codegenParameter.isFloat)) {
            codegenParameter.example = "3.4";
        } else if (Boolean.TRUE.equals(codegenParameter.isDouble)) {
            codegenParameter.example = "1.2";
        } else if (Boolean.TRUE.equals(codegenParameter.isNumber)) {
            codegenParameter.example = "8.14";
        } else if (Boolean.TRUE.equals(codegenParameter.isBinary)) {
            codegenParameter.example = "BINARY_DATA_HERE";
        } else if (Boolean.TRUE.equals(codegenParameter.isByteArray)) {
            codegenParameter.example = "BYTE_ARRAY_DATA_HERE";
        } else if (Boolean.TRUE.equals(codegenParameter.isFile)) {
            codegenParameter.example = "/path/to/file.txt";
        } else if (Boolean.TRUE.equals(codegenParameter.isDate)) {
            codegenParameter.example = "2013-10-20";
        } else if (Boolean.TRUE.equals(codegenParameter.isDateTime)) {
            codegenParameter.example = "2013-10-20T19:20:30+01:00";
        } else if (Boolean.TRUE.equals(codegenParameter.isUuid)) {
            codegenParameter.example = "38400000-8cf0-11bd-b23e-10b96e4ef00d";
        } else if (Boolean.TRUE.equals(codegenParameter.isUri)) {
            codegenParameter.example = "https://openapi-generator.tech";
        } else if (Boolean.TRUE.equals(codegenParameter.isString)) {
            codegenParameter.example = codegenParameter.paramName + "_example";
        } else if (Boolean.TRUE.equals(codegenParameter.isFreeFormObject)) {
            codegenParameter.example = "Object";
        }
    }

    public void setParameterExampleValue(CodegenParameter codegenParameter, Parameter parameter) {
        Example example;
        if (parameter.getExample() != null) {
            codegenParameter.example = parameter.getExample().toString();
            return;
        }
        if (parameter.getExamples() != null && !parameter.getExamples().isEmpty() && (example = (Example)parameter.getExamples().values().iterator().next()).getValue() != null) {
            codegenParameter.example = example.getValue().toString();
            return;
        }
        Schema schema = parameter.getSchema();
        if (schema != null && schema.getExample() != null) {
            codegenParameter.example = schema.getExample().toString();
            return;
        }
        this.setParameterExampleValue(codegenParameter);
    }

    public void setParameterExamples(CodegenParameter codegenParameter, Parameter parameter) {
        if (parameter.getExamples() != null && !parameter.getExamples().isEmpty()) {
            codegenParameter.examples = parameter.getExamples();
        }
    }

    public void setParameterExampleValue(CodegenParameter codegenParameter, RequestBody requestBody) {
        Example example;
        MediaType mediaType;
        Content content = requestBody.getContent();
        if (content.size() > 1) {
            OnceLogger.once(this.LOGGER).debug("Multiple MediaTypes found, using only the first one");
        }
        if ((mediaType = (MediaType)content.values().iterator().next()).getExample() != null) {
            codegenParameter.example = mediaType.getExample().toString();
            return;
        }
        if (mediaType.getExamples() != null && !mediaType.getExamples().isEmpty() && (example = (Example)mediaType.getExamples().values().iterator().next()).getValue() != null) {
            codegenParameter.example = example.getValue().toString();
            return;
        }
        this.setParameterExampleValue(codegenParameter);
    }

    public void setParameterEncodingValues(CodegenParameter codegenParameter, MediaType mediaType) {
        if (mediaType != null && mediaType.getEncoding() != null) {
            Encoding encoding = (Encoding)mediaType.getEncoding().get(codegenParameter.baseName);
            if (encoding != null) {
                boolean styleGiven = true;
                Encoding.StyleEnum style = encoding.getStyle();
                if (style == null || style == Encoding.StyleEnum.FORM) {
                    style = Encoding.StyleEnum.FORM;
                    styleGiven = false;
                }
                boolean explodeGiven = true;
                Boolean explode = encoding.getExplode();
                if (explode == null) {
                    explode = style == Encoding.StyleEnum.FORM;
                    explodeGiven = false;
                }
                if (!styleGiven && !explodeGiven) {
                    codegenParameter.contentType = encoding.getContentType();
                }
                codegenParameter.style = style.toString();
                boolean bl = codegenParameter.isDeepObject = Encoding.StyleEnum.DEEP_OBJECT == style;
                if (codegenParameter.isContainer) {
                    codegenParameter.isExplode = explode;
                    String collectionFormat = this.getCollectionFormat(codegenParameter);
                    codegenParameter.collectionFormat = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)collectionFormat) ? "csv" : collectionFormat;
                    codegenParameter.isCollectionFormatMulti = "multi".equals(collectionFormat);
                } else {
                    codegenParameter.isExplode = false;
                    codegenParameter.collectionFormat = null;
                    codegenParameter.isCollectionFormatMulti = false;
                }
            } else {
                this.LOGGER.debug("encoding not specified for {}", (Object)codegenParameter.baseName);
            }
        }
    }

    public String toExampleValue(Schema schema) {
        if (schema.getExample() != null) {
            return schema.getExample().toString();
        }
        return "null";
    }

    public String toDefaultValue(Schema schema) {
        if (schema.getDefault() != null) {
            return schema.getDefault().toString();
        }
        return "null";
    }

    public String toDefaultParameterValue(Schema<?> schema) {
        return this.toDefaultValue(schema);
    }

    public String toDefaultParameterValue(CodegenProperty codegenProperty, Schema<?> schema) {
        return this.toDefaultParameterValue(schema);
    }

    public String toDefaultValueWithParam(String name, Schema schema) {
        return " = data." + name + ";";
    }

    public String toDefaultValue(CodegenProperty codegenProperty, Schema schema) {
        return this.toDefaultValue(schema);
    }

    public String getSchemaType(Schema schema) {
        if (ModelUtils.isComposedSchema(schema)) {
            List<Schema> schemas = ModelUtils.getInterfaces(schema);
            ArrayList<String> names = new ArrayList<String>();
            for (Schema s : schemas) {
                names.add(this.getSingleSchemaType(s));
            }
            if (schema.getAllOf() != null) {
                return this.toAllOfName(names, schema);
            }
            if (schema.getAnyOf() != null) {
                return this.toAnyOfName(names, schema);
            }
            if (schema.getOneOf() != null) {
                return this.toOneOfName(names, schema);
            }
        }
        return this.getSingleSchemaType(schema);
    }

    protected Schema<?> getSchemaAdditionalProperties(Schema schema) {
        Schema inner = ModelUtils.getAdditionalProperties(schema);
        if (inner == null) {
            this.LOGGER.error("`{}` (map property) does not have a proper inner type defined. Default to type:string", (Object)schema.getName());
            inner = new StringSchema().description("TODO default missing map inner type to string");
            schema.setAdditionalProperties((Object)inner);
        }
        return inner;
    }

    public String toAllOfName(List<String> names, Schema composedSchema) {
        Map exts = composedSchema.getExtensions();
        if (exts != null && exts.containsKey("x-all-of-name")) {
            return (String)exts.get("x-all-of-name");
        }
        if (names.size() == 0) {
            this.LOGGER.error("allOf has no member defined: {}. Default to ERROR_ALLOF_SCHEMA", (Object)composedSchema);
            return "ERROR_ALLOF_SCHEMA";
        }
        if (names.size() == 1) {
            return names.get(0);
        }
        this.LOGGER.debug("allOf with multiple schemas defined. Using only the first one: {}", (Object)names.get(0));
        return names.get(0);
    }

    public String toAnyOfName(List<String> names, Schema composedSchema) {
        return "anyOf<" + String.join((CharSequence)",", names) + ">";
    }

    public String toOneOfName(List<String> names, Schema composedSchema) {
        Map exts = composedSchema.getExtensions();
        if (exts != null && exts.containsKey("x-one-of-name")) {
            return (String)exts.get("x-one-of-name");
        }
        return "oneOf<" + String.join((CharSequence)",", names) + ">";
    }

    @Override
    public Schema unaliasSchema(Schema schema) {
        return ModelUtils.unaliasSchema(this.openAPI, schema, this.schemaMapping);
    }

    protected String getSingleSchemaType(Schema schema) {
        Schema<?> refSchema;
        Schema unaliasSchema = this.unaliasSchema(schema);
        if (ModelUtils.isRefToSchemaWithProperties(unaliasSchema.get$ref()) && (refSchema = ModelUtils.getReferencedSchema(this.openAPI, unaliasSchema)) != null) {
            return this.getSingleSchemaType(refSchema);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)unaliasSchema.get$ref())) {
            String schemaName = ModelUtils.getSimpleRef(unaliasSchema.get$ref());
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)schemaName)) {
                if (this.schemaMapping.containsKey(schemaName)) {
                    return schemaName;
                }
                return this.getAlias(schemaName);
            }
            this.LOGGER.warn("Error obtaining the datatype from ref: {}. Default to 'object'", (Object)unaliasSchema.get$ref());
            return "object";
        }
        return this.getAlias(this.getPrimitiveType(unaliasSchema));
    }

    private String getPrimitiveType(Schema schema) {
        if (schema == null) {
            throw new RuntimeException("schema cannot be null in getPrimitiveType");
        }
        if (this.typeMapping.containsKey(ModelUtils.getType(schema) + "+" + schema.getFormat())) {
            return this.typeMapping.get(ModelUtils.getType(schema) + "+" + schema.getFormat());
        }
        if (ModelUtils.isNullType(schema)) {
            return "null";
        }
        if (ModelUtils.isDecimalSchema(schema)) {
            return "decimal";
        }
        if (ModelUtils.isByteArraySchema(schema)) {
            return "ByteArray";
        }
        if (ModelUtils.isFileSchema(schema)) {
            return "file";
        }
        if (ModelUtils.isBinarySchema(schema)) {
            return "binary";
        }
        if (ModelUtils.isBooleanSchema(schema)) {
            return "boolean";
        }
        if (ModelUtils.isDateSchema(schema)) {
            return "date";
        }
        if (ModelUtils.isDateTimeSchema(schema)) {
            return "DateTime";
        }
        if (ModelUtils.isNumberSchema(schema)) {
            if (schema.getFormat() == null) {
                return "number";
            }
            if (ModelUtils.isFloatSchema(schema)) {
                return "float";
            }
            if (ModelUtils.isDoubleSchema(schema)) {
                return "double";
            }
            this.LOGGER.warn("Unknown `format` {} detected for type `number`. Defaulting to `number`", (Object)schema.getFormat());
            return "number";
        }
        if (ModelUtils.isIntegerSchema(schema)) {
            if (ModelUtils.isUnsignedLongSchema(schema)) {
                return "UnsignedLong";
            }
            if (ModelUtils.isUnsignedIntegerSchema(schema)) {
                return "UnsignedInteger";
            }
            if (ModelUtils.isLongSchema(schema)) {
                return "long";
            }
            if (ModelUtils.isShortSchema(schema)) {
                return "integer";
            }
            return ModelUtils.getType(schema);
        }
        if (ModelUtils.isMapSchema(schema)) {
            return "map";
        }
        if (ModelUtils.isArraySchema(schema)) {
            if (ModelUtils.isSet(schema)) {
                return "set";
            }
            return "array";
        }
        if (ModelUtils.isUUIDSchema(schema)) {
            return "UUID";
        }
        if (ModelUtils.isURISchema(schema)) {
            return "URI";
        }
        if (ModelUtils.isStringSchema(schema)) {
            if (this.typeMapping.containsKey(schema.getFormat())) {
                return schema.getFormat();
            }
            return "string";
        }
        if (ModelUtils.isFreeFormObject(schema)) {
            return "object";
        }
        if (schema.getProperties() != null && !schema.getProperties().isEmpty()) {
            return "object";
        }
        if (ModelUtils.isAnyType(schema)) {
            return "AnyType";
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)ModelUtils.getType(schema))) {
            if (!this.schemaMapping.containsKey(ModelUtils.getType(schema))) {
                this.LOGGER.warn("Unknown type found in the schema: {}. To map it, please use the schema mapping option (e.g. --schema-mappings in CLI)", (Object)ModelUtils.getType(schema));
            }
            return ModelUtils.getType(schema);
        }
        return "object";
    }

    public String lowerCamelCase(String name) {
        return name.length() > 0 ? Character.toLowerCase(name.charAt(0)) + name.substring(1) : "";
    }

    @Override
    public String getTypeDeclaration(String name) {
        return name;
    }

    @Override
    public String getTypeDeclaration(Schema schema) {
        if (schema == null) {
            this.LOGGER.warn("Null schema found. Default type to `NULL_SCHEMA_ERR`");
            return "NULL_SCHEMA_ERR";
        }
        String oasType = this.getSchemaType(schema);
        if (this.typeMapping.containsKey(oasType)) {
            return this.typeMapping.get(oasType);
        }
        return oasType;
    }

    public String getAlias(String name) {
        if (this.typeAliases != null && this.typeAliases.containsKey(name)) {
            return this.typeAliases.get(name);
        }
        return name;
    }

    @Override
    public String toBooleanGetter(String name) {
        return "get" + this.getterAndSetterCapitalize(name);
    }

    @Override
    public String toGetter(String name) {
        return "get" + this.getterAndSetterCapitalize(name);
    }

    @Override
    public String toSetter(String name) {
        return "set" + this.getterAndSetterCapitalize(name);
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        return StringUtils.camelize(this.apiNamePrefix + "_" + name + "_" + this.apiNameSuffix);
    }

    @Override
    public String toModelName(String name) {
        if (this.modelNameMapping.containsKey(name)) {
            return this.modelNameMapping.get(name);
        }
        if (this.schemaKeyToModelNameCache.containsKey(name)) {
            return this.schemaKeyToModelNameCache.get(name);
        }
        String camelizedName = StringUtils.camelize(this.modelNamePrefix + "_" + name + "_" + this.modelNameSuffix);
        this.schemaKeyToModelNameCache.put(name, camelizedName);
        return camelizedName;
    }

    protected void updateModelForComposedSchema(CodegenModel m, Schema schema, Map<String, Schema> allDefinitions) {
        List<Schema> interfaces;
        Schema parent;
        Schema composed = schema;
        LinkedHashMap<String, Schema> properties = new LinkedHashMap<String, Schema>();
        ArrayList<String> required = new ArrayList<String>();
        LinkedHashMap<String, Schema> allProperties = new LinkedHashMap<String, Schema>();
        ArrayList<String> allRequired = new ArrayList<String>();
        if (composed.getProperties() != null && !composed.getProperties().isEmpty()) {
            if (composed.getOneOf() != null && !composed.getOneOf().isEmpty()) {
                this.LOGGER.warn("'oneOf' is intended to include only the additional optional OAS extension discriminator object. For more details, see https://json-schema.org/draft/2019-09/json-schema-core.html#rfc.section.9.2.1.3 and the OAS section on 'Composition and Inheritance'.");
            }
            this.addVars(m, this.unaliasPropertySchema(composed.getProperties()), composed.getRequired(), null, null);
        }
        String parentName = ModelUtils.getParentName(composed, allDefinitions);
        List<String> allParents = ModelUtils.getAllParentsName(composed, allDefinitions, false);
        Schema schema2 = parent = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)parentName) || allDefinitions == null ? null : allDefinitions.get(parentName);
        if (this.supportsInheritance || this.supportsMixins) {
            m.allVars = new ArrayList<CodegenProperty>();
            if (composed.getAllOf() != null) {
                int modelImplCnt = 0;
                int modelDiscriminators = 0;
                for (Object innerSchema : composed.getAllOf()) {
                    if (m.discriminator == null && ((Schema)innerSchema).getDiscriminator() != null) {
                        this.LOGGER.debug("discriminator is set to null (not correctly set earlier): {}", (Object)m.name);
                        m.setDiscriminator(this.createDiscriminator(m.name, (Schema)innerSchema));
                        ++modelDiscriminators;
                    }
                    if (((Schema)innerSchema).getXml() != null) {
                        m.xmlPrefix = ((Schema)innerSchema).getXml().getPrefix();
                        m.xmlNamespace = ((Schema)innerSchema).getXml().getNamespace();
                        m.xmlName = ((Schema)innerSchema).getXml().getName();
                    }
                    if (modelDiscriminators > 1) {
                        this.LOGGER.error("Allof composed schema is inheriting >1 discriminator. Only use one discriminator: {}", (Object)composed);
                    }
                    if (modelImplCnt++ <= 1) continue;
                    this.LOGGER.warn("More than one inline schema specified in allOf:. Only the first one is recognized. All others are ignored.");
                    break;
                }
            }
        }
        if (!(interfaces = ModelUtils.getInterfaces(composed)).isEmpty()) {
            if (m.interfaces == null) {
                m.interfaces = new ArrayList<String>();
            }
            for (Schema interfaceSchema : interfaces) {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)(interfaceSchema = this.unaliasSchema(interfaceSchema)).get$ref())) {
                    String languageType = this.getTypeDeclaration(interfaceSchema);
                    CodegenProperty interfaceProperty = this.fromProperty(languageType, interfaceSchema, false);
                    if (ModelUtils.isArraySchema(interfaceSchema) || ModelUtils.isMapSchema(interfaceSchema)) {
                        while (interfaceProperty != null) {
                            this.addImport(m, interfaceProperty.complexType);
                            interfaceProperty = interfaceProperty.items;
                        }
                    }
                    if (composed.getAnyOf() != null) {
                        if (m.anyOf.contains(languageType)) {
                            this.LOGGER.debug("{} (anyOf schema) already has `{}` defined and therefore it's skipped.", (Object)m.name, (Object)languageType);
                            continue;
                        }
                        m.anyOf.add(languageType);
                        continue;
                    }
                    if (composed.getOneOf() != null) {
                        if (m.oneOf.contains(languageType)) {
                            this.LOGGER.debug("{} (oneOf schema) already has `{}` defined and therefore it's skipped.", (Object)m.name, (Object)languageType);
                            continue;
                        }
                        m.oneOf.add(languageType);
                        continue;
                    }
                    if (composed.getAllOf() != null) continue;
                    this.LOGGER.error("Composed schema has incorrect anyOf, allOf, oneOf defined: {}", (Object)composed);
                    continue;
                }
                Schema refSchema = null;
                String ref = ModelUtils.getSimpleRef(interfaceSchema.get$ref());
                if (allDefinitions != null) {
                    refSchema = allDefinitions.get(ref);
                }
                String modelName = this.toModelName(ref);
                CodegenProperty interfaceProperty = this.fromProperty(modelName, interfaceSchema, false);
                m.interfaces.add(modelName);
                this.addImport(composed, refSchema, m, modelName);
                if (allDefinitions != null && refSchema != null) {
                    if (allParents.contains(ref) && this.supportsMultipleInheritance) {
                        this.addProperties(allProperties, allRequired, refSchema, new HashSet<Schema>());
                    } else if (parentName != null && parentName.equals(ref) && this.supportsInheritance) {
                        this.addProperties(allProperties, allRequired, refSchema, new HashSet<Schema>());
                    } else {
                        LinkedHashMap<String, Schema> newProperties = new LinkedHashMap<String, Schema>();
                        this.addProperties(newProperties, required, refSchema, new HashSet<Schema>());
                        this.mergeProperties(properties, newProperties);
                        this.addProperties(allProperties, allRequired, refSchema, new HashSet<Schema>());
                    }
                }
                if (composed.getAnyOf() != null) {
                    m.anyOf.add(modelName);
                    continue;
                }
                if (composed.getOneOf() != null) {
                    m.oneOf.add(modelName);
                    continue;
                }
                if (composed.getAllOf() != null) {
                    m.allOf.add(modelName);
                    continue;
                }
                this.LOGGER.error("Composed schema has incorrect anyOf, allOf, oneOf defined: {}", (Object)composed);
            }
        }
        if (parent != null && composed.getAllOf() != null) {
            m.parentSchema = parentName;
            m.parent = this.toModelName(parentName);
            if (this.supportsMultipleInheritance) {
                m.allParents = new ArrayList<String>();
                for (String pname : allParents) {
                    String pModelName = this.toModelName(pname);
                    m.allParents.add(pModelName);
                    this.addImport(m, pModelName);
                }
            } else {
                this.addImport(m, m.parent);
            }
        }
        for (Schema component : interfaces) {
            if (component.get$ref() != null || component == null) continue;
            this.addProperties(properties, required, component, new HashSet<Schema>());
            this.addProperties(allProperties, allRequired, component, new HashSet<Schema>());
        }
        if (composed.getRequired() != null) {
            required.addAll(composed.getRequired());
            allRequired.addAll(composed.getRequired());
        }
        this.addVars(m, this.unaliasPropertySchema(properties), required, this.unaliasPropertySchema(allProperties), allRequired);
        if (this.supportsAdditionalPropertiesWithComposedSchema) {
            this.addAdditionPropertiesToCodeGenModel(m, schema);
        }
        if (Boolean.TRUE.equals(schema.getNullable())) {
            m.isNullable = Boolean.TRUE;
        }
    }

    private void mergeProperties(Map<String, Schema> existingProperties, Map<String, Schema> newProperties) {
        if (null != existingProperties && null != newProperties) {
            Schema existingType = existingProperties.get("type");
            Schema newType = newProperties.get("type");
            newProperties.forEach((key, value) -> existingProperties.put((String)key, ModelUtils.cloneSchema(value, this.specVersionGreaterThanOrEqualTo310(this.openAPI))));
            if (null != existingType && null != newType && null != newType.getEnum() && !newType.getEnum().isEmpty()) {
                for (Object e : newType.getEnum()) {
                    if (null == existingType.getEnum() || existingType.getEnum().contains(e)) continue;
                    existingType.addEnumItemObject(e);
                }
                existingProperties.put("type", existingType);
            }
        }
    }

    protected void updateModelForObject(CodegenModel m, Schema schema) {
        if (schema.getProperties() != null || schema.getRequired() != null && !ModelUtils.isComposedSchema(schema)) {
            this.addVars(m, this.unaliasPropertySchema(schema.getProperties()), schema.getRequired(), null, null);
        }
        if (ModelUtils.isMapSchema(schema)) {
            this.addAdditionPropertiesToCodeGenModel(m, schema);
        } else if (ModelUtils.isFreeFormObject(schema)) {
            this.addAdditionPropertiesToCodeGenModel(m, schema);
        }
        this.setAddProps(schema, m);
        this.addRequiredVarsMap(schema, m);
    }

    protected void updateModelForAnyType(CodegenModel m, Schema schema) {
        if (Boolean.FALSE.equals(schema.getNullable())) {
            this.LOGGER.error("Schema '{}' is any type, which includes the 'null' value. 'nullable' cannot be set to 'false'", (Object)m.name);
        }
        if (ModelUtils.isMapSchema(schema)) {
            this.addAdditionPropertiesToCodeGenModel(m, schema);
            m.isMap = true;
        }
        if (schema.getProperties() != null || schema.getRequired() != null && !ModelUtils.isComposedSchema(schema)) {
            this.addVars(m, this.unaliasPropertySchema(schema.getProperties()), schema.getRequired(), null, null);
        }
        this.setAddProps(schema, m);
        this.addRequiredVarsMap(schema, m);
    }

    protected String toTestCaseName(String specTestCaseName) {
        return specTestCaseName;
    }

    protected Object processTestExampleData(Object data) {
        return data;
    }

    private HashMap<String, SchemaTestCase> extractSchemaTestCases(String refToTestCases) {
        HashMap vendorExtensions = (HashMap)this.openAPI.getComponents().getExtensions();
        if (vendorExtensions == null || !vendorExtensions.containsKey(xSchemaTestExamplesKey)) {
            return null;
        }
        if (!refToTestCases.startsWith(xSchemaTestExamplesRefPrefix)) {
            return null;
        }
        String schemaName = refToTestCases.substring(xSchemaTestExamplesRefPrefix.length());
        HashMap<String, SchemaTestCase> schemaTestCases = new HashMap<String, SchemaTestCase>();
        LinkedHashMap schemaNameToTestCases = (LinkedHashMap)vendorExtensions.get(xSchemaTestExamplesKey);
        if (!schemaNameToTestCases.containsKey(schemaName)) {
            return null;
        }
        LinkedHashMap testNameToTesCase = (LinkedHashMap)schemaNameToTestCases.get(schemaName);
        for (Map.Entry entry : testNameToTesCase.entrySet()) {
            LinkedHashMap testExample = (LinkedHashMap)entry.getValue();
            String nameInSnakeCase = this.toTestCaseName((String)entry.getKey());
            Object data = this.processTestExampleData(testExample.get("data"));
            SchemaTestCase testCase = new SchemaTestCase(testExample.getOrDefault("description", ""), new ObjectWithTypeBooleans(data), (Boolean)testExample.get("valid"));
            schemaTestCases.put(nameInSnakeCase, testCase);
        }
        return schemaTestCases;
    }

    protected void updateModelForString(CodegenModel model, Schema schema) {
        if (ModelUtils.isDateTimeSchema(schema)) {
            model.setIsString(false);
            model.isDateTime = Boolean.TRUE;
        } else if (ModelUtils.isDateSchema(schema)) {
            model.setIsString(false);
            model.isDate = Boolean.TRUE;
        } else if (ModelUtils.isUUIDSchema(schema)) {
            model.setIsString(false);
            model.setIsUuid(true);
        } else if (ModelUtils.isURISchema(schema)) {
            model.setIsString(false);
            model.setIsUri(true);
        }
    }

    protected void updateModelForNumber(CodegenModel model, Schema schema) {
        model.isNumeric = Boolean.TRUE;
        if (ModelUtils.isFloatSchema(schema)) {
            model.isFloat = Boolean.TRUE;
        } else if (ModelUtils.isDoubleSchema(schema)) {
            model.isDouble = Boolean.TRUE;
        }
    }

    protected void updateModelForInteger(CodegenModel model, Schema schema) {
        model.isNumeric = Boolean.TRUE;
        if (ModelUtils.isLongSchema(schema)) {
            model.isLong = Boolean.TRUE;
        } else {
            model.isInteger = Boolean.TRUE;
            if (ModelUtils.isShortSchema(schema)) {
                model.setIsShort(Boolean.TRUE);
            }
        }
    }

    @Override
    public CodegenModel fromModel(String name, Schema schema) {
        Map<String, Schema> allDefinitions = ModelUtils.getSchemas(this.openAPI);
        CodegenModel m = (CodegenModel)CodegenModelFactory.newInstance(CodegenModelType.MODEL);
        if (schema.equals((Object)trueSchema)) {
            m.setIsBooleanSchemaTrue(true);
        } else if (schema.equals((Object)falseSchema)) {
            m.setIsBooleanSchemaFalse(true);
        }
        schema = this.unaliasSchema(schema);
        if (schema == null) {
            this.LOGGER.warn("Schema {} not found", (Object)name);
            return null;
        }
        ModelUtils.syncValidationProperties(schema, m);
        if (this.openAPI != null) {
            HashMap<String, SchemaTestCase> schemaTestCases = this.extractSchemaTestCases(xSchemaTestExamplesRefPrefix + name);
            m.testCases = schemaTestCases;
        }
        m.name = this.reservedWords.contains(name) ? this.escapeReservedWord(name) : name;
        m.schemaName = name;
        m.title = this.escapeText(schema.getTitle());
        m.description = this.escapeText(schema.getDescription());
        m.unescapedDescription = schema.getDescription();
        m.classname = this.toModelName(name);
        m.classVarName = this.toVarName(name);
        m.classFilename = this.toModelFilename(name);
        m.modelJson = Json.pretty((Object)schema);
        m.externalDocumentation = schema.getExternalDocs();
        if (schema.getExtensions() != null && !schema.getExtensions().isEmpty()) {
            m.getVendorExtensions().putAll(schema.getExtensions());
        }
        m.isAlias = this.typeAliases.containsKey(name) || this.isAliasOfSimpleTypes(schema) != false;
        m.setDiscriminator(this.createDiscriminator(name, schema));
        if (schema.getDeprecated() != null) {
            m.isDeprecated = schema.getDeprecated();
        }
        if (schema.getXml() != null) {
            m.xmlPrefix = schema.getXml().getPrefix();
            m.xmlNamespace = schema.getXml().getNamespace();
            m.xmlName = schema.getXml().getName();
        }
        if (!(ModelUtils.isAnyType(schema) || ModelUtils.isTypeObjectSchema(schema) || ModelUtils.isArraySchema(schema) || schema.get$ref() != null || schema.getEnum() == null || schema.getEnum().isEmpty())) {
            m.isEnum = true;
            m.allowableValues = new HashMap<String, Object>();
            m.allowableValues.put("values", schema.getEnum());
        }
        if (!ModelUtils.isArraySchema(schema)) {
            m.dataType = this.getSchemaType(schema);
        }
        if (!ModelUtils.isAnyType(schema) && Boolean.TRUE.equals(schema.getNullable())) {
            m.isNullable = Boolean.TRUE;
        }
        m.setTypeProperties(schema);
        m.setFormat(schema.getFormat());
        m.setComposedSchemas(this.getComposedSchemas(schema));
        if (ModelUtils.isArraySchema(schema)) {
            CodegenProperty arrayProperty = this.fromProperty(name, schema, false);
            m.setItems(arrayProperty.items);
            m.arrayModelType = arrayProperty.complexType;
            this.addParentContainer(m, name, schema);
        } else if (ModelUtils.isIntegerSchema(schema)) {
            this.updateModelForInteger(m, schema);
        } else if (ModelUtils.isStringSchema(schema)) {
            this.updateModelForString(m, schema);
        } else if (ModelUtils.isNumberSchema(schema)) {
            this.updateModelForNumber(m, schema);
        } else if (ModelUtils.isAnyType(schema)) {
            this.updateModelForAnyType(m, schema);
        } else if (ModelUtils.isTypeObjectSchema(schema)) {
            this.updateModelForObject(m, schema);
        } else if (!ModelUtils.isNullType(schema)) {
            // empty if block
        }
        if (schema.get$ref() != null) {
            m.setRef(schema.get$ref());
        }
        if (ModelUtils.isComposedSchema(schema)) {
            this.updateModelForComposedSchema(m, schema, allDefinitions);
        }
        m.removeAllDuplicatedProperty();
        if (m.discriminator != null) {
            String discPropName = m.discriminator.getPropertyBaseName();
            ArrayList<List<CodegenProperty>> listOLists = new ArrayList<List<CodegenProperty>>();
            listOLists.add(m.requiredVars);
            listOLists.add(m.vars);
            listOLists.add(m.allVars);
            for (List list : listOLists) {
                for (CodegenProperty requiredVar : list) {
                    if (!discPropName.equals(requiredVar.baseName)) continue;
                    requiredVar.isDiscriminator = true;
                }
            }
        }
        if (m.requiredVars != null && m.requiredVars.size() > 0) {
            m.setHasRequired(true);
        }
        if (this.sortModelPropertiesByRequiredFlag.booleanValue()) {
            Comparator<CodegenProperty> comparator = new Comparator<CodegenProperty>(){

                @Override
                public int compare(CodegenProperty one, CodegenProperty another) {
                    if (one.required == another.required) {
                        return 0;
                    }
                    if (one.required) {
                        return -1;
                    }
                    return 1;
                }
            };
            Collections.sort(m.vars, comparator);
            Collections.sort(m.allVars, comparator);
        }
        if (m.vars != null) {
            for (CodegenProperty prop : m.vars) {
                this.postProcessModelProperty(m, prop);
            }
            boolean bl = m.hasVars = m.vars.size() > 0;
        }
        if (m.allVars != null) {
            for (CodegenProperty prop : m.allVars) {
                this.postProcessModelProperty(m, prop);
            }
        }
        return m;
    }

    protected void setAddProps(Schema schema, IJsonSchemaValidationProperties property) {
        if (schema.equals((Object)new Schema())) {
            return;
        }
        boolean additionalPropertiesIsAnyType = false;
        CodegenModel m = null;
        if (property instanceof CodegenModel) {
            m = (CodegenModel)property;
        }
        CodegenProperty addPropProp = null;
        boolean isAdditionalPropertiesTrue = false;
        if (schema.getAdditionalProperties() == null) {
            if (!this.disallowAdditionalPropertiesIfNotPresent) {
                isAdditionalPropertiesTrue = true;
                addPropProp = this.fromProperty(this.getAdditionalPropertiesName(), new Schema(), false);
                additionalPropertiesIsAnyType = true;
            }
        } else if (schema.getAdditionalProperties() instanceof Boolean) {
            if (Boolean.TRUE.equals(schema.getAdditionalProperties())) {
                isAdditionalPropertiesTrue = true;
                addPropProp = this.fromProperty(this.getAdditionalPropertiesName(), new Schema(), false);
                additionalPropertiesIsAnyType = true;
            }
        } else {
            addPropProp = this.fromProperty(this.getAdditionalPropertiesName(), (Schema)schema.getAdditionalProperties(), false);
            additionalPropertiesIsAnyType = true;
        }
        if (additionalPropertiesIsAnyType) {
            property.setAdditionalPropertiesIsAnyType(true);
        }
        if (m != null && (isAdditionalPropertiesTrue || additionalPropertiesIsAnyType)) {
            m.isAdditionalPropertiesTrue = true;
        }
        if (ModelUtils.isComposedSchema(schema) && !this.supportsAdditionalPropertiesWithComposedSchema) {
            return;
        }
        if (addPropProp != null) {
            property.setAdditionalProperties(addPropProp);
        }
    }

    private CodegenProperty discriminatorFound(String composedSchemaName, Schema sc, String discPropName, Set<String> visitedSchemas) {
        if (visitedSchemas.contains(composedSchemaName)) {
            return null;
        }
        visitedSchemas.add(composedSchemaName);
        Schema<?> refSchema = ModelUtils.getReferencedSchema(this.openAPI, sc);
        if (refSchema.getProperties() != null && refSchema.getProperties().get(discPropName) != null) {
            Schema discSchema = (Schema)refSchema.getProperties().get(discPropName);
            CodegenProperty cp = new CodegenProperty();
            if (ModelUtils.isStringSchema(discSchema)) {
                cp.isString = true;
            }
            cp.setRequired(false);
            if (refSchema.getRequired() != null && refSchema.getRequired().contains(discPropName)) {
                cp.setRequired(true);
            }
            return cp;
        }
        if (ModelUtils.isComposedSchema(refSchema)) {
            Object cp;
            Schema<?> composedSchema = refSchema;
            if (composedSchema.getAllOf() != null) {
                for (Object allOf : composedSchema.getAllOf()) {
                    CodegenProperty cp2 = this.discriminatorFound(composedSchemaName, (Schema)allOf, discPropName, visitedSchemas);
                    if (cp2 == null) continue;
                    return cp2;
                }
            }
            if (composedSchema.getOneOf() != null && composedSchema.getOneOf().size() != 0) {
                cp = new CodegenProperty();
                for (Object oneOf : composedSchema.getOneOf()) {
                    String modelName = ModelUtils.getSimpleRef(((Schema)oneOf).get$ref());
                    CodegenProperty thisCp = this.discriminatorFound(composedSchemaName, (Schema)oneOf, discPropName, visitedSchemas);
                    if (thisCp == null) {
                        OnceLogger.once(this.LOGGER).warn("'{}' defines discriminator '{}', but the referenced OneOf schema '{}' is missing {}", new Object[]{composedSchemaName, discPropName, modelName, discPropName});
                    }
                    if (cp != null && ((CodegenProperty)cp).dataType == null) {
                        cp = thisCp;
                        continue;
                    }
                    if (cp == thisCp) continue;
                    OnceLogger.once(this.LOGGER).warn("'{}' defines discriminator '{}', but the OneOf schema '{}' has a different {} definition than the prior OneOf schema's. Make sure the {} type and required values are the same", new Object[]{composedSchemaName, discPropName, modelName, discPropName, discPropName});
                }
                return cp;
            }
            if (composedSchema.getAnyOf() != null && composedSchema.getAnyOf().size() != 0) {
                cp = new CodegenProperty();
                for (Object anyOf : composedSchema.getAnyOf()) {
                    String modelName = ModelUtils.getSimpleRef(((Schema)anyOf).get$ref());
                    CodegenProperty thisCp = this.discriminatorFound(composedSchemaName, (Schema)anyOf, discPropName, visitedSchemas);
                    if (thisCp == null) {
                        OnceLogger.once(this.LOGGER).warn("'{}' defines discriminator '{}', but the referenced AnyOf schema '{}' is missing {}", new Object[]{composedSchemaName, discPropName, modelName, discPropName});
                    }
                    if (cp != null && ((CodegenProperty)cp).dataType == null) {
                        cp = thisCp;
                        continue;
                    }
                    if (cp == thisCp) continue;
                    OnceLogger.once(this.LOGGER).warn("'{}' defines discriminator '{}', but the AnyOf schema '{}' has a different {} definition than the prior AnyOf schema's. Make sure the {} type and required values are the same", new Object[]{composedSchemaName, discPropName, modelName, discPropName, discPropName});
                }
                return cp;
            }
        }
        return null;
    }

    private Discriminator recursiveGetDiscriminator(Schema sc, ArrayList<Schema> visitedSchemas) {
        Schema<?> refSchema = ModelUtils.getReferencedSchema(this.openAPI, sc);
        Discriminator foundDisc = refSchema.getDiscriminator();
        if (foundDisc != null) {
            return foundDisc;
        }
        if (this.getLegacyDiscriminatorBehavior().booleanValue()) {
            return null;
        }
        for (Schema s : visitedSchemas) {
            if (s != refSchema) continue;
            return null;
        }
        visitedSchemas.add(refSchema);
        Discriminator disc = new Discriminator();
        if (ModelUtils.isComposedSchema(refSchema)) {
            Integer n;
            Integer n2;
            HashSet<String> discriminatorsPropNames;
            Integer hasNullTypeCnt;
            Integer hasDiscriminatorCnt;
            Schema<?> composedSchema = refSchema;
            if (composedSchema.getAllOf() != null) {
                for (Object allOf : composedSchema.getAllOf()) {
                    foundDisc = this.recursiveGetDiscriminator((Schema)allOf, visitedSchemas);
                    if (foundDisc == null) continue;
                    disc.setPropertyName(foundDisc.getPropertyName());
                    disc.setMapping(foundDisc.getMapping());
                    return disc;
                }
            }
            if (composedSchema.getOneOf() != null && composedSchema.getOneOf().size() != 0) {
                hasDiscriminatorCnt = 0;
                hasNullTypeCnt = 0;
                discriminatorsPropNames = new HashSet<String>();
                for (Object oneOf : composedSchema.getOneOf()) {
                    if (ModelUtils.isNullType((Schema)oneOf)) {
                        n2 = hasNullTypeCnt;
                        n = hasNullTypeCnt = Integer.valueOf(hasNullTypeCnt + 1);
                        continue;
                    }
                    foundDisc = this.recursiveGetDiscriminator((Schema)oneOf, visitedSchemas);
                    if (foundDisc == null) continue;
                    discriminatorsPropNames.add(foundDisc.getPropertyName());
                    n2 = hasDiscriminatorCnt;
                    n = hasDiscriminatorCnt = Integer.valueOf(hasDiscriminatorCnt + 1);
                }
                if (discriminatorsPropNames.size() > 1) {
                    OnceLogger.once(this.LOGGER).warn("The oneOf schemas have conflicting discriminator property names. oneOf schemas must have the same property name, but found " + String.join((CharSequence)", ", discriminatorsPropNames));
                }
                if (foundDisc != null && hasDiscriminatorCnt + hasNullTypeCnt == composedSchema.getOneOf().size() && discriminatorsPropNames.size() == 1) {
                    disc.setPropertyName(foundDisc.getPropertyName());
                    disc.setMapping(foundDisc.getMapping());
                    return disc;
                }
            }
            if (composedSchema.getAnyOf() != null && composedSchema.getAnyOf().size() != 0) {
                hasDiscriminatorCnt = 0;
                hasNullTypeCnt = 0;
                discriminatorsPropNames = new HashSet();
                for (Object anyOf : composedSchema.getAnyOf()) {
                    if (ModelUtils.isNullType((Schema)anyOf)) {
                        n2 = hasNullTypeCnt;
                        n = hasNullTypeCnt = Integer.valueOf(hasNullTypeCnt + 1);
                        continue;
                    }
                    foundDisc = this.recursiveGetDiscriminator((Schema)anyOf, visitedSchemas);
                    if (foundDisc == null) continue;
                    discriminatorsPropNames.add(foundDisc.getPropertyName());
                    n2 = hasDiscriminatorCnt;
                    n = hasDiscriminatorCnt = Integer.valueOf(hasDiscriminatorCnt + 1);
                }
                if (discriminatorsPropNames.size() > 1) {
                    OnceLogger.once(this.LOGGER).warn("The anyOf schemas have conflicting discriminator property names. anyOf schemas must have the same property name, but found " + String.join((CharSequence)", ", discriminatorsPropNames));
                }
                if (foundDisc != null && hasDiscriminatorCnt + hasNullTypeCnt == composedSchema.getAnyOf().size() && discriminatorsPropNames.size() == 1) {
                    disc.setPropertyName(foundDisc.getPropertyName());
                    disc.setMapping(foundDisc.getMapping());
                    return disc;
                }
            }
        }
        return null;
    }

    protected List<CodegenDiscriminator.MappedModel> getOneOfAnyOfDescendants(String composedSchemaName, String discPropName, Schema c) {
        ArrayList<List> listOLists = new ArrayList<List>();
        listOLists.add(c.getOneOf());
        listOLists.add(c.getAnyOf());
        ArrayList<CodegenDiscriminator.MappedModel> descendentSchemas = new ArrayList<CodegenDiscriminator.MappedModel>();
        for (List schemaList : listOLists) {
            if (schemaList == null) continue;
            for (Schema sc : schemaList) {
                if (ModelUtils.isNullType(sc)) continue;
                String ref = sc.get$ref();
                if (ref == null) {
                    OnceLogger.once(this.LOGGER).warn("Invalid inline schema defined in oneOf/anyOf in '{}'. Per the OpenApi spec, for this case when a composed schema defines a discriminator, the oneOf/anyOf schemas must use $ref. Change this inline definition to a $ref definition", (Object)composedSchemaName);
                }
                CodegenProperty df = this.discriminatorFound(composedSchemaName, sc, discPropName, new TreeSet<String>());
                String modelName = ModelUtils.getSimpleRef(ref);
                if (df == null || !df.isString || !df.required) {
                    Object msgSuffix = "";
                    if (df == null) {
                        msgSuffix = (String)msgSuffix + discPropName + " is missing from the schema, define it as required and type string";
                    } else {
                        if (!df.isString) {
                            msgSuffix = (String)msgSuffix + "invalid type for " + discPropName + ", set it to string";
                        }
                        if (!df.required) {
                            String spacer = "";
                            if (((String)msgSuffix).length() != 0) {
                                spacer = ". ";
                            }
                            msgSuffix = (String)msgSuffix + spacer + "invalid optional definition of " + discPropName + ", include it in required";
                        }
                    }
                    OnceLogger.once(this.LOGGER).warn("'{}' defines discriminator '{}', but the referenced schema '{}' is incorrect. {}", new Object[]{composedSchemaName, discPropName, modelName, msgSuffix});
                }
                CodegenDiscriminator.MappedModel mm = new CodegenDiscriminator.MappedModel(modelName, this.toModelName(modelName));
                descendentSchemas.add(mm);
                Schema cs = ModelUtils.getSchema(this.openAPI, modelName);
                if (cs == null) {
                    OnceLogger.once(this.LOGGER).error("Failed to lookup the schema '{}' when processing oneOf/anyOf. Please check to ensure it's defined properly.", (Object)modelName);
                    continue;
                }
                Map vendorExtensions = cs.getExtensions();
                if (vendorExtensions == null || vendorExtensions.isEmpty() || !vendorExtensions.containsKey("x-discriminator-value")) continue;
                String xDiscriminatorValue = (String)vendorExtensions.get("x-discriminator-value");
                mm = new CodegenDiscriminator.MappedModel(xDiscriminatorValue, this.toModelName(modelName), true);
                descendentSchemas.add(mm);
            }
        }
        return descendentSchemas;
    }

    protected List<CodegenDiscriminator.MappedModel> getAllOfDescendants(String thisSchemaName) {
        ArrayList<String> queue = new ArrayList<String>();
        ArrayList<CodegenDiscriminator.MappedModel> descendentSchemas = new ArrayList<CodegenDiscriminator.MappedModel>();
        Map<String, Schema> schemas = ModelUtils.getSchemas(this.openAPI);
        String currentSchemaName = thisSchemaName;
        Set<String> keys = schemas.keySet();
        int count = 0;
        while (100000 > count++) {
            block1: for (String childName : keys) {
                List parents;
                Schema child;
                if (childName.equals(thisSchemaName) || !ModelUtils.isComposedSchema(child = schemas.get(childName)) || (parents = child.getAllOf()) == null) continue;
                for (Schema parent : parents) {
                    String parentName;
                    String ref = parent.get$ref();
                    if (ref == null || (parentName = ModelUtils.getSimpleRef(ref)) == null || !parentName.equals(currentSchemaName)) continue;
                    if (queue.contains(childName) || descendentSchemas.stream().anyMatch(i -> childName.equals(i.getMappingName()))) {
                        throw new RuntimeException("Stack overflow hit when looking for " + thisSchemaName + " an infinite loop starting and ending at " + childName + " was seen");
                    }
                    queue.add(childName);
                    continue block1;
                }
            }
            if (queue.size() == 0) break;
            currentSchemaName = (String)queue.remove(0);
            Schema cs = schemas.get(currentSchemaName);
            Map vendorExtensions = cs.getExtensions();
            String mappingName = Optional.ofNullable(vendorExtensions).map(ve -> ve.get("x-discriminator-value")).map(discriminatorValue -> (String)discriminatorValue).orElse(currentSchemaName);
            CodegenDiscriminator.MappedModel mm = new CodegenDiscriminator.MappedModel(mappingName, this.toModelName(currentSchemaName), !mappingName.equals(currentSchemaName));
            descendentSchemas.add(mm);
        }
        return descendentSchemas;
    }

    protected CodegenDiscriminator createDiscriminator(String schemaName, Schema schema) {
        List<CodegenDiscriminator.MappedModel> otherDescendants;
        boolean legacyUseCase;
        StringSchema s;
        Discriminator sourceDiscriminator = this.recursiveGetDiscriminator(schema, new ArrayList<Schema>());
        if (sourceDiscriminator == null) {
            return null;
        }
        CodegenDiscriminator discriminator = new CodegenDiscriminator();
        String discriminatorPropertyName = sourceDiscriminator.getPropertyName();
        discriminator.setPropertyName(this.toVarName(discriminatorPropertyName));
        discriminator.setPropertyBaseName(sourceDiscriminator.getPropertyName());
        discriminator.setPropertyGetter(this.toGetter(discriminator.getPropertyName()));
        if (sourceDiscriminator.getExtensions() != null) {
            discriminator.setVendorExtensions(sourceDiscriminator.getExtensions());
        }
        String propertyType = Optional.ofNullable(schema.getProperties()).map(p -> (Schema)p.get(discriminatorPropertyName)).map(Schema::get$ref).map(ModelUtils::getSimpleRef).map(this::toModelName).orElseGet(() -> this.typeMapping.get("string"));
        discriminator.setPropertyType(propertyType);
        if (schema.getProperties() != null && schema.getProperties().get(discriminatorPropertyName) instanceof StringSchema && (s = (StringSchema)schema.getProperties().get(discriminatorPropertyName)).getEnum() != null && !s.getEnum().isEmpty()) {
            discriminator.setIsEnum(true);
        }
        discriminator.setMapping(sourceDiscriminator.getMapping());
        ArrayList<CodegenDiscriminator.MappedModel> uniqueDescendants = new ArrayList<CodegenDiscriminator.MappedModel>();
        if (sourceDiscriminator.getMapping() != null && !sourceDiscriminator.getMapping().isEmpty()) {
            for (Map.Entry e : sourceDiscriminator.getMapping().entrySet()) {
                String name;
                if (((String)e.getValue()).indexOf(47) >= 0) {
                    name = ModelUtils.getSimpleRef((String)e.getValue());
                    if (ModelUtils.getSchema(this.openAPI, name) == null) {
                        OnceLogger.once(this.LOGGER).error("Failed to lookup the schema '{}' when processing the discriminator mapping of oneOf/anyOf. Please check to ensure it's defined properly.", (Object)name);
                    }
                } else {
                    name = (String)e.getValue();
                }
                uniqueDescendants.add(new CodegenDiscriminator.MappedModel((String)e.getKey(), this.toModelName(name), true));
            }
        }
        boolean bl = legacyUseCase = this.getLegacyDiscriminatorBehavior() != false && uniqueDescendants.isEmpty();
        if (!this.getLegacyDiscriminatorBehavior().booleanValue() || legacyUseCase) {
            otherDescendants = this.getAllOfDescendants(schemaName);
            for (CodegenDiscriminator.MappedModel otherDescendant : otherDescendants) {
                boolean matched = false;
                for (CodegenDiscriminator.MappedModel uniqueDescendant : uniqueDescendants) {
                    if (!uniqueDescendant.getMappingName().equals(otherDescendant.getMappingName()) && !uniqueDescendant.getModelName().equals(otherDescendant.getModelName())) continue;
                    matched = true;
                    break;
                }
                if (matched) continue;
                uniqueDescendants.add(otherDescendant);
            }
        }
        if (ModelUtils.isComposedSchema(schema) && !this.getLegacyDiscriminatorBehavior().booleanValue()) {
            otherDescendants = this.getOneOfAnyOfDescendants(schemaName, discriminatorPropertyName, schema);
            for (CodegenDiscriminator.MappedModel otherDescendant : otherDescendants) {
                if (uniqueDescendants.contains(otherDescendant)) continue;
                uniqueDescendants.add(otherDescendant);
            }
        }
        if (!this.getLegacyDiscriminatorBehavior().booleanValue()) {
            Collections.sort(uniqueDescendants);
        }
        discriminator.getMappedModels().addAll(uniqueDescendants);
        return discriminator;
    }

    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        this.addParentContainer(codegenModel, codegenModel.name, schema);
    }

    protected void addProperties(Map<String, Schema> properties, List<String> required, Schema schema, Set<Schema> visitedSchemas) {
        if (schema == null) {
            return;
        }
        if (!visitedSchemas.add(schema)) {
            return;
        }
        if (ModelUtils.isComposedSchema(schema)) {
            if (schema.getProperties() != null && !schema.getProperties().isEmpty()) {
                properties.putAll(schema.getProperties());
            }
            if (schema.getAllOf() != null) {
                for (Object component : schema.getAllOf()) {
                    this.addProperties(properties, required, (Schema)component, visitedSchemas);
                }
            }
            if (schema.getRequired() != null) {
                required.addAll(schema.getRequired());
            }
            if (schema.getOneOf() != null) {
                for (Object component : schema.getOneOf()) {
                    this.addProperties(properties, required, (Schema)component, visitedSchemas);
                }
            }
            if (schema.getAnyOf() != null) {
                for (Object component : schema.getAnyOf()) {
                    this.addProperties(properties, required, (Schema)component, visitedSchemas);
                }
            }
            for (String r : required) {
                if (properties.containsKey(r)) continue;
                this.LOGGER.error("Required var {} not in properties", (Object)r);
            }
            return;
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)schema.get$ref())) {
            Schema<?> interfaceSchema = ModelUtils.getReferencedSchema(this.openAPI, schema);
            this.addProperties(properties, required, interfaceSchema, visitedSchemas);
            return;
        }
        if (schema.getProperties() != null) {
            properties.putAll(schema.getProperties());
        }
        if (schema.getRequired() != null) {
            required.addAll(schema.getRequired());
        }
    }

    public String getterAndSetterCapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return StringUtils.camelize(this.toVarName(name));
    }

    protected void updatePropertyForMap(CodegenProperty property, Schema p) {
        if (p.getAdditionalProperties() instanceof Boolean && Boolean.FALSE.equals(p.getAdditionalProperties())) {
            throw new RuntimeException("additionalProperties cannot be false in updatePropertyForMap.");
        }
        property.isContainer = true;
        property.containerType = "map";
        property.containerTypeMapped = this.typeMapping.get(property.containerType);
        property.minItems = p.getMinProperties();
        property.maxItems = p.getMaxProperties();
        Schema innerSchema = this.unaliasSchema(ModelUtils.getAdditionalProperties(p));
        if (innerSchema == null) {
            this.LOGGER.error("Undefined map inner type for `{}`. Default to String.", (Object)p.getName());
            innerSchema = new StringSchema().description("//TODO automatically added by openapi-generator due to undefined type");
            p.setAdditionalProperties((Object)innerSchema);
        }
        CodegenProperty cp = this.fromProperty("inner", innerSchema, false);
        this.updatePropertyForMap(property, cp);
    }

    protected void updatePropertyForObject(CodegenProperty property, Schema p) {
        if (ModelUtils.isFreeFormObject(p)) {
            property.isFreeFormObject = true;
            if (this.languageSpecificPrimitives.contains(property.dataType)) {
                property.isPrimitiveType = true;
            }
            if (ModelUtils.isMapSchema(p)) {
                this.updatePropertyForMap(property, p);
            } else {
                property.setIsMap(false);
            }
        } else if (ModelUtils.isMapSchema(p)) {
            this.updatePropertyForMap(property, p);
        }
        this.addVarsRequiredVarsAdditionalProps(p, property);
    }

    protected void updatePropertyForAnyType(CodegenProperty property, Schema p) {
        if (Boolean.FALSE.equals(p.getNullable())) {
            this.LOGGER.warn("Schema '{}' is any type, which includes the 'null' value. 'nullable' cannot be set to 'false'", (Object)p.getName());
        }
        boolean bl = property.isNullable = property.isNullable || !ModelUtils.isComposedSchema(p) || p.getAllOf() == null || p.getAllOf().size() == 0;
        if (this.languageSpecificPrimitives.contains(property.dataType)) {
            property.isPrimitiveType = true;
        }
        if (ModelUtils.isMapSchema(p)) {
            this.updatePropertyForMap(property, p);
        }
        this.addVarsRequiredVarsAdditionalProps(p, property);
    }

    protected void updatePropertyForString(CodegenProperty property, Schema p) {
        if (ModelUtils.isByteArraySchema(p)) {
            property.setIsString(false);
            property.isByteArray = true;
        } else if (ModelUtils.isBinarySchema(p)) {
            property.isBinary = true;
            property.isFile = true;
        } else if (ModelUtils.isUUIDSchema(p)) {
            property.isUuid = true;
        } else if (ModelUtils.isURISchema(p)) {
            property.isUri = true;
        } else if (ModelUtils.isEmailSchema(p)) {
            property.isEmail = true;
        } else if (ModelUtils.isPasswordSchema(p)) {
            property.isPassword = true;
        } else if (ModelUtils.isDateSchema(p)) {
            property.setIsString(false);
            property.isDate = true;
        } else if (ModelUtils.isDateTimeSchema(p)) {
            property.setIsString(false);
            property.isDateTime = true;
        } else if (ModelUtils.isDecimalSchema(p)) {
            property.isDecimal = true;
            property.setIsString(false);
        }
        property.pattern = this.toRegularExpression(p.getPattern());
    }

    protected void updatePropertyForNumber(CodegenProperty property, Schema p) {
        property.isNumeric = Boolean.TRUE;
        if (ModelUtils.isFloatSchema(p)) {
            property.isFloat = Boolean.TRUE;
        } else if (ModelUtils.isDoubleSchema(p)) {
            property.isDouble = Boolean.TRUE;
        }
    }

    protected void updatePropertyForInteger(CodegenProperty property, Schema p) {
        property.isNumeric = Boolean.TRUE;
        if (ModelUtils.isLongSchema(p)) {
            property.isLong = Boolean.TRUE;
        } else {
            property.isInteger = Boolean.TRUE;
            if (ModelUtils.isShortSchema(p)) {
                property.setIsShort(Boolean.TRUE);
            }
        }
    }

    public CodegenProperty fromProperty(String name, Schema p, boolean required) {
        return this.fromProperty(name, p, required, false);
    }

    public CodegenProperty fromProperty(String name, Schema p) {
        return this.fromProperty(name, p, false, false);
    }

    public CodegenProperty fromProperty(String name, Schema p, boolean required, boolean schemaIsFromAdditionalProperties) {
        boolean isAnyTypeWithNothingElseSet;
        Schema<?> referencedSchema;
        Object referencedSchema2;
        String ref;
        if (p == null) {
            this.LOGGER.error("Undefined property/schema for `{}`. Default to type:string.", (Object)name);
            return null;
        }
        this.LOGGER.debug("debugging fromProperty for {}: {}", (Object)name, (Object)p);
        NamedSchema ns = new NamedSchema(name, p, required, schemaIsFromAdditionalProperties);
        CodegenProperty cpc = this.schemaCodegenPropertyCache.get(ns);
        if (cpc != null) {
            this.LOGGER.debug("Cached fromProperty for {} : {} required={}", new Object[]{name, p.getName(), required});
            return cpc;
        }
        Schema refToPropertiesSchema = ModelUtils.getSchemaFromRefToSchemaWithProperties(this.openAPI, p.get$ref());
        if (refToPropertiesSchema != null) {
            p = refToPropertiesSchema;
            return this.fromProperty(name, refToPropertiesSchema, required, schemaIsFromAdditionalProperties);
        }
        Schema original = null;
        if (ModelUtils.isAllOf(p) && p.getAllOf().size() == 1) {
            if (p.getAllOf().get(0) instanceof Schema) {
                original = p;
                p = (Schema)p.getAllOf().get(0);
            } else {
                this.LOGGER.error("Unknown type in allOf schema. Please report the issue via openapi-generator's Github issue tracker.");
            }
        } else if (p.get$ref() != null) {
            original = p;
        }
        CodegenProperty property = (CodegenProperty)CodegenModelFactory.newInstance(CodegenModelType.PROPERTY);
        if (p.equals((Object)trueSchema)) {
            property.setIsBooleanSchemaTrue(true);
        } else if (p.equals((Object)falseSchema)) {
            property.setIsBooleanSchemaFalse(true);
        }
        p = this.unaliasSchema(p);
        property.setSchemaIsFromAdditionalProperties(schemaIsFromAdditionalProperties);
        property.required = required;
        ModelUtils.syncValidationProperties(p, property);
        property.setFormat(p.getFormat());
        property.name = this.toVarName(name);
        property.baseName = name;
        property.openApiType = ModelUtils.getType(p) == null ? this.getSchemaType(p) : ModelUtils.getType(p);
        property.nameInPascalCase = StringUtils.camelize(property.name);
        property.nameInCamelCase = StringUtils.camelize(property.name, CamelizeOption.LOWERCASE_FIRST_LETTER);
        property.nameInSnakeCase = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, property.nameInPascalCase);
        property.description = this.escapeText(p.getDescription());
        property.unescapedDescription = p.getDescription();
        property.title = p.getTitle();
        property.getter = this.toGetter(name);
        property.setter = this.toSetter(name);
        try {
            property.example = this.toExampleValue(p);
        }
        catch (Exception e) {
            this.LOGGER.error("Error in generating `example` for the property {}. Default to ERROR_TO_EXAMPLE_VALUE. Enable debugging for more info.", (Object)property.baseName);
            this.LOGGER.debug("Exception from toExampleValue: {}", (Object)e.getMessage());
            property.example = "ERROR_TO_EXAMPLE_VALUE";
        }
        property.jsonSchema = Json.pretty((Object)Json.mapper().convertValue((Object)p, TreeMap.class));
        if (p.getDeprecated() != null) {
            property.deprecated = p.getDeprecated();
        } else if (p.get$ref() != null && (ref = ModelUtils.getSimpleRef(p.get$ref())) != null && (referencedSchema2 = ModelUtils.getSchemas(this.openAPI).get(ref)) != null && referencedSchema2.getDeprecated() != null) {
            property.deprecated = referencedSchema2.getDeprecated();
        }
        if (p.getReadOnly() != null) {
            property.isReadOnly = p.getReadOnly();
        }
        if (p.getWriteOnly() != null) {
            property.isWriteOnly = p.getWriteOnly();
        }
        if (p.getNullable() != null) {
            property.isNullable = p.getNullable();
        }
        if (p.getExtensions() != null && !p.getExtensions().isEmpty()) {
            property.getVendorExtensions().putAll(p.getExtensions());
        } else if (p.get$ref() != null && (referencedSchema = ModelUtils.getReferencedSchema(this.openAPI, p)).getExtensions() != null && !referencedSchema.getExtensions().isEmpty()) {
            property.getVendorExtensions().putAll(referencedSchema.getExtensions());
        }
        if (p.getEnum() != null && !p.getEnum().isEmpty()) {
            List _enum = p.getEnum();
            property._enum = new ArrayList<String>();
            for (Object i : _enum) {
                property._enum.add(String.valueOf(i));
            }
            property.isEnum = true;
            property.isInnerEnum = true;
            HashMap<String, Object> allowableValues = new HashMap<String, Object>();
            allowableValues.put("values", _enum);
            if (allowableValues.size() > 0) {
                property.allowableValues = allowableValues;
            }
        }
        if ((referencedSchema = ModelUtils.getReferencedSchema(this.openAPI, p)) != p && referencedSchema.getEnum() != null && !referencedSchema.getEnum().isEmpty()) {
            List _enum = referencedSchema.getEnum();
            property.isEnumRef = true;
            HashMap<String, Object> allowableValues = new HashMap<String, Object>();
            allowableValues.put("values", _enum);
            if (allowableValues.size() > 0) {
                property.allowableValues = allowableValues;
            }
        }
        if (referencedSchema.getNullable() != null) {
            property.isNullable = referencedSchema.getNullable();
        } else if (referencedSchema.getExtensions() != null && referencedSchema.getExtensions().containsKey("x-nullable")) {
            property.isNullable = (Boolean)referencedSchema.getExtensions().get("x-nullable");
        }
        XML referencedSchemaXml = referencedSchema.getXml();
        if (referencedSchemaXml != null) {
            property.xmlName = referencedSchemaXml.getName();
            property.xmlNamespace = referencedSchemaXml.getNamespace();
            property.xmlPrefix = referencedSchemaXml.getPrefix();
            if (referencedSchemaXml.getAttribute() != null) {
                property.isXmlAttribute = referencedSchemaXml.getAttribute();
            }
            if (referencedSchemaXml.getWrapped() != null) {
                property.isXmlWrapped = referencedSchemaXml.getWrapped();
            }
        }
        if (p.getXml() != null) {
            if (p.getXml().getAttribute() != null) {
                property.isXmlAttribute = p.getXml().getAttribute();
            }
            if (p.getXml().getWrapped() != null) {
                property.isXmlWrapped = p.getXml().getWrapped();
            }
            property.xmlPrefix = p.getXml().getPrefix();
            property.xmlName = p.getXml().getName();
            property.xmlNamespace = p.getXml().getNamespace();
        }
        property.dataType = this.getTypeDeclaration(p);
        property.dataFormat = p.getFormat();
        property.baseType = this.getSchemaType(p);
        if (property.isEnum) {
            property.datatypeWithEnum = this.toEnumName(property);
            property.enumName = this.toEnumName(property);
        } else {
            property.datatypeWithEnum = property.dataType;
        }
        property.setTypeProperties(p);
        property.setComposedSchemas(this.getComposedSchemas(p));
        if (ModelUtils.isIntegerSchema(p)) {
            this.updatePropertyForInteger(property, p);
        } else if (ModelUtils.isBooleanSchema(p)) {
            property.getter = this.toBooleanGetter(name);
        } else if (ModelUtils.isFileSchema(p) && !ModelUtils.isStringSchema(p)) {
            property.isFile = true;
        } else if (ModelUtils.isStringSchema(p)) {
            this.updatePropertyForString(property, p);
        } else if (ModelUtils.isNumberSchema(p)) {
            this.updatePropertyForNumber(property, p);
        } else if (ModelUtils.isArraySchema(p)) {
            property.isContainer = true;
            if (ModelUtils.isSet(p)) {
                property.containerType = "set";
                property.containerTypeMapped = this.typeMapping.get(property.containerType);
            } else {
                property.containerType = "array";
                property.containerTypeMapped = this.typeMapping.get(property.containerType);
            }
            property.baseType = this.getSchemaType(p);
            String itemName = this.getItemsName(p, name);
            Schema innerSchema = this.unaliasSchema(ModelUtils.getSchemaItems(p));
            CodegenProperty cp = this.fromProperty(itemName, innerSchema, false);
            this.updatePropertyForArray(property, cp);
        } else if (ModelUtils.isTypeObjectSchema(p)) {
            this.updatePropertyForObject(property, p);
        } else if (ModelUtils.isAnyType(p)) {
            this.updatePropertyForAnyType(property, p);
        } else if (!ModelUtils.isNullType(p)) {
            // empty if block
        }
        if (p.get$ref() != null) {
            property.setRef(p.get$ref());
        }
        boolean bl = isAnyTypeWithNothingElseSet = ModelUtils.isAnyType(p) && (p.getProperties() == null || p.getProperties().isEmpty()) && !ModelUtils.isComposedSchema(p) && p.getAdditionalProperties() == null && p.getNot() == null && p.getEnum() == null;
        if (!(ModelUtils.isArraySchema(p) || ModelUtils.isMapSchema(p) || ModelUtils.isFreeFormObject(p) || isAnyTypeWithNothingElseSet)) {
            String type = this.getSchemaType(p);
            this.setNonArrayMapProperty(property, type);
            boolean bl2 = property.isModel = (ModelUtils.isComposedSchema(referencedSchema) || ModelUtils.isObjectSchema(referencedSchema)) && ModelUtils.isModel(referencedSchema);
        }
        if (original != null) {
            p = original;
            if (p.getNullable() != null) {
                property.isNullable = p.getNullable();
            } else if (p.getExtensions() != null && p.getExtensions().containsKey("x-nullable")) {
                property.isNullable = (Boolean)p.getExtensions().get("x-nullable");
            }
            if (p.getReadOnly() != null) {
                property.isReadOnly = p.getReadOnly();
            }
            if (p.getWriteOnly() != null) {
                property.isWriteOnly = p.getWriteOnly();
            }
            if (original.getExtensions() != null) {
                property.getVendorExtensions().putAll(original.getExtensions());
            }
            if (original.getDeprecated() != null) {
                property.deprecated = p.getDeprecated();
            }
            if (original.getDescription() != null) {
                property.description = this.escapeText(p.getDescription());
                property.unescapedDescription = p.getDescription();
            }
            if (original.getMaxLength() != null) {
                property.setMaxLength(original.getMaxLength());
            }
            if (original.getMinLength() != null) {
                property.setMinLength(original.getMinLength());
            }
            if (original.getMaxItems() != null) {
                property.setMaxItems(original.getMaxItems());
            }
            if (original.getMinItems() != null) {
                property.setMinItems(original.getMinItems());
            }
            if (original.getMaximum() != null) {
                property.setMaximum(String.valueOf(original.getMaximum().doubleValue()));
            }
            if (original.getMinimum() != null) {
                property.setMinimum(String.valueOf(original.getMinimum().doubleValue()));
            }
            if (original.getTitle() != null) {
                property.setTitle(original.getTitle());
            }
        }
        property.defaultValue = this.toDefaultValue(property, p);
        property.defaultValueWithParam = this.toDefaultValueWithParam(name, p);
        this.LOGGER.debug("debugging from property return: {}", (Object)property);
        this.schemaCodegenPropertyCache.put(ns, property);
        return property;
    }

    protected void updatePropertyForArray(CodegenProperty property, CodegenProperty innerProperty) {
        if (innerProperty == null) {
            if (this.LOGGER.isWarnEnabled()) {
                this.LOGGER.warn("skipping invalid array property {}", (Object)Json.pretty((Object)property));
            }
            return;
        }
        property.dataFormat = innerProperty.dataFormat;
        if (!this.languageSpecificPrimitives.contains(innerProperty.baseType)) {
            property.complexType = innerProperty.baseType;
        } else {
            property.isPrimitiveType = true;
        }
        property.items = innerProperty;
        property.mostInnerItems = this.getMostInnerItems(innerProperty);
        if (this.isPropertyInnerMostEnum(property).booleanValue()) {
            property.isEnum = true;
            property.isInnerEnum = true;
            this.updateDataTypeWithEnumForArray(property);
            property.allowableValues = this.getInnerEnumAllowableValues(property);
        }
    }

    protected void updatePropertyForMap(CodegenProperty property, CodegenProperty innerProperty) {
        if (innerProperty == null) {
            if (this.LOGGER.isWarnEnabled()) {
                this.LOGGER.warn("skipping invalid map property {}", (Object)Json.pretty((Object)property));
            }
            return;
        }
        if (!this.languageSpecificPrimitives.contains(innerProperty.baseType)) {
            property.complexType = innerProperty.baseType;
        } else {
            property.isPrimitiveType = true;
        }
        property.items = innerProperty;
        property.mostInnerItems = this.getMostInnerItems(innerProperty);
        property.dataFormat = innerProperty.dataFormat;
        if (this.isPropertyInnerMostEnum(property).booleanValue()) {
            property.isEnum = true;
            property.isInnerEnum = true;
            this.updateDataTypeWithEnumForMap(property);
            property.allowableValues = this.getInnerEnumAllowableValues(property);
        }
    }

    protected Boolean isPropertyInnerMostEnum(CodegenProperty property) {
        CodegenProperty currentProperty = this.getMostInnerItems(property);
        return currentProperty != null && currentProperty.isEnum;
    }

    protected CodegenProperty getMostInnerItems(CodegenProperty property) {
        CodegenProperty currentProperty = property;
        while (currentProperty != null && (Boolean.TRUE.equals(currentProperty.isMap) || Boolean.TRUE.equals(currentProperty.isArray)) && currentProperty.items != null) {
            currentProperty = currentProperty.items;
        }
        return currentProperty;
    }

    protected Map<String, Object> getInnerEnumAllowableValues(CodegenProperty property) {
        CodegenProperty currentProperty = this.getMostInnerItems(property);
        return currentProperty == null ? new HashMap() : currentProperty.allowableValues;
    }

    protected void updateDataTypeWithEnumForArray(CodegenProperty property) {
        CodegenProperty baseItem = property.items;
        while (baseItem != null && (Boolean.TRUE.equals(baseItem.isMap) || Boolean.TRUE.equals(baseItem.isArray))) {
            baseItem = baseItem.items;
        }
        if (baseItem != null) {
            property.datatypeWithEnum = property.datatypeWithEnum.replace(baseItem.baseType, this.toEnumName(baseItem));
            property.enumName = this.toEnumName(property);
            if (property.defaultValue != null) {
                property.defaultValue = property.defaultValue.replace(baseItem.baseType, this.toEnumName(baseItem));
            }
            this.updateCodegenPropertyEnum(property);
        }
    }

    protected void updateDataTypeWithEnumForMap(CodegenProperty property) {
        CodegenProperty baseItem = property.items;
        while (baseItem != null && (Boolean.TRUE.equals(baseItem.isMap) || Boolean.TRUE.equals(baseItem.isArray))) {
            baseItem = baseItem.items;
        }
        if (baseItem != null) {
            property.datatypeWithEnum = property.datatypeWithEnum.replace(", " + baseItem.baseType, ", " + this.toEnumName(baseItem));
            property.enumName = this.toEnumName(property);
            if (property.defaultValue != null) {
                property.defaultValue = property.defaultValue.replace(", " + property.items.baseType, ", " + this.toEnumName(property.items));
            }
            this.updateCodegenPropertyEnum(property);
        }
    }

    protected void setNonArrayMapProperty(CodegenProperty property, String type) {
        property.isContainer = false;
        if (this.languageSpecificPrimitives().contains(type)) {
            property.isPrimitiveType = true;
        } else {
            property.complexType = property.baseType;
            property.isModel = true;
        }
    }

    protected ApiResponse findMethodResponse(ApiResponses responses) {
        String code = null;
        for (String responseCode : responses.keySet()) {
            if (!responseCode.startsWith("2") && !responseCode.equals("default") || code != null && code.compareTo(responseCode) <= 0) continue;
            code = responseCode;
        }
        if (code == null) {
            return null;
        }
        return (ApiResponse)responses.get(code);
    }

    protected void handleMethodResponse(Operation operation, Map<String, Schema> schemas, CodegenOperation op, ApiResponse methodResponse) {
        this.handleMethodResponse(operation, schemas, op, methodResponse, Collections.emptyMap());
    }

    protected void handleMethodResponse(Operation operation, Map<String, Schema> schemas, CodegenOperation op, ApiResponse methodResponse, Map<String, String> schemaMappings) {
        Schema responseSchema = this.unaliasSchema(ModelUtils.getSchemaFromResponse(this.openAPI, methodResponse));
        if (responseSchema != null) {
            CodegenProperty innerProperty;
            CodegenProperty cm = this.fromProperty("response", responseSchema, false);
            if (ModelUtils.isArraySchema(responseSchema)) {
                innerProperty = this.fromProperty("response", ModelUtils.getSchemaItems(responseSchema), false);
                op.returnBaseType = innerProperty.baseType;
            } else if (ModelUtils.isMapSchema(responseSchema)) {
                innerProperty = this.fromProperty("response", ModelUtils.getAdditionalProperties(responseSchema), false);
                op.returnBaseType = innerProperty.baseType;
            } else {
                op.returnBaseType = cm.complexType != null ? cm.complexType : cm.baseType;
            }
            op.defaultResponse = this.toDefaultValue(responseSchema);
            op.returnType = cm.dataType;
            op.returnFormat = cm.dataFormat;
            op.hasReference = schemas != null && schemas.containsKey(op.returnBaseType);
            Schema schema = null;
            if (schemas != null) {
                schema = schemas.get(op.returnBaseType);
            }
            if (schema != null) {
                CodegenModel cmod = this.fromModel(op.returnBaseType, schema);
                op.discriminator = cmod.discriminator;
            }
            if (cm.isContainer) {
                op.returnContainer = cm.containerType;
                if ("map".equals(cm.containerType)) {
                    op.isMap = true;
                } else if ("list".equalsIgnoreCase(cm.containerType)) {
                    op.isArray = true;
                } else if ("array".equalsIgnoreCase(cm.containerType)) {
                    op.isArray = true;
                } else if ("set".equalsIgnoreCase(cm.containerType)) {
                    op.isArray = true;
                }
            } else {
                op.returnSimpleType = true;
            }
            if (this.languageSpecificPrimitives().contains(op.returnBaseType) || op.returnBaseType == null) {
                op.returnTypeIsPrimitive = true;
            }
            op.returnProperty = cm;
        }
        this.addHeaders(methodResponse, op.responseHeaders);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        String[] components;
        this.LOGGER.debug("fromOperation => operation: {}", (Object)operation);
        if (operation == null) {
            throw new RuntimeException("operation cannot be null in fromOperation");
        }
        Map<String, Schema> schemas = ModelUtils.getSchemas(this.openAPI);
        CodegenOperation op = (CodegenOperation)CodegenModelFactory.newInstance(CodegenModelType.OPERATION);
        HashSet<String> imports = new HashSet<String>();
        if (operation.getExtensions() != null && !operation.getExtensions().isEmpty()) {
            op.vendorExtensions.putAll(operation.getExtensions());
            Object isCallbackRequest = op.vendorExtensions.remove("x-callback-request");
            op.isCallbackRequest = Boolean.TRUE.equals(isCallbackRequest);
        }
        if (operation.getServers() != null && !operation.getServers().isEmpty()) {
            op.servers = this.fromServers(operation.getServers());
        } else if (servers != null && !servers.isEmpty()) {
            op.servers = this.fromServers(servers);
        }
        op.operationIdOriginal = operation.getOperationId();
        String operationId = this.getOrGenerateOperationId(operation, path, httpMethod);
        if (this.removeOperationIdPrefix && (components = operationId.split("[" + this.removeOperationIdPrefixDelimiter + "]")).length > 1) {
            int component_number = this.removeOperationIdPrefixCount == -1 ? components.length - 1 : this.removeOperationIdPrefixCount;
            component_number = Math.min(component_number, components.length - 1);
            operationId = String.join((CharSequence)this.removeOperationIdPrefixDelimiter, Arrays.copyOfRange(components, component_number, components.length));
        }
        operationId = this.removeNonNameElementToCamelCase(operationId);
        op.path = this.isStrictSpecBehavior() && !path.startsWith("/") ? "/" + path : path;
        op.operationId = this.operationIdNameMapping.containsKey(operationId) ? this.operationIdNameMapping.get(operationId) : this.toOperationId(operationId);
        op.summary = this.escapeText(operation.getSummary());
        op.unescapedNotes = operation.getDescription();
        op.notes = this.escapeText(operation.getDescription());
        op.hasConsumes = false;
        op.hasProduces = false;
        if (operation.getDeprecated() != null) {
            op.isDeprecated = operation.getDeprecated();
        }
        this.addConsumesInfo(operation, op);
        if (operation.getResponses() != null && !operation.getResponses().isEmpty()) {
            ApiResponse methodResponse = this.findMethodResponse(operation.getResponses());
            for (Object operationGetResponsesEntry : operation.getResponses().entrySet()) {
                String key = (String)operationGetResponsesEntry.getKey();
                ApiResponse response2 = (ApiResponse)operationGetResponsesEntry.getValue();
                this.addProducesInfo(response2, op);
                CodegenResponse r = this.fromResponse(key, response2);
                Map headers = response2.getHeaders();
                if (headers != null) {
                    ArrayList<CodegenParameter> responseHeaders = new ArrayList<CodegenParameter>();
                    for (Map.Entry entry : headers.entrySet()) {
                        String headerName = (String)entry.getKey();
                        Header header = ModelUtils.getReferencedHeader(this.openAPI, (Header)entry.getValue());
                        CodegenParameter responseHeader = this.headerToCodegenParameter(header, headerName, imports, String.format(Locale.ROOT, "%sResponseParameter", r.code));
                        responseHeaders.add(responseHeader);
                    }
                    r.setResponseHeaders(responseHeaders);
                }
                String mediaTypeSchemaSuffix = String.format(Locale.ROOT, "%sResponseBody", r.code);
                r.setContent(this.getContent(response2.getContent(), imports, mediaTypeSchemaSuffix));
                if (r.baseType != null && !this.defaultIncludes.contains(r.baseType) && !this.languageSpecificPrimitives.contains(r.baseType)) {
                    imports.add(r.baseType);
                }
                if ("set".equals(r.containerType) && this.typeMapping.containsKey(r.containerType)) {
                    op.uniqueItems = true;
                    imports.add(this.typeMapping.get(r.containerType));
                }
                op.responses.add(r);
                if (Boolean.TRUE.equals(r.isBinary) && Boolean.TRUE.equals(r.is2xx) && Boolean.FALSE.equals(op.isResponseBinary)) {
                    op.isResponseBinary = Boolean.TRUE;
                }
                if (Boolean.TRUE.equals(r.isFile) && Boolean.TRUE.equals(r.is2xx) && Boolean.FALSE.equals(op.isResponseFile)) {
                    op.isResponseFile = Boolean.TRUE;
                }
                if (Boolean.TRUE.equals(r.isDefault)) {
                    op.defaultReturnType = Boolean.TRUE;
                }
                if (!Boolean.TRUE.equals(r.is4xx) && !Boolean.TRUE.equals(r.is5xx) || !Boolean.FALSE.equals(r.primitiveType) || !Boolean.FALSE.equals(r.simpleType)) continue;
                op.hasErrorResponseObject = Boolean.TRUE;
            }
            if (op.responses.stream().anyMatch(response -> response.is2xx && response.dataType != null) && op.responses.stream().anyMatch(response -> response.is2xx && response.dataType == null)) {
                op.isResponseOptional = Boolean.TRUE;
            }
            op.responses.sort((a, b) -> {
                int aScore;
                int n = a.isWildcard() ? 2 : (aScore = a.isRange() ? 1 : 0);
                int bScore = b.isWildcard() ? 2 : (b.isRange() ? 1 : 0);
                return Integer.compare(aScore, bScore);
            });
            if (methodResponse != null) {
                this.handleMethodResponse(operation, schemas, op, methodResponse, this.importMapping);
            }
        }
        if (!this.isSkipOperationExample() && operation.getResponses() != null) {
            ExampleGenerator generator = new ExampleGenerator(schemas, this.openAPI);
            ArrayList<Map<String, String>> examples = new ArrayList<Map<String, String>>();
            for (String statusCode : operation.getResponses().keySet()) {
                List<Map<String, String>> examplesForResponse;
                ApiResponse apiResponse = (ApiResponse)operation.getResponses().get((Object)statusCode);
                Schema schema = this.unaliasSchema(ModelUtils.getSchemaFromResponse(this.openAPI, apiResponse));
                if (schema == null || apiResponse.getContent() == null) continue;
                ConcurrentSkipListSet<String> producesInfo = new ConcurrentSkipListSet<String>(apiResponse.getContent().keySet());
                String exampleStatusCode = statusCode;
                if (exampleStatusCode.equals("default")) {
                    exampleStatusCode = "200";
                }
                if ((examplesForResponse = generator.generateFromResponseSchema(exampleStatusCode, schema, producesInfo)) == null) continue;
                examples.addAll(examplesForResponse);
            }
            op.examples = examples;
        }
        if (operation.getCallbacks() != null && !operation.getCallbacks().isEmpty()) {
            operation.getCallbacks().forEach((name, callback) -> {
                CodegenCallback c = this.fromCallback((String)name, (Callback)callback, servers);
                op.callbacks.add(c);
            });
        }
        List parameters = operation.getParameters();
        ArrayList<CodegenParameter> allParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> bodyParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> pathParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> queryParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> headerParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> cookieParams = new ArrayList<CodegenParameter>();
        List<Object> formParams = new ArrayList();
        ArrayList<CodegenParameter> requiredParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> optionalParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> requiredAndNotNullableParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> notNullableParams = new ArrayList<CodegenParameter>();
        CodegenParameter bodyParam = null;
        RequestBody requestBody = ModelUtils.getReferencedRequestBody(this.openAPI, operation.getRequestBody());
        if (requestBody != null) {
            String contentType = this.getContentType(requestBody);
            if (contentType != null) {
                contentType = contentType.toLowerCase(Locale.ROOT);
            }
            if (contentType != null && (!(this instanceof RustAxumServerCodegen) && contentType.startsWith("application/x-www-form-urlencoded") || contentType.startsWith("multipart"))) {
                formParams = this.fromRequestBodyToFormParameters(requestBody, imports);
                op.isMultipart = contentType.startsWith("multipart");
                for (CodegenParameter codegenParameter : formParams) {
                    this.setParameterEncodingValues(codegenParameter, (MediaType)requestBody.getContent().get((Object)contentType));
                    this.postProcessParameter(codegenParameter);
                }
                if (this.prependFormOrBodyParameters.booleanValue()) {
                    for (CodegenParameter codegenParameter : formParams) {
                        allParams.add(codegenParameter.copy());
                    }
                }
            } else {
                void var24_33;
                String string = "";
                if (op.vendorExtensions != null && op.vendorExtensions.containsKey("x-codegen-request-body-name")) {
                    String string2 = (String)op.vendorExtensions.get("x-codegen-request-body-name");
                }
                if (requestBody.getExtensions() != null && requestBody.getExtensions().containsKey("x-codegen-request-body-name")) {
                    String string3 = (String)requestBody.getExtensions().get("x-codegen-request-body-name");
                }
                if ((bodyParam = this.fromRequestBody(requestBody, imports, (String)var24_33)) != null) {
                    bodyParam.description = this.escapeText(requestBody.getDescription());
                    this.postProcessParameter(bodyParam);
                    bodyParams.add(bodyParam);
                    if (this.prependFormOrBodyParameters.booleanValue()) {
                        allParams.add(bodyParam);
                    }
                    if (schemas != null && !this.isSkipOperationExample()) {
                        op.requestBodyExamples = new ExampleGenerator(schemas, this.openAPI).generate(null, new ArrayList<String>(DefaultCodegen.getConsumesInfo(this.openAPI, operation)), bodyParam.baseType);
                    }
                }
            }
        }
        if (parameters != null) {
            for (Parameter parameter : parameters) {
                Parameter parameter2 = ModelUtils.getReferencedParameter(this.openAPI, parameter);
                CodegenParameter codegenParameter = this.fromParameter(parameter2, imports);
                codegenParameter.setContent(this.getContent(parameter2.getContent(), imports, "RequestParameter" + this.toModelName(parameter2.getName())));
                if (this.ensureUniqueParams.booleanValue()) {
                    while (!this.isParameterNameUnique(codegenParameter, allParams)) {
                        codegenParameter.paramName = DefaultCodegen.generateNextName(codegenParameter.paramName);
                    }
                }
                allParams.add(codegenParameter);
                if (parameter2 instanceof QueryParameter || "query".equalsIgnoreCase(parameter2.getIn())) {
                    queryParams.add(codegenParameter.copy());
                    continue;
                }
                if (parameter2 instanceof PathParameter || "path".equalsIgnoreCase(parameter2.getIn())) {
                    pathParams.add(codegenParameter.copy());
                    continue;
                }
                if (parameter2 instanceof HeaderParameter || "header".equalsIgnoreCase(parameter2.getIn())) {
                    headerParams.add(codegenParameter.copy());
                    continue;
                }
                if (parameter2 instanceof CookieParameter || "cookie".equalsIgnoreCase(parameter2.getIn())) {
                    cookieParams.add(codegenParameter.copy());
                    continue;
                }
                this.LOGGER.warn("Unknown parameter type {} for {}", (Object)codegenParameter.baseType, (Object)codegenParameter.baseName);
            }
        }
        if (!this.prependFormOrBodyParameters.booleanValue()) {
            for (CodegenParameter codegenParameter : formParams) {
                if (this.ensureUniqueParams.booleanValue()) {
                    while (!this.isParameterNameUnique(codegenParameter, allParams)) {
                        codegenParameter.paramName = DefaultCodegen.generateNextName(codegenParameter.paramName);
                    }
                }
                allParams.add(codegenParameter.copy());
            }
            for (CodegenParameter codegenParameter : bodyParams) {
                if (this.ensureUniqueParams.booleanValue()) {
                    while (!this.isParameterNameUnique(codegenParameter, allParams)) {
                        codegenParameter.paramName = DefaultCodegen.generateNextName(codegenParameter.paramName);
                    }
                }
                allParams.add(codegenParameter.copy());
            }
        }
        for (CodegenParameter codegenParameter : allParams) {
            if (codegenParameter.required) {
                requiredParams.add(codegenParameter.copy());
            } else {
                optionalParams.add(codegenParameter.copy());
                op.hasOptionalParams = true;
            }
            if (codegenParameter.requiredAndNotNullable()) {
                requiredAndNotNullableParams.add(codegenParameter.copy());
            }
            if (codegenParameter.isNullable) continue;
            notNullableParams.add(codegenParameter.copy());
        }
        for (String string : imports) {
            if (!this.needToImport(string)) continue;
            op.imports.add(string);
        }
        op.bodyParam = bodyParam;
        op.httpMethod = httpMethod.toUpperCase(Locale.ROOT);
        if (this.sortParamsByRequiredFlag.booleanValue()) {
            Collections.sort(allParams, new Comparator<CodegenParameter>(){

                @Override
                public int compare(CodegenParameter one, CodegenParameter another) {
                    if (one.required == another.required) {
                        return 0;
                    }
                    if (one.required) {
                        return -1;
                    }
                    return 1;
                }
            });
        }
        op.allParams = allParams;
        op.bodyParams = bodyParams;
        op.pathParams = pathParams;
        op.queryParams = queryParams;
        op.headerParams = headerParams;
        op.cookieParams = cookieParams;
        op.formParams = formParams;
        op.requiredParams = requiredParams;
        op.optionalParams = optionalParams;
        op.requiredAndNotNullableParams = requiredAndNotNullableParams;
        op.notNullableParams = notNullableParams;
        op.externalDocs = operation.getExternalDocs();
        op.nickname = op.operationId;
        if (op.allParams.size() > 0) {
            op.hasParams = true;
        }
        op.hasRequiredParams = op.requiredParams.size() > 0;
        op.isRestfulShow = op.isRestfulShow();
        op.isRestfulIndex = op.isRestfulIndex();
        op.isRestfulCreate = op.isRestfulCreate();
        op.isRestfulUpdate = op.isRestfulUpdate();
        op.isRestfulDestroy = op.isRestfulDestroy();
        op.isRestful = op.isRestful();
        return op;
    }

    public boolean isParameterNameUnique(CodegenParameter p, List<CodegenParameter> parameters) {
        for (CodegenParameter parameter : parameters) {
            if (System.identityHashCode(p) == System.identityHashCode(parameter) || !p.paramName.equals(parameter.paramName)) continue;
            return false;
        }
        return true;
    }

    public CodegenResponse fromResponse(String responseCode, ApiResponse response) {
        CodegenResponse r = (CodegenResponse)CodegenModelFactory.newInstance(CodegenModelType.RESPONSE);
        if ("default".equals(responseCode) || "defaultResponse".equals(responseCode)) {
            r.code = "0";
            r.isDefault = true;
        } else {
            r.code = responseCode;
            switch (r.code.charAt(0)) {
                case '1': {
                    r.is1xx = true;
                    break;
                }
                case '2': {
                    r.is2xx = true;
                    break;
                }
                case '3': {
                    r.is3xx = true;
                    break;
                }
                case '4': {
                    r.is4xx = true;
                    break;
                }
                case '5': {
                    r.is5xx = true;
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid response code " + responseCode);
                }
            }
        }
        Schema responseSchema = this.openAPI != null && this.openAPI.getComponents() != null ? this.unaliasSchema(ModelUtils.getSchemaFromResponse(this.openAPI, response)) : ModelUtils.getSchemaFromResponse(this.openAPI, response);
        r.schema = responseSchema;
        r.message = this.escapeText(response.getDescription());
        r.jsonSchema = Json.pretty((Object)response);
        if (response.getExtensions() != null && !response.getExtensions().isEmpty()) {
            r.vendorExtensions.putAll(response.getExtensions());
        }
        this.addHeaders(response, r.headers);
        boolean bl = r.hasHeaders = !r.headers.isEmpty();
        if (r.schema == null) {
            r.primitiveType = true;
            r.simpleType = true;
            return r;
        }
        ModelUtils.syncValidationProperties(responseSchema, r);
        if (responseSchema.getPattern() != null) {
            r.setPattern(this.toRegularExpression(responseSchema.getPattern()));
        }
        CodegenProperty cp = this.fromProperty("response", responseSchema, false);
        r.dataType = this.getTypeDeclaration(responseSchema);
        r.returnProperty = cp;
        if (!ModelUtils.isArraySchema(responseSchema)) {
            if (cp.complexType != null) {
                r.baseType = cp.items != null ? cp.items.complexType : cp.complexType;
                r.isModel = true;
            } else {
                r.baseType = cp.baseType;
            }
        }
        r.setTypeProperties(responseSchema);
        r.setComposedSchemas(this.getComposedSchemas(responseSchema));
        if (ModelUtils.isArraySchema(responseSchema)) {
            r.simpleType = false;
            r.isArray = true;
            r.containerType = cp.containerType;
            r.containerTypeMapped = this.typeMapping.get(cp.containerType);
            CodegenProperty items = this.fromProperty("response", ModelUtils.getSchemaItems(responseSchema), false);
            r.setItems(items);
            CodegenProperty innerCp = items;
            while (innerCp != null) {
                r.baseType = innerCp.baseType;
                innerCp = innerCp.items;
            }
        } else if (ModelUtils.isFileSchema(responseSchema) && !ModelUtils.isStringSchema(responseSchema)) {
            r.isFile = true;
        } else if (ModelUtils.isStringSchema(responseSchema)) {
            if (ModelUtils.isEmailSchema(responseSchema)) {
                r.isEmail = true;
            } else if (ModelUtils.isPasswordSchema(responseSchema)) {
                r.isPassword = true;
            } else if (ModelUtils.isUUIDSchema(responseSchema)) {
                r.isUuid = true;
            } else if (ModelUtils.isByteArraySchema(responseSchema)) {
                r.setIsString(false);
                r.isByteArray = true;
            } else if (ModelUtils.isBinarySchema(responseSchema)) {
                r.isFile = true;
                r.isBinary = true;
            } else if (ModelUtils.isDateSchema(responseSchema)) {
                r.setIsString(false);
                r.isDate = true;
            } else if (ModelUtils.isDateTimeSchema(responseSchema)) {
                r.setIsString(false);
                r.isDateTime = true;
            } else if (ModelUtils.isDecimalSchema(responseSchema)) {
                r.isDecimal = true;
                r.setIsString(false);
                r.isNumeric = true;
            }
        } else if (ModelUtils.isIntegerSchema(responseSchema)) {
            r.isNumeric = Boolean.TRUE;
            if (ModelUtils.isLongSchema(responseSchema)) {
                r.isLong = Boolean.TRUE;
            } else {
                r.isInteger = Boolean.TRUE;
                if (ModelUtils.isShortSchema(responseSchema)) {
                    r.setIsShort(Boolean.TRUE);
                }
            }
        } else if (ModelUtils.isNumberSchema(responseSchema)) {
            r.isNumeric = Boolean.TRUE;
            if (ModelUtils.isFloatSchema(responseSchema)) {
                r.isFloat = Boolean.TRUE;
            } else if (ModelUtils.isDoubleSchema(responseSchema)) {
                r.isDouble = Boolean.TRUE;
            }
        } else if (ModelUtils.isTypeObjectSchema(responseSchema)) {
            if (ModelUtils.isFreeFormObject(responseSchema)) {
                r.isFreeFormObject = true;
            } else {
                r.isModel = true;
            }
            r.simpleType = false;
            r.containerType = cp.containerType;
            r.containerTypeMapped = cp.containerTypeMapped;
            this.addVarsRequiredVarsAdditionalProps(responseSchema, r);
        } else if (ModelUtils.isAnyType(responseSchema)) {
            this.addVarsRequiredVarsAdditionalProps(responseSchema, r);
        } else if (!ModelUtils.isBooleanSchema(responseSchema)) {
            this.LOGGER.debug("Property type is not primitive: {}", (Object)cp.dataType);
        }
        boolean bl2 = r.primitiveType = r.baseType == null || this.languageSpecificPrimitives().contains(r.baseType);
        if (r.baseType == null) {
            r.isMap = false;
            r.isArray = false;
            r.primitiveType = true;
            r.simpleType = true;
        }
        this.postProcessResponseWithProperty(r, cp);
        return r;
    }

    public CodegenCallback fromCallback(String name, Callback callback, List<Server> servers) {
        CodegenCallback c = new CodegenCallback();
        c.name = name;
        if (callback.getExtensions() != null && !callback.getExtensions().isEmpty()) {
            c.vendorExtensions.putAll(callback.getExtensions());
        }
        callback.forEach((expression, pi) -> {
            CodegenCallback.Url u = new CodegenCallback.Url();
            u.expression = expression;
            if (pi.getExtensions() != null && !pi.getExtensions().isEmpty()) {
                u.vendorExtensions.putAll(pi.getExtensions());
            }
            Stream.of(Pair.of((Object)"get", (Object)pi.getGet()), Pair.of((Object)"head", (Object)pi.getHead()), Pair.of((Object)"put", (Object)pi.getPut()), Pair.of((Object)"post", (Object)pi.getPost()), Pair.of((Object)"delete", (Object)pi.getDelete()), Pair.of((Object)"patch", (Object)pi.getPatch()), Pair.of((Object)"options", (Object)pi.getOptions())).filter(p -> p.getValue() != null).forEach(p -> {
                String method = (String)p.getKey();
                Operation op = (Operation)p.getValue();
                if (op.getExtensions() != null && Boolean.TRUE.equals(op.getExtensions().get("x-internal"))) {
                    this.LOGGER.info("Operation ({} {} - {}) not generated since x-internal is set to true", new Object[]{method, expression, op.getOperationId()});
                } else {
                    boolean genId;
                    boolean bl = genId = op.getOperationId() == null;
                    if (genId) {
                        op.setOperationId(this.getOrGenerateOperationId(op, c.name + "_" + expression.replaceAll("\\{\\$.*}", ""), method));
                    }
                    if (op.getExtensions() == null) {
                        op.setExtensions(new HashMap());
                    }
                    op.getExtensions().put("x-callback-request", true);
                    CodegenOperation co = this.fromOperation((String)expression, method, op, servers);
                    if (genId) {
                        co.operationIdOriginal = null;
                        co.nickname = co.operationId;
                    }
                    u.requests.add(co);
                }
            });
            c.urls.add(u);
        });
        return c;
    }

    private void finishUpdatingParameter(CodegenParameter codegenParameter, Parameter parameter) {
        if (codegenParameter.paramName == null) {
            this.LOGGER.warn("Parameter name not defined properly. Default to UNKNOWN_PARAMETER_NAME");
            codegenParameter.paramName = "UNKNOWN_PARAMETER_NAME";
        }
        this.setParameterExampleValue(codegenParameter, parameter);
        this.setParameterExamples(codegenParameter, parameter);
        this.postProcessParameter(codegenParameter);
        this.LOGGER.debug("debugging codegenParameter return: {}", (Object)codegenParameter);
    }

    private void updateParameterForMap(CodegenParameter codegenParameter, Schema parameterSchema, Set<String> imports) {
        CodegenProperty codegenProperty;
        codegenParameter.items = codegenProperty = this.fromProperty("inner", ModelUtils.getAdditionalProperties(parameterSchema), false);
        codegenParameter.mostInnerItems = codegenProperty.mostInnerItems;
        codegenParameter.baseType = codegenProperty.dataType;
        codegenParameter.isContainer = true;
        codegenParameter.isMap = true;
        while (codegenProperty != null) {
            imports.add(codegenProperty.baseType);
            codegenProperty = codegenProperty.items;
        }
    }

    protected void updateParameterForString(CodegenParameter codegenParameter, Schema parameterSchema) {
        if (ModelUtils.isEmailSchema(parameterSchema)) {
            codegenParameter.isEmail = true;
        } else if (ModelUtils.isUUIDSchema(parameterSchema)) {
            codegenParameter.isUuid = true;
        } else if (ModelUtils.isByteArraySchema(parameterSchema)) {
            codegenParameter.setIsString(false);
            codegenParameter.isByteArray = true;
            codegenParameter.isPrimitiveType = true;
        } else if (ModelUtils.isBinarySchema(parameterSchema)) {
            codegenParameter.isBinary = true;
            codegenParameter.isFile = true;
            codegenParameter.isPrimitiveType = true;
        } else if (ModelUtils.isDateSchema(parameterSchema)) {
            codegenParameter.setIsString(false);
            codegenParameter.isDate = true;
            codegenParameter.isPrimitiveType = true;
        } else if (ModelUtils.isDateTimeSchema(parameterSchema)) {
            codegenParameter.setIsString(false);
            codegenParameter.isDateTime = true;
            codegenParameter.isPrimitiveType = true;
        } else if (ModelUtils.isDecimalSchema(parameterSchema)) {
            codegenParameter.setIsString(false);
            codegenParameter.isDecimal = true;
            codegenParameter.isPrimitiveType = true;
        }
        if (Boolean.TRUE.equals(codegenParameter.isString)) {
            codegenParameter.isPrimitiveType = true;
        }
    }

    public CodegenParameter fromParameter(Parameter parameter, Set<String> imports) {
        String collectionFormat;
        Schema<?> parameterSchema;
        String parameterModelName;
        CodegenParameter codegenParameter;
        block51: {
            block56: {
                block57: {
                    block54: {
                        block55: {
                            block53: {
                                block52: {
                                    block50: {
                                        codegenParameter = (CodegenParameter)CodegenModelFactory.newInstance(CodegenModelType.PARAMETER);
                                        codegenParameter.baseName = parameter.getName();
                                        codegenParameter.description = this.escapeText(parameter.getDescription());
                                        codegenParameter.unescapedDescription = parameter.getDescription();
                                        if (parameter.getRequired() != null) {
                                            codegenParameter.required = parameter.getRequired();
                                        }
                                        if (parameter.getDeprecated() != null) {
                                            codegenParameter.isDeprecated = parameter.getDeprecated();
                                        }
                                        codegenParameter.jsonSchema = Json.pretty((Object)parameter);
                                        if (GlobalSettings.getProperty("debugParser") != null) {
                                            this.LOGGER.info("working on Parameter {}", (Object)parameter.getName());
                                            this.LOGGER.info("JSON schema: {}", (Object)codegenParameter.jsonSchema);
                                        }
                                        if (parameter.getExtensions() != null && !parameter.getExtensions().isEmpty()) {
                                            codegenParameter.vendorExtensions.putAll(parameter.getExtensions());
                                        }
                                        if (parameter.getSchema() != null && parameter.getSchema().getExtensions() != null && !parameter.getSchema().getExtensions().isEmpty()) {
                                            codegenParameter.vendorExtensions.putAll(parameter.getSchema().getExtensions());
                                        }
                                        parameterModelName = null;
                                        if (parameter.getSchema() != null) {
                                            parameterSchema = this.unaliasSchema(parameter.getSchema());
                                            parameterModelName = this.getParameterDataType(parameter, (Schema)parameterSchema);
                                            CodegenProperty prop = this instanceof RustServerCodegen ? this.fromProperty(parameter.getName(), (Schema)parameterSchema, false) : (this.getUseInlineModelResolver() ? this.fromProperty(parameter.getName(), this.getReferencedSchemaWhenNotEnum((Schema)parameterSchema), false) : this.fromProperty(parameter.getName(), (Schema)parameterSchema, false));
                                            codegenParameter.setSchema(prop);
                                        } else if (parameter.getContent() != null) {
                                            Content content = parameter.getContent();
                                            if (content.size() > 1) {
                                                OnceLogger.once(this.LOGGER).warn("Multiple schemas found in content, returning only the first one");
                                            }
                                            Map.Entry entry2 = (Map.Entry)content.entrySet().iterator().next();
                                            codegenParameter.contentType = (String)entry2.getKey();
                                            parameterSchema = ((MediaType)entry2.getValue()).getSchema();
                                            parameterModelName = this.getParameterDataType(parameter, (Schema)parameterSchema);
                                        } else {
                                            parameterSchema = null;
                                        }
                                        if (parameter instanceof QueryParameter || "query".equalsIgnoreCase(parameter.getIn())) {
                                            codegenParameter.isQueryParam = true;
                                            codegenParameter.isAllowEmptyValue = parameter.getAllowEmptyValue() != null && parameter.getAllowEmptyValue() != false;
                                        } else if (parameter instanceof PathParameter || "path".equalsIgnoreCase(parameter.getIn())) {
                                            codegenParameter.required = true;
                                            codegenParameter.isPathParam = true;
                                        } else if (parameter instanceof HeaderParameter || "header".equalsIgnoreCase(parameter.getIn())) {
                                            codegenParameter.isHeaderParam = true;
                                        } else if (parameter instanceof CookieParameter || "cookie".equalsIgnoreCase(parameter.getIn())) {
                                            codegenParameter.isCookieParam = true;
                                        } else {
                                            this.LOGGER.warn("Unknown parameter type: {}", (Object)parameter.getName());
                                        }
                                        if (parameterSchema == null) {
                                            this.LOGGER.error("Not handling {} as Body Parameter at the moment", (Object)parameter);
                                            this.finishUpdatingParameter(codegenParameter, parameter);
                                            return codegenParameter;
                                        }
                                        if ((parameterSchema = this.unaliasSchema((Schema)parameterSchema)) == null) {
                                            this.LOGGER.warn("warning!  Schema not found for parameter \" {} \"", (Object)parameter.getName());
                                            this.finishUpdatingParameter(codegenParameter, parameter);
                                            return codegenParameter;
                                        }
                                        if (this.getUseInlineModelResolver() && !(this instanceof RustServerCodegen)) {
                                            parameterSchema = this.getReferencedSchemaWhenNotEnum((Schema)parameterSchema);
                                        }
                                        ModelUtils.syncValidationProperties((Schema)parameterSchema, codegenParameter);
                                        codegenParameter.setTypeProperties((Schema)parameterSchema);
                                        codegenParameter.setComposedSchemas(this.getComposedSchemas((Schema)parameterSchema));
                                        if (Boolean.TRUE.equals(parameterSchema.getNullable())) {
                                            codegenParameter.isNullable = true;
                                        }
                                        if (parameter.getStyle() != null) {
                                            codegenParameter.style = parameter.getStyle().toString();
                                            codegenParameter.isDeepObject = Parameter.StyleEnum.DEEPOBJECT == parameter.getStyle();
                                            codegenParameter.isMatrix = Parameter.StyleEnum.MATRIX == parameter.getStyle();
                                        }
                                        codegenParameter.isExplode = parameter.getExplode() != null && parameter.getExplode() != false;
                                        collectionFormat = null;
                                        if (!ModelUtils.isFileSchema((Schema)parameterSchema) || ModelUtils.isStringSchema((Schema)parameterSchema)) break block50;
                                        codegenParameter.isFile = true;
                                        break block51;
                                    }
                                    if (!ModelUtils.isStringSchema((Schema)parameterSchema)) break block52;
                                    this.updateParameterForString(codegenParameter, (Schema)parameterSchema);
                                    break block51;
                                }
                                if (!ModelUtils.isBooleanSchema((Schema)parameterSchema)) break block53;
                                codegenParameter.isPrimitiveType = true;
                                break block51;
                            }
                            if (!ModelUtils.isNumberSchema((Schema)parameterSchema)) break block54;
                            codegenParameter.isPrimitiveType = true;
                            if (!ModelUtils.isFloatSchema((Schema)parameterSchema)) break block55;
                            codegenParameter.isFloat = true;
                            break block51;
                        }
                        if (!ModelUtils.isDoubleSchema((Schema)parameterSchema)) break block51;
                        codegenParameter.isDouble = true;
                        break block51;
                    }
                    if (!ModelUtils.isIntegerSchema((Schema)parameterSchema)) break block56;
                    codegenParameter.isPrimitiveType = true;
                    if (!ModelUtils.isLongSchema((Schema)parameterSchema)) break block57;
                    codegenParameter.isLong = true;
                    break block51;
                }
                codegenParameter.isInteger = true;
                if (!ModelUtils.isShortSchema((Schema)parameterSchema)) break block51;
                codegenParameter.isShort = true;
                break block51;
            }
            if (ModelUtils.isTypeObjectSchema((Schema)parameterSchema)) {
                if (ModelUtils.isMapSchema((Schema)parameterSchema)) {
                    this.updateParameterForMap(codegenParameter, (Schema)parameterSchema, imports);
                }
                if (ModelUtils.isFreeFormObject((Schema)parameterSchema)) {
                    codegenParameter.isFreeFormObject = true;
                }
                this.addVarsRequiredVarsAdditionalProps((Schema)parameterSchema, codegenParameter);
            } else if (!ModelUtils.isNullType((Schema)parameterSchema)) {
                if (ModelUtils.isAnyType((Schema)parameterSchema)) {
                    if (ModelUtils.isMapSchema((Schema)parameterSchema)) {
                        this.updateParameterForMap(codegenParameter, (Schema)parameterSchema, imports);
                    }
                    this.addVarsRequiredVarsAdditionalProps((Schema)parameterSchema, codegenParameter);
                } else if (ModelUtils.isArraySchema((Schema)parameterSchema)) {
                    CodegenProperty itemsProperty;
                    Schema<?> inner = ModelUtils.getSchemaItems((Schema)parameterSchema);
                    collectionFormat = this.getCollectionFormat(parameter);
                    collectionFormat = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)collectionFormat) ? "csv" : collectionFormat;
                    codegenParameter.items = itemsProperty = this.fromProperty("inner", inner, false);
                    codegenParameter.mostInnerItems = itemsProperty.mostInnerItems;
                    codegenParameter.baseType = itemsProperty.dataType;
                    codegenParameter.isContainer = true;
                    while (itemsProperty != null) {
                        imports.add(itemsProperty.baseType);
                        itemsProperty = itemsProperty.items;
                    }
                }
            }
        }
        CodegenProperty codegenProperty = this.fromProperty(parameter.getName(), (Schema)parameterSchema, false);
        if (Boolean.TRUE.equals(codegenProperty.isModel)) {
            codegenParameter.isModel = true;
        }
        if (parameterModelName != null) {
            codegenParameter.dataType = parameterModelName;
            if (ModelUtils.isObjectSchema((Schema)parameterSchema) || ModelUtils.isComposedSchema((Schema)parameterSchema)) {
                codegenProperty.complexType = codegenParameter.dataType;
            }
        } else {
            codegenParameter.dataType = codegenProperty.dataType;
        }
        if (ModelUtils.isArraySchema((Schema)parameterSchema)) {
            imports.add(codegenProperty.baseType);
        }
        codegenParameter.dataFormat = codegenProperty.dataFormat;
        if (parameter.getRequired() != null) {
            codegenParameter.required = parameter.getRequired();
        }
        codegenParameter.containerType = codegenProperty.containerType;
        codegenParameter.containerTypeMapped = codegenProperty.containerTypeMapped;
        this.updateCodegenPropertyEnum(codegenProperty);
        codegenParameter.isEnum = codegenProperty.isEnum;
        codegenParameter.isEnumRef = codegenProperty.isEnumRef;
        codegenParameter._enum = codegenProperty._enum;
        codegenParameter.allowableValues = codegenProperty.allowableValues;
        if (codegenProperty.isEnum) {
            codegenParameter.datatypeWithEnum = codegenProperty.datatypeWithEnum;
            codegenParameter.enumName = codegenProperty.enumName;
            if (codegenProperty.defaultValue != null) {
                codegenParameter.enumDefaultValue = codegenProperty.defaultValue.replace(codegenProperty.enumName + ".", "");
            }
        }
        if (codegenProperty.items != null && codegenProperty.items.isEnum) {
            codegenParameter.datatypeWithEnum = codegenProperty.datatypeWithEnum;
            codegenParameter.enumName = codegenProperty.enumName;
            codegenParameter.items = codegenProperty.items;
            codegenParameter.mostInnerItems = codegenProperty.mostInnerItems;
        }
        codegenParameter.collectionFormat = collectionFormat;
        if ("multi".equals(collectionFormat)) {
            codegenParameter.isCollectionFormatMulti = true;
        }
        codegenParameter.paramName = this.toParamName(parameter.getName());
        codegenParameter.nameInCamelCase = StringUtils.camelize(codegenParameter.paramName, CamelizeOption.LOWERCASE_FIRST_LETTER);
        codegenParameter.nameInPascalCase = StringUtils.camelize(codegenParameter.paramName);
        codegenParameter.nameInSnakeCase = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, codegenParameter.nameInPascalCase);
        codegenParameter.nameInLowerCase = codegenParameter.paramName.toLowerCase(Locale.ROOT);
        if (codegenProperty.complexType != null) {
            imports.add(codegenProperty.complexType);
        }
        codegenParameter.pattern = this.toRegularExpression(parameterSchema.getPattern());
        if (codegenParameter.isQueryParam && codegenParameter.isDeepObject && this.loadDeepObjectIntoItems) {
            Schema<?> schema = parameterSchema;
            if (schema.get$ref() != null) {
                schema = ModelUtils.getReferencedSchema(this.openAPI, (Schema)schema);
            }
            codegenParameter.items = this.fromProperty(codegenParameter.paramName, schema, false);
            if (schema != null) {
                Map properties = schema.getProperties();
                ArrayList requiredVarNames = new ArrayList();
                if (schema.getRequired() != null) {
                    requiredVarNames.addAll(schema.getRequired());
                }
                if (properties != null) {
                    codegenParameter.items.vars = properties.entrySet().stream().map(entry -> {
                        CodegenProperty property = this.fromProperty((String)entry.getKey(), (Schema)entry.getValue(), requiredVarNames.contains(entry.getKey()));
                        return property;
                    }).collect(Collectors.toList());
                }
            } else {
                this.LOGGER.warn("No object schema found for deepObject parameter{} deepObject won't have specific properties", (Object)codegenParameter);
            }
        }
        codegenParameter.defaultValue = this.toDefaultParameterValue(codegenProperty, parameterSchema);
        this.finishUpdatingParameter(codegenParameter, parameter);
        return codegenParameter;
    }

    private Schema getReferencedSchemaWhenNotEnum(Schema parameterSchema) {
        Schema referencedSchema = ModelUtils.getReferencedSchema(this.openAPI, parameterSchema);
        if (referencedSchema.getEnum() != null && !referencedSchema.getEnum().isEmpty()) {
            referencedSchema = parameterSchema;
        }
        return referencedSchema;
    }

    protected String getParameterDataType(Parameter parameter, Schema schema) {
        Schema unaliasSchema = this.unaliasSchema(schema);
        if (unaliasSchema.get$ref() != null) {
            return this.toModelName(ModelUtils.getSimpleRef(unaliasSchema.get$ref()));
        }
        return null;
    }

    public boolean isDataTypeBinary(String dataType) {
        if (dataType != null) {
            return dataType.toLowerCase(Locale.ROOT).startsWith("byte");
        }
        return false;
    }

    public boolean isDataTypeFile(String dataType) {
        if (dataType != null) {
            return dataType.toLowerCase(Locale.ROOT).equals("file");
        }
        return false;
    }

    @Override
    public List<CodegenSecurity> fromSecurity(Map<String, SecurityScheme> securitySchemeMap) {
        if (securitySchemeMap == null) {
            return Collections.emptyList();
        }
        ArrayList<CodegenSecurity> codegenSecurities = new ArrayList<CodegenSecurity>(securitySchemeMap.size());
        for (String key : securitySchemeMap.keySet()) {
            CodegenSecurity cs;
            SecurityScheme securityScheme = securitySchemeMap.get(key);
            if (SecurityScheme.Type.APIKEY.equals((Object)securityScheme.getType())) {
                cs = this.defaultCodegenSecurity(key, securityScheme);
                cs.isOAuth = cs.isOpenId = Boolean.valueOf(false);
                cs.isBasic = cs.isOpenId;
                cs.isApiKey = true;
                cs.keyParamName = securityScheme.getName();
                cs.isKeyInHeader = securityScheme.getIn() == SecurityScheme.In.HEADER;
                cs.isKeyInQuery = securityScheme.getIn() == SecurityScheme.In.QUERY;
                cs.isKeyInCookie = securityScheme.getIn() == SecurityScheme.In.COOKIE;
                codegenSecurities.add(cs);
                continue;
            }
            if (SecurityScheme.Type.HTTP.equals((Object)securityScheme.getType())) {
                cs = this.defaultCodegenSecurity(key, securityScheme);
                cs.isOAuth = cs.isOpenId = Boolean.valueOf(false);
                cs.isApiKey = cs.isOpenId;
                cs.isKeyInCookie = cs.isOpenId;
                cs.isKeyInQuery = cs.isOpenId;
                cs.isKeyInHeader = cs.isOpenId;
                cs.isBasic = true;
                if ("basic".equalsIgnoreCase(securityScheme.getScheme())) {
                    cs.isBasicBasic = true;
                } else if ("bearer".equalsIgnoreCase(securityScheme.getScheme())) {
                    cs.isBasicBearer = true;
                    cs.bearerFormat = securityScheme.getBearerFormat();
                } else if ("signature".equalsIgnoreCase(securityScheme.getScheme())) {
                    cs.isHttpSignature = true;
                    OnceLogger.once(this.LOGGER).warn("Security scheme 'HTTP signature' is a draft IETF RFC and subject to change.");
                } else {
                    OnceLogger.once(this.LOGGER).warn("Unknown scheme `{}` found in the HTTP security definition.", (Object)securityScheme.getScheme());
                }
                codegenSecurities.add(cs);
                continue;
            }
            if (SecurityScheme.Type.OAUTH2.equals((Object)securityScheme.getType())) {
                CodegenSecurity cs2;
                OAuthFlows flows = securityScheme.getFlows();
                boolean isFlowEmpty = true;
                if (securityScheme.getFlows() == null) {
                    throw new RuntimeException("missing oauth flow in " + key);
                }
                if (flows.getPassword() != null) {
                    cs2 = this.defaultOauthCodegenSecurity(key, securityScheme);
                    this.setOauth2Info(cs2, flows.getPassword());
                    cs2.isPassword = true;
                    cs2.flow = "password";
                    codegenSecurities.add(cs2);
                    isFlowEmpty = false;
                }
                if (flows.getImplicit() != null) {
                    cs2 = this.defaultOauthCodegenSecurity(key, securityScheme);
                    this.setOauth2Info(cs2, flows.getImplicit());
                    cs2.isImplicit = true;
                    cs2.flow = "implicit";
                    codegenSecurities.add(cs2);
                    isFlowEmpty = false;
                }
                if (flows.getClientCredentials() != null) {
                    cs2 = this.defaultOauthCodegenSecurity(key, securityScheme);
                    this.setOauth2Info(cs2, flows.getClientCredentials());
                    cs2.isApplication = true;
                    cs2.flow = "application";
                    codegenSecurities.add(cs2);
                    isFlowEmpty = false;
                }
                if (flows.getAuthorizationCode() != null) {
                    cs2 = this.defaultOauthCodegenSecurity(key, securityScheme);
                    this.setOauth2Info(cs2, flows.getAuthorizationCode());
                    cs2.isCode = true;
                    cs2.flow = "accessCode";
                    codegenSecurities.add(cs2);
                    isFlowEmpty = false;
                }
                if (!isFlowEmpty) continue;
                OnceLogger.once(this.LOGGER).error("Invalid flow definition defined in the security scheme: {}", (Object)flows);
                continue;
            }
            if (SecurityScheme.Type.OPENIDCONNECT.equals((Object)securityScheme.getType())) {
                cs = this.defaultCodegenSecurity(key, securityScheme);
                cs.isApiKey = cs.isBasic = Boolean.valueOf(false);
                cs.isKeyInCookie = cs.isBasic;
                cs.isKeyInQuery = cs.isBasic;
                cs.isKeyInHeader = cs.isBasic;
                cs.isOpenId = true;
                cs.openIdConnectUrl = securityScheme.getOpenIdConnectUrl();
                if (securityScheme.getFlows() != null) {
                    this.setOpenIdConnectInfo(cs, securityScheme.getFlows().getAuthorizationCode());
                }
                codegenSecurities.add(cs);
                continue;
            }
            OnceLogger.once(this.LOGGER).error("Unknown type `{}` found in the security definition `{}`.", (Object)securityScheme.getType(), (Object)securityScheme.getName());
        }
        return codegenSecurities;
    }

    private CodegenSecurity defaultCodegenSecurity(String key, SecurityScheme securityScheme) {
        CodegenSecurity cs = (CodegenSecurity)CodegenModelFactory.newInstance(CodegenModelType.SECURITY);
        cs.name = key;
        cs.description = securityScheme.getDescription();
        cs.type = securityScheme.getType().toString();
        cs.isImplicit = cs.isOpenId = Boolean.valueOf(false);
        cs.isApplication = cs.isOpenId;
        cs.isPassword = cs.isOpenId;
        cs.isCode = cs.isOpenId;
        cs.isHttpSignature = false;
        cs.isBasicBasic = cs.isBasicBearer = Boolean.valueOf(false);
        cs.scheme = securityScheme.getScheme();
        if (securityScheme.getExtensions() != null) {
            cs.vendorExtensions.putAll(securityScheme.getExtensions());
        }
        return cs;
    }

    private CodegenSecurity defaultOauthCodegenSecurity(String key, SecurityScheme securityScheme) {
        CodegenSecurity cs = this.defaultCodegenSecurity(key, securityScheme);
        cs.isBasic = cs.isOpenId = Boolean.valueOf(false);
        cs.isApiKey = cs.isOpenId;
        cs.isKeyInCookie = cs.isOpenId;
        cs.isKeyInQuery = cs.isOpenId;
        cs.isKeyInHeader = cs.isOpenId;
        cs.isOAuth = true;
        return cs;
    }

    protected void setReservedWordsLowerCase(List<String> words) {
        this.reservedWords = new HashSet<String>();
        for (String word : words) {
            this.reservedWords.add(word.toLowerCase(Locale.ROOT));
        }
    }

    protected boolean isReservedWord(String word) {
        return word != null && this.reservedWords.contains(word.toLowerCase(Locale.ROOT));
    }

    /*
     * WARNING - void declaration
     */
    protected String getOrGenerateOperationId(Operation operation, String path, String httpMethod) {
        String operationId = operation.getOperationId();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)operationId)) {
            String tmpPath = path;
            tmpPath = tmpPath.replaceAll("\\{", "");
            tmpPath = tmpPath.replaceAll("\\}", "");
            String[] parts = (tmpPath + "/" + httpMethod).split("/");
            StringBuilder builder = new StringBuilder();
            if ("/".equals(tmpPath)) {
                builder.append("root");
            }
            for (String string : parts) {
                void var11_15;
                if (string.length() <= 0) continue;
                if (builder.toString().length() == 0) {
                    String string2 = Character.toLowerCase(string.charAt(0)) + string.substring(1);
                } else {
                    String string3 = StringUtils.camelize(string);
                }
                builder.append((String)var11_15);
            }
            operationId = this.sanitizeName(builder.toString());
            this.LOGGER.warn("Empty operationId found for path: {} {}. Renamed to auto-generated operationId: {}", new Object[]{httpMethod, path, operationId});
        }
        return operationId;
    }

    protected boolean needToImport(String type) {
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)type) && !this.defaultIncludes.contains(type) && !this.languageSpecificPrimitives.contains(type);
    }

    protected List<Map<String, Object>> toExamples(Map<String, Object> examples) {
        if (examples == null) {
            return null;
        }
        ArrayList<Map<String, Object>> output = new ArrayList<Map<String, Object>>(examples.size());
        for (Map.Entry<String, Object> entry : examples.entrySet()) {
            HashMap<String, Object> kv = new HashMap<String, Object>();
            kv.put("contentType", entry.getKey());
            kv.put("example", entry.getValue());
            output.add(kv);
        }
        return output;
    }

    protected void addHeaders(ApiResponse response, List<CodegenProperty> properties) {
        if (response.getHeaders() != null) {
            for (Map.Entry headerEntry : response.getHeaders().entrySet()) {
                Schema schema;
                String description = ((Header)headerEntry.getValue()).getDescription();
                Header header = ModelUtils.getReferencedHeader(this.openAPI, (Header)headerEntry.getValue());
                if (header.getSchema() == null) {
                    this.LOGGER.warn("No schema defined for Header '{}', using a String schema", headerEntry.getKey());
                    schema = new StringSchema();
                } else {
                    schema = header.getSchema();
                }
                CodegenProperty cp = this.fromProperty((String)headerEntry.getKey(), schema, false);
                cp.setDescription(this.escapeText(description));
                cp.setUnescapedDescription(description);
                if (header.getRequired() != null) {
                    cp.setRequired(header.getRequired());
                } else {
                    cp.setRequired(false);
                }
                properties.add(cp);
            }
        }
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        List<CodegenOperation> opList = operations.get(tag);
        if (opList == null) {
            opList = new ArrayList<CodegenOperation>();
            operations.put(tag, opList);
        }
        Object uniqueName = co.operationId;
        int counter = 0;
        for (CodegenOperation op : opList) {
            if (!((String)uniqueName).equals(op.operationId)) continue;
            uniqueName = co.operationId + "_" + counter;
            ++counter;
        }
        if (!co.operationId.equals(uniqueName)) {
            this.LOGGER.warn("generated unique operationId `{}`", uniqueName);
        }
        co.operationId = uniqueName;
        co.operationIdLowerCase = ((String)uniqueName).toLowerCase(Locale.ROOT);
        co.operationIdCamelCase = StringUtils.camelize((String)uniqueName);
        co.operationIdSnakeCase = StringUtils.underscore((String)uniqueName);
        opList.add(co);
        co.baseName = tag;
    }

    protected void addParentFromContainer(CodegenModel model, Schema schema) {
        model.parent = this.toInstantiationType(schema);
    }

    protected void addParentContainer(CodegenModel model, String name, Schema schema) {
        CodegenProperty property = this.fromProperty(name, schema, false);
        this.addImport(model, property.complexType);
        this.addParentFromContainer(model, schema);
        String instantiationType = this.instantiationTypes.get(property.containerType);
        if (instantiationType != null) {
            this.addImport(model, instantiationType);
        }
        if (property.containerTypeMapped != null) {
            this.addImport(model, property.containerTypeMapped);
        }
    }

    private static String generateNextName(String name) {
        Pattern pattern = Pattern.compile("\\d+\\z");
        Matcher matcher = pattern.matcher(name);
        if (matcher.find()) {
            String numStr = matcher.group();
            int num = Integer.parseInt(numStr) + 1;
            return name.substring(0, name.length() - numStr.length()) + num;
        }
        return name + "2";
    }

    protected void addImports(CodegenModel m, IJsonSchemaValidationProperties type) {
        this.addImports(m.imports, type);
    }

    protected void addImports(Set<String> importsToBeAddedTo, IJsonSchemaValidationProperties type) {
        this.addImports(importsToBeAddedTo, type.getImports(this.importContainerType, this.importBaseType, this.generatorMetadata.getFeatureSet()));
    }

    protected void addImports(Set<String> importsToBeAddedTo, Set<String> importsToAdd) {
        importsToAdd.stream().forEach(i -> this.addImport(importsToBeAddedTo, (String)i));
    }

    protected void addImport(CodegenModel m, String type) {
        this.addImport(m.imports, type);
    }

    protected void addImport(Set<String> importsToBeAddedTo, String type) {
        if (this.shouldAddImport(type)) {
            importsToBeAddedTo.add(type);
        }
    }

    protected void addImport(Schema composed, Schema childSchema, CodegenModel model, String modelName) {
        if (composed == null || childSchema == null) {
            return;
        }
        if (composed.getAllOf() == null || childSchema.getDiscriminator() != null) {
            this.addImport(model, modelName);
        } else {
            this.LOGGER.debug("Skipped import for allOf composition schema {}", (Object)modelName);
        }
    }

    protected boolean shouldAddImport(String type) {
        return type != null && this.needToImport(type);
    }

    protected Map<String, Schema> unaliasPropertySchema(Map<String, Schema> properties) {
        if (properties != null) {
            for (String key : properties.keySet()) {
                properties.put(key, this.unaliasSchema(properties.get(key)));
            }
        }
        return properties;
    }

    protected void addVars(CodegenModel m, Map<String, Schema> properties, List<String> required, Map<String, Schema> allProperties, List<String> allRequired) {
        m.hasRequired = false;
        m.hasReadOnly = false;
        if (properties != null && !properties.isEmpty()) {
            m.hasVars = true;
            TreeSet<String> mandatory = required == null ? Collections.emptySet() : new TreeSet<String>(required);
            this.addVars(m, m.vars, properties, mandatory);
            m.mandatory = mandatory;
            m.allMandatory = m.mandatory;
        } else {
            m.emptyVars = true;
            m.hasVars = false;
            m.hasEnums = false;
        }
        if (allProperties != null) {
            TreeSet<String> allMandatory = allRequired == null ? Collections.emptySet() : new TreeSet<String>(allRequired);
            this.addVars(m, m.allVars, allProperties, allMandatory);
            m.allMandatory = allMandatory;
        } else {
            m.allVars = m.vars;
            m.allMandatory = m.mandatory;
        }
        ConcurrentSkipListSet<String> renamedMandatory = new ConcurrentSkipListSet<String>();
        Iterator<String> mandatoryIterator = m.mandatory.iterator();
        while (mandatoryIterator.hasNext()) {
            renamedMandatory.add(this.toVarName(mandatoryIterator.next()));
        }
        m.mandatory = renamedMandatory;
        ConcurrentSkipListSet<String> renamedAllMandatory = new ConcurrentSkipListSet<String>();
        Iterator<String> allMandatoryIterator = m.allMandatory.iterator();
        while (allMandatoryIterator.hasNext()) {
            renamedAllMandatory.add(this.toVarName(allMandatoryIterator.next()));
        }
        m.allMandatory = renamedAllMandatory;
    }

    protected void addVars(IJsonSchemaValidationProperties m, List<CodegenProperty> vars, Map<String, Schema> properties, Set<String> mandatory) {
        if (properties == null) {
            return;
        }
        HashMap<String, CodegenProperty> varsMap = new HashMap<String, CodegenProperty>();
        CodegenModel cm = null;
        if (m instanceof CodegenModel) {
            cm = (CodegenModel)m;
            if (cm.allVars == vars) {
                for (CodegenProperty var : cm.vars) {
                    varsMap.put(var.baseName, var);
                    var.isOverridden = false;
                }
            }
        }
        for (Map.Entry<String, Schema> entry : properties.entrySet()) {
            CodegenProperty cp;
            String key = entry.getKey();
            Schema prop = entry.getValue();
            if (prop == null) {
                this.LOGGER.warn("Please report the issue. There shouldn't be null property for {}", (Object)key);
                continue;
            }
            if (cm != null && cm.allVars == vars && varsMap.keySet().contains(key)) {
                this.LOGGER.debug("The property `{}` already defined in the child model. Using the one from child.", (Object)key);
                cp = (CodegenProperty)varsMap.get(key);
            } else {
                cp = this.fromProperty(key, prop, mandatory.contains(key));
            }
            if (cm != null && cm.allVars == vars && cp.isOverridden == null) {
                cp.isOverridden = true;
            }
            vars.add(cp);
            m.setHasVars(true);
            if (cp.required) {
                m.setHasRequired(true);
                m.getRequiredVars().add(cp);
            }
            if (cm == null) continue;
            boolean bl = cm.hasOptional = cm.hasOptional || !cp.required;
            if (cp.getIsEnumOrRef()) {
                cm.hasEnums = true;
            }
            if (!Boolean.TRUE.equals(cp.isReadOnly)) {
                cm.hasOnlyReadOnly = false;
            }
            this.addImportsForPropertyType(cm, cp);
            if (Boolean.FALSE.equals(cp.required)) {
                cm.optionalVars.add(cp);
            }
            if (Boolean.TRUE.equals(cp.isReadOnly)) {
                cm.readOnlyVars.add(cp);
                cm.hasReadOnly = true;
            } else {
                cm.readWriteVars.add(cp);
            }
            if (!Boolean.FALSE.equals(cp.isNullable)) continue;
            cm.nonNullableVars.add(cp);
        }
    }

    protected void addImportsForPropertyType(CodegenModel model, CodegenProperty property) {
        if (property.isArray) {
            if (Boolean.TRUE.equals(property.getUniqueItemsBoolean())) {
                this.addImport(model.imports, this.typeMapping.get("set"));
            } else {
                this.addImport(model.imports, this.typeMapping.get("array"));
            }
        }
        if (property.isMap) {
            this.addImport(model.imports, this.typeMapping.get("map"));
        }
        this.addImports(model, (IJsonSchemaValidationProperties)property);
    }

    Map<String, String> getAllAliases(Map<String, Schema> schemas) {
        if (schemas == null || schemas.isEmpty()) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> aliases = new HashMap<String, String>();
        for (Map.Entry<String, Schema> entry : schemas.entrySet()) {
            Schema schema = entry.getValue();
            if (!this.isAliasOfSimpleTypes(schema).booleanValue()) continue;
            if (schema.getAllOf() != null && schema.getAllOf().size() == 1) {
                Schema<?> unaliasSchema = this.unaliasSchema(schema);
                unaliasSchema = ModelUtils.getReferencedSchema(this.openAPI, (Schema)unaliasSchema);
                aliases.put(entry.getKey(), this.getPrimitiveType(unaliasSchema));
                continue;
            }
            aliases.put(entry.getKey(), this.getPrimitiveType(schema));
        }
        return aliases;
    }

    private Boolean isAliasOfSimpleTypes(Schema schema) {
        if (schema == null) {
            return false;
        }
        if (schema.getAllOf() != null && schema.getAllOf().size() == 1 && schema.getAllOf().get(0) instanceof Schema) {
            schema = this.unaliasSchema((Schema)schema.getAllOf().get(0));
            schema = ModelUtils.getReferencedSchema(this.openAPI, (Schema)schema);
        }
        return !ModelUtils.isObjectSchema((Schema)schema) && !ModelUtils.isArraySchema((Schema)schema) && !ModelUtils.isMapSchema((Schema)schema) && !ModelUtils.isComposedSchema((Schema)schema) && schema.getEnum() == null;
    }

    public String removeNonNameElementToCamelCase(String name) {
        return this.removeNonNameElementToCamelCase(name, "[-_:;#" + this.removeOperationIdPrefixDelimiter + "]");
    }

    protected String removeNonNameElementToCamelCase(String name, String nonNameElementPattern) {
        Object result = Arrays.stream(name.split(nonNameElementPattern)).map(org.apache.commons.lang3.StringUtils::capitalize).collect(Collectors.joining(""));
        if (((String)result).length() > 0) {
            result = ((String)result).substring(0, 1).toLowerCase(Locale.ROOT) + ((String)result).substring(1);
        }
        return result;
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        String suffix = this.apiTemplateFiles().get(templateName);
        return this.apiFileFolder() + File.separator + this.toApiFilename(tag) + suffix;
    }

    @Override
    public String apiFilename(String templateName, String tag, String outputDir) {
        String suffix = this.apiTemplateFiles().get(templateName);
        return outputDir + File.separator + this.toApiFilename(tag) + suffix;
    }

    @Override
    public String modelFilename(String templateName, String modelName) {
        String suffix = this.modelTemplateFiles().get(templateName);
        return this.modelFileFolder() + File.separator + this.toModelFilename(modelName) + suffix;
    }

    @Override
    public String modelFilename(String templateName, String modelName, String outputDir) {
        String suffix = this.modelTemplateFiles().get(templateName);
        return outputDir + File.separator + this.toModelFilename(modelName) + suffix;
    }

    @Override
    public String apiDocFilename(String templateName, String tag) {
        String docExtension = this.getDocExtension();
        String suffix = docExtension != null ? docExtension : this.apiDocTemplateFiles().get(templateName);
        return this.apiDocFileFolder() + File.separator + this.toApiDocFilename(tag) + suffix;
    }

    @Override
    public String apiTestFilename(String templateName, String tag) {
        String suffix = this.apiTestTemplateFiles().get(templateName);
        return this.apiTestFileFolder() + File.separator + this.toApiTestFilename(tag) + suffix;
    }

    @Override
    public boolean shouldOverwrite(String filename) {
        return !this.skipOverwrite || !new File(filename).exists();
    }

    @Override
    public boolean isSkipOverwrite() {
        return this.skipOverwrite;
    }

    @Override
    public void setSkipOverwrite(boolean skipOverwrite) {
        this.skipOverwrite = skipOverwrite;
    }

    @Override
    public boolean isRemoveOperationIdPrefix() {
        return this.removeOperationIdPrefix;
    }

    @Override
    public boolean isSkipOperationExample() {
        return this.skipOperationExample;
    }

    @Override
    public void setRemoveOperationIdPrefix(boolean removeOperationIdPrefix) {
        this.removeOperationIdPrefix = removeOperationIdPrefix;
    }

    @Override
    public void setSkipOperationExample(boolean skipOperationExample) {
        this.skipOperationExample = skipOperationExample;
    }

    @Override
    public boolean isHideGenerationTimestamp() {
        return this.hideGenerationTimestamp;
    }

    @Override
    public void setHideGenerationTimestamp(boolean hideGenerationTimestamp) {
        this.hideGenerationTimestamp = hideGenerationTimestamp;
    }

    @Override
    public Map<String, String> supportedLibraries() {
        return this.supportedLibraries;
    }

    @Override
    public void setLibrary(String library) {
        if (library != null && !this.supportedLibraries.containsKey(library)) {
            StringBuilder sb = new StringBuilder("Unknown library: " + library + "\nAvailable libraries:");
            if (this.supportedLibraries.size() == 0) {
                sb.append("\n  ").append("NONE");
            } else {
                for (String lib : this.supportedLibraries.keySet()) {
                    sb.append("\n  ").append(lib);
                }
            }
            throw new RuntimeException(sb.toString());
        }
        this.library = library;
    }

    @Override
    public String getLibrary() {
        return this.library;
    }

    public final boolean isLibrary(String library) {
        return library.equals(this.library);
    }

    @Override
    public void setGitHost(String gitHost) {
        this.gitHost = gitHost;
    }

    @Override
    public String getGitHost() {
        return this.gitHost;
    }

    @Override
    public void setGitUserId(String gitUserId) {
        this.gitUserId = gitUserId;
    }

    @Override
    public String getGitUserId() {
        return this.gitUserId;
    }

    @Override
    public void setGitRepoId(String gitRepoId) {
        this.gitRepoId = gitRepoId;
    }

    @Override
    public String getGitRepoId() {
        return this.gitRepoId;
    }

    @Override
    public void setReleaseNote(String releaseNote) {
        this.releaseNote = releaseNote;
    }

    @Override
    public String getReleaseNote() {
        return this.releaseNote;
    }

    @Override
    public String getDocExtension() {
        return this.docExtension;
    }

    @Override
    public void setDocExtension(String userDocExtension) {
        this.docExtension = userDocExtension;
    }

    @Override
    public void setHttpUserAgent(String httpUserAgent) {
        this.httpUserAgent = httpUserAgent;
    }

    @Override
    public String getHttpUserAgent() {
        return this.httpUserAgent;
    }

    protected CliOption buildLibraryCliOption(Map<String, String> supportedLibraries) {
        StringBuilder sb = new StringBuilder("library template (sub-template) to use:");
        for (String lib : supportedLibraries.keySet()) {
            sb.append("\n").append(lib).append(" - ").append(supportedLibraries.get(lib));
        }
        return new CliOption("library", sb.toString());
    }

    @Override
    public String sanitizeName(String name) {
        return this.sanitizeName(name, "\\W");
    }

    @Override
    public void setTemplatingEngine(TemplatingEngineAdapter templatingEngine) {
        this.templatingEngine = templatingEngine;
    }

    @Override
    public TemplatingEngineAdapter getTemplatingEngine() {
        return this.templatingEngine;
    }

    public String sanitizeName(String name, String removeCharRegEx) {
        return this.sanitizeName(name, removeCharRegEx, new ArrayList<String>());
    }

    public String sanitizeName(String name, String removeCharRegEx, ArrayList<String> exceptionList) {
        if (name == null) {
            this.LOGGER.error("String to be sanitized is null. Default to ERROR_UNKNOWN");
            return "ERROR_UNKNOWN";
        }
        if ("$".equals(name)) {
            return "value";
        }
        SanitizeNameOptions opts = new SanitizeNameOptions(name, removeCharRegEx, exceptionList);
        return (String)sanitizedNameCache.get((Object)opts, sanitizeNameOptions -> {
            String modifiable = sanitizeNameOptions.getName();
            List<String> exceptions = sanitizeNameOptions.getExceptions();
            modifiable = this.sanitizeValue(modifiable, "\\[\\]", "", exceptions);
            modifiable = this.sanitizeValue(modifiable, "\\[", "_", exceptions);
            modifiable = this.sanitizeValue(modifiable, "\\]", "", exceptions);
            modifiable = this.sanitizeValue(modifiable, "\\(", "_", exceptions);
            modifiable = this.sanitizeValue(modifiable, "\\)", "", exceptions);
            modifiable = this.sanitizeValue(modifiable, "\\.", "_", exceptions);
            modifiable = this.sanitizeValue(modifiable, "-", "_", exceptions);
            modifiable = this.sanitizeValue(modifiable, "\\|", "_", exceptions);
            modifiable = this.sanitizeValue(modifiable, " ", "_", exceptions);
            modifiable = modifiable.replaceAll("/", "_");
            modifiable = modifiable.replaceAll("\\\\", "_");
            modifiable = this.allowUnicodeIdentifiers != false ? Pattern.compile(sanitizeNameOptions.getRemoveCharRegEx(), 256).matcher(modifiable).replaceAll("") : modifiable.replaceAll(sanitizeNameOptions.getRemoveCharRegEx(), "");
            return modifiable;
        });
    }

    private String sanitizeValue(String value, String replaceMatch, String replaceValue, List<String> exceptionList) {
        if (exceptionList.size() == 0 || !exceptionList.contains(replaceMatch)) {
            return value.replaceAll(replaceMatch, replaceValue);
        }
        return value;
    }

    @Override
    public String sanitizeTag(String tag) {
        if (((String)(tag = StringUtils.camelize(this.sanitizeName((String)tag)))).matches("^\\d.*")) {
            tag = "Class" + (String)tag;
        }
        return tag;
    }

    public void setParameterBooleanFlagWithCodegenProperty(CodegenParameter parameter, CodegenProperty property) {
        if (parameter == null) {
            this.LOGGER.error("Codegen Parameter cannot be null.");
            return;
        }
        if (property == null) {
            this.LOGGER.error("Codegen Property cannot be null.");
            return;
        }
        if (Boolean.TRUE.equals(property.isEmail) && Boolean.TRUE.equals(property.isString)) {
            parameter.isEmail = true;
        } else if (Boolean.TRUE.equals(property.isPassword) && Boolean.TRUE.equals(property.isString)) {
            parameter.isPassword = true;
        } else if (Boolean.TRUE.equals(property.isUuid) && Boolean.TRUE.equals(property.isString)) {
            parameter.isUuid = true;
        } else if (Boolean.TRUE.equals(property.isByteArray)) {
            parameter.isByteArray = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isBinary)) {
            parameter.isBinary = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isString)) {
            parameter.isString = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isBoolean)) {
            parameter.isBoolean = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isLong)) {
            parameter.isLong = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isInteger)) {
            parameter.isInteger = true;
            parameter.isPrimitiveType = true;
            if (Boolean.TRUE.equals(property.isShort)) {
                parameter.isShort = true;
            } else if (Boolean.TRUE.equals(property.isUnboundedInteger)) {
                parameter.isUnboundedInteger = true;
            }
        } else if (Boolean.TRUE.equals(property.isDouble)) {
            parameter.isDouble = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isFloat)) {
            parameter.isFloat = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isDecimal)) {
            parameter.isDecimal = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isNumber)) {
            parameter.isNumber = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isDate)) {
            parameter.isDate = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isDateTime)) {
            parameter.isDateTime = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isFreeFormObject)) {
            parameter.isFreeFormObject = true;
        } else if (Boolean.TRUE.equals(property.isAnyType)) {
            parameter.isAnyType = true;
        } else {
            this.LOGGER.debug("Property type is not primitive: {}", (Object)property.dataType);
        }
        if (Boolean.TRUE.equals(property.isFile)) {
            parameter.isFile = true;
        }
        if (Boolean.TRUE.equals(property.isModel)) {
            parameter.isModel = true;
        }
    }

    public void updateCodegenPropertyEnum(CodegenProperty var) {
        Map<String, Object> extensions;
        Map<String, Object> allowableValues = var.allowableValues;
        if (var.mostInnerItems != null) {
            allowableValues = var.mostInnerItems.allowableValues;
        }
        if (allowableValues == null) {
            return;
        }
        List values = (List)allowableValues.get("values");
        if (values == null) {
            return;
        }
        String varDataType = var.mostInnerItems != null ? var.mostInnerItems.dataType : var.dataType;
        Optional<Schema> referencedSchema = ModelUtils.getSchemas(this.openAPI).entrySet().stream().filter(entry -> Objects.equals(varDataType, this.toModelName((String)entry.getKey()))).map(Map.Entry::getValue).findFirst();
        String dataType = referencedSchema.isPresent() ? this.getTypeDeclaration(referencedSchema.get()) : varDataType;
        List<Map<String, Object>> enumVars = this.buildEnumVars(values, dataType);
        this.postProcessEnumVars(enumVars);
        Map<String, Object> map = extensions = var.mostInnerItems != null ? var.mostInnerItems.getVendorExtensions() : var.getVendorExtensions();
        if (referencedSchema.isPresent()) {
            extensions = referencedSchema.get().getExtensions();
        }
        this.updateEnumVarsWithExtensions(enumVars, extensions, dataType);
        allowableValues.put("enumVars", enumVars);
        if (var.defaultValue != null) {
            String enumDefaultValue = this.getEnumDefaultValue(var.defaultValue, dataType);
            String enumName = null;
            for (Map<String, Object> enumVar : enumVars) {
                if (!enumDefaultValue.equals(enumVar.get("value"))) continue;
                enumName = (String)enumVar.get("name");
                break;
            }
            if (enumName != null) {
                var.defaultValue = this.toEnumDefaultValue(var, enumName);
            }
        }
    }

    protected String getEnumDefaultValue(String defaultValue, String dataType) {
        String enumDefaultValue = this.isDataTypeString(dataType) ? this.toEnumValue(defaultValue, dataType) : defaultValue;
        return enumDefaultValue;
    }

    protected List<Map<String, Object>> buildEnumVars(List<Object> values, String dataType) {
        ArrayList<Map<String, Object>> enumVars = new ArrayList<Map<String, Object>>();
        int truncateIdx = this.isRemoveEnumValuePrefix() ? this.findCommonPrefixOfVars(values).length() : 0;
        for (Object value : values) {
            String enumName;
            HashMap<String, Object> enumVar = new HashMap<String, Object>();
            String string = enumName = truncateIdx == 0 ? String.valueOf(value) : value.toString().substring(truncateIdx);
            if (enumName.isEmpty()) {
                enumName = value.toString();
            }
            String finalEnumName = this.toEnumVarName(enumName, dataType);
            enumVar.put("name", finalEnumName);
            enumVar.put("value", this.toEnumValue(String.valueOf(value), dataType));
            enumVar.put("isString", this.isDataTypeString(dataType));
            enumVars.add(enumVar);
        }
        if (this.enumUnknownDefaultCase) {
            HashMap<String, Object> enumVar = new HashMap<String, Object>();
            String enumName = this.enumUnknownDefaultCaseName;
            String enumValue = this.isDataTypeString(dataType) ? this.enumUnknownDefaultCaseName : String.valueOf(0xAAAAA9);
            enumVar.put("name", this.toEnumVarName(enumName, dataType));
            enumVar.put("value", this.toEnumValue(enumValue, dataType));
            enumVar.put("isString", this.isDataTypeString(dataType));
            enumVars.add(enumVar);
        }
        return enumVars;
    }

    protected void postProcessEnumVars(List<Map<String, Object>> enumVars) {
        Collections.reverse(enumVars);
        enumVars.forEach(v -> {
            String name = (String)v.get("name");
            long count = enumVars.stream().filter(v1 -> v1.get("name").equals(name)).count();
            if (count > 1L) {
                String uniqueEnumName = this.getUniqueEnumName(name, enumVars);
                this.LOGGER.debug("Changing duplicate enumeration name from " + v.get("name") + " to " + uniqueEnumName);
                v.put("name", uniqueEnumName);
            }
        });
        Collections.reverse(enumVars);
    }

    private String getUniqueEnumName(String name, List<Map<String, Object>> enumVars) {
        long count = enumVars.stream().filter(v -> v.get("name").equals(name)).count();
        return count > 1L ? this.getUniqueEnumName(name + count, enumVars) : name;
    }

    protected void updateEnumVarsWithExtensions(List<Map<String, Object>> enumVars, Map<String, Object> vendorExtensions, String dataType) {
        if (vendorExtensions != null) {
            this.updateEnumVarsWithExtensions(enumVars, vendorExtensions, "x-enum-varnames", "name");
            this.updateEnumVarsWithExtensions(enumVars, vendorExtensions, "x-enum-descriptions", "enumDescription");
        }
    }

    private void updateEnumVarsWithExtensions(List<Map<String, Object>> enumVars, Map<String, Object> vendorExtensions, String extensionKey, String key) {
        if (vendorExtensions.containsKey(extensionKey)) {
            List values = (List)vendorExtensions.get(extensionKey);
            int size = Math.min(enumVars.size(), values.size());
            for (int i = 0; i < size; ++i) {
                enumVars.get(i).put(key, values.get(i));
            }
        }
    }

    public String addRegularExpressionDelimiter(String pattern) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)pattern)) {
            return pattern;
        }
        if (!pattern.matches("^/.*")) {
            return "/" + pattern.replaceAll("/", "\\\\/") + "/";
        }
        return pattern;
    }

    public boolean convertPropertyToBooleanAndWriteBack(String propertyKey) {
        boolean result = this.convertPropertyToBoolean(propertyKey);
        this.writePropertyBack(propertyKey, result);
        return result;
    }

    public boolean convertPropertyToBooleanAndWriteBack(String propertyKey, Consumer<Boolean> booleanSetter) {
        if (this.additionalProperties.containsKey(propertyKey)) {
            boolean result = this.convertPropertyToBoolean(propertyKey);
            this.writePropertyBack(propertyKey, result);
            booleanSetter.accept(result);
            return result;
        }
        return false;
    }

    public String convertPropertyToStringAndWriteBack(String propertyKey, Consumer<String> stringSetter) {
        return this.convertPropertyToTypeAndWriteBack(propertyKey, Function.identity(), stringSetter);
    }

    public <T> T convertPropertyToTypeAndWriteBack(String propertyKey, Function<String, T> converter, Consumer<T> stringSetter) {
        if (this.additionalProperties.containsKey(propertyKey)) {
            String value = this.additionalProperties.get(propertyKey).toString();
            T result = converter.apply(value);
            this.writePropertyBack(propertyKey, result);
            stringSetter.accept(result);
            return result;
        }
        return null;
    }

    @Override
    public String getIgnoreFilePathOverride() {
        return this.ignoreFilePathOverride;
    }

    @Override
    public void setIgnoreFilePathOverride(String ignoreFileOverride) {
        this.ignoreFilePathOverride = ignoreFileOverride;
    }

    public boolean convertPropertyToBoolean(String propertyKey) {
        Object booleanValue = this.additionalProperties.get(propertyKey);
        boolean result = Boolean.FALSE;
        if (booleanValue instanceof Boolean) {
            result = (Boolean)booleanValue;
        } else if (booleanValue instanceof String) {
            result = Boolean.parseBoolean((String)booleanValue);
        } else {
            this.LOGGER.warn("The value (generator's option) must be either boolean or string. Default to `false`.");
        }
        return result;
    }

    public void writePropertyBack(String propertyKey, Object value) {
        this.additionalProperties.put(propertyKey, value);
    }

    protected String getContentType(RequestBody requestBody) {
        if (requestBody == null || requestBody.getContent() == null || requestBody.getContent().isEmpty()) {
            this.LOGGER.debug("Cannot determine the content type. Returning null.");
            return null;
        }
        return (String)new ArrayList(requestBody.getContent().keySet()).get(0);
    }

    private void setOauth2Info(CodegenSecurity codegenSecurity, OAuthFlow flow) {
        codegenSecurity.authorizationUrl = flow.getAuthorizationUrl();
        codegenSecurity.tokenUrl = flow.getTokenUrl();
        codegenSecurity.refreshUrl = flow.getRefreshUrl();
        if (flow.getScopes() != null && !flow.getScopes().isEmpty()) {
            ArrayList<Map<String, Object>> scopes = new ArrayList<Map<String, Object>>();
            for (Map.Entry scopeEntry : flow.getScopes().entrySet()) {
                HashMap scope = new HashMap();
                scope.put("scope", scopeEntry.getKey());
                scope.put("description", this.escapeText((String)scopeEntry.getValue()));
                scopes.add(scope);
            }
            codegenSecurity.scopes = scopes;
            codegenSecurity.hasScopes = true;
        }
    }

    private void setOpenIdConnectInfo(CodegenSecurity codegenSecurity, OAuthFlow flow) {
        if (flow.getScopes() != null && !flow.getScopes().isEmpty()) {
            ArrayList<Map<String, Object>> scopes = new ArrayList<Map<String, Object>>();
            for (Map.Entry scopeEntry : flow.getScopes().entrySet()) {
                HashMap scope = new HashMap();
                scope.put("scope", scopeEntry.getKey());
                scopes.add(scope);
            }
            codegenSecurity.scopes = scopes;
        }
    }

    private void addConsumesInfo(Operation operation, CodegenOperation codegenOperation) {
        RequestBody requestBody = ModelUtils.getReferencedRequestBody(this.openAPI, operation.getRequestBody());
        if (requestBody == null || requestBody.getContent() == null || requestBody.getContent().isEmpty()) {
            return;
        }
        Set consumes = requestBody.getContent().keySet();
        ArrayList<Map<String, String>> mediaTypeList = new ArrayList<Map<String, String>>();
        for (String key : consumes) {
            HashMap<String, String> mediaType = new HashMap<String, String>();
            if ("*/*".equals(key)) continue;
            mediaType.put("mediaType", this.escapeQuotationMark(key));
            if (DefaultCodegen.isJsonMimeType(key)) {
                mediaType.put("isJson", "true");
            } else if (DefaultCodegen.isXmlMimeType(key)) {
                mediaType.put("isXml", "true");
            }
            mediaTypeList.add(mediaType);
        }
        if (!mediaTypeList.isEmpty()) {
            codegenOperation.consumes = mediaTypeList;
            codegenOperation.hasConsumes = true;
        }
    }

    public static Set<String> getConsumesInfo(OpenAPI openAPI, Operation operation) {
        RequestBody requestBody = ModelUtils.getReferencedRequestBody(openAPI, operation.getRequestBody());
        if (requestBody == null || requestBody.getContent() == null || requestBody.getContent().isEmpty()) {
            return Collections.emptySet();
        }
        return requestBody.getContent().keySet();
    }

    public boolean hasFormParameter(Operation operation) {
        Set<String> consumesInfo = DefaultCodegen.getConsumesInfo(this.openAPI, operation);
        if (consumesInfo == null || consumesInfo.isEmpty()) {
            return false;
        }
        for (String consume : consumesInfo) {
            if (consume == null || !consume.toLowerCase(Locale.ROOT).startsWith("application/x-www-form-urlencoded") && !consume.toLowerCase(Locale.ROOT).startsWith("multipart")) continue;
            return true;
        }
        return false;
    }

    public boolean hasBodyParameter(Operation operation) {
        RequestBody requestBody = ModelUtils.getReferencedRequestBody(this.openAPI, operation.getRequestBody());
        if (requestBody == null) {
            return false;
        }
        Schema schema = ModelUtils.getSchemaFromRequestBody(requestBody);
        return ModelUtils.getReferencedSchema(this.openAPI, schema) != null;
    }

    private void addProducesInfo(ApiResponse inputResponse, CodegenOperation codegenOperation) {
        ApiResponse response = ModelUtils.getReferencedApiResponse(this.openAPI, inputResponse);
        if (response == null || response.getContent() == null || response.getContent().isEmpty()) {
            return;
        }
        Set produces = response.getContent().keySet();
        if (codegenOperation.produces == null) {
            codegenOperation.produces = new ArrayList<Map<String, String>>();
        }
        HashSet<String> existingMediaTypes = new HashSet<String>();
        for (Map<String, String> mediaType : codegenOperation.produces) {
            existingMediaTypes.add(mediaType.get("mediaType"));
        }
        for (String key : produces) {
            String encodedKey = "*/*".equals(key) ? key : this.escapeQuotationMark(key);
            if (existingMediaTypes.contains(encodedKey)) continue;
            HashMap<String, String> mediaType = new HashMap<String, String>();
            mediaType.put("mediaType", encodedKey);
            if (DefaultCodegen.isJsonMimeType(encodedKey)) {
                mediaType.put("isJson", "true");
            } else if (DefaultCodegen.isXmlMimeType(encodedKey)) {
                mediaType.put("isXml", "true");
            }
            codegenOperation.produces.add(mediaType);
            codegenOperation.hasProduces = Boolean.TRUE;
        }
    }

    public static Set<String> getProducesInfo(OpenAPI openAPI, Operation operation) {
        if (operation.getResponses() == null || operation.getResponses().isEmpty()) {
            return null;
        }
        ConcurrentSkipListSet<String> produces = new ConcurrentSkipListSet<String>();
        for (ApiResponse r : operation.getResponses().values()) {
            ApiResponse response = ModelUtils.getReferencedApiResponse(openAPI, r);
            if (response.getContent() == null) continue;
            produces.addAll(response.getContent().keySet());
        }
        return produces;
    }

    protected String getCollectionFormat(Parameter parameter) {
        if (Parameter.StyleEnum.FORM.equals((Object)parameter.getStyle())) {
            if (Boolean.TRUE.equals(parameter.getExplode())) {
                return "multi";
            }
            return "csv";
        }
        if (Parameter.StyleEnum.SIMPLE.equals((Object)parameter.getStyle())) {
            return "csv";
        }
        if (Parameter.StyleEnum.PIPEDELIMITED.equals((Object)parameter.getStyle())) {
            return "pipes";
        }
        if (Parameter.StyleEnum.SPACEDELIMITED.equals((Object)parameter.getStyle())) {
            return "ssv";
        }
        return null;
    }

    @Override
    public CodegenType getTag() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getHelp() {
        return null;
    }

    public List<CodegenParameter> fromRequestBodyToFormParameters(RequestBody body, Set<String> imports) {
        boolean isOneOfOrAnyOf;
        ArrayList<CodegenParameter> parameters = new ArrayList<CodegenParameter>();
        this.LOGGER.debug("debugging fromRequestBodyToFormParameters= {}", (Object)body);
        Schema schema = ModelUtils.getSchemaFromRequestBody(body);
        schema = ModelUtils.getReferencedSchema(this.openAPI, schema);
        Schema original = null;
        if (ModelUtils.isAllOf(schema) && schema.getAllOf().size() == 1 && ModelUtils.getType(schema) == null) {
            if (schema.getAllOf().get(0) instanceof Schema) {
                original = schema;
                schema = (Schema)schema.getAllOf().get(0);
            } else {
                this.LOGGER.error("Unknown type in allOf schema. Please report the issue via openapi-generator's Github issue tracker.");
            }
        }
        if (ModelUtils.isMapSchema(schema)) {
            this.LOGGER.error("Form parameters with additionalProperties are not supported by OpenAPI Generator. Please report the issue to https://github.com/openapitools/openapi-generator if you need help.");
        }
        if (ModelUtils.isArraySchema(schema)) {
            this.LOGGER.error("Array form parameters are not supported by OpenAPI Generator. Please report the issue to https://github.com/openapitools/openapi-generator if you need help.");
        }
        ArrayList<String> allRequired = new ArrayList<String>();
        LinkedHashMap<String, Schema> properties = new LinkedHashMap<String, Schema>();
        this.addProperties(properties, allRequired, schema, new HashSet<Schema>());
        boolean bl = isOneOfOrAnyOf = ModelUtils.isOneOf(schema) || ModelUtils.isAnyOf(schema);
        if (!properties.isEmpty()) {
            for (Map.Entry entry : properties.entrySet()) {
                String propertyName = (String)entry.getKey();
                Schema propertySchema = (Schema)entry.getValue();
                CodegenParameter codegenParameter = this.fromFormProperty(propertyName, propertySchema, imports);
                if (isOneOfOrAnyOf) {
                    codegenParameter.required = false;
                } else if (!codegenParameter.required && schema.getRequired() != null) {
                    codegenParameter.required = schema.getRequired().contains(entry.getKey());
                } else if (!codegenParameter.required) {
                    codegenParameter.required = allRequired.stream().anyMatch(r -> r.equals(codegenParameter.paramName));
                }
                parameters.add(codegenParameter);
            }
        }
        return parameters;
    }

    public CodegenParameter fromFormProperty(String name, Schema propertySchema, Set<String> imports) {
        CodegenProperty codegenProperty;
        CodegenParameter codegenParameter;
        block31: {
            Schema ps;
            block38: {
                block39: {
                    block36: {
                        block37: {
                            block34: {
                                block35: {
                                    block33: {
                                        block32: {
                                            block30: {
                                                codegenParameter = (CodegenParameter)CodegenModelFactory.newInstance(CodegenModelType.PARAMETER);
                                                this.LOGGER.debug("Debugging fromFormProperty {}: {}", (Object)name, (Object)propertySchema);
                                                codegenProperty = this.fromProperty(name, propertySchema, false);
                                                ps = this.unaliasSchema(propertySchema);
                                                ModelUtils.syncValidationProperties(ps, codegenParameter);
                                                codegenParameter.setTypeProperties(ps);
                                                codegenParameter.setComposedSchemas(this.getComposedSchemas(ps));
                                                if (ps.getPattern() != null) {
                                                    codegenParameter.pattern = this.toRegularExpression(ps.getPattern());
                                                }
                                                codegenParameter.baseType = codegenProperty.baseType;
                                                codegenParameter.dataType = codegenProperty.dataType;
                                                codegenParameter.baseName = codegenProperty.baseName;
                                                codegenParameter.paramName = this.toParamName(codegenParameter.baseName);
                                                codegenParameter.nameInCamelCase = StringUtils.camelize(codegenParameter.paramName, CamelizeOption.LOWERCASE_FIRST_LETTER);
                                                codegenParameter.nameInPascalCase = StringUtils.camelize(codegenParameter.paramName);
                                                codegenParameter.nameInSnakeCase = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, codegenParameter.nameInPascalCase);
                                                codegenParameter.nameInLowerCase = codegenParameter.paramName.toLowerCase(Locale.ROOT);
                                                codegenParameter.isContainer = codegenProperty.isContainer;
                                                codegenParameter.containerType = codegenProperty.containerType;
                                                codegenParameter.containerTypeMapped = codegenProperty.containerTypeMapped;
                                                codegenParameter.dataFormat = codegenProperty.dataFormat;
                                                this.updateCodegenPropertyEnum(codegenProperty);
                                                codegenParameter.isEnum = codegenProperty.isEnum;
                                                codegenParameter.isEnumRef = codegenProperty.isEnumRef;
                                                codegenParameter._enum = codegenProperty._enum;
                                                codegenParameter.allowableValues = codegenProperty.allowableValues;
                                                codegenParameter.defaultValue = this.toDefaultParameterValue(codegenProperty, propertySchema);
                                                if (!ModelUtils.isFileSchema(ps) || ModelUtils.isStringSchema(ps)) break block30;
                                                codegenParameter.isFile = true;
                                                break block31;
                                            }
                                            if (!ModelUtils.isStringSchema(ps)) break block32;
                                            if (ModelUtils.isEmailSchema(ps)) {
                                                codegenParameter.isEmail = true;
                                            } else if (ModelUtils.isPasswordSchema(ps)) {
                                                codegenParameter.isPassword = true;
                                            } else if (ModelUtils.isUUIDSchema(ps)) {
                                                codegenParameter.isUuid = true;
                                            } else if (ModelUtils.isByteArraySchema(ps)) {
                                                codegenParameter.setIsString(false);
                                                codegenParameter.isByteArray = true;
                                                codegenParameter.isPrimitiveType = true;
                                            } else if (ModelUtils.isBinarySchema(ps)) {
                                                codegenParameter.isBinary = true;
                                                codegenParameter.isFile = true;
                                                codegenParameter.isPrimitiveType = true;
                                            } else if (ModelUtils.isDateSchema(ps)) {
                                                codegenParameter.setIsString(false);
                                                codegenParameter.isDate = true;
                                                codegenParameter.isPrimitiveType = true;
                                            } else if (ModelUtils.isDateTimeSchema(ps)) {
                                                codegenParameter.setIsString(false);
                                                codegenParameter.isDateTime = true;
                                                codegenParameter.isPrimitiveType = true;
                                            } else if (ModelUtils.isDecimalSchema(ps)) {
                                                codegenParameter.setIsString(false);
                                                codegenParameter.isDecimal = true;
                                                codegenParameter.isPrimitiveType = true;
                                            }
                                            if (Boolean.TRUE.equals(codegenParameter.isString)) {
                                                codegenParameter.isPrimitiveType = true;
                                            }
                                            break block31;
                                        }
                                        if (!ModelUtils.isBooleanSchema(ps)) break block33;
                                        codegenParameter.isPrimitiveType = true;
                                        break block31;
                                    }
                                    if (!ModelUtils.isNumberSchema(ps)) break block34;
                                    codegenParameter.isPrimitiveType = true;
                                    if (!ModelUtils.isFloatSchema(ps)) break block35;
                                    codegenParameter.isFloat = true;
                                    break block31;
                                }
                                if (!ModelUtils.isDoubleSchema(ps)) break block31;
                                codegenParameter.isDouble = true;
                                break block31;
                            }
                            if (!ModelUtils.isIntegerSchema(ps)) break block36;
                            codegenParameter.isPrimitiveType = true;
                            if (!ModelUtils.isLongSchema(ps)) break block37;
                            codegenParameter.isLong = true;
                            break block31;
                        }
                        codegenParameter.isInteger = true;
                        if (!ModelUtils.isShortSchema(ps)) break block31;
                        codegenParameter.isShort = true;
                        break block31;
                    }
                    if (!ModelUtils.isTypeObjectSchema(ps)) break block38;
                    if (!ModelUtils.isMapSchema(ps)) break block39;
                    codegenParameter.isMap = true;
                    codegenParameter.additionalProperties = codegenProperty.additionalProperties;
                    codegenParameter.setAdditionalPropertiesIsAnyType(codegenProperty.getAdditionalPropertiesIsAnyType());
                    codegenParameter.items = codegenProperty.items;
                    codegenParameter.isPrimitiveType = false;
                    codegenParameter.items = codegenProperty.items;
                    codegenParameter.mostInnerItems = codegenProperty.mostInnerItems;
                    break block31;
                }
                if (!ModelUtils.isFreeFormObject(ps)) break block31;
                codegenParameter.isFreeFormObject = true;
                break block31;
            }
            if (!ModelUtils.isNullType(ps) && !ModelUtils.isAnyType(ps) && ModelUtils.isArraySchema(ps)) {
                Schema<?> inner = ModelUtils.getSchemaItems(ps);
                CodegenProperty arrayInnerProperty = this.fromProperty("inner", inner, false);
                codegenParameter.isArray = true;
                codegenParameter.items = arrayInnerProperty;
                codegenParameter.mostInnerItems = arrayInnerProperty.mostInnerItems;
                codegenParameter.isPrimitiveType = false;
                codegenParameter.baseType = arrayInnerProperty.dataType;
                if (!(this instanceof PhpNextgenClientCodegen)) {
                    codegenParameter.defaultValue = arrayInnerProperty.getDefaultValue();
                }
                if (codegenParameter.items.isFile) {
                    codegenParameter.isFile = true;
                    codegenParameter.dataFormat = codegenParameter.items.dataFormat;
                }
                if (arrayInnerProperty._enum != null) {
                    codegenParameter._enum = arrayInnerProperty._enum;
                }
                if (arrayInnerProperty.baseType != null && arrayInnerProperty.enumName != null) {
                    codegenParameter.datatypeWithEnum = codegenParameter.dataType.replace(arrayInnerProperty.baseType, arrayInnerProperty.enumName);
                } else {
                    this.LOGGER.warn("Could not compute datatypeWithEnum from {}, {}", (Object)arrayInnerProperty.baseType, (Object)arrayInnerProperty.enumName);
                }
                String collectionFormat = this.getCollectionFormat(codegenParameter);
                codegenParameter.collectionFormat = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)collectionFormat) ? "csv" : collectionFormat;
                codegenParameter.isCollectionFormatMulti = "multi".equals(collectionFormat);
                while (arrayInnerProperty != null) {
                    imports.add(arrayInnerProperty.baseType);
                    arrayInnerProperty = arrayInnerProperty.items;
                }
            }
        }
        if (Boolean.TRUE.equals(codegenProperty.isModel)) {
            codegenParameter.isModel = true;
        }
        codegenParameter.isFormParam = Boolean.TRUE;
        codegenParameter.description = this.escapeText(codegenProperty.description);
        codegenParameter.unescapedDescription = codegenProperty.getDescription();
        codegenParameter.jsonSchema = Json.pretty((Object)propertySchema);
        codegenParameter.containerType = codegenProperty.containerType;
        codegenParameter.containerTypeMapped = codegenProperty.containerTypeMapped;
        if (codegenProperty.getVendorExtensions() != null && !codegenProperty.getVendorExtensions().isEmpty()) {
            codegenParameter.vendorExtensions = codegenProperty.getVendorExtensions();
        }
        if (propertySchema.getRequired() != null && !propertySchema.getRequired().isEmpty() && propertySchema.getRequired().contains(codegenProperty.baseName)) {
            codegenParameter.required = Boolean.TRUE;
        }
        if (codegenProperty.isEnum) {
            codegenParameter.datatypeWithEnum = codegenProperty.datatypeWithEnum;
            codegenParameter.enumName = codegenProperty.enumName;
            if (codegenProperty.defaultValue != null) {
                codegenParameter.enumDefaultValue = codegenProperty.defaultValue.replace(codegenProperty.enumName + ".", "");
            }
        }
        if (codegenProperty.complexType != null) {
            imports.add(codegenProperty.complexType);
        }
        this.setParameterExampleValue(codegenParameter);
        this.setParameterNullable(codegenParameter, codegenProperty);
        return codegenParameter;
    }

    protected void addBodyModelSchema(CodegenParameter codegenParameter, String name, Schema schema, Set<String> imports, String bodyParameterName, boolean forceSimpleRef) {
        CodegenModel codegenModel = null;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)name)) {
            schema.setName(name);
            codegenModel = this.fromModel(name, schema);
        }
        if (codegenModel != null) {
            codegenParameter.isModel = true;
        }
        if (codegenModel != null && (codegenModel.hasVars || forceSimpleRef)) {
            codegenParameter.baseName = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)bodyParameterName) ? codegenModel.classname : bodyParameterName;
            codegenParameter.paramName = this.toParamName(codegenParameter.baseName);
            codegenParameter.baseType = codegenModel.classname;
            codegenParameter.dataType = this.getTypeDeclaration(codegenModel.classname);
            codegenParameter.description = codegenModel.description;
            codegenParameter.isNullable = codegenModel.isNullable;
            imports.add(codegenParameter.baseType);
        } else {
            CodegenProperty codegenProperty = this.fromProperty("property", schema, false);
            if (codegenProperty != null && codegenProperty.getComplexType() != null && codegenProperty.getComplexType().contains(" | ")) {
                String codegenModelName;
                List<String> parts = Arrays.asList(codegenProperty.getComplexType().split(" \\| "));
                imports.addAll(parts);
                codegenParameter.baseName = codegenModelName = codegenProperty.getComplexType();
                codegenParameter.paramName = this.toParamName(codegenParameter.baseName);
                codegenParameter.baseType = codegenParameter.baseName;
                codegenParameter.dataType = this.getTypeDeclaration(codegenModelName);
                codegenParameter.description = codegenProperty.getDescription();
                codegenParameter.isNullable = codegenProperty.isNullable;
            } else if (ModelUtils.isMapSchema(schema)) {
                this.LOGGER.error("Map should be supported. Please report to openapi-generator github repo about the issue.");
            } else if (codegenProperty != null) {
                String codegenModelDescription;
                String codegenModelName;
                if (codegenModel != null) {
                    codegenModelName = codegenModel.classname;
                    codegenModelDescription = codegenModel.description;
                } else {
                    this.LOGGER.warn("The following schema has undefined (null) baseType. It could be due to form parameter defined in OpenAPI v2 spec with incorrect consumes. A correct 'consumes' for form parameters should be 'application/x-www-form-urlencoded' or 'multipart/?'");
                    this.LOGGER.warn("schema: {}", (Object)schema);
                    this.LOGGER.warn("codegenModel is null. Default to UNKNOWN_BASE_TYPE");
                    codegenModelName = "UNKNOWN_BASE_TYPE";
                    codegenModelDescription = "UNKNOWN_DESCRIPTION";
                }
                codegenParameter.baseName = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)bodyParameterName) ? codegenModelName : bodyParameterName;
                codegenParameter.paramName = this.toParamName(codegenParameter.baseName);
                codegenParameter.baseType = codegenModelName;
                codegenParameter.dataType = this.getTypeDeclaration(codegenModelName);
                codegenParameter.description = codegenModelDescription;
                imports.add(codegenParameter.baseType);
                if (codegenProperty.complexType != null && codegenProperty.getComposedSchemas() == null) {
                    imports.add(codegenProperty.complexType);
                }
            }
            this.setParameterNullable(codegenParameter, codegenProperty);
        }
    }

    protected void updateRequestBodyForMap(CodegenParameter codegenParameter, Schema schema, String name, Set<String> imports, String bodyParameterName) {
        boolean useModel = true;
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)name)) {
            useModel = false;
        } else if (ModelUtils.isFreeFormObject(schema)) {
            useModel = ModelUtils.shouldGenerateFreeFormObjectModel(name, this);
        } else if (ModelUtils.isMapSchema(schema)) {
            useModel = ModelUtils.shouldGenerateMapModel(schema);
        } else if (ModelUtils.isArraySchema(schema)) {
            useModel = ModelUtils.shouldGenerateArrayModel(schema);
        }
        if (useModel) {
            this.addBodyModelSchema(codegenParameter, name, schema, imports, bodyParameterName, true);
        } else {
            Schema inner = ModelUtils.getAdditionalProperties(schema);
            if (inner == null) {
                this.LOGGER.error("No inner type supplied for map parameter `{}`. Default to type:string", (Object)schema.getName());
                inner = new StringSchema().description("//TODO automatically added by openapi-generator");
                schema.setAdditionalProperties((Object)inner);
            }
            CodegenProperty codegenProperty = this.fromProperty("property", schema, false);
            imports.add(codegenProperty.baseType);
            CodegenProperty innerCp = codegenProperty;
            while (innerCp != null) {
                if (innerCp.complexType != null) {
                    imports.add(innerCp.complexType);
                }
                innerCp = innerCp.items;
            }
            codegenParameter.baseName = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)bodyParameterName) ? "request_body" : bodyParameterName;
            codegenParameter.paramName = this.toParamName(codegenParameter.baseName);
            codegenParameter.items = codegenProperty.items;
            codegenParameter.mostInnerItems = codegenProperty.mostInnerItems;
            codegenParameter.dataType = this.getTypeDeclaration(schema);
            codegenParameter.baseType = this.getSchemaType(inner);
            codegenParameter.isContainer = Boolean.TRUE;
            codegenParameter.isMap = Boolean.TRUE;
            codegenParameter.isNullable = codegenProperty.isNullable;
            codegenParameter.containerType = codegenProperty.containerType;
            codegenParameter.containerTypeMapped = codegenProperty.containerTypeMapped;
            this.setParameterNullable(codegenParameter, codegenProperty);
        }
    }

    protected void updateRequestBodyForPrimitiveType(CodegenParameter codegenParameter, Schema schema, String bodyParameterName, Set<String> imports) {
        CodegenProperty codegenProperty = this.fromProperty("PRIMITIVE_REQUEST_BODY", schema, false);
        if (codegenProperty != null) {
            codegenParameter.baseName = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)bodyParameterName) ? "body" : bodyParameterName;
            codegenParameter.isPrimitiveType = true;
            codegenParameter.baseType = codegenProperty.baseType;
            codegenParameter.dataType = codegenProperty.dataType;
            codegenParameter.description = codegenProperty.description;
            codegenParameter.paramName = this.toParamName(codegenParameter.baseName);
            codegenParameter.pattern = codegenProperty.pattern;
            codegenParameter.isNullable = codegenProperty.isNullable;
            if (codegenProperty.complexType != null) {
                imports.add(codegenProperty.complexType);
            }
        }
        this.setParameterNullable(codegenParameter, codegenProperty);
    }

    protected void updateRequestBodyForObject(CodegenParameter codegenParameter, Schema schema, String name, Set<String> imports, String bodyParameterName) {
        if (ModelUtils.isMapSchema(schema)) {
            this.updateRequestBodyForMap(codegenParameter, schema, name, imports, bodyParameterName);
        } else if (ModelUtils.isFreeFormObject(schema)) {
            codegenParameter.isFreeFormObject = true;
            CodegenProperty codegenProperty = this.fromProperty("FREE_FORM_REQUEST_BODY", schema, false);
            if (codegenProperty != null) {
                codegenParameter.baseName = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)bodyParameterName) ? "body" : bodyParameterName;
                codegenParameter.isPrimitiveType = true;
                codegenParameter.baseType = codegenProperty.baseType;
                codegenParameter.dataType = codegenProperty.dataType;
                codegenParameter.description = codegenProperty.description;
                codegenParameter.isNullable = codegenProperty.isNullable;
                codegenParameter.paramName = this.toParamName(codegenParameter.baseName);
            }
            this.setParameterNullable(codegenParameter, codegenProperty);
        } else if (ModelUtils.isObjectSchema(schema) || ModelUtils.isComposedSchema(schema)) {
            this.addBodyModelSchema(codegenParameter, name, schema, imports, bodyParameterName, false);
        }
        this.addVarsRequiredVarsAdditionalProps(schema, codegenParameter);
    }

    protected void updateRequestBodyForArray(CodegenParameter codegenParameter, Schema schema, String name, Set<String> imports, String bodyParameterName) {
        if (ModelUtils.isGenerateAliasAsModel(schema) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)name)) {
            this.addBodyModelSchema(codegenParameter, name, schema, imports, bodyParameterName, true);
        } else {
            CodegenProperty innerCp;
            Schema<?> inner = ModelUtils.getSchemaItems(schema);
            CodegenProperty codegenProperty = this.fromProperty("property", schema, false);
            if (codegenProperty == null) {
                throw new RuntimeException("CodegenProperty cannot be null. arraySchema for debugging: " + schema);
            }
            imports.add(codegenProperty.baseType);
            CodegenProperty mostInnerItem = innerCp = codegenProperty;
            while (innerCp != null) {
                if (innerCp.complexType != null) {
                    imports.add(innerCp.complexType);
                }
                mostInnerItem = innerCp;
                innerCp = innerCp.items;
            }
            codegenParameter.baseName = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)bodyParameterName) ? (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)mostInnerItem.complexType) ? "request_body" : mostInnerItem.complexType) : bodyParameterName;
            codegenParameter.paramName = this.toArrayModelParamName(codegenParameter.baseName);
            codegenParameter.nameInCamelCase = StringUtils.camelize(codegenParameter.paramName, CamelizeOption.LOWERCASE_FIRST_LETTER);
            codegenParameter.nameInPascalCase = StringUtils.camelize(codegenParameter.paramName);
            codegenParameter.nameInSnakeCase = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, codegenParameter.nameInPascalCase);
            codegenParameter.nameInLowerCase = codegenParameter.paramName.toLowerCase(Locale.ROOT);
            codegenParameter.items = codegenProperty.items;
            codegenParameter.mostInnerItems = codegenProperty.mostInnerItems;
            codegenParameter.dataType = this.getTypeDeclaration(schema);
            codegenParameter.baseType = this.getSchemaType(inner);
            codegenParameter.isContainer = Boolean.TRUE;
            codegenParameter.isNullable = codegenProperty.isNullable;
            codegenParameter.containerType = codegenProperty.containerType;
            codegenParameter.containerTypeMapped = codegenProperty.containerTypeMapped;
            this.setParameterNullable(codegenParameter, codegenProperty);
            while (codegenProperty != null) {
                imports.add(codegenProperty.baseType);
                codegenProperty = codegenProperty.items;
            }
        }
    }

    protected void updateRequestBodyForString(CodegenParameter codegenParameter, Schema schema, Set<String> imports, String bodyParameterName) {
        this.updateRequestBodyForPrimitiveType(codegenParameter, schema, bodyParameterName, imports);
        if (ModelUtils.isByteArraySchema(schema)) {
            codegenParameter.setIsString(false);
            codegenParameter.isByteArray = true;
        } else if (ModelUtils.isBinarySchema(schema)) {
            codegenParameter.isBinary = true;
            codegenParameter.isFile = true;
        } else if (ModelUtils.isUUIDSchema(schema)) {
            codegenParameter.isUuid = true;
        } else if (ModelUtils.isURISchema(schema)) {
            codegenParameter.isUri = true;
        } else if (ModelUtils.isEmailSchema(schema)) {
            codegenParameter.isEmail = true;
        } else if (ModelUtils.isDateSchema(schema)) {
            codegenParameter.setIsString(false);
            codegenParameter.isDate = true;
        } else if (ModelUtils.isDateTimeSchema(schema)) {
            codegenParameter.setIsString(false);
            codegenParameter.isDateTime = true;
        } else if (ModelUtils.isDecimalSchema(schema)) {
            codegenParameter.isDecimal = true;
            codegenParameter.setIsString(false);
        }
        codegenParameter.pattern = this.toRegularExpression(schema.getPattern());
    }

    protected String toMediaTypeSchemaName(String contentType, String mediaTypeSchemaSuffix) {
        return "SchemaFor" + mediaTypeSchemaSuffix + this.toModelName(contentType);
    }

    private CodegenParameter headerToCodegenParameter(Header header, String headerName, Set<String> imports, String mediaTypeSchemaSuffix) {
        if (header == null) {
            return null;
        }
        Parameter headerParam = new Parameter();
        headerParam.setName(headerName);
        headerParam.setIn("header");
        headerParam.setDescription(header.getDescription());
        headerParam.setRequired(header.getRequired());
        headerParam.setDeprecated(header.getDeprecated());
        Header.StyleEnum style = header.getStyle();
        if (style != null) {
            headerParam.setStyle(Parameter.StyleEnum.valueOf((String)style.name()));
        }
        headerParam.setExplode(header.getExplode());
        headerParam.setSchema(header.getSchema());
        headerParam.setExamples(header.getExamples());
        headerParam.setExample(header.getExample());
        headerParam.setContent(header.getContent());
        headerParam.setExtensions(header.getExtensions());
        CodegenParameter param = this.fromParameter(headerParam, imports);
        param.setContent(this.getContent(headerParam.getContent(), imports, mediaTypeSchemaSuffix));
        return param;
    }

    protected LinkedHashMap<String, CodegenMediaType> getContent(Content content, Set<String> imports, String mediaTypeSchemaSuffix) {
        if (content == null) {
            return null;
        }
        LinkedHashMap<String, CodegenMediaType> cmtContent = new LinkedHashMap<String, CodegenMediaType>();
        for (Map.Entry contentEntry : content.entrySet()) {
            String refKey;
            LinkedHashMap nodeWithRef;
            String refToTestCases;
            Object objNodeWithRef;
            MediaType mt = (MediaType)contentEntry.getValue();
            LinkedHashMap<String, CodegenEncoding> ceMap = null;
            if (mt.getEncoding() != null) {
                ceMap = new LinkedHashMap<String, CodegenEncoding>();
                Map encMap = mt.getEncoding();
                for (Map.Entry encodingEntry : encMap.entrySet()) {
                    Encoding enc = (Encoding)encodingEntry.getValue();
                    ArrayList<CodegenParameter> headers = new ArrayList<CodegenParameter>();
                    if (enc.getHeaders() != null) {
                        Map encHeaders = enc.getHeaders();
                        for (Map.Entry headerEntry : encHeaders.entrySet()) {
                            String headerName = (String)headerEntry.getKey();
                            Header header = ModelUtils.getReferencedHeader(this.openAPI, (Header)headerEntry.getValue());
                            CodegenParameter param = this.headerToCodegenParameter(header, headerName, imports, mediaTypeSchemaSuffix);
                            headers.add(param);
                        }
                    }
                    CodegenEncoding ce = new CodegenEncoding(enc.getContentType(), headers, enc.getStyle().toString(), enc.getExplode() == null ? false : enc.getExplode(), enc.getAllowReserved() == null ? false : enc.getAllowReserved());
                    if (enc.getExtensions() != null) {
                        ce.vendorExtensions = enc.getExtensions();
                    }
                    String propName = (String)encodingEntry.getKey();
                    ceMap.put(propName, ce);
                }
            }
            String contentType = (String)contentEntry.getKey();
            CodegenProperty schemaProp = null;
            if (mt.getSchema() != null) {
                schemaProp = this.fromProperty(this.toMediaTypeSchemaName(contentType, mediaTypeSchemaSuffix), mt.getSchema(), false);
            }
            HashMap<String, SchemaTestCase> schemaTestCases = null;
            if (mt.getExtensions() != null && mt.getExtensions().containsKey(xSchemaTestExamplesKey) && (objNodeWithRef = mt.getExtensions().get(xSchemaTestExamplesKey)) instanceof LinkedHashMap && (refToTestCases = (String)(nodeWithRef = (LinkedHashMap)objNodeWithRef).getOrDefault(refKey = "$ref", null)) != null) {
                schemaTestCases = this.extractSchemaTestCases(refToTestCases);
            }
            CodegenMediaType codegenMt = mt.getExamples() != null ? new CodegenMediaType(schemaProp, ceMap, schemaTestCases, mt.getExamples()) : (mt.getExample() != null ? new CodegenMediaType(schemaProp, ceMap, schemaTestCases, mt.getExample()) : new CodegenMediaType(schemaProp, ceMap, schemaTestCases));
            if (mt.getExtensions() != null) {
                codegenMt.vendorExtensions = mt.getExtensions();
            }
            cmtContent.put(contentType, codegenMt);
            if (schemaProp == null) continue;
            this.addImports(imports, schemaProp.getImports(true, this.importBaseType, this.generatorMetadata.getFeatureSet()));
        }
        return cmtContent;
    }

    public CodegenParameter fromRequestBody(RequestBody body, Set<String> imports, String bodyParameterName) {
        if (body == null) {
            this.LOGGER.error("body in fromRequestBody cannot be null!");
            throw new RuntimeException("body in fromRequestBody cannot be null!");
        }
        CodegenParameter codegenParameter = (CodegenParameter)CodegenModelFactory.newInstance(CodegenModelType.PARAMETER);
        codegenParameter.baseName = "UNKNOWN_BASE_NAME";
        codegenParameter.paramName = "UNKNOWN_PARAM_NAME";
        codegenParameter.description = this.escapeText(body.getDescription());
        codegenParameter.required = body.getRequired() != null ? body.getRequired() : Boolean.FALSE;
        codegenParameter.isBodyParam = Boolean.TRUE;
        if (body.getExtensions() != null) {
            codegenParameter.vendorExtensions.putAll(body.getExtensions());
        }
        String name = null;
        this.LOGGER.debug("Request body = {}", (Object)body);
        Schema schema = ModelUtils.getSchemaFromRequestBody(body);
        if (schema == null) {
            this.LOGGER.error("Schema cannot be null in the request body: {}", (Object)body);
            return null;
        }
        Schema original = null;
        if (ModelUtils.isAllOf(schema) && schema.getAllOf().size() == 1 && ModelUtils.getType(schema) == null) {
            if (schema.getAllOf().get(0) instanceof Schema) {
                original = schema;
                schema = (Schema)schema.getAllOf().get(0);
            } else {
                this.LOGGER.error("Unknown type in allOf schema. Please report the issue via openapi-generator's Github issue tracker.");
            }
        }
        codegenParameter.setContent(this.getContent(body.getContent(), imports, "RequestBody"));
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)schema.get$ref())) {
            name = ModelUtils.getSimpleRef(schema.get$ref());
        }
        Schema unaliasedSchema = this.unaliasSchema(schema);
        schema = ModelUtils.getReferencedSchema(this.openAPI, schema);
        ModelUtils.syncValidationProperties(unaliasedSchema, codegenParameter);
        codegenParameter.setTypeProperties(unaliasedSchema);
        codegenParameter.setComposedSchemas(this.getComposedSchemas(unaliasedSchema));
        if (ModelUtils.isArraySchema(schema)) {
            this.updateRequestBodyForArray(codegenParameter, schema, name, imports, bodyParameterName);
        } else if (ModelUtils.isTypeObjectSchema(schema)) {
            this.updateRequestBodyForObject(codegenParameter, schema, name, imports, bodyParameterName);
        } else if (ModelUtils.isIntegerSchema(schema)) {
            this.updateRequestBodyForPrimitiveType(codegenParameter, schema, bodyParameterName, imports);
            codegenParameter.isNumeric = Boolean.TRUE;
            if (ModelUtils.isLongSchema(schema)) {
                codegenParameter.isLong = Boolean.TRUE;
            } else {
                codegenParameter.isInteger = Boolean.TRUE;
                if (ModelUtils.isShortSchema(schema)) {
                    codegenParameter.setIsShort(Boolean.TRUE);
                }
            }
        } else if (ModelUtils.isBooleanSchema(schema)) {
            this.updateRequestBodyForPrimitiveType(codegenParameter, schema, bodyParameterName, imports);
        } else if (ModelUtils.isFileSchema(schema) && !ModelUtils.isStringSchema(schema)) {
            codegenParameter.isFile = true;
        } else if (ModelUtils.isStringSchema(schema)) {
            this.updateRequestBodyForString(codegenParameter, schema, imports, bodyParameterName);
        } else if (ModelUtils.isNumberSchema(schema)) {
            this.updateRequestBodyForPrimitiveType(codegenParameter, schema, bodyParameterName, imports);
            codegenParameter.isNumeric = Boolean.TRUE;
            if (ModelUtils.isFloatSchema(schema)) {
                codegenParameter.isFloat = Boolean.TRUE;
            } else if (ModelUtils.isDoubleSchema(schema)) {
                codegenParameter.isDouble = Boolean.TRUE;
            }
        } else if (ModelUtils.isNullType(schema)) {
            this.updateRequestBodyForPrimitiveType(codegenParameter, schema, bodyParameterName, imports);
        } else if (ModelUtils.isAnyType(schema)) {
            if (ModelUtils.isMapSchema(schema)) {
                this.updateRequestBodyForMap(codegenParameter, schema, name, imports, bodyParameterName);
            } else if (ModelUtils.isComposedSchema(schema)) {
                this.addBodyModelSchema(codegenParameter, name, schema, imports, bodyParameterName, false);
            } else if (ModelUtils.isObjectSchema(schema)) {
                this.addBodyModelSchema(codegenParameter, name, schema, imports, bodyParameterName, false);
            } else {
                this.updateRequestBodyForPrimitiveType(codegenParameter, schema, bodyParameterName, imports);
            }
            this.addVarsRequiredVarsAdditionalProps(schema, codegenParameter);
        } else {
            this.updateRequestBodyForPrimitiveType(codegenParameter, schema, bodyParameterName, imports);
        }
        this.addJsonSchemaForBodyRequestInCaseItsNotPresent(codegenParameter, body);
        this.setParameterExampleValue(codegenParameter, body);
        if (original != null) {
            if (original.getNullable() != null) {
                codegenParameter.isNullable = original.getNullable();
            } else if (original.getExtensions() != null && original.getExtensions().containsKey("x-nullable")) {
                codegenParameter.isNullable = (Boolean)original.getExtensions().get("x-nullable");
            }
            if (original.getExtensions() != null) {
                codegenParameter.vendorExtensions.putAll(original.getExtensions());
            }
            if (original.getDeprecated() != null) {
                codegenParameter.isDeprecated = original.getDeprecated();
            }
            if (original.getDescription() != null) {
                codegenParameter.description = this.escapeText(original.getDescription());
                codegenParameter.unescapedDescription = original.getDescription();
            }
            if (original.getMaxLength() != null) {
                codegenParameter.setMaxLength(original.getMaxLength());
            }
            if (original.getMinLength() != null) {
                codegenParameter.setMinLength(original.getMinLength());
            }
            if (original.getMaxItems() != null) {
                codegenParameter.setMaxItems(original.getMaxItems());
            }
            if (original.getMinItems() != null) {
                codegenParameter.setMinItems(original.getMinItems());
            }
            if (original.getMaximum() != null) {
                codegenParameter.setMaximum(String.valueOf(original.getMaximum().doubleValue()));
            }
            if (original.getMinimum() != null) {
                codegenParameter.setMinimum(String.valueOf(original.getMinimum().doubleValue()));
            }
        }
        return codegenParameter;
    }

    protected void addRequiredVarsMap(Schema schema, IJsonSchemaValidationProperties property) {
        Map properties = schema.getProperties();
        HashMap<String, CodegenProperty> requiredVarsMap = new HashMap<String, CodegenProperty>();
        List requiredPropertyNames = schema.getRequired();
        if (requiredPropertyNames == null) {
            return;
        }
        for (String requiredPropertyName : requiredPropertyNames) {
            String usedRequiredPropertyName = this.handleSpecialCharacters(requiredPropertyName);
            if (properties != null && properties.containsKey(requiredPropertyName)) {
                boolean found = false;
                for (CodegenProperty cp : property.getVars()) {
                    if (!cp.baseName.equals(requiredPropertyName)) continue;
                    found = true;
                    requiredVarsMap.put(requiredPropertyName, cp);
                    break;
                }
                if (found) continue;
                this.LOGGER.warn("Property {} is not processed correctly (missing from getVars). Maybe it's a const (not yet supported) in openapi v3.1 spec.", (Object)requiredPropertyName);
                continue;
            }
            if (schema.getAdditionalProperties() instanceof Boolean && Boolean.FALSE.equals(schema.getAdditionalProperties())) {
                requiredVarsMap.put(usedRequiredPropertyName, null);
                continue;
            }
            if (!this.supportsAdditionalPropertiesWithComposedSchema || this.disallowAdditionalPropertiesIfNotPresent) continue;
            CodegenProperty cp = schema.getAdditionalProperties() == null ? this.fromProperty(usedRequiredPropertyName, new Schema(), true, true) : (schema.getAdditionalProperties() instanceof Boolean && Boolean.TRUE.equals(schema.getAdditionalProperties()) ? this.fromProperty(requiredPropertyName, new Schema(), true, true) : this.fromProperty(requiredPropertyName, (Schema)schema.getAdditionalProperties(), true, true));
            requiredVarsMap.put(usedRequiredPropertyName, cp);
        }
        if (!requiredVarsMap.isEmpty()) {
            property.setRequiredVarsMap(requiredVarsMap);
        }
    }

    protected void addVarsRequiredVarsAdditionalProps(Schema schema, IJsonSchemaValidationProperties property) {
        this.setAddProps(schema, property);
        TreeSet<String> mandatory = schema.getRequired() == null ? Collections.emptySet() : new TreeSet<String>(schema.getRequired());
        this.addVars(property, property.getVars(), schema.getProperties(), mandatory);
        this.addRequiredVarsMap(schema, property);
    }

    protected String getItemsName(Schema containingSchema, String containingSchemaName) {
        if (containingSchema.getExtensions() != null && containingSchema.getExtensions().get("x-item-name") != null) {
            return containingSchema.getExtensions().get("x-item-name").toString();
        }
        return this.toVarName(containingSchemaName);
    }

    protected String getAdditionalPropertiesName() {
        return "additional_properties";
    }

    private void addJsonSchemaForBodyRequestInCaseItsNotPresent(CodegenParameter codegenParameter, RequestBody body) {
        if (codegenParameter.jsonSchema == null) {
            codegenParameter.jsonSchema = Json.pretty((Object)body);
        }
    }

    protected void addOption(String key, String description, String defaultValue) {
        this.addOption(key, description, defaultValue, null);
    }

    protected void addOption(String key, String description, String defaultValue, Map<String, String> enumValues) {
        CliOption option = new CliOption(key, description);
        if (defaultValue != null) {
            option.defaultValue(defaultValue);
        }
        if (enumValues != null) {
            option.setEnum(enumValues);
        }
        this.cliOptions.add(option);
    }

    protected void updateOption(String key, String defaultValue) {
        for (CliOption cliOption : this.cliOptions) {
            if (!cliOption.getOpt().equals(key)) continue;
            cliOption.setDefault(defaultValue);
            break;
        }
    }

    protected void removeOption(String key) {
        for (int i = 0; i < this.cliOptions.size(); ++i) {
            if (!key.equals(this.cliOptions.get(i).getOpt())) continue;
            this.cliOptions.remove(i);
            break;
        }
    }

    protected void addSwitch(String key, String description, Boolean defaultValue) {
        CliOption option = CliOption.newBoolean(key, description);
        if (defaultValue != null) {
            option.defaultValue(defaultValue.toString());
        }
        this.cliOptions.add(option);
    }

    protected void generateJSONSpecFile(Map<String, Object> objs) {
        OpenAPI openAPI = (OpenAPI)objs.get("openAPI");
        if (openAPI != null) {
            objs.put("openapi-json", SerializerUtils.toJsonString(openAPI));
        }
    }

    public void generateYAMLSpecFile(Map<String, Object> objs) {
        OpenAPI openAPI = (OpenAPI)objs.get("openAPI");
        String yaml = SerializerUtils.toYamlString(openAPI);
        if (yaml != null) {
            objs.put("openapi-yaml", yaml);
        }
    }

    public boolean isDataTypeString(String dataType) {
        return "String".equals(dataType);
    }

    @Override
    public List<CodegenServer> fromServers(List<Server> servers) {
        if (servers == null) {
            return Collections.emptyList();
        }
        LinkedList<CodegenServer> codegenServers = new LinkedList<CodegenServer>();
        for (Server server : servers) {
            CodegenServer cs = new CodegenServer();
            cs.description = this.escapeText(server.getDescription());
            cs.url = server.getUrl();
            cs.variables = this.fromServerVariables((Map<String, ServerVariable>)server.getVariables());
            if (server.getExtensions() != null) {
                cs.vendorExtensions = server.getExtensions();
            }
            codegenServers.add(cs);
        }
        return codegenServers;
    }

    @Override
    public List<CodegenServerVariable> fromServerVariables(Map<String, ServerVariable> variables) {
        if (variables == null) {
            return Collections.emptyList();
        }
        Map<String, String> variableOverrides = this.serverVariableOverrides();
        LinkedList<CodegenServerVariable> codegenServerVariables = new LinkedList<CodegenServerVariable>();
        for (Map.Entry<String, ServerVariable> variableEntry : variables.entrySet()) {
            CodegenServerVariable codegenServerVariable = new CodegenServerVariable();
            ServerVariable variable = variableEntry.getValue();
            List enums = variable.getEnum();
            codegenServerVariable.defaultValue = variable.getDefault();
            codegenServerVariable.description = this.escapeText(variable.getDescription());
            codegenServerVariable.enumValues = enums;
            codegenServerVariable.name = variableEntry.getKey();
            if (variable.getExtensions() != null) {
                codegenServerVariable.vendorExtensions = variable.getExtensions();
            }
            if (variableOverrides != null && !variableOverrides.isEmpty()) {
                String value;
                codegenServerVariable.value = value = variableOverrides.getOrDefault(variableEntry.getKey(), variable.getDefault());
                if (enums != null && !enums.isEmpty() && !enums.contains(value) && this.LOGGER.isWarnEnabled()) {
                    this.LOGGER.warn("Variable override of '{}' is not listed in the enum of allowed values ({}).", (Object)value, (Object)org.apache.commons.lang3.StringUtils.join((Iterable)enums, (String)","));
                }
            } else {
                codegenServerVariable.value = variable.getDefault();
            }
            codegenServerVariables.add(codegenServerVariable);
        }
        return codegenServerVariables;
    }

    protected void setParameterNullable(CodegenParameter parameter, CodegenProperty property) {
        if (parameter == null || property == null) {
            return;
        }
        parameter.isNullable = property.isNullable;
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        this.LOGGER.debug("Post processing file {} ({})", (Object)file, (Object)fileType);
    }

    @Override
    public boolean isEnablePostProcessFile() {
        return this.enablePostProcessFile;
    }

    @Override
    public void setEnablePostProcessFile(boolean enablePostProcessFile) {
        this.enablePostProcessFile = enablePostProcessFile;
    }

    @Override
    public boolean isEnableMinimalUpdate() {
        return this.enableMinimalUpdate;
    }

    @Override
    public void setEnableMinimalUpdate(boolean enableMinimalUpdate) {
        this.enableMinimalUpdate = enableMinimalUpdate;
    }

    @Override
    public boolean isStrictSpecBehavior() {
        return this.strictSpecBehavior;
    }

    @Override
    public void setStrictSpecBehavior(boolean strictSpecBehavior) {
        this.strictSpecBehavior = strictSpecBehavior;
    }

    @Override
    public FeatureSet getFeatureSet() {
        return this.generatorMetadata.getFeatureSet();
    }

    @Override
    public boolean isRemoveEnumValuePrefix() {
        return this.removeEnumValuePrefix;
    }

    @Override
    public void setRemoveEnumValuePrefix(boolean removeEnumValuePrefix) {
        this.removeEnumValuePrefix = removeEnumValuePrefix;
    }

    public void addOneOfNameExtension(Schema schema, String name) {
        if (schema.getOneOf() != null && schema.getOneOf().size() > 0) {
            schema.addExtension("x-one-of-name", (Object)name);
        }
    }

    public void addOneOfInterfaceModel(Schema cs, String type) {
        if (cs.getOneOf() == null) {
            return;
        }
        CodegenModel cm = new CodegenModel();
        cm.setDiscriminator(this.createDiscriminator("", cs));
        for (Object o : Optional.ofNullable(cs.getOneOf()).orElse(Collections.emptyList())) {
            if (((Schema)o).get$ref() == null) {
                if (cm.discriminator != null && ((Schema)o).get$ref() == null) {
                    this.LOGGER.warn("Ignoring inline object in oneOf definition of {}, since discriminator is used", (Object)type);
                    continue;
                }
                this.LOGGER.warn("Inline models are not supported in oneOf definition right now");
                continue;
            }
            cm.oneOf.add(this.toModelName(ModelUtils.getSimpleRef(((Schema)o).get$ref())));
        }
        cm.name = type;
        cm.classname = type;
        cm.vendorExtensions.put("x-is-one-of-interface", true);
        cm.interfaceModels = new ArrayList<CodegenModel>();
        this.addOneOfInterfaces.add(cm);
    }

    public void addImportsToOneOfInterface(List<Map<String, String>> imports) {
    }

    protected void modifyFeatureSet(Consumer<FeatureSet.Builder> processor) {
        FeatureSet.Builder builder = this.getFeatureSet().modify();
        processor.accept(builder);
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).featureSet(builder.build()).build();
    }

    public static boolean isJsonMimeType(String mime) {
        return mime != null && JSON_MIME_PATTERN.matcher(mime).matches();
    }

    public static boolean isXmlMimeType(String mime) {
        return mime != null && XML_MIME_PATTERN.matcher(mime).matches();
    }

    protected static boolean isJsonVendorMimeType(String mime) {
        return mime != null && JSON_VENDOR_MIME_PATTERN.matcher(mime).matches();
    }

    protected String getCollectionFormat(CodegenParameter codegenParameter) {
        if ("form".equals(codegenParameter.style)) {
            if (codegenParameter.isExplode) {
                return "multi";
            }
            return "csv";
        }
        if ("simple".equals(codegenParameter.style)) {
            return "csv";
        }
        if ("pipeDelimited".equals(codegenParameter.style)) {
            return "pipes";
        }
        if ("spaceDelimited".equals(codegenParameter.style)) {
            return "ssv";
        }
        return null;
    }

    private CodegenComposedSchemas getComposedSchemas(Schema schema) {
        if (!ModelUtils.isComposedSchema(schema) && schema.getNot() == null) {
            return null;
        }
        Schema notSchema = schema.getNot();
        CodegenProperty notProperty = null;
        if (notSchema != null) {
            notProperty = this.fromProperty("not_schema", notSchema, false);
        }
        List<CodegenProperty> allOf = new ArrayList<CodegenProperty>();
        List<CodegenProperty> oneOf = new ArrayList<CodegenProperty>();
        List<CodegenProperty> anyOf = new ArrayList<CodegenProperty>();
        if (ModelUtils.isComposedSchema(schema)) {
            allOf = this.getComposedProperties(schema.getAllOf(), "all_of");
            oneOf = this.getComposedProperties(schema.getOneOf(), "one_of");
            anyOf = this.getComposedProperties(schema.getAnyOf(), "any_of");
        }
        return new CodegenComposedSchemas(allOf, oneOf, anyOf, notProperty);
    }

    private List<CodegenProperty> getComposedProperties(List<Schema> xOfCollection, String collectionName) {
        if (xOfCollection == null) {
            return null;
        }
        ArrayList<CodegenProperty> xOf = new ArrayList<CodegenProperty>();
        HashSet<String> dataTypeSet = new HashSet<String>();
        int i = 0;
        for (Schema xOfSchema : xOfCollection) {
            CodegenProperty cp = this.fromProperty(collectionName + "_" + i, xOfSchema, false);
            xOf.add(cp);
            ++i;
            if (dataTypeSet.contains(cp.dataType) || this.isTypeErasedGenerics() && dataTypeSet.contains(cp.baseType)) {
                cp.vendorExtensions.putIfAbsent("x-duplicated-data-type", true);
                continue;
            }
            if (this.isTypeErasedGenerics()) {
                dataTypeSet.add(cp.baseType);
                continue;
            }
            dataTypeSet.add(cp.dataType);
        }
        return xOf;
    }

    @Override
    public String defaultTemplatingEngine() {
        return "mustache";
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return GeneratorLanguage.JAVA;
    }

    @Override
    public String generatorLanguageVersion() {
        return null;
    }

    @Override
    public List<VendorExtension> getSupportedVendorExtensions() {
        return new ArrayList<VendorExtension>();
    }

    @Override
    public boolean getUseInlineModelResolver() {
        return true;
    }

    @Override
    public boolean getUseOpenapiNormalizer() {
        return true;
    }

    @Override
    public Set<String> getOpenapiGeneratorIgnoreList() {
        return this.openapiGeneratorIgnoreList;
    }

    @Override
    public boolean isTypeErasedGenerics() {
        return false;
    }

    protected String handleSpecialCharacters(String name) {
        return name;
    }

    protected Schema getSchemaFromBooleanOrSchema(Object schema) {
        if (schema == null) {
            return null;
        }
        if (schema instanceof Boolean) {
            if (Boolean.TRUE.equals(schema)) {
                return trueSchema;
            }
            if (Boolean.FALSE.equals(schema)) {
                return falseSchema;
            }
            return null;
        }
        if (schema instanceof Schema) {
            return (Schema)schema;
        }
        throw new IllegalArgumentException("Invalid schema type; type must be Boolean or Schema");
    }

    protected void handleConstantParams(CodegenOperation operation) {
        if (!this.autosetConstants || operation.allParams.isEmpty()) {
            return;
        }
        ArrayList<CodegenParameter> copy = new ArrayList<CodegenParameter>(operation.allParams);
        operation.allParams.clear();
        for (CodegenParameter p : copy) {
            if (p.isEnum && p.required && p._enum != null && p._enum.size() == 1) {
                operation.constantParams.add(p);
                if (p.isQueryParam) {
                    operation.queryParams.removeIf(param -> param.baseName.equals(p.baseName));
                }
                if (p.isHeaderParam) {
                    operation.headerParams.removeIf(param -> param.baseName.equals(p.baseName));
                }
                if (p.isCookieParam) {
                    operation.cookieParams.removeIf(param -> param.baseName.equals(p.baseName));
                }
                this.LOGGER.info("Update operation [{}]. Remove parameter [{}] because it can only have a fixed value of [{}]", new Object[]{operation.operationId, p.baseName, p._enum.get(0)});
                continue;
            }
            operation.allParams.add(p);
        }
        operation.hasParams = !operation.allParams.isEmpty();
    }

    public void setModelPackage(String modelPackage) {
        this.modelPackage = modelPackage;
    }

    public void setApiPackage(String apiPackage) {
        this.apiPackage = apiPackage;
    }

    public String getModelNamePrefix() {
        return this.modelNamePrefix;
    }

    public String getModelNameSuffix() {
        return this.modelNameSuffix;
    }

    public void setModelNamePrefix(String modelNamePrefix) {
        this.modelNamePrefix = modelNamePrefix;
    }

    public void setModelNameSuffix(String modelNameSuffix) {
        this.modelNameSuffix = modelNameSuffix;
    }

    public String getApiNamePrefix() {
        return this.apiNamePrefix;
    }

    public String getApiNameSuffix() {
        return this.apiNameSuffix;
    }

    public void setApiNamePrefix(String apiNamePrefix) {
        this.apiNamePrefix = apiNamePrefix;
    }

    public void setApiNameSuffix(String apiNameSuffix) {
        this.apiNameSuffix = apiNameSuffix;
    }

    public void setFilesMetadataFilename(String filesMetadataFilename) {
        this.filesMetadataFilename = filesMetadataFilename;
    }

    public void setVersionMetadataFilename(String versionMetadataFilename) {
        this.versionMetadataFilename = versionMetadataFilename;
    }

    public void setTemplateDir(String templateDir) {
        this.templateDir = templateDir;
    }

    public String getRemoveOperationIdPrefixDelimiter() {
        return this.removeOperationIdPrefixDelimiter;
    }

    public void setRemoveOperationIdPrefixDelimiter(String removeOperationIdPrefixDelimiter) {
        this.removeOperationIdPrefixDelimiter = removeOperationIdPrefixDelimiter;
    }

    public int getRemoveOperationIdPrefixCount() {
        return this.removeOperationIdPrefixCount;
    }

    public void setRemoveOperationIdPrefixCount(int removeOperationIdPrefixCount) {
        this.removeOperationIdPrefixCount = removeOperationIdPrefixCount;
    }

    public Boolean getSortParamsByRequiredFlag() {
        return this.sortParamsByRequiredFlag;
    }

    public void setSortParamsByRequiredFlag(Boolean sortParamsByRequiredFlag) {
        this.sortParamsByRequiredFlag = sortParamsByRequiredFlag;
    }

    public Boolean getSortModelPropertiesByRequiredFlag() {
        return this.sortModelPropertiesByRequiredFlag;
    }

    public void setSortModelPropertiesByRequiredFlag(Boolean sortModelPropertiesByRequiredFlag) {
        this.sortModelPropertiesByRequiredFlag = sortModelPropertiesByRequiredFlag;
    }

    public Boolean getEnsureUniqueParams() {
        return this.ensureUniqueParams;
    }

    public void setEnsureUniqueParams(Boolean ensureUniqueParams) {
        this.ensureUniqueParams = ensureUniqueParams;
    }

    public Boolean getAllowUnicodeIdentifiers() {
        return this.allowUnicodeIdentifiers;
    }

    public void setAllowUnicodeIdentifiers(Boolean allowUnicodeIdentifiers) {
        this.allowUnicodeIdentifiers = allowUnicodeIdentifiers;
    }

    public Boolean getPrependFormOrBodyParameters() {
        return this.prependFormOrBodyParameters;
    }

    public void setPrependFormOrBodyParameters(Boolean prependFormOrBodyParameters) {
        this.prependFormOrBodyParameters = prependFormOrBodyParameters;
    }

    public void setLegacyDiscriminatorBehavior(boolean legacyDiscriminatorBehavior) {
        this.legacyDiscriminatorBehavior = legacyDiscriminatorBehavior;
    }

    public void setDisallowAdditionalPropertiesIfNotPresent(boolean disallowAdditionalPropertiesIfNotPresent) {
        this.disallowAdditionalPropertiesIfNotPresent = disallowAdditionalPropertiesIfNotPresent;
    }

    public void setEnumUnknownDefaultCase(boolean enumUnknownDefaultCase) {
        this.enumUnknownDefaultCase = enumUnknownDefaultCase;
    }

    public void setAutosetConstants(boolean autosetConstants) {
        this.autosetConstants = autosetConstants;
    }

    static {
        trueSchema = new Schema();
        DefaultFeatureSet = FeatureSet.newBuilder().includeDataTypeFeatures(new DataTypeFeature[]{DataTypeFeature.Int32, DataTypeFeature.Int64, DataTypeFeature.Float, DataTypeFeature.Double, DataTypeFeature.Decimal, DataTypeFeature.String, DataTypeFeature.Byte, DataTypeFeature.Binary, DataTypeFeature.Boolean, DataTypeFeature.Date, DataTypeFeature.DateTime, DataTypeFeature.Password, DataTypeFeature.File, DataTypeFeature.Array, DataTypeFeature.Object, DataTypeFeature.Maps, DataTypeFeature.CollectionFormat, DataTypeFeature.CollectionFormatMulti, DataTypeFeature.Enum, DataTypeFeature.ArrayOfEnum, DataTypeFeature.ArrayOfModel, DataTypeFeature.ArrayOfCollectionOfPrimitives, DataTypeFeature.ArrayOfCollectionOfModel, DataTypeFeature.ArrayOfCollectionOfEnum, DataTypeFeature.MapOfEnum, DataTypeFeature.MapOfModel, DataTypeFeature.MapOfCollectionOfPrimitives, DataTypeFeature.MapOfCollectionOfModel, DataTypeFeature.MapOfCollectionOfEnum}).includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Api, DocumentationFeature.Model}).includeGlobalFeatures(new GlobalFeature[]{GlobalFeature.Host, GlobalFeature.BasePath, GlobalFeature.Info, GlobalFeature.PartialSchemes, GlobalFeature.Consumes, GlobalFeature.Produces, GlobalFeature.ExternalDocumentation, GlobalFeature.Examples, GlobalFeature.Callbacks}).includeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Simple, SchemaSupportFeature.Composite, SchemaSupportFeature.Polymorphism}).includeParameterFeatures(new ParameterFeature[]{ParameterFeature.Path, ParameterFeature.Query, ParameterFeature.Header, ParameterFeature.Body, ParameterFeature.FormUnencoded, ParameterFeature.FormMultipart, ParameterFeature.Cookie}).includeSecurityFeatures(new SecurityFeature[]{SecurityFeature.BasicAuth, SecurityFeature.ApiKey, SecurityFeature.BearerToken, SecurityFeature.OAuth2_Implicit, SecurityFeature.OAuth2_Password, SecurityFeature.OAuth2_ClientCredentials, SecurityFeature.OAuth2_AuthorizationCode}).includeWireFormatFeatures(new WireFormatFeature[]{WireFormatFeature.JSON, WireFormatFeature.XML}).build();
        int cacheSize = Integer.parseInt(GlobalSettings.getProperty("org.openapitools.codegen.utils.namecache.cachesize", "500"));
        int cacheExpiry = Integer.parseInt(GlobalSettings.getProperty("org.openapitools.codegen.utils.namecache.expireafter.seconds", "10"));
        sanitizedNameCache = Caffeine.newBuilder().maximumSize((long)cacheSize).expireAfterAccess((long)cacheExpiry, TimeUnit.SECONDS).ticker(Ticker.systemTicker()).build();
        falseSchema = new Schema();
        falseSchema.setNot(new Schema());
        XML_MIME_PATTERN = Pattern.compile("(?i)application\\/(.*)[+]?xml(;.*)?");
        JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
        JSON_VENDOR_MIME_PATTERN = Pattern.compile("(?i)application\\/vnd.(.*)+json(;.*)?");
        COMMON_PREFIX_ENUM_NAME = Pattern.compile("[a-zA-Z0-9]+\\z");
    }

    private static class SanitizeNameOptions {
        private final String name;
        private final String removeCharRegEx;
        private final List<String> exceptions;

        public SanitizeNameOptions(String name, String removeCharRegEx, List<String> exceptions) {
            this.name = name;
            this.removeCharRegEx = removeCharRegEx;
            this.exceptions = exceptions != null ? Collections.unmodifiableList(exceptions) : Collections.emptyList();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SanitizeNameOptions that = (SanitizeNameOptions)o;
            return Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getRemoveCharRegEx(), that.getRemoveCharRegEx()) && Objects.equals(this.getExceptions(), that.getExceptions());
        }

        public int hashCode() {
            return Objects.hash(this.getName(), this.getRemoveCharRegEx(), this.getExceptions());
        }

        public String getName() {
            return this.name;
        }

        public String getRemoveCharRegEx() {
            return this.removeCharRegEx;
        }

        public List<String> getExceptions() {
            return this.exceptions;
        }
    }

    private static class NamedSchema {
        private String name;
        private Schema schema;
        private boolean required;
        private boolean schemaIsFromAdditionalProperties;

        private NamedSchema(String name, Schema s, boolean required, boolean schemaIsFromAdditionalProperties) {
            this.name = name;
            this.schema = s;
            this.required = required;
            this.schemaIsFromAdditionalProperties = schemaIsFromAdditionalProperties;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NamedSchema that = (NamedSchema)o;
            return Objects.equals(this.required, that.required) && Objects.equals(this.name, that.name) && Objects.equals(this.schema, that.schema) && Objects.equals(this.schemaIsFromAdditionalProperties, that.schemaIsFromAdditionalProperties);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.schema, this.required, this.schemaIsFromAdditionalProperties);
        }
    }
}

