/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractScalaCodegen;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.utils.CamelizeOption;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScalazClientCodegen
extends AbstractScalaCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(ScalazClientCodegen.class);

    public ScalazClientCodegen() {
        this.modifyFeatureSet(features -> features.wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON)).securityFeatures(EnumSet.noneOf(SecurityFeature.class)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}));
        this.outputFolder = "generated-code/scalaz";
        this.templateDir = "scalaz";
        this.embeddedTemplateDir = "scalaz";
        this.apiPackage = "org.openapitools.client.api";
        this.modelPackage = "org.openapitools.client.api";
        this.modelTemplateFiles.put("model.mustache", ".scala");
        this.apiTemplateFiles.put("api.mustache", ".scala");
        this.setReservedWordsLowerCase(Arrays.asList("path", "contentTypes", "contentType", "queryParams", "headerParams", "formParams", "postBody", "mp", "basePath", "apiInvoker", "abstract", "case", "catch", "class", "def", "do", "else", "extends", "false", "final", "finally", "for", "forSome", "if", "implicit", "import", "lazy", "match", "new", "null", "object", "override", "package", "private", "protected", "return", "sealed", "super", "this", "throw", "trait", "try", "true", "type", "val", "var", "while", "with", "yield"));
        this.additionalProperties.put("apiPackage", this.apiPackage);
        this.supportingFiles.add(new SupportingFile("build.properties.mustache", "", "project/build.properties"));
        this.supportingFiles.add(new SupportingFile("build.sbt.mustache", "", "build.sbt"));
        this.supportingFiles.add(new SupportingFile("dateTimeCodecs.mustache", (this.sourceFolder + File.separator + this.apiPackage).replace(".", File.separator), "DateTimeCodecs.scala"));
        this.supportingFiles.add(new SupportingFile("HelperCodecs.mustache", (this.sourceFolder + File.separator + this.apiPackage).replace(".", File.separator), "HelperCodecs.scala"));
        this.supportingFiles.add(new SupportingFile("QueryParamTypeclass.mustache", (this.sourceFolder + File.separator + this.apiPackage).replace(".", File.separator), "QueryParamTypeclass.scala"));
        this.importMapping.remove("List");
        this.importMapping.remove("Set");
        this.importMapping.remove("Map");
        this.importMapping.put("Date", "java.util.Date");
        this.importMapping.put("DateTime", "org.joda.time.DateTime");
        this.importMapping.put("LocalDateTime", "org.joda.time.LocalDateTime");
        this.importMapping.put("LocalDate", "org.joda.time.LocalDate");
        this.importMapping.put("LocalTime", "org.joda.time.LocalTime");
        this.typeMapping = new HashMap();
        this.typeMapping.put("enum", "NSString");
        this.typeMapping.put("array", "List");
        this.typeMapping.put("set", "Set");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("int", "Int");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("byte", "Byte");
        this.typeMapping.put("short", "Short");
        this.typeMapping.put("char", "Char");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("object", "Any");
        this.typeMapping.put("file", "File");
        this.typeMapping.put("binary", "File");
        this.typeMapping.put("number", "BigDecimal");
        this.typeMapping.put("decimal", "BigDecimal");
        this.typeMapping.put("date-time", "DateTime");
        this.typeMapping.put("date", "DateTime");
        this.instantiationTypes.put("array", "ListBuffer");
        this.instantiationTypes.put("map", "HashMap");
        this.additionalProperties.put("fnEnumEntry", new EnumEntryLambda());
    }

    @Override
    public void processOpts() {
        super.processOpts();
    }

    @Override
    public String toParamName(String name) {
        if (this.parameterNameMapping.containsKey(name)) {
            return (String)this.parameterNameMapping.get(name);
        }
        return this.toVarName(name);
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        return this.formatIdentifier(property.baseName, true);
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (p.getDefault() != null) {
            return p.getDefault().toString();
        }
        if (ModelUtils.isBooleanSchema(p)) {
            return null;
        }
        if (ModelUtils.isDateSchema(p)) {
            return null;
        }
        if (ModelUtils.isDateTimeSchema(p)) {
            return null;
        }
        if (ModelUtils.isNumberSchema(p)) {
            return null;
        }
        if (ModelUtils.isIntegerSchema(p)) {
            return null;
        }
        if (ModelUtils.isMapSchema(p)) {
            String inner = this.getSchemaType(ModelUtils.getAdditionalProperties(p));
            return "Map.empty[String, " + inner + "] ";
        }
        if (ModelUtils.isArraySchema(p)) {
            String inner = this.getSchemaType(ModelUtils.getSchemaItems(p));
            String collectionType = ModelUtils.isSet(p) ? (String)this.typeMapping.get("set") : (String)this.typeMapping.get("array");
            return collectionType + ".empty[" + inner + "] ";
        }
        if (ModelUtils.isStringSchema(p)) {
            return null;
        }
        return null;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "scalaz";
    }

    @Override
    public String getHelp() {
        return "Generates a Scalaz client library (beta) that uses http4s";
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            throw new RuntimeException(operationId + " (reserved word) cannot be used as method name");
        }
        return StringUtils.camelize(operationId, CamelizeOption.LOWERCASE_FIRST_LETTER);
    }

    private class EnumEntryLambda
    extends CustomLambda {
        private EnumEntryLambda() {
        }

        @Override
        public String formatFragment(String fragment) {
            return ScalazClientCodegen.this.formatIdentifier(fragment, true);
        }
    }

    private static abstract class CustomLambda
    implements Mustache.Lambda {
        private CustomLambda() {
        }

        public void execute(Template.Fragment frag, Writer out) throws IOException {
            StringWriter tempWriter = new StringWriter();
            frag.execute((Writer)tempWriter);
            out.write(this.formatFragment(tempWriter.toString()));
        }

        public abstract String formatFragment(String var1);
    }
}

