/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.Applicability;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public class UpperCaseLiteralSuffixes
extends Recipe {
    public String getDisplayName() {
        return "Upper case literal suffixes";
    }

    public String getDescription() {
        return "Using upper case literal suffixes for declaring literals is less ambiguous, e.g., `1l` versus `1L`.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-818");
    }

    @Nullable
    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.of(2L, ChronoUnit.MINUTES);
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return Applicability.or((TreeVisitor[])new TreeVisitor[]{new UsesType("long", false), new UsesType("java.lang.Long", false), new UsesType("double", false), new UsesType("java.lang.Double", false), new UsesType("float", false), new UsesType("java.lang.Float", false)});
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext executionContext) {
                String upperValueSource;
                J.Literal initializer;
                J nv = super.visitVariable(variable, executionContext);
                if (((J.VariableDeclarations.NamedVariable)nv).getInitializer() instanceof J.Literal && ((J.VariableDeclarations.NamedVariable)nv).getInitializer().getType() != null && ((initializer = (J.Literal)((J.VariableDeclarations.NamedVariable)nv).getInitializer()).getType() == JavaType.Primitive.Double || initializer.getType() == JavaType.Primitive.Float || initializer.getType() == JavaType.Primitive.Long) && (upperValueSource = this.upperCaseSuffix(initializer.getValueSource())) != null && !upperValueSource.equals(initializer.getValueSource())) {
                    nv = ((J.VariableDeclarations.NamedVariable)nv).withInitializer(initializer.withValueSource(upperValueSource));
                }
                return nv;
            }

            @Nullable
            private String upperCaseSuffix(@Nullable String valueSource) {
                if (valueSource == null || valueSource.length() < 2) {
                    return valueSource;
                }
                return valueSource.substring(0, valueSource.length() - 1) + valueSource.substring(valueSource.length() - 1).toUpperCase();
            }
        };
    }
}

