/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.table;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

@JsonIgnoreType
public class MethodCalls
extends DataTable<Row> {
    public MethodCalls(Recipe recipe) {
        super(recipe, "Method calls", "The text of matching method invocations.");
    }

    public static final class Row {
        @Column(displayName="Source file", description="The source file that the method call occurred in.")
        private final String sourceFile;
        @Column(displayName="Method call", description="The text of the method call.")
        private final String method;

        public Row(String sourceFile, String method) {
            this.sourceFile = sourceFile;
            this.method = method;
        }

        public String getSourceFile() {
            return this.sourceFile;
        }

        public String getMethod() {
            return this.method;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$sourceFile = this.getSourceFile();
            String other$sourceFile = other.getSourceFile();
            if (this$sourceFile == null ? other$sourceFile != null : !this$sourceFile.equals(other$sourceFile)) {
                return false;
            }
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            return !(this$method == null ? other$method != null : !this$method.equals(other$method));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sourceFile = this.getSourceFile();
            result = result * 59 + ($sourceFile == null ? 43 : $sourceFile.hashCode());
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "MethodCalls.Row(sourceFile=" + this.getSourceFile() + ", method=" + this.getMethod() + ")";
        }
    }
}

