/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph.invariant;

import org.openscience.cdk.exception.NoSuchAtomException;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.graph.invariant.GIMatrix;
import org.openscience.cdk.graph.invariant.exception.BadMatrixFormatException;
import org.openscience.cdk.graph.invariant.exception.IndexOutOfBoundsException;
import org.openscience.cdk.graph.matrix.ConnectionMatrix;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

public class HuLuIndexTool {
    public static double getSqrtRadii(IAtom atom) {
        if (atom.getAtomicNumber() == null) {
            throw new NullPointerException("Atomic Number not set");
        }
        switch (atom.getAtomicNumber()) {
            case 1: {
                return Math.sqrt(0.37);
            }
            case 3: {
                return Math.sqrt(1.225);
            }
            case 4: {
                return Math.sqrt(0.889);
            }
            case 5: {
                return Math.sqrt(0.8);
            }
            case 6: {
                return Math.sqrt(0.7709999);
            }
            case 7: {
                return Math.sqrt(0.74);
            }
            case 8: {
                return Math.sqrt(0.74);
            }
            case 9: {
                return Math.sqrt(0.72);
            }
            case 11: {
                return Math.sqrt(1.572);
            }
            case 12: {
                return Math.sqrt(1.364);
            }
            case 13: {
                return Math.sqrt(1.248);
            }
            case 14: {
                return Math.sqrt(1.173);
            }
            case 15: {
                return Math.sqrt(1.1);
            }
            case 16: {
                return Math.sqrt(1.04);
            }
            case 17: {
                return Math.sqrt(0.994);
            }
            case 35: {
                return Math.sqrt(1.142);
            }
            case 53: {
                return Math.sqrt(1.334);
            }
        }
        throw new IllegalArgumentException("Unsupported element: " + atom.getSymbol());
    }

    private static int sigma(IAtomContainer mol, IAtom atom) {
        int hcnt = atom.getImplicitHydrogenCount();
        for (IBond bond : mol.getConnectedBondsList(atom)) {
            IAtom nbor = bond.getOther(atom);
            if (nbor.getAtomicNumber() != 1) continue;
            ++hcnt;
        }
        switch (atom.getAtomicNumber()) {
            case 3: {
                return 1 - hcnt;
            }
            case 11: {
                return 1 - hcnt;
            }
            case 4: {
                return 2 - hcnt;
            }
            case 12: {
                return 2 - hcnt;
            }
            case 5: {
                return 3 - hcnt;
            }
            case 13: {
                return 3 - hcnt;
            }
            case 6: {
                return 4 - hcnt;
            }
            case 7: {
                return 5 - hcnt;
            }
            case 15: {
                return 5 - hcnt;
            }
            case 8: {
                return 6 - hcnt;
            }
            case 16: {
                return 6 - hcnt;
            }
            case 9: {
                return 7 - hcnt;
            }
            case 17: {
                return 7 - hcnt;
            }
            case 35: {
                return 7 - hcnt;
            }
            case 53: {
                return 7 - hcnt;
            }
        }
        throw new IllegalArgumentException("Unsupported atom: " + atom.getAtomicNumber());
    }

    private static double getWeight(IBond bond) {
        if (bond.isAromatic()) {
            return 1.5;
        }
        switch (bond.getOrder()) {
            case SINGLE: {
                return 1.0;
            }
            case DOUBLE: {
                return 2.0;
            }
            case TRIPLE: {
                return 3.0;
            }
        }
        throw new IllegalArgumentException("Unsupported bond type: " + bond);
    }

    private static double[][] getAdjacencyMatrix(IAtomContainer mol) {
        int acount = mol.getAtomCount();
        double[][] adjMat = new double[acount][acount];
        for (IBond bond : mol.bonds()) {
            int i = bond.getBegin().getIndex();
            int j = bond.getEnd().getIndex();
            double d = HuLuIndexTool.getWeight(bond);
            adjMat[j][i] = d;
            adjMat[i][j] = d;
        }
        return adjMat;
    }

    static double[] getAtomWeights(IAtomContainer mol) {
        double[] weightArray = new double[mol.getAtomCount()];
        double[][] adjaMatrix = ConnectionMatrix.getMatrix((IAtomContainer)mol);
        int[][] apspMatrix = PathTools.computeFloydAPSP((double[][])adjaMatrix);
        int[] atomLayers = HuLuIndexTool.getAtomLayers(apspMatrix);
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            int j;
            IAtom atom = mol.getAtom(i);
            if (atomLayers[i] > mol.getAtomCount()) continue;
            int[] cvm = new int[atomLayers[i]];
            int[] interLayerBondSum = new int[atomLayers[i] - 1];
            weightArray[i] = HuLuIndexTool.sigma(mol, atom);
            for (j = 0; j < apspMatrix.length; ++j) {
                if (apspMatrix[j][i] > mol.getAtomCount()) continue;
                int n = apspMatrix[j][i];
                cvm[n] = cvm[n] + HuLuIndexTool.sigma(mol, mol.getAtom(j));
            }
            for (IBond bond : mol.bonds()) {
                int min;
                int endAtomPosition;
                IAtom headAtom = bond.getBegin();
                IAtom endAtom = bond.getEnd();
                int headAtomPosition = mol.indexOf(headAtom);
                if (Math.abs(apspMatrix[i][headAtomPosition] - apspMatrix[i][endAtomPosition = mol.indexOf(endAtom)]) != 1) continue;
                int n = min = Math.min(apspMatrix[i][headAtomPosition], apspMatrix[i][endAtomPosition]);
                interLayerBondSum[n] = (int)((double)interLayerBondSum[n] + HuLuIndexTool.getWeight(bond));
            }
            for (j = 0; j < interLayerBondSum.length; ++j) {
                int n = i;
                weightArray[n] = weightArray[n] + (double)(interLayerBondSum[j] * cvm[j + 1]) * Math.pow(10.0, -(j + 1));
            }
        }
        return weightArray;
    }

    static double[][] getWeightMatrix(IAtomContainer mol) {
        int acount = mol.getAtomCount();
        double[][] matrix = new double[acount][acount];
        double[] weights = HuLuIndexTool.getAtomWeights(mol);
        for (int i = 0; i < acount; ++i) {
            for (int j = i + 1; j < acount; ++j) {
                double d = Math.sqrt(weights[i] / weights[j]) + Math.sqrt(weights[j] / weights[i]);
                matrix[j][i] = d;
                matrix[i][j] = d;
            }
        }
        return matrix;
    }

    public static double[][] getExtendedAdjacencyMatrix(IAtomContainer mol) {
        int acount = mol.getAtomCount();
        double[][] extAdjMat = new double[acount][acount];
        double[][] adjMat = HuLuIndexTool.getAdjacencyMatrix(mol);
        double[][] wgtMat = HuLuIndexTool.getWeightMatrix(mol);
        for (int i = 0; i < acount; ++i) {
            extAdjMat[i][i] = HuLuIndexTool.getSqrtRadii(mol.getAtom(i)) / 6.0;
            for (int j = i + 1; j < acount; ++j) {
                double d = Math.sqrt(adjMat[i][j]) * wgtMat[i][j] / 6.0;
                extAdjMat[i][j] = d;
                extAdjMat[j][i] = d;
            }
        }
        return extAdjMat;
    }

    public static int[] getAtomLayers(int[][] apspMatrix) {
        int[] atomLayers = new int[apspMatrix.length];
        for (int i = 0; i < apspMatrix.length; ++i) {
            atomLayers[i] = 0;
            for (int[] matrix : apspMatrix) {
                if (matrix[i] > apspMatrix.length || atomLayers[i] >= 1 + matrix[i]) continue;
                atomLayers[i] = 1 + matrix[i];
            }
        }
        return atomLayers;
    }

    public static double getEAIDNumber(IAtomContainer atomContainer) throws NoSuchAtomException, BadMatrixFormatException, IndexOutOfBoundsException {
        int i;
        GIMatrix matrix;
        GIMatrix tempMatrix = matrix = new GIMatrix(HuLuIndexTool.getExtendedAdjacencyMatrix(atomContainer));
        GIMatrix fixedMatrix = matrix;
        for (i = 2; i < atomContainer.getAtomCount(); ++i) {
            tempMatrix = tempMatrix.multiply(fixedMatrix);
            matrix = matrix.add(tempMatrix);
        }
        for (i = 0; i < atomContainer.getAtomCount(); ++i) {
            matrix.setValueAt(i, i, matrix.getValueAt(i, i) + 1.0);
        }
        return matrix.trace();
    }
}

