/*
 * Decompiled with CFR 0.152.
 */
package nl.tue.buildingsmart.express.parser;

import antlr.CommonAST;
import antlr.collections.AST;
import java.io.FileOutputStream;
import java.io.PrintStream;
import net.sourceforge.osexpress.parser.EasyParser;
import nl.tue.buildingsmart.express.parser.Express2DictWalker;
import nl.tue.buildingsmart.schema.SchemaDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaLoader {
    private SchemaDefinition schema = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaLoader.class);

    public SchemaLoader(String fileName) {
        try {
            EasyParser parser = new EasyParser(fileName);
            Express2DictWalker walker = new Express2DictWalker();
            CommonAST t = parser.parse();
            PrintStream stdErrOld = System.err;
            PrintStream stdOutOld = System.out;
            FileOutputStream log = new FileOutputStream("parser.log");
            PrintStream myErr = new PrintStream(log);
            System.setErr(myErr);
            System.setOut(myErr);
            walker.setPass(1);
            walker.syntax((AST)t);
            walker.setPass(2);
            walker.syntax_pass2((AST)t);
            walker.setPass(3);
            walker.syntax_pass2((AST)t);
            this.schema = walker.getSchema();
            this.schema.constructHirarchyMap();
            System.setErr(stdErrOld);
            System.setOut(stdOutOld);
            myErr.close();
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public SchemaDefinition getSchema() {
        return this.schema;
    }
}

