/*
 * Decompiled with CFR 0.152.
 */
package nl.tue.buildingsmart.express.population;

import java.util.ArrayList;
import java.util.HashMap;
import nl.tue.buildingsmart.express.population.AttributeInstance;
import nl.tue.buildingsmart.express.population.ModelPopulation;
import nl.tue.buildingsmart.schema.EntityDefinition;

public class EntityInstance {
    private int id;
    private EntityDefinition entDef;
    private ArrayList<AttributeInstance> attributes;
    private ArrayList<EntityInstance> references;
    private HashMap<String, AttributeInstance> attributeMap;
    private int numAttribues = 0;
    private ModelPopulation model;

    public EntityInstance(ModelPopulation model, int id) {
        this.setId(id);
        this.setModel(model);
        this.attributes = new ArrayList();
        this.references = new ArrayList();
        this.attributeMap = new HashMap();
    }

    public ArrayList<AttributeInstance> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(AttributeInstance attribute) {
        this.attributes.add(attribute);
        attribute.setAttributeOf(this);
        this.attributeMap.put(attribute.getAttributeType().getName(), attribute);
        this.numAttribues = this.attributes.size();
    }

    public void setAttributes(ArrayList<AttributeInstance> attributes) {
        this.attributes = attributes;
        for (int i = 0; i < attributes.size(); ++i) {
            this.attributeMap.put(attributes.get(i).getAttributeType().getName(), attributes.get(i));
        }
    }

    public EntityDefinition getEntityDefinition() {
        return this.entDef;
    }

    public void setEntityDefinition(EntityDefinition entDef) {
        this.entDef = entDef;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public ArrayList<EntityInstance> getReferneces() {
        return this.references;
    }

    public void addReference(EntityInstance instance) {
        this.references.add(instance);
    }

    public void setReferneces(ArrayList<EntityInstance> referneces) {
        this.references = referneces;
    }

    public Object getAttributeValueBN(String attributeName) {
        AttributeInstance attrib = this.attributeMap.get(attributeName);
        if (attrib != null) {
            return attrib.getValue();
        }
        return null;
    }

    public String getAttributeValueBNasString(String attributeName) {
        return (String)this.getAttributeValueBN(attributeName);
    }

    public int getNumAttribues() {
        return this.numAttribues;
    }

    public EntityInstance getAttributeValueBNasEntityInstance(String attributeName) {
        AttributeInstance attr = this.attributeMap.get(attributeName);
        if (attr != null) {
            return attr.getEntityInstanceValue();
        }
        return null;
    }

    public ArrayList<EntityInstance> getAttributeValueBNasEntityInstanceList(String attributeName) {
        AttributeInstance attr = this.attributeMap.get(attributeName);
        if (attr != null) {
            return attr.getEntityList();
        }
        return null;
    }

    public ModelPopulation getModel() {
        return this.model;
    }

    public void setModel(ModelPopulation model) {
        this.model = model;
    }
}

