/*
 * Decompiled with CFR 0.152.
 */
package nl.tue.buildingsmart.express.population;

import java.io.FileInputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import nl.tue.buildingsmart.express.population.EntityInstance;
import nl.tue.buildingsmart.express.population.ParseException;
import nl.tue.buildingsmart.express.population.Part21Parser;
import nl.tue.buildingsmart.schema.EntityDefinition;
import nl.tue.buildingsmart.schema.SchemaDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelPopulation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelPopulation.class);
    private HashMap<Integer, EntityInstance> instances;
    private HashMap<String, Vector<EntityInstance>> typeNameMap;
    private SchemaDefinition schema;
    private Part21Parser parser;
    private Path schemaFile;
    private String entityPrefixString = "ENTITY_";

    public ModelPopulation(FileInputStream input) {
        this.parser = new Part21Parser(input);
    }

    public SchemaDefinition getSchema() {
        return this.schema;
    }

    public void setSchema(SchemaDefinition schema) {
        this.schema = schema;
        if (this.parser != null) {
            this.parser.setSchema(schema);
        }
    }

    public Path getSchemaFile() {
        return this.schemaFile;
    }

    public void setSchemaFile(Path schemaFile) {
        this.schemaFile = schemaFile;
        this.parser.setSchemaFile(schemaFile);
    }

    public void load() {
        try {
            this.parser.setModel(this);
            this.parser.init();
            this.parser.syntax();
            this.setInstances(this.parser.getInstances());
            this.buildTypeNameMap();
        }
        catch (ParseException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public HashMap<Integer, EntityInstance> getInstances() {
        return this.instances;
    }

    public void setInstances(HashMap<Integer, EntityInstance> instances) {
        this.instances = instances;
    }

    public EntityInstance getEntity(Integer id) {
        return this.instances.get(id);
    }

    private void buildTypeNameMap() {
        this.typeNameMap = new HashMap();
        Iterator<Integer> instKeyIter = this.instances.keySet().iterator();
        while (instKeyIter.hasNext()) {
            EntityInstance inst = this.instances.get(instKeyIter.next());
            String typeName = inst.getEntityDefinition().getName();
            if (!this.typeNameMap.containsKey(typeName)) {
                this.typeNameMap.put(typeName, new Vector());
            }
            this.typeNameMap.get(typeName).add(inst);
        }
    }

    public Vector<EntityInstance> getInstancesOfType(String typeName) {
        return this.getInstancesOfType(typeName, false);
    }

    public Vector<EntityInstance> getInstancesOfFirstNonAbstractTypes(String typeName) {
        Vector<EntityInstance> instances = new Vector<EntityInstance>();
        EntityDefinition ent = this.schema.getEnitiesBN().get(typeName.toUpperCase());
        if (!ent.isInstantiable()) {
            for (EntityDefinition subEnt : ent.getSubtypes()) {
                Vector<EntityInstance> tmp = this.getInstancesOfFirstNonAbstractTypes(subEnt.getName());
                instances.addAll(tmp);
            }
        } else {
            Vector<EntityInstance> tmp = this.getInstancesOfType(ent.getName());
            instances.addAll(tmp);
        }
        return instances;
    }

    public Vector<EntityInstance> getInstancesOfType(String typeName, boolean includeSubClasses) {
        System.out.println("checking:" + typeName);
        Vector<EntityInstance> instances = this.typeNameMap.get(typeName);
        if (includeSubClasses) {
            EntityDefinition ent = this.schema.getEnitiesBN().get(typeName.toUpperCase());
            for (EntityDefinition subClass : ent.getSubtypes()) {
                Vector<EntityInstance> subClassInstances = this.getInstancesOfType(subClass.getName(), includeSubClasses);
                if (subClassInstances == null) continue;
                if (instances == null) {
                    instances = new Vector();
                }
                instances.addAll(subClassInstances);
            }
        }
        if (instances == null) {
            instances = new Vector();
        }
        return instances;
    }

    public String getEntityPrefix() {
        return this.entityPrefixString;
    }
}

