/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.springframework.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.JEEContextFactory;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.WebContextFactory;
import org.pac4j.core.context.session.JEESessionStore;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.CallbackLogic;
import org.pac4j.core.engine.DefaultCallbackLogic;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.http.adapter.JEEHttpActionAdapter;
import org.pac4j.core.util.FindBest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class CallbackController {
    private CallbackLogic<Object, JEEContext> callbackLogic;
    @Value(value="${pac4j.callback.defaultUrl:#{null}}")
    private String defaultUrl;
    @Value(value="${pac4j.callback.multiProfile:#{null}}")
    private Boolean multiProfile;
    @Value(value="${pac4j.callback.saveInSession:#{null}}")
    private Boolean saveInSession;
    @Value(value="${pac4j.callback.renewSession:#{null}}")
    private Boolean renewSession;
    @Value(value="${pac4j.callback.defaultClient:#{null}}")
    private String defaultClient;
    @Autowired
    private Config config;

    @RequestMapping(value={"${pac4j.callback.path:/callback}"})
    public void callback(HttpServletRequest request, HttpServletResponse response) {
        SessionStore bestSessionStore = FindBest.sessionStore(null, (Config)this.config, (SessionStore)JEESessionStore.INSTANCE);
        HttpActionAdapter bestAdapter = FindBest.httpActionAdapter(null, (Config)this.config, (HttpActionAdapter)JEEHttpActionAdapter.INSTANCE);
        CallbackLogic bestLogic = FindBest.callbackLogic(this.callbackLogic, (Config)this.config, (CallbackLogic)DefaultCallbackLogic.INSTANCE);
        JEEContext context = (JEEContext)FindBest.webContextFactory(null, (Config)this.config, (WebContextFactory)JEEContextFactory.INSTANCE).newContext(new Object[]{request, response, bestSessionStore});
        bestLogic.perform((WebContext)context, this.config, bestAdapter, this.defaultUrl, this.saveInSession, this.multiProfile, this.renewSession, this.defaultClient);
    }

    @RequestMapping(value={"${pac4j.callback.path/{cn}:/callback/{cn}}"})
    public void callbackWithClientName(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="cn") String cn) {
        this.callback(request, response);
    }

    public String getDefaultUrl() {
        return this.defaultUrl;
    }

    public void setDefaultUrl(String defaultUrl) {
        this.defaultUrl = defaultUrl;
    }

    public CallbackLogic<Object, JEEContext> getCallbackLogic() {
        return this.callbackLogic;
    }

    public void setCallbackLogic(CallbackLogic<Object, JEEContext> callbackLogic) {
        this.callbackLogic = callbackLogic;
    }

    public Boolean getMultiProfile() {
        return this.multiProfile;
    }

    public void setMultiProfile(Boolean multiProfile) {
        this.multiProfile = multiProfile;
    }

    public Boolean getSaveInSession() {
        return this.saveInSession;
    }

    public void setSaveInSession(Boolean saveInSession) {
        this.saveInSession = saveInSession;
    }

    public Boolean getRenewSession() {
        return this.renewSession;
    }

    public void setRenewSession(Boolean renewSession) {
        this.renewSession = renewSession;
    }

    public String getDefaultClient() {
        return this.defaultClient;
    }

    public void setDefaultClient(String client) {
        this.defaultClient = client;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }
}

