/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.mockpolicies;

import java.lang.reflect.Method;
import org.mockito.Mockito;
import org.powermock.core.spi.PowerMockPolicy;
import org.powermock.mockpolicies.MockPolicyClassLoadingSettings;
import org.powermock.mockpolicies.MockPolicyInterceptionSettings;
import org.powermock.mockpolicies.support.LogPolicySupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Slf4jMockPolicy
implements PowerMockPolicy {
    private static final String LOGGER_FACTORY_CLASS_NAME = "org.slf4j.LoggerFactory";
    private static final String LOGGER_FACTORY_METHOD_NAME = "getLogger";
    private static final String FRAMEWORK_NAME = "sfl4j";
    private static final String LOGGER_CLASS_NAME = "org.slf4j.Logger";
    private static ThreadLocal<Object> threadLogger = new ThreadLocal();

    public void applyClassLoadingPolicy(MockPolicyClassLoadingSettings mockPolicyClassLoadingSettings) {
        mockPolicyClassLoadingSettings.addFullyQualifiedNamesOfClassesToLoadByMockClassloader(LOGGER_FACTORY_CLASS_NAME, new String[]{"org.apache.log4j.Appender", "org.apache.log4j.xml.DOMConfigurator"});
    }

    public void applyInterceptionPolicy(MockPolicyInterceptionSettings mockPolicyInterceptionSettings) {
        LogPolicySupport logPolicySupport = new LogPolicySupport();
        Method[] loggerFactoryMethods = logPolicySupport.getLoggerMethods(LOGGER_FACTORY_CLASS_NAME, LOGGER_FACTORY_METHOD_NAME, FRAMEWORK_NAME);
        this.initializeMockForThread(logPolicySupport);
        for (Method loggerFactoryMethod : loggerFactoryMethods) {
            mockPolicyInterceptionSettings.stubMethod(loggerFactoryMethod, threadLogger.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeMockForThread(LogPolicySupport logPolicySupport) {
        Class<?> loggerClass = this.getLoggerClass(logPolicySupport);
        if (threadLogger.get() == null) {
            Object mock;
            ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
            ClassLoader classLoader = Mockito.class.getClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            try {
                mock = Mockito.mock(loggerClass);
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalCl);
            }
            threadLogger.set(mock);
        }
    }

    private Class<?> getLoggerClass(LogPolicySupport logPolicySupport) {
        Class loggerType;
        try {
            loggerType = logPolicySupport.getType(LOGGER_CLASS_NAME, FRAMEWORK_NAME);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return loggerType;
    }
}

